
//
// On-Line Property extension | inventory | database | 
//
// Author: MdotEdot
//
// Use at your own risk
//
// No backups or guarantees are made on the availability of servers.
// 
// The server to which you connect must supply you with application-id and score-id.
//
// Supplies:
//
//
// AppID is used in each block to check specific for that AppID : multiple connections to different AppIDs ?!?
//           
// For 3.3 uncommment these lines..
//import openfl.net.URLLoader;
//import openfl.net.URLLoaderDataFormat;
//import openfl.net.URLRequest;
//import openfl.events.Event;
//import openfl.events.IOErrorEvent;
// For previous Stencyl versions:
import nme.net.URLLoader;
import nme.net.URLLoaderDataFormat;
import nme.net.URLRequest;
import nme.events.Event;
import nme.events.IOErrorEvent;


//
// Property static class to handle properties on the network
//
class Property{
	// Network  variables
	private static var loader:URLLoader=null;
	public static var debug:Bool=true;

 	public static var isConnect:Map<String,Bool>=new Map<String, Bool>();
	// dbURL = 192.168.x.x:/database/stencyl.php
	// we will add ?a=  (a is the parameter that is used in stencyl.php)
   	private static var urls:Map<String,String>=new Map<String,String>();
	// Each AppID its own secret
	private static var SecretIDs:Map<String,Float>=new Map<String,Float>();
	private static var appIDs:Map<String,String>=new Map<String,String>();

	// The function caller names
	private static var callers:Map<String,String>=new Map<String, String>();
	// The functions that are called
	private static var callFunctions:Map<String,Dynamic>=new Map<String, Dynamic>();
	// The AppID that the action is performed on : Multiple AppIDs should be possible in one game (?)
	private static var callAppIDs:Map<String,Dynamic>=new Map<String, Dynamic>();

	// Exception handling
	private static var resultCode:Map<String, String>=new Map<String, String>();
	// Locking
	private static var lockIDs:Map<String, Float>=new Map<String, Float>();
	private static var retryCounter:Map<String, Float>=new Map<String, Float>();
	// Set Property history -> when retry is not 0 we need to track the property setting and its counter
	private static var setProps:Map<String, String>=new Map<String, String>();
	private static var setVals:Map<String, String>=new Map<String, String>();
	//private static var setApps:Map<String, String>=new Map<String, String>();
	private static var setLockCounters:Map<String, Float>=new Map<String, Float>();
	// getProperty
	private static var getVals:Map<String, String>=new Map<String, String>();
	private static var getProps:Map<String, String>=new Map<String, String>();
	//
	// abstract error: Abstract Map has no @:to function that accepts IMap<Float, String> : private static var setLocks:Map<Float, String>=new Map<Float, String>();
	private static var setLocks:Map<String, String>=new Map<String, String>();
	private static var Lock:Map<String, Bool>=new Map<String, Bool>();
	private static var setLockApps:Map<String, String>=new Map<String, String>();
	private static var setLockFuncs:Map<String, Dynamic>=new Map<String, Dynamic>();
	private static var setReleaseLockFuncs:Map<String, Dynamic>=new Map<String, Dynamic>();

	//
	// Extension Functions
	//
	public static function setDebug(sw:Bool){
		debug=sw;
	} // eof setDebug

	public static function isConnected(appID:String):Bool{
 		return isConnect.get(""+appID);
	}

	public static function init(dburl:String, appID:String, secret:Float, func:Dynamic){
		// The Database Connection Server should ALWAYS be the same, even though we have different appIDs
		urls.set(""+appID, dburl);

		// Store the secret key for future use
		SecretIDs.set(""+appID, secret);

		// Assume we don't have connection
 		isConnect.set(""+appID, false);
		var callID=getCallID("initFunc", appID, func);
		appIDs.set(""+callID, appID);
if(debug)trace("Init - call id : "+callID);
		// Make Code makes a calculation based on the secret and the 
	    	var scd=MultiPlay.makeCode(appID,secret);

                var args:Array<String>=new Array<String>();

                var args:Array<String>=new Array<String>();
                args.push("property");
                args.push("init");
                args.push(""+callID);
                args.push(""+appID);
                args.push(""+scd[0]);
                args.push(""+scd[1]);
                call(callID,args);

		//var scd=makeCode(secret,appID);
		//call2(callID,Base64.encode("property")+","+Base64.encode("init")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",");
	} // eof init

	//
	// SetProperty
	// 
	//   Will perform a Optimistic lock even if there is no property to begin with : race-prevention
	//
	public static function setProperty(PropName:String, PropValue:String, appID:String, lock:Bool, func:Dynamic){
		var secret:Float=SecretIDs.get(""+appID);

                var callID=getCallID("set", appID, func);
if(debug)trace("set Property - call id : "+callID);
                // Make Code makes a calculation based on the secret and the
//                var scd=makeCode(secret,appID);

		var scd=MultiPlay.makeCode(appID,secret);

		// 
		setProps.set(""+callID, PropName);
		setVals.set(""+callID, PropValue);
		//setApps.set(""+callID, appID);
		appIDs.set(""+callID, appID);
		Lock.set(""+callID, lock);

		var lockID=lockIDs.get(""+appID);
		if(!lock) lockID=-1;

		var retry=retryCounter.get(""+appID);
		if(retry == null || retry < 0) {
			retry = 0;
		}

                var args:Array<String>=new Array<String>();
		args.push("property");
                args.push("set");
                args.push(""+callID);
                args.push(""+appID);
		args.push(""+PropName);
		args.push(""+PropValue);
		args.push(""+lockID);
		args.push(""+retry);
                args.push(""+scd[0]);
                args.push(""+scd[1]);
                call(callID,args);

                //var parm:String=""+Base64.encode("property")+","+Base64.encode("set")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+PropName)+","+Base64.encode(""+PropValue)+","+Base64.encode(""+lockID)+","+Base64.encode(""+retry)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
//trace("SetProperty calling the set and calling the function: "+parm);
                //call2(callID,parm);

	} // eof: setProperty 


	public static function setPropertyAndGet(PropName:String, PropValue:String, appID:String, QueryString:String, func:Dynamic){
//~,~,~,~,function myFunc(){~});"
		var secret:Float=SecretIDs.get(""+appID);

                var callID=getCallID("setandget", appID, func);
if(debug)trace("set and get Property - call id : "+callID);
                // Make Code makes a calculation based on the secret and the
//                var scd=makeCode(secret,appID);
var scd=MultiPlay.makeCode(appID,secret);

		// 
		setProps.set(""+callID, PropName);
		setVals.set(""+callID, PropValue);
		//setApps.set(""+callID, appID);
		appIDs.set(""+callID, appID);

                var args:Array<String>=new Array<String>();
		args.push("property");
                args.push("setandget");
                args.push(""+callID);
                args.push(""+appID);
		args.push(""+PropName);
		args.push(""+PropValue);
		args.push(""+QueryString);
                args.push(""+scd[0]);
                args.push(""+scd[1]);
                call(callID,args);


                //var parm:String=""+Base64.encode("property")+","+Base64.encode("setandget")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+PropName)+","+Base64.encode(""+PropValue)+","+Base64.encode(""+QueryString)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
                //call2(callID,parm);
	} // setPropertyAndGet



//     <block tag="Property_Lock_" spec="Property: Property Lock on: %0 for AppID: %1 " code="Property.setLock(~,~,function myFunc(){Property.setLockCounter++; ~ Property.releaseLock(Property.setLockCounter); Property.setLockCounter--; });" type="wrapper" color="cyan" returns="void">
	//
	// Locking a property so that extension user can get and set without interference ... (primary use: counters)
	//
	public static function setLock(PropName:String, appID:String, setLockCounter:Float, func:Dynamic){
		// setLockCounter IS increased and will be decreased once the function has been called
		var secret:Float=SecretIDs.get(""+appID);

                var callID=getCallID("setlock", appID, func);
                // Make Code makes a calculation based on the secret and the
//                var scd=makeCode(secret,appID);
var scd=MultiPlay.makeCode(appID,secret);


		// 
		setProps.set(""+callID, PropName);
		//setApps.set(""+callID, appID);
		appIDs.set(""+callID,appID);
		setLockCounters.set(""+callID,setLockCounter);
		// LockCounting .. so that when we relesae the lock on property it will be the property we locked!
		setLocks.set(""+setLockCounter, PropName);
		setLockApps.set(""+setLockCounter, appID);
		setLockFuncs.set(""+setLockCounter, func);

		var lockID=lockIDs.get(""+appID);

		var retry=retryCounter.get(""+appID+"."+setLockCounter);
		if(retry == null || retry < 0) {
			retry = 0;
		}
                var args:Array<String>=new Array<String>();
		args.push("property");
                args.push("init");
                args.push(""+callID);
                args.push(""+appID);
		args.push(""+PropName);
		args.push("0");
		args.push(""+lockID);
		args.push(""+retry);
                args.push(""+scd[0]);
                args.push(""+scd[1]);
                call(callID,args);


		// PropValue is "" <- we do not set a value
                //var callString:String=""+Base64.encode("property")+","+Base64.encode("setlock")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+PropName)+","+Base64.encode("0")+","+Base64.encode(""+lockID)+","+Base64.encode(""+retry)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
//trace("setLock calling : "+callString);
		//call2(callID, callString);
			
	} // eof setLock

	// Internally called by extension (from block.xml) --> No interaction from extension user .. wrapper ending = releaseLock
	public static function releaseLock(setLockCounter:Float, func:Dynamic){
		// setLockCounter can be decommisioned
		var PropName:String=setLocks.get(""+setLockCounter);
		var appID:String=setLockApps.get(""+setLockCounter);

		var secret:Float=SecretIDs.get(""+appID);
                // Make Code makes a calculation based on the secret and the

                var callID=getCallID("releaselock", appID, func);
		setProps.set(""+callID, PropName);
		appIDs.set(""+callID, appID);
		//setApps.set(""+callID, appID);
		setLockCounters.set(""+callID, setLockCounter);
		// LockCounting .. so that when we relesae the lock on property it will be the property we locked!
                // Make Code makes a calculation based on the secret and the

		var scd=MultiPlay.makeCode(appID,secret);

		var lockID=lockIDs.get(""+appID);
		var retry=retryCounter.get(""+appID+"."+setLockCounter);
		if(retry == null || retry < 0) {
			retry = 0;
		}
                var args:Array<String>=new Array<String>();
		args.push("property");
                args.push("releaselock");
                args.push(""+callID);
                args.push(""+appID);
		args.push(""+PropName);
		args.push("0");
		args.push(""+lockID);
		args.push(""+retry);
                args.push(""+scd[0]);
                args.push(""+scd[1]);
                call(callID,args);


		// PropValue = "" <- we don't set a value
                //var callString:String=""+Base64.encode("property")+","+Base64.encode("releaselock")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+PropName)+","+Base64.encode("0")+","+Base64.encode(""+lockID)+","+Base64.encode(""+retry)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
//trace("Release Lock: "+callString);
		//call2(callID, callString);

		//
	} // eof releaseLock

//       <block tag="Property_Request" spec="Property: Request Property: %0 from AppID: %1" code="Property.requestProperty(~,~,function MyFunc(){~ Property.requestFunc=null;});" type="wrapper" color="cyan" returns="void">
	public static function requestProperty(PropName:String, appID:String, func:Dynamic){
		var retval:String="";

    		var secret:Float=SecretIDs.get(""+appID);

                var callID=getCallID("get", appID, func);
		appIDs.set(""+callID, appID);

		getProps.set(""+PropName, ""+callID);
		
if(debug)trace("RequestProperty - call id : "+callID);
                // Make Code makes a calculation based on the secret and the
//                var scd=makeCode(secret,appID);
		var scd=MultiPlay.makeCode(appID,secret);
     
                var args:Array<String>=new Array<String>();
		args.push("property");
                args.push("get");
                args.push(""+callID);
                args.push(""+appID);
		args.push(""+PropName);
                args.push(""+scd[0]);
                args.push(""+scd[1]);
                call(callID,args);


                //var callString=""+Base64.encode("property")+","+Base64.encode("get")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+PropName)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
//trace("Request Property : "+callString);
		//call2(callID, callString);
	} // requestProperty


//      <block tag="Property_Get_" spec="Property: get Value Property %0 from AppID %1" code="Property.getProperty(~)" type="normal" color="cyan" returns="text">
	public static function getProperty(PropName:String):String{
		var retval:String="";

		retval=getVals.get(getProps.get(""+PropName));

		return retval;
	}

     	private static function call(CallID:String, Args:Array<String>){
                var str:String="";


                // Store the timer
                //exectimer=time();

                // Convert each argument into a Base64 encoded string
                for(arg in Args){
if(debug)trace("Sending Data : "+arg+" encode the arg: "+MultiPlay.Base64_URL_encode(arg));
                        str=str+MultiPlay.Base64_URL_encode(arg)+",";
                }
                var url_encode:String=MultiPlay.Base64_URL_encode(str);
if(debug)trace("encrypted send: "+url_encode);
		var appID=appIDs.get(""+CallID);
                var execUrl=""+urls.get(""+appID)+"?c="+CallID+"&a="+url_encode+"&t="+MultiPlay.Base64_URL_encode(""+Date.now());
if(debug)if(debug)trace("Calling :"+execUrl);
                var r:URLRequest=new URLRequest(execUrl);
                var ul:URLLoader=new URLLoader();
                ul.addEventListener( IOErrorEvent.IO_ERROR, onError);
                ul.addEventListener(Event.COMPLETE,onData);
                ul.load(r);
        } // eof call


	//
	// NETWORK Handling
	//

        // call2(W1a231,yY882H,YYGJE)
        public static function call2(callID:String, param:String){
                var str:String=""+param;
                // base64 encoded param seperated by ","
                // after all fields are converted make a
                // Ask the database
                // Base64 encoding of the query
                //var execParm = haxe.crypto.BaseCode.encode( parm , base64 );
                var execParm = Base64.encode(  str );
                var p1=StringTools.replace(""+execParm, "+", ":");
                var p2=StringTools.replace(p1, "/", "_");
                var p3=StringTools.replace(p2, "=", ".");
if(debug)trace("Property: Ask Encoded: "+p3+" it was: ("+str+")");
                //
                // If security --> encode with securityID
                // Including the date so that each call is different : avoid URL Caching
		//
//                var execUrl=""+dbURL+"?c="+callID+"&a="+p3+"&t="+Base64.encode(""+Date.now());
		var appID=appIDs.get(""+callID);
trace("AppIDs get : ("+callID+") = "+appID);
		if(urls.get(""+appID) != null){
			var execUrl=""+urls.get(""+appID)+"?c="+callID+"&a="+p3+"&t="+Base64.encode(""+Date.now());
if(debug)trace("Calling :"+execUrl);
			var r:URLRequest=new URLRequest(execUrl);
			var ul:URLLoader=new URLLoader();
			ul.addEventListener( IOErrorEvent.IO_ERROR, onError);
			ul.addEventListener(Event.COMPLETE,onData);
			if(ul!=null){
				ul.load(r);
			}else{
if(debug)trace(" URL Loader Property is null !!!");
			}
		}
        }

	//
	// When something bad happens
	//
	public static function onError(e:Event){
if(debug)trace("onError called: "+e);
  		var cvt=""+e;
                if(cvt.indexOf("?=c") > -1){
                        var callID:String=cvt.substring(cvt.indexOf("?c=")+3, cvt.indexOf("&"));
if(debug)trace("onError callback possibility : callID: "+callID);
			resultCode.set(""+callID, cvt);
		       var appID=appIDs.get(""+callID);
                        // Maybe we do not need to do this??!?
                        isConnect.set(""+appID, false);

			callBack(callID);
		} // if we have CallID
	} // eof: onError

	//
	// When we receive data from the server
	//
	public static function onData(e:Event){
    // get the Call ID from the data
                var e_str:String=""+e;
if(debug)trace("In onData: "+e_str);
                var callID:String=e_str.substring(e_str.indexOf("?c=")+3, e_str.indexOf("&"));

                var result=MultiPlay.Base64_URL_decode(e.target.data);
if(debug)trace("Decoded: "+result+" orig Data: "+e.target.data);

                var items=result.split(",");
if(debug)trace("CallID?: items[0]: "+items[0]);
                if(items.length > 0 && (""+items[0]).charAt(0)=="C"){
                        var callID=items[0];
if(debug)trace("OnData : CallID retrieved: "+callID);
                        var appID=appIDs.get(""+callID);
                        isConnect.set(""+appID, true);
			interpretAction(items);
                } // if items and items-first-element contains a C for callID

	} // onData


	// Old Data : error on invalid character base64
	public static function OldonData(e:Event){
		var theData="";
		var result:String="";

		var cvt:String=""; // convert

		// Get the data 
  		if(e != null){
                        if(e.target != null){
                                theData=""+e.target.data;
                        }else{
                                if(debug)trace("===");
                                if(debug)trace("The e.target is null!!!");
                        }
                }else{
                        if(debug)trace("-----");
                        if(debug)trace("The event is null!!!");
                        if(debug)trace("-----");
                }

		// The data is Base64 - online variant = no characters that break URL

	        var p1=StringTools.replace(""+theData, ":", "+");
                var p2=StringTools.replace(p1, "_", "/");
                var p3=StringTools.replace(p2, ".", "=");
if(debug)trace("Before decode :"+p3);
 		if(p3 == null){
                        if(debug)trace("Data is null!");
                }else{
			// Thing on 000webhosting
if(debug)trace("Found text: "+p3.indexOf("RESULTSTENCYL"));
                        if(p3.indexOf("RESULTSTENCYL") > -1){
                                // special decoding since the external website puts javascript at the end
                                result=Base64.decode(p3.substr(p3.indexOf("RESULTSTENCYL")+13,p3.length));
                        }else{
                                //result=p3;
                               // result=Base64.decode(p3);
                                result=Base64.decode(""+theData);
                        }
                }

//                var result=Base64.decode(p3);
if(debug)trace("After decode (SetProperty?) :"+result);

if(debug)trace("Result after decode:"+result);
                var items:Array<Dynamic>=result.split(",");
 		if(items.length > 0 && (""+items[0]).charAt(0)=="C"){
                        var callID=items[0];
if(debug)trace("OnData : CallID retrieved: "+callID);
                        var appID=appIDs.get(""+callID);
                        isConnect.set(""+appID, true);
			interpretAction(items);
		}

	} // onData


	//
	//
	// InterpretAction when they come back from the server
	//
	//
	private static function interpretAction(Items:Array<Dynamic>){

		var func=callers.get(""+Items[0]);
		var appid=callAppIDs.get(""+Items[0]);

trace("InterPretAction : callid:("+Items[0]+")  func :"+func);

		
		if(func == "initFunc"){
trace("LockCode: |"+Items[1]+"|");
			if(Items[1]=="BAD"){
 				isConnect.set(""+appid, false);
			}else{
				lockIDs.set(""+appid, Std.parseFloat(""+Items[1]));
			}
			// Do not do this outside this IF .. the Set function requires re-visit of this function
			if(Items[0]!=null && Items[0].length > 0)callBack(Items[0]);
		} // initFunc
		if(func == "set"){
	
			// Get The type back
trace("SetProperty: state: "+Items[1]);
			var retry=Std.parseInt(""+Items[2]);
trace("SetProperty: retry: "+Items[2]+" convert :"+retry);
			if(retry > 0){
				//retryCounter.set(""+setApps.get(""+Items[0]), retry);
				retryCounter.set(""+appIDs.get(""+Items[0]), retry);
				
				// Items[0] = CallID
				//setProperty(""+setProps.get(""+Items[0]), ""+setVals.get(""+Items[0]), ""+setApps.get(""+Items[0]), callFunctions.get(""+Items[0]));
				setProperty(""+setProps.get(""+Items[0]), ""+setVals.get(""+Items[0]), ""+appIDs.get(""+Items[0]), Lock.get(""+Items[0]),callFunctions.get(""+Items[0]));
			}else{
				// Done!!
				if(Items[0]!=null && Items[0].length > 0)callBack(Items[0]);
			}
			// result of setProperty
		} // setProperty
		if(func == "get"){
			if(Items[1] != "BAD" && Items[1] != "UNKOWN"){
trace("Request  GETPROPERTY What is the Items[2] :"+Items[2]);
				if(Items[2] == "#!NOT_A_VALUE!#")
					getVals.set(""+Items[0], "");
				else{
					 var p1=StringTools.replace(""+Items[2], ":", "+");
					var p2=StringTools.replace(p1, "_", "/");
					var p3=StringTools.replace(p2, ".", "=");
					getVals.set(""+Items[0],""+p3);
				}
				callBack(Items[0]);
			} // Items
		} // getProperty
		
		if(func == "setlock"){
	
			// Get The type back
trace("SetLock: state: "+Items[1]);
			var retry=Std.parseInt(""+Items[2]);
trace("SetLock: retry: "+Items[2]+" convert :"+retry);
			if(retry > 0){
				//retryCounter.set(""+setApps.get(""+Items[0])+"."+setLockCounters.get(""+Items[0]), retry);
				retryCounter.set(""+appIDs.get(""+Items[0])+"."+setLockCounters.get(""+Items[0]), retry);
				
				// Items[0] = CallID
				//setLock(""+setProps.get(""+Items[0]), ""+setApps.get(""+Items[0]), setLockCounters.get(""+Items[0]), callFunctions.get(""+Items[0]));
				setLock(""+setProps.get(""+Items[0]), ""+appIDs.get(""+Items[0]), setLockCounters.get(""+Items[0]), callFunctions.get(""+Items[0]));
			}else{
				// Done!!
				if(Items[0]!=null && Items[0].length > 0){
					callBack(Items[0]);
				}
			}
		} // setLock
		if(func == "releaselock"){
			// Items[0] == callid	
			// Get The type back
trace("ReleaseLock: state: "+Items[1]);
			var retry=Std.parseInt(""+Items[2]);
trace("ReleaseLock: retry: "+Items[2]+" convert :"+retry);
			if(retry > 0){
				//retryCounter.set(""+setApps.get(""+Items[0])+"."+setLockCounters.get(""+Items[0]), retry);
				retryCounter.set(""+appIDs.get(""+Items[0])+"."+setLockCounters.get(""+Items[0]), retry);
				
				var releaselock=setLockCounters.get(""+Items[0]);
				// Items[0] = CallID
				releaseLock(releaselock, callFunctions.get(""+Items[0]));
			}else{
trace("ReleaseLock : finished .. no retry .. so do we have a CallBackID: "+Items[0]);
				// Done!!
				if(Items[0]!=null && Items[0].length > 0){
					callBack(Items[0]);
				}
			}
		} // releaseLock

	}

	// When onData/ onError are done, call the inside-block functions

	public static function callBack(callID:String){
   		if(callID != null && callID.length > 0){
                        var callback=callFunctions.get(callID);
                        var func=callers.get(callID);
trace("Calling the callback function that we stored("+callID+") : "+callback+" name of func: "+func);
                        if(callback != null) callback();
                }

	} // callBack

	//
	//
        // Store the function to the callers
	//
	// We create an ID which is random and unique to us and store that number with the function_pointer in a List.
	//
	// When we receive data with that ID we know that the data belongs to the call made with this ID
        //
        public static function getCallID(callFunction:String, appID:String, function_pointer:Dynamic):String{
                var retval="";
                var found=true;
                while(found){
                        retval="C"+Std.random(2300023);
                        var chk=callers.get(retval);
                        if(chk == null){
                                found=false;
                                callers.set(retval, callFunction);
				callAppIDs.set(retval,""+appID);
                                callFunctions.set(retval, function_pointer);
                        }
                }
                return retval;
        }






} // class
