// Colyseus.hx
// Colyseus 0.10 No Fossildata but Schema

import com.stencyl.Engine;
import com.stencyl.behavior.Script.*;

import openfl.ui.Keyboard;
import openfl.display.*;
import openfl.ui.Keyboard;
import openfl.display.Sprite;
import openfl.events.Event;
import openfl.events.KeyboardEvent;
import io.colyseus.*;
import com.stencyl.utils.*; // HashMap Count

typedef JSONData = Map<String, {
	var value:String;
}>;

class Colyseus extends Sprite{

	// TO BE DONE :  Is this obsolete by removal of the Lock Logic??? Propably not ...
	private static var equalSplit="@=@";
	private static var oldNewSplit="@$,$@";
	private static var seperateSplit="@|;|@";
	// END OF TO BE DONE

	private var oldSendString:String="!@#$!#%^!!$@#!";
	//private var oldSendTime:Date=Date.now().getTime();
	private var oldSendTime:Float=Date.now().getTime();
	private var lastTime:Float=1000;
	private var hasLeft:Bool=true; // When leaving : hasLeft = true; When Creating/Joinging : hasLeft=false;
	private var minTime:Float=9000;
	private var maxTime:Float=1;
	private var avgTime:Float=100;
	private var avgValue:Float=0;
	private var timeCounter:Float=0;
	
	private var isBusySwitchingRoom:Bool=false;
	public static var colyseus:Colyseus=new Colyseus();

	private var oldAllPlayers:Map<String, Dynamic>=new Map<String, Dynamic>();
		
	public static var isDebug:Bool=true;		
		
	var DataMap:Map<String, Dynamic>=new Map<String, Dynamic>(); // Lock RoomType: Data Map (maybe move to Lock.hx?!)
	var RuleMap:Map<String, Dynamic>=new Map<String, Dynamic>(); // Lock RoomType: all the rules
	public var oldDataMap:Map<String, Dynamic>=new Map<String, Dynamic>(); // Lock RoomType: oldData Map (maybe move to Lock.hx?!)
	
	public var lockIDs:Map<String, String>=new Map<String,String>();
	public var lockTypes:Map<String,String>=new Map<String,String>();
	public var lockStrings:Map<String, String>=new Map<String,String>();
	
	
	public var lockAccept:Map<String, Dynamic>=new Map<String, Dynamic>();
	public var lockDenied:Map<String, Dynamic>=new Map<String, Dynamic>();
	public var lockOutOfSync:Map<String, Dynamic>=new Map<String, Dynamic>();
	public var lockTimeOut:Map<String, Dynamic>=new Map<String, Dynamic>();
	
	
	private var PlayerPos:Float=0;
	private var Direction:Float=0;
	
	//private  var rawroom:Array<Raw>=new Array<Raw>();
	//private var turnroom:Turn=null;
	//private var lockroom:Lock=null;
	private var stencylRoom:Dynamic=null;
		
		
	private  var client:Client;
	private  var room:Room<State>;
	private static var RoomType:String="";
	public var PlayerName:String="UNKNO";
	public var PlayerID:String="";
	private var NrOfSeats:Float=0;
		
	private static var lobby:Lobby; //new lbboy?
	
	public  var ApplicationID:String="";
	private  var isError:Bool=false;
	public  static var  isInit:Bool=false;

	public var ErrorFunc:Dynamic=null;
	public var ErrorText:String="";
	
	//private var rawRoomCounter:Int=-1;
	private var rawRoomCounter:Int=0;
	
	public var ColyseusDataList:Array<Dynamic>=new Array<Dynamic>();
	//private var TurnDataCounter:Float=0;
	

		public function getServerTime(displayType:String):Float{
			var retval:Float=0;
				//
				// 
				var serverTime:Float=0;
				if(lobby != null){
					serverTime=lobby.getServerTime();
				}
				if(displayType == "ROUND")
					retval=Math.fround(serverTime/10); // use fround since round results in integer which is negative on Windows
				else
					retval=serverTime;
				return retval;
		}// getServerTime
		
		
		
		public  function getPingTime(pingType:String):Float{
			var retval:Float=0;
			if(pingType=="CURRENT"){
				retval=lastTime;
			}
			if(pingType=="MAX"){
				retval=maxTime;
			}
			if(pingType=="MIN"){
				retval=minTime;
			}
			if(pingType=="AVG"){
				retval=avgTime;
			}
			
				return retval;
		}// getPingTime
	
	public static function debug(debugString:String){
		if(isDebug){
			// Check if METools exists ...
			/*
			var theClass=Type.resolveClass("METools");
			if(theClass != null) {
				var fl: Dynamic = Reflect.field(theClass, "debug"); //ok,works

				Reflect.callMethod(theClass, fl, [debugString]); 
			}		else trace(""+debugString);
			*/
			trace(""+debugString);
		}

	}
	
	public static function JSONgetMap(data:String):Map<String, Dynamic>{
		var retval:Map<String, Dynamic>=new Map<String,Dynamic>();

        var parse = haxe.Json.parse(data);

		for(field in Reflect.fields(parse)){
			retval.set(field, Reflect.field(parse, field));
		}
debug(" json From "+data+" to Map: "+retval);
        return retval;
	} // JSONgetMap
	
	public static function JSONsetMap(theMap:Map<String,Dynamic>):String{
		var retval:String="";
		
		//race(data["apple"].value); // 10
		retval="{";
		'{"name": "computer", "quantity": "2" }';
		for(item in theMap.keys()){
			retval=retval+'"'+item+'": "'+theMap.get(item)+'", ';
		}
		// remove the last , and add } 
		retval=retval.substring(0,retval.length-2)+"}";
		return retval;
	}// JSONsetMap
	
	// 
	// For TURN Mechanism  : TO BE DONE : Combine both send (Lock/Turn) MAP and get (Lock/turn) MAP 
	//
	public function getTurnMap():Map<String, Dynamic>{
		var theString:String="";
		var theKey:String="";
		var theValue:String="";
		
		var retval:Map<String, Dynamic>=new Map<String,Dynamic>();
		if(!Colyseus.isInit) return retval;
		if(hasLeft){
debug("getTurnMap : stencylRoom in leaving state");		
			return retval;
		}
		var newDataCounter:Int=0;
		
		if(stencylRoom != null && stencylRoom.ColyseusDataList!=null)			newDataCounter=stencylRoom.ColyseusDataList.length;
		
		if(newDataCounter > 0) debug("init getMap : newDataCounter: "+newDataCounter);		
		var dataCounter:Int=0;
//debug(" GetMap : newDataCounter :"+newDataCounter);		
		
		while(stencylRoom != null && stencylRoom.ColyseusDataList != null && stencylRoom.ColyseusDataList.length > 0){

			theString=""+stencylRoom.ColyseusDataList[0];
			
			if(theString != null && theString.length > 0){
				var keyPair:Array<Dynamic>=theString.split(seperateSplit);
				if(keyPair != null){
					for(keyPairValue in keyPair){
						var EqualParts=keyPairValue.split(equalSplit);
						theKey=EqualParts[0];
						theValue=EqualParts[1];
						//if(theValue!=null && theValue.indexOf(oldNewSplit) > -1) theValue=theValue.split(oldNewSplit)[0];
debug("GETTURNMAP_: theKey: "+theKey+" theValue: "+theValue);						

							retval.set(theKey, theValue);
						
					} // for key
				} // if key
debug(" getTurnMap getting to Stencyl.behavior.DataList				: "+theString);
		
			}
			stencylRoom.ColyseusDataList.splice(0,1);

		}
		
		return retval;
	} //getTurnMap
	
	
	//
	// For Lock Mechanism : memory  property system
	//
	public function getMap():Map<String, Dynamic>{
		var theString:String="";
		var theKey:String="";
		var theValue:String="";
		
		var retval:Map<String, Dynamic>=new Map<String,Dynamic>();
		if(!Colyseus.isInit) return retval;
		if(hasLeft){
debug("getMap : stencylRoom in leaving state");		
			return retval;
		}
		var newDataCounter:Int=0;
		
		if(stencylRoom != null && stencylRoom.ColyseusDataList!=null)			newDataCounter=stencylRoom.ColyseusDataList.length;
		
		if(newDataCounter > 0) debug("init getMap : newDataCounter: "+newDataCounter);		
		var dataCounter:Int=0;
//debug(" GetMap : newDataCounter :"+newDataCounter);		
		
		while(stencylRoom != null && stencylRoom.ColyseusDataList != null && stencylRoom.ColyseusDataList.length > 0){

			theString=""+stencylRoom.ColyseusDataList[0];
debug("getMap: theString: "+theString); //  getMap: theString: 76@=@1000@$,$@null@|;|@86@=@null@$,$@1000@|;|@
			if(theString != null && theString.length > 0){
				var keyPair:Array<Dynamic>=theString.split(seperateSplit);
				if(keyPair != null){
					for(keyPairValue in keyPair){
						var EqualParts=keyPairValue.split(equalSplit);
						theKey=EqualParts[0];
						theValue=EqualParts[1];
						if(theValue!=null && theValue.indexOf(oldNewSplit) > -1) theValue=theValue.split(oldNewSplit)[0]; else theValue="null";
debug("GETMAP_: theKey: "+theKey+" theValue: "+theValue);	
						// Do not remove the value when it is null : let the extension user delete it from their map 
						retval.set(theKey, theValue);
						oldDataMap.set(theKey,theValue);
					} // for key
				} // if key
debug(" datalist getting to Stencyl.behavior.DataList				: "+theString);
		
			}
			stencylRoom.ColyseusDataList.splice(0,1);

		}
		
		return retval;
	} //getMap
	
	 
	public function getList():Array<Dynamic>{
		if(!Colyseus.isInit) return new Array<Dynamic>() ;
		if(hasLeft){
debug("getList : stencylRoom in leaving state");		
			 return new Array<Dynamic>() ;
		}		
		var retval:Array<Dynamic>=new Array<Dynamic>();
		//var newDataCounter:Float=Std.parseFloat(""+(ColyseusDataList.length-lastObtained));
		var newDataCounter:Float=0.0;
		if(stencylRoom == null) return retval;
		
		var theString:String="";
		while(stencylRoom.ColyseusDataList.length > 0){

			theString=""+stencylRoom.ColyseusDataList[0];
			
			if(theString != null && theString.length > 0){
				
				calcPingTime(theString);
				
				retval.push(""+theString);
			}
			stencylRoom.ColyseusDataList.splice(0,1);

		}
		
	// Swap first in , first out
	retval.reverse();
	
if(isDebug)if(retval.length  > 0 )debug("GetList datalist Return : "+retval);		
		return retval;
	} // getList
			
	
	
	private function calcPingTime(theString:String){
		if(theString.substr(0,oldSendString.length) == oldSendString){
			lastTime=Math.round(Date.now().getTime()-oldSendTime);
			avgValue=avgValue+lastTime;
			if(lastTime > maxTime)if(lastTime > 10)maxTime=Math.round(lastTime);
			if(lastTime < minTime)if(lastTime > 10)minTime=Math.round(lastTime);
			avgTime= Math.round(avgValue/timeCounter);
			oldSendString="@#$!Q#Q@#$!@$!@#";
			timeCounter++;
		}
	}//calcPingTime
	
	
	public function new() {
		super();
	}
	
	public function init(server:String,playerName:String, applicationID:String) {
	
		ApplicationID=applicationID;
		isError=false;

		rawRoomCounter=0;
		hasLeft=true;
		lobby=new Lobby();
			
		PlayerName=""+playerName;
		
		// Use server string+Port : server = "192.168.2.252:5566" 
debug(" (init) CLIENT NEW calling");
		this.client = new Client("ws://"+server+"");
		/**
		 * Client callbacks
		 */
		this.client.onOpen = function() {
debug("CLIENT OPEN (CLIENT.ONJOIN), id => " + this.client.id);
			PlayerID=""+this.client.id;
			Colyseus.isInit=true;
			// (roomName: String, ?options: Map<String, Dynamic>, ?cls: Class<T>):
			/////this.room = this.client.join("lobby", new Map<String,Dynamic>(), State);
			lobby.join(this.client,this);

		};

		this.client.onClose = function() {
			Colyseus.isInit=false;
		};

		this.client.onError = function(message) {
				if(getGameAttribute("ColyseusErrorCounter") == null) setGameAttribute("ColyseusErrorCounter", 0);
				setGameAttribute("ColyseusErrorCounter", getGameAttribute("ColyseusErrorCounter")+1);
				callErrorBlock("[Colyseus.Client] "+message);
		};

			
   } // init
   
   public  function disconnect(){
debug(" Colyseus.disconnect called");
	   if(lobby != null && lobby.room != null) {
			hasLeft=true;
			if(stencylRoom != null && stencylRoom.room != null) stencylRoom.room.leave();
			lobby.room.leave();
			var disconnectTimer = new haxe.Timer(200);  
			disconnectTimer.run = function() {
				disconnectTimer.stop();
				lobby=null;
				if(this.client != null)	   this.client.close();
			}
		}
	   
   
   }
   
   
   public function getErrorText():String{
	   return ErrorText;
   }
   
   // [Colyseus_CreateRooms_v2.exe] io/colyseus/Room.hx:82: Possible causes: room's onAuth() failed or maxClients has been reached.
   
   public function callErrorBlock(Message:String){
debug(" ERROR BLOCK CALLING with text: "+Message);
	   ErrorText=Message;
	   if(ErrorFunc != null) ErrorFunc();
   }//
   
   public  function isInitialized():Bool{
		var retval:Bool=false;
		
		return Colyseus.isInit;
	} //Colyseus.isInit
	

	private function onUpdate(e:Event):Void {
	}

	public function send(theString:String){
		if(!Colyseus.isInit)return;
		if(hasLeft){
debug("send : stencylRoom in leaving state");		
			 return ;
		}		

		if(stencylRoom != null && stencylRoom.room != null){
debug("Sending data: "+theString);			
			stencylRoom.room.send(""+theString);
			oldSendString=""+theString;
			oldSendTime=Date.now().getTime();
		}
		
	} //sendString
	
	
	public function sendTurnMap(theMap:Map<String,Dynamic>){
		if(!Colyseus.isInit)return;
		if(hasLeft){
debug("sendMap : stencylRoom in leaving state");		
			 return ;
		}		

debug("SendTurnMap : theMap: "+theMap);		
		if(theMap == null) return;
		var theString:String="";
		// Make theString of the new data to be sent with getting the same data converted to empty text when it has olddata
		// theString="key=newvalue_from_theMap;key2 ...";
		for(theMapKey in theMap.keys()){
				theString=theString+theMapKey+equalSplit+theMap.get(theMapKey)+seperateSplit;
		}
		theString="TURNDATA*"+seperateSplit+theString;
		// then afterwards set the oldDataMap to the sendmap value
debug("SendTurnMap (init ?) : theString = " +theString);		
		send(theString);
	} //sendMap
	
	// SendMap should only be used by the active user
	// Normally you would use lockrequest mechanism to send/change data that is already present on the server
	// There is no locking involved with sendMap
	// This can lead to out-of-sync  : but that is ok : the out-of-sync should call getallserverdata to get the latest state of the server
	public function sendMap(theMap:Map<String,Dynamic>){
		if(!isTurn()) return;
		if(!Colyseus.isInit)return;
		if(hasLeft){
debug("sendMap : stencylRoom in leaving state");		
			 return ;
		}		

debug("SendMap : theMap: "+theMap);		
		if(theMap == null) return;
		var theString:String="";
		//oldDataMap : the data map that is internal in the extension; it contains the old data that has been receireceived
		// Make theString of the new data to be sent with getting the same data converted to empty text when it has olddata
		// theString="key=newvalue_from_theMap,oldvalue_from_oldDataMap;key2 ...";
		for(theMapKey in theMap.keys()){
				var temp:String=oldDataMap.get(theMapKey);
				if(temp == null) temp="null"; // Maybe set to null ? So that the server can always accept the newValue?!?
				theString=theString+seperateSplit+theMapKey+equalSplit+theMap.get(theMapKey)+oldNewSplit+temp+seperateSplit;
		}
		theString="LOCKDATA*"+theString;
		// then afterwards set the oldDataMap to the sendmap value
debug("SendMap (init ?) : theString = " +theString);		
		send(theString);
	} //sendMap
	
	// getAllServerData : oldDataMap reset
	public function getAllServerData(){
		if(hasLeft){
debug("getAllServerData : stencylRoom in leaving state");		
			 return ;
		}		
	
		oldDataMap=new Map<String, Dynamic>();
debug("Colyseus: getAllServerData .. roomtype: ["+RoomType+"]");		
		if(stencylRoom != null && stencylRoom.room != null){
			stencylRoom.room.send("GETLOCKDATA*");
		}else{
			debug("getAllServerData : Room is invalid (create or join!)");
		}
	} // getallServerData
	
	
	public function getRoomID():String{
		if(!Colyseus.isInit)return "";
		
		if(stencylRoom == null || stencylRoom.room == null){
//debug(" getroomID : stencylROom is NULL");			
			return "";
		}
		var retval:String=""+stencylRoom.room.id;
		
		return retval;
		
	} // getRoomID
	
	public function createRoom(RoomName:String, roomType:String, okFunc:Dynamic):Void{

		RoomType=roomType;
		if(isBusySwitchingRoom){
debug("CreateRoom : IsBusySwitchingRooms!!! .. return nothing!");
			return; // avoid multiple calls
		}
		isBusySwitchingRoom=true;		
		var theOptions:Map<String, Dynamic>=new Map<String,Dynamic>();
		theOptions.set("RoomName", ""+RoomName);
		theOptions.set("PlayerName", PlayerName);
		theOptions.set("CreateOrJoin", "CREATE");
		theOptions.set("ApplicationID", ApplicationID);
		theOptions.set("PlayerID", PlayerID);
		theOptions.set("RoomID", "");
		//theOptions.set("nrOfSeats", NrOfSeats);
		
		if(stencylRoom != null){
			if(stencylRoom.isJoined){
				hasLeft=true;
				stencylRoom.room.leave();
				stencylRoom = null;
			}
		}
debug(" Create and Join : 		"+roomType);
		var createRoomTimer = new haxe.Timer(1000);  // was 1000 : possibly too fast to join?!?
		createRoomTimer.run = function() {
			createRoomTimer.stop();
			if(roomType=="LOCK"){
				hasLeft=false;
				stencylRoom=new Lock();
				
				lockAccept=new Map<String, Dynamic>();
				lockDenied=new Map<String, Dynamic>();
				lockOutOfSync=new Map<String, Dynamic>();
				lockTimeOut=new Map<String, Dynamic>();
				lockIDs=new Map<String,String>();
				lockStrings=new Map<String,String>();
debug(" Create and Join : LOCK");				
			}
			if(roomType=="TURN"){
				hasLeft=false;
				stencylRoom=new Turn();
				
			}
			if(roomType=="RAW"){
				hasLeft=false;
debug(" CreateRoom : Create Type RAW");				
				stencylRoom=new Raw();
debug(" CreateRoom : after new Raw");				
			}
			if(stencylRoom != null){
				hasLeft=true;
debug(" Joining the created new created room:  this.client: "+this.client+" this: "+this+" theoptions: "+theOptions);								
//debug("This Client.connection : "+this.client.connection.ws.impl);
				stencylRoom.join(this.client,this,theOptions);				
//debug(" After Join Call: "+stencylRoom+" ");								
				var createRoomTimer2 = new haxe.Timer(1000);  // 1000 possibly too fast?!?!
				createRoomTimer2.run = function() {
					
					
					if(stencylRoom != null && stencylRoom.room != null){
//debug(" In createroomtimer2 : stencylroom: "+stencylRoom+" and what is the stencylroom.room? "+stencylRoom.room);														
						createRoomTimer2.stop();
						isBusySwitchingRoom=false;	
debug("CreateRoom Timer2 id:"+stencylRoom.room.id);		
							
						if(stencylRoom.room.id != null){
debug("CreateRoom    PlayerID:"+PlayerID);		
							hasLeft=false;
							lobby.addRoomInfo(""+stencylRoom.room.id+"@"+PlayerID);					
								//lobby room .. add player to roomid
debug("CreateRoom id:"+stencylRoom.room.id);		
						
							if(okFunc!=null){
debug("CreateRoom    id:"+stencylRoom.room.id+" Callin okFunc!!!");		
								okFunc();
							}
						}else{
							// try again
debug("CreateRoom   : StencylRoom.room.id == null .... Try Again ... ");										
								createRoom(RoomName, roomType, okFunc);
						}
					
						
					}else{
						createRoomTimer2.stop();
						// try again
						createRoom(RoomName, roomType, okFunc);
					}
				} // createRoomTimer2 function
			} // stencylRoom valid
		} // createRoomTimer
		
		
	} //createRoom
	
	
	// leaveRoom(roomType:String,  
	public function leaveRoom( leaveFunc:Dynamic):Void{
		hasLeft=true;
		if(lobby != null && stencylRoom != null&& stencylRoom.room != null) {
			// lobby room remove player from roomid
			lobby.addRoomInfo(""+stencylRoom.room.id+"%"+PlayerID); // percent indicates removal ?? TO BE DONE: Check please!
			
			stencylRoom.room.leave();
			
			var leaveTimer = new haxe.Timer(500);   // 200 possibly too fast?!?
				leaveTimer.run = function() {
					leaveTimer.stop();
					stencylRoom = null;
					if(leaveFunc != null) leaveFunc();
			}// leaveTimer
			
		}else{
			if(leaveFunc != null) leaveFunc();
		}
		
	} // leaveRoom
	
	
	
	public function joinRoom(id:String, roomType:String, func:Dynamic){
			
		var theOptions:Map<String, Dynamic>=new Map<String,Dynamic>();
		theOptions.set("CreateOrJoin", "JOIN");
		theOptions.set("PlayerName", PlayerName);
		theOptions.set("PlayerID", PlayerID);
		theOptions.set("RoomID", ""+id);
		theOptions.set("ApplicationID", ApplicationID);

		RoomType=roomType;
debug("JOINING the options: "+theOptions+"                   RoomType: "+roomType);
				
		var doNotJoin:Bool=false;
		
		
			if(stencylRoom!=null){
				if(stencylRoom.isJoined){
					if(stencylRoom.room.id != id){
						stencylRoom.room.leave();
						hasLeft=true;
						stencylRoom = null;
					}else{
						doNotJoin=true;
						// if(func != null)func();
						debug(" (JoinRoom) Already joined to "+id);
					}
				}

			} // !=null
			else{
debug(" JoinRoom : stencylRoom is NULL!");
			}
			
			if(!doNotJoin){
				var joinTimer = new haxe.Timer(1000);   // possibly 500 too fast?!
				joinTimer.run = function() {
					joinTimer.stop();
					
debug(" Now joining room : "+id);

					hasLeft=true;
					if(roomType == "LOCK") stencylRoom=new Lock();
					if(roomType == "TURN") stencylRoom=new Turn();
					if(roomType == "RAW") stencylRoom=new Raw();
					if(stencylRoom == null){
debug(" joinRoom: StencylRoom not initialized!!");						
						return ;
					}
					hasLeft=false; //??
					stencylRoom.join(this.client, this, theOptions);
					var joinTimer2 = new haxe.Timer(1000);  // possibly 500 too fast?!
					joinTimer2.run = function() {
						joinTimer2.stop();
						if(stencylRoom != null){
							if(stencylRoom.room != null && stencylRoom.room.id != null){
								lobby.addRoomInfo(""+stencylRoom.room.id+"@"+PlayerID);
								hasLeft=false;
								//lobby room .. add player to roomid
								//isBusySwitchingRoom=false;
								if(func != null)func();
							}else{
								// try again
								joinRoom(id, roomType, func);
							}
						}else{
								// try again
								joinRoom(id, roomType, func);
						}
					}
				} 
			} // donotjoin
		
	} // roomJoin 
	
	
	//public function getRoomList(roomType:String):Map<String,Dynamic>{
	public function getRoomList(roomType:String):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
			
		if(lobby == null){
debug(" getRoomList : Lobby is NULL");			
			return retval;
		}
		
		// Get RoomList based on ApplicationID
		retval=lobby.RoomList.get((""+roomType).toUpperCase());
		if(retval==null){
			retval=new Array<Dynamic>();
		}
		return retval;
	} // getRoomList
	
	public function getPlayerID(playerName:String):String{
		if(!Colyseus.isInit)return "";
		if(lobby == null) return "";
		return ""+lobby.LobbyPlayerIDs.get(""+playerName);
		
	} // getPlayerID
	
	
	public function getPlayerNameFromID(playerID:String):String{
		var retval:String="";
		if(lobby == null || lobby.LobbyPlayerIDs== null) return "";
		
		for(playername in lobby.LobbyPlayerIDs.keys()){
			if(lobby.LobbyPlayerIDs.get(playername) == playerID) retval=playername;
		}
		return retval;
	} // getPlayerNameFromID
	
	
	private function getRoomNameFromID(roomID:String):String{
		var retval:String="";
		var isFound:Bool=false;
		if(lobby.RoomNames == null) return "";
		for(roomType in (lobby.RoomNames.keys())){
			if(!isFound){
				var roomNames:Map<String, Dynamic>=lobby.RoomNames.get((""+roomType).toUpperCase());
				var theName=roomNames.get(""+roomID);
				if(theName!=null){
					retval=""+theName;
					isFound=true;
				}else retval="";
			}
		}
		return retval;
	} // getRoomNameFromID
	
	public function getRoomInfo(roomID:String, property:String):Dynamic{
		var retval:Dynamic=null;
//trace("Lobby getRoomInfo;  roomID : "+roomID+"  property: "+property);		
		if(lobby == null ||lobby.RoomNames == null || lobby.RoomPlayers == null) return new Array<Dynamic>();
	
		if(property=="roomname"){
				// go through all the roomtypes and get the roomNames 
					retval=getRoomNameFromID(roomID);
		}
		
		if(property == "playernames"){
				var retval=new Array<Dynamic>();
				
//trace("lobby : getRoomInfo : playernames : RoomID: "+roomID);				
				//var roomName:String=getRoomNameFromID(""+roomID);
//trace("lobby : getRoomInfo : playernames : RoomName: "+roomName);								
				//if(roomName == null)roomName="";
				var playerList:Array<Dynamic>=lobby.RoomPlayers.get(roomID);
//trace("lobby : getRoomInfo : playernames : lobby.RoomPlayers: "+lobby.RoomPlayers);								
				
				if(playerList != null){
					for(player in playerList){
						if(player != null && player.length > 0){
							retval.push(player);
						}
					}
				}
				return retval;
				
		}
		
		// Number of players in room : length playerNames list  : rawroom[rawRoomCounter].playerNames.length
		// We need a way to get the number of clients WITHOUT joining the room .. so ask Lobby !!!
		if(property== "clients"){
			var retval:Int=0;
				var isFound:Bool=false;
//				var roomName:String=getRoomNameFromID(""+roomID);
//				if(roomName == null)roomName="";

				var playerList:Array<Dynamic>=lobby.RoomPlayers.get(roomID);
				
				if(playerList != null){
					//retval=playerList.length;
					for(player in playerList){
						if(player != null && player.length > 0){
//trace("Debug NrOfPlayers : "+retval+" player = ("+player+")");							
							retval++;
						}
					} // each player in list (check if name is present)
				}
			return retval;
			
		}
		
		return retval;
	} // getRoomInfo
	
	
	// TO BE DONE : OBSOLETE ? can't we do that on client?!
	/*
	public function setMaxPlayers(nrOfPlayers:Float){
		if(RoomType=="TURN"){
			if(turnroom!=null){
				send("SETMAXPLAYERS="+nrOfPlayers);
			}
		}
	} // 
	
	public function getNrOfPlayers(NRPlayerRoomID:String){
		if(RoomType=="TURN"){
			if(turnroom!=null){
				send("GETNRPLAYERS="+NRPlayerRoomID);
			}
		}
	} // getNrOfPlayers
	*/
	
	// TURN : For A.I. = client makes moves for players that have left
	// Slots is the number of seats that are in a room. For instance 2 for tictactoe, 6 for poker
	public function getBetweenPlayers(NrOfSlots:Float):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		if(isTurn()){
				var activeSeat:Float=getActiveSeatNR();
				
                // activeSeat
                // var activeSeat // getActiveSeatNR

trace("getBetweenPlayers: ActiveSeat: "+activeSeat);				
                var inspectPos:Int=Std.int(activeSeat)-1;
                var isStop:Bool=false;
				var lastPlayerSeat:Int=-1;
                var nrOfSeats:Float=0;
				var playerList:Array<Dynamic>=lobby.RoomPlayers.get(getRoomID());
				
trace("getBetweenPlayers: lobby.RoomPlayers.get("+getRoomID()+") resulting playerList: "+playerList);		

trace("getBetweenPlayers: lobby.RoomPlayers = ("+lobby.RoomPlayers+") ");		

		
				if(playerList == null) return retval;

				// Debug
				for(i in 0 ... 1000){
					if(getPlayerInSeat(i).length > 0){
						trace("getBetweenPlayers: player in seat:("+i+") = "+getPlayerInSeat(i));	
						lastPlayerSeat=i;
					}
				}
				
				nrOfSeats=playerList.length;
				var inspectCounter:Int=1;
				while(!isStop){
                        if(inspectPos < 0) inspectPos=Std.parseInt(""+NrOfSlots)-1;
						
                        //if(seat[inspectPos] != 0){
						if(getPlayerInSeat(inspectPos) == null || getPlayerInSeat(inspectPos) == "" ){
trace("getBetweenPlayers: is inspectpos/inspectCounter: "+inspectCounter+" > NrOfSlots: "+NrOfSlots+"   ? ");
							if(inspectCounter > NrOfSlots){
								isStop=true;
							}else{
									retval.push(inspectPos);
							}
                              
                        }else{
								isStop=true;
                              
                        }
                        inspectPos--;
						inspectCounter++;
                }
                // swap all entries in the list so that the last becomes the first
                retval.reverse();
trace("getBetweenPlayers: lobby.RoomPlayers.get(roomid) resulting lengt: "+nrOfSeats+" playerList: "+retval);				

                // Display the order of the seats between the last player and the active player
				// Debug
                for(i in 0 ... retval.length){
debug(" getBetweenPlayers ["+activeSeat+"]  BetweenPrevious and Last and Current is Seat number = "+retval[i]);

                }

			
		}
		return retval;
	} // getBetweenPlayers



	
	public function isTurn():Bool{
		var retval:Bool=false;
		if(hasLeft){
debug("isTurn: stencylRoom in leaving state");		
			 return retval;
		}		
			
		//retval = (getActiveSeatNR() == getSeat());
		retval = (getActivePlayer() == getPlayerInSeat(getSeat()));
		return retval;
	} // isTurn
	
	
	public function nextTurn(){
		// Give the next seat control
		send("NEXTTURN");
		
		
	} // nextTurn
	
	
	public function onNextTurn(onNextFunction:Dynamic){
		var oldActivePlayerID:String="";
		var activePlayerID:String="";
		var playerID_InSeat:String="";
		if(onNextFunction != null){
			// each millisecond check
			var onNextTimer = new haxe.Timer(10);  
			onNextTimer.run = function() {
				if(stencylRoom != null){
					activePlayerID=""+stencylRoom.getActivePlayerID();		
					if(activePlayerID != oldActivePlayerID){
							oldActivePlayerID=activePlayerID;
							onNextFunction();
					}
				} // ifStencylRoom
			} // onNextTimer
		}
	} // onNextTurn
	
	public function getSeat():Float{
		var retval:Float=-1.0;
		if(stencylRoom == null){
debug(" getSeat : stencylRoom is NULL");			
			return retval;
		}
		if(hasLeft){
debug("getSeat: stencylRoom in leaving state");		
			 return retval;
		}		
			
		var temp:String=""+stencylRoom.getSeatNR();
		if(temp.length  > 0 )retval=Std.parseFloat(""+temp);
		
		return retval;
	} //getSeat
	
	//              setActiveSeatNR
	public function setActiveSeatNR(seatNR:Float){
		if(stencylRoom == null || stencylRoom.room == null){
debug(" setActiveSeatNR : stencylRoom or stencylroom.room is NULL");
			return;
		}
		if(hasLeft){
debug("setActiveSeatNR: stencylRoom in leaving state");		
			 return;
		}		
			
		//stencylRoom.setActiveSeatNR(seatNR);
		var sendText:String="SETACTIVESEATNR:"+seatNR;
		stencylRoom.room.send(""+sendText);
		
	}// setActiveSeatNR
	
	public function getActiveSeatNR():Float{
		var retval:Float=0;
		if(stencylRoom == null){
debug(" getActiveSeatNR : stencylRoom is NULL");
			return -1;
		}
		if(hasLeft){
debug("getActiveSeatNR: stencylRoom in leaving state");		
			 return -1;
		}		
			
		retval=Std.parseFloat(""+stencylRoom.getActiveSeatNR());
		return retval;
		
	} // getActiveSeatNR
	
	
	public function getPlayerInSeat(seatNr: Float): String{
		var retval:String="";
		if(stencylRoom == null){
debug(" stencylRoom is NULL !");		
			return "";
		}
		if(hasLeft){
debug("getPlayerInSeat: stencylRoom in leaving state");		
			 return retval;
		}		
	
		retval=""+stencylRoom.getPlayerInSeat(""+seatNr);
		if(retval==null || retval=="null")retval="";
		return retval;
		
	} // getPlayerInSeat
	
	public function getActivePlayer():String{
		var retval:String="";
		if(stencylRoom == null){
debug(" getActivePlayer : stencylRoom is NULL");
				return "";
		}
		if(hasLeft){
debug("getActivePlayer: stencylRoom in leaving state");		
			 return retval;
		}		
	
		retval=""+stencylRoom.getActivePlayerID();
		
		if(retval==null || retval=="null")retval="";
		return retval;
	} // getActivePlayer
	

	public function onError(errorFunc:Dynamic):Void{
			if(getGameAttribute("ColyseusErrorCounter") == null) setGameAttribute("ColyseusErrorCounter", 0);
			// do not increase errorcounter. This onError is merely there to MAKE the onError function active
			ErrorFunc=errorFunc;
	} // onError
	
	//
	// ON-Lock events
	//
	//public function onLockRequest(lockType:String, lockString:String,  lockID:String, lockFunc:Dynamic):Void{
	/*	
	// TO BE DONE : remove the lockType : we do only Data with the lock system!
	public function onLockRequest(lockType:String, lockMap:Map<String,Dynamic>,  lockID:String, lockFunc:Dynamic):Void{
		if(hasLeft){
debug("onLockRequest: stencylRoom in leaving state");		
			 return ;
		}		
			
		if(RoomType!="LOCK"){
debug("onLockRequest: RoomType is not LOCK !!");
			return;
		}
		//if(lockroom==null){
		if(stencylRoom == null){
debug("onLockRequst: LockRoom is not joined or created!");
			return;
		}
		if(lockMap == null){
debug("onLockRequest : LockMap is null : provide a MAP data type!");		
			return;
		}
		
		var sendText:String="";
		var lockString:String=""+lockMap;
debug("onLockRequest");
debug("lockMap: "+lockString );
debug(" Lock ID: " +lockID);
debug(" Function : "+lockFunc );
		lockString="";
		for(item in lockMap.keys()){
			var temp:String=oldDataMap.get(item);
			if(temp==null)temp="";
			if(temp.indexOf(oldNewSplit) > -1) temp=temp.split(oldNewSplit)[0];
			lockString=lockString+item+equalSplit+lockMap.get(item)+oldNewSplit+temp+seperateSplit;
			oldDataMap.set(item, ""+temp);
		}
debug(" lockmap converted into lockString to be send with LOCKREQUEST: "+lockString);
	
		// check if the lockID is not used elsewhere
		if(lockIDs.get(""+lockID) != null){
			debug("The lockID: "+lockID+" is already used with value: "+lockIDs.get(""+lockID));
		}else{
			lockTypes.set(""+lockID, lockType);
			lockIDs.set(""+lockID, lockString+"*"+(Date.now().getTime()));
			lockStrings.set(""+lockID, lockString);
			
			if(lockFunc != null) lockFunc();
			// Execute lockFunc before sending data... So that the onLock... functions can register themselves
			if(lockType=="DATA"){
				sendText="LOCKREQUEST*"+lockID+"*"+lockString+"*";
				//lockroom.room.send(sendText);
				stencylRoom.room.send(""+sendText);
				
			}else{
				sendText="LOCKROOM*"+colyseus.PlayerID+"*"+lockID+"*"+lockString+"*";
				//lockroom.room.send(sendText);
				stencylRoom.room.send(""+sendText);
			}
debug("onLockRequest : this is send to the serer: "+sendText);
			//room.send("LOCKROOM*"+colyseus.PlayerID+"*"+LockRequest);
		}
	} //onLockRequest
	*/


	
	
	// TO BE DONE : remove the lockType : we do only Data with the lock system!
	public function onLockRequest( lockMap:Map<String,Dynamic>,  lockID:String, lockFunc:Dynamic):Void{
		if(hasLeft){
debug("onLockRequest: stencylRoom in leaving state");		
			 return ;
		}		
			
		//if(lockroom==null){
		if(stencylRoom == null){
debug("onLockRequst: LockRoom is not joined or created!");
			return;
		}
		if(lockMap == null){
debug("onLockRequest : LockMap is null : provide a MAP data type!");		
			return;
		}
		
		var sendText:String="";
		var lockString:String=""+lockMap;
debug("onLockRequest");
debug("lockMap: "+lockString );
debug(" Lock ID: " +lockID);
debug(" Function : "+lockFunc );
		lockString="";
		for(item in lockMap.keys()){
			var temp:String=oldDataMap.get(item);
			if(temp==null)temp="null";
			if(temp.indexOf(oldNewSplit) > -1) temp=temp.split(oldNewSplit)[0];
			lockString=lockString+item+equalSplit+lockMap.get(item)+oldNewSplit+temp+seperateSplit;
			//oldDataMap.set(item, ""+temp); // in getmap we set the oldmap value to the new received oldvalue from the server
		}
debug(" lockmap converted into lockString to be send with LOCKREQUEST: "+lockString);
	
		// check if the lockID is not used elsewhere
		if(lockIDs.get(""+lockID) != null){
			debug("The lockID: "+lockID+" is already used with value: "+lockIDs.get(""+lockID));
		}else{
			//lockTypes.set(""+lockID, lockType);
			lockIDs.set(""+lockID, lockString+"*"+(Date.now().getTime()));
			lockStrings.set(""+lockID, lockString);
			
			if(lockFunc != null) lockFunc();
			// Execute lockFunc before sending data... So that the onLock... functions can register themselves
			sendText="LOCKREQUEST*"+lockID+"*"+lockString+"*";
			//lockroom.room.send(sendText);
			stencylRoom.room.send(""+sendText);
			
debug("onLockRequest : this is send to the serer: "+sendText);
			//room.send("LOCKROOM*"+colyseus.PlayerID+"*"+LockRequest);
		}
	} //onLockRequest


	
	
	public function onLockDynamic(lockID:String, lockAction:String, lockFunc:Dynamic):Void{
		if(lockAction == "ACCEPT")		onLockAccept(lockID, lockFunc);
		if(lockAction == "DENY") 		onLockDenied(lockID, lockFunc);
		if(lockAction == "TIME-OUT") 	onLockTimeOut(lockID, lockFunc);
		if(lockAction == "OUT-OF-SYNC")	onLockOutOfSync(lockID, lockFunc);
		// Do not remove lockID from lockids-map since you want to have unique values. Do not re-use lockid!
		
	}
	
	
	
	
	public function onLockAccept(lockID:String, lockFunc:Dynamic):Void{
		if(RoomType!="LOCK")return;
		if(hasLeft){
debug("onLockAccept: stencylRoom in leaving state");		
			 return ;
		}		
	
		
		if(stencylRoom == null || stencylRoom.room == null) return;
			
debug("  onLockAccept : ADD to lockAccept functions with lockID: "+lockID);
		lockAccept.set(""+lockID, lockFunc);
		//if(lockFunc != null) lockFunc();
	} // onLockAccept
	
	public function onLockDenied(lockID:String, lockFunc:Dynamic):Void{
		if(RoomType!="LOCK")return;
		if(hasLeft){
debug("onLockDenied: stencylRoom in leaving state");		
			 return ;
		}		
	
		if(stencylRoom == null || stencylRoom.room == null) return;

debug("  ADD to lockDenied functions with lockid "+lockID);
			lockDenied.set(""+lockID, lockFunc);
			
	} // onLockDenied

	public function onLockTimeOut(lockID:String, lockFunc:Dynamic):Void{
		if(RoomType!="LOCK")return;
			if(hasLeft){
debug("onLockTimeout: stencylRoom in leaving state");		
			 return ;
		}		
	
		if(stencylRoom == null || stencylRoom.room == null) return;
//debug(" Add to onLockTimeOut functions with  lockID: "+lockID);
			lockTimeOut.set(""+lockID, lockFunc);
	} // onLockTimeout
	
	public function onLockOutOfSync(lockID:String, lockFunc:Dynamic):Void{
		if(RoomType!="LOCK")return;
		if(hasLeft){
debug("onLockOutOfSync: stencylRoom in leaving state");		
			 return ;
		}		
	
		if(stencylRoom == null || stencylRoom.room == null) return;

//debug(" ADD to onLockOutOfSync functions with lockID: "+lockID);
			lockOutOfSync.set(""+lockID, lockFunc);
	} // onLockOutOfSync
	
	// End of ON-events Lock 
	

 	
		
} // Colyseus Class



