// Colyseus.hx
// Colyseus 0.10 No Fossildata but Schema


import com.stencyl.Engine;
import com.stencyl.behavior.Script.*;

import openfl.ui.Keyboard;
import openfl.display.*;
import openfl.ui.Keyboard;
import openfl.display.Sprite;
import openfl.events.Event;
import openfl.events.KeyboardEvent;
import io.colyseus.*;


import com.stencyl.utils.*; // HashMap Count

class Colyseus extends Sprite{

	private var isBusySwitchingRoom:Bool=false;
	public static var colyseus:Colyseus=new Colyseus();

	
	var DataMap:Map<String, Dynamic>=new Map<String, Dynamic>(); // Lock RoomType: Data Map (maybe move to Lock.hx?!)
	var RuleMap:Map<String, Dynamic>=new Map<String, Dynamic>(); // Lock RoomType: all the rules
	
	
	private var PlayerPos:Float=0;
	private var Direction:Float=0;
	
		private  var rawroom:Array<Raw>=new Array<Raw>();
		private var turnroom:Turn=null;
		private var lockroom:Lock=null;
		
		
	private  var client:Client;
	private  var room:Room<State>;
	private static var RoomType:String="";
	public var PlayerName:String="UNKNO";
	public var PlayerID:String="";
	private var NrOfSeats:Float=0;
		
	private var lobby:Lobby; //new lbboy?
	
	public  var ApplicationID:String="";
	private  var isError:Bool=false;
	public  static var  isInit:Bool=false;

	//private var rawRoomCounter:Int=-1;
	private var rawRoomCounter:Int=0;
	
	public var ColyseusDataList:Array<Dynamic>=new Array<Dynamic>();
	private var TurnDataCounter:Float=0;
	
	// getData
	public function getList(lastObtained:Float):Array<Dynamic>{
		if(!Colyseus.isInit) return new Array<Dynamic>() ;
		var retval:Array<Dynamic>=new Array<Dynamic>();
		//var newDataCounter:Float=Std.parseFloat(""+(ColyseusDataList.length-lastObtained));
		var newDataCounter:Float=0.0;
		
		if(RoomType == "RAW" && rawroom[rawRoomCounter] != null){
				//newDataCounter=Std.parseFloat(""+(rawroom[rawRoomCounter].ColyseusRawDataList.length-lastObtained));
				newDataCounter=rawroom[rawRoomCounter].ColyseusRawDataList.length;
		}
		//if(RoomType == "TURN"  && turnroom != null) newDataCounter=Std.parseFloat(""+(turnroom.ColyseusTurnDataList.length-lastObtained));
		if(RoomType == "TURN"  && turnroom != null){ //newDataCounter=Std.parseFloat(""+(turnroom.ColyseusTurnDataList.length-TurnDataCounter));
			newDataCounter=turnroom.ColyseusTurnDataList.length;
		}
		if(RoomType == "LOCK"  && lockroom != null){
			newDataCounter=Std.parseFloat(""+(lockroom.ColyseusLockDataList.length-lastObtained));
			// search lock state
		}
		var dataCounter:Float=0;
		while(dataCounter < newDataCounter){
		//	var theString:String=""+ColyseusDataList[Std.int(lastObtained+dataCounter)];
			var theString:String="";
		
			// Add Player, Remove Player with the LobbyDataList
			//PlayerMap.set("RoomID", playerList.pus
			//PlayerList================PlayerMap.get("RoomID"); PlayerList.push(PlayerKey) or PlayerList.remove(PlayerKey); PlayerMap.set("RoomID",,,,,,,,,,,playerList);
			
			// TODO .. do for RAW what you did with TURN and make a list splice thing = Stack
			if(RoomType == "RAW" && rawroom[rawRoomCounter]!=null && rawroom[rawRoomCounter].ColyseusRawDataList!=null){
				//	theString=""+rawroom[rawRoomCounter].ColyseusRawDataList[Std.int(lastObtained+dataCounter)];
				if(rawroom[rawRoomCounter].ColyseusRawDataList.length > 0){
					theString=""+rawroom[rawRoomCounter].ColyseusRawDataList[0];
					rawroom[rawRoomCounter].ColyseusRawDataList.splice(0,1);
//trace("GetList Return List : "+turnroom.ColyseusTurnDataList);									
				}
			}
			
			if(RoomType == "TURN" && turnroom !=null && turnroom.ColyseusTurnDataList!=null){
				if(turnroom.ColyseusTurnDataList.length > 0){
					theString=""+turnroom.ColyseusTurnDataList[0];
					turnroom.ColyseusTurnDataList.splice(0,1);

				}
			}
			
			// TODO .. do for LOCK what you did with TURN and make a list splice thing = Stack
			if(RoomType == "LOCK" && lockroom !=null && lockroom.ColyseusLockDataList!=null){
				theString=""+lockroom.ColyseusLockDataList[Std.int(lastObtained+dataCounter)];
			}
			
			// For All
			if(theString != null && theString.length > 0){
				retval.push(""+theString);
			}

			dataCounter++;
		} // for data

//trace("GetList Return : "+retval);		
		return retval;
	} // getList
			
	
	public function new() {
		super();
	}
	
	public function init(server:String,playerName:String, applicationID:String) {
	
		ApplicationID=applicationID;
		isError=false;

			rawRoomCounter=0;
			
		PlayerName=""+playerName;
		
		// Use server string+Port : server = "192.168.2.252:5566" 
		this.client = new Client("ws://"+server+"");
		/**
		 * Client callbacks
		 */
		this.client.onOpen = function() {
trace("CLIENT OPEN (CLIENT.ONJOIN), id => " + this.client.id);
			PlayerID=""+this.client.id;
			Colyseus.isInit=true;
			// (roomName: String, ?options: Map<String, Dynamic>, ?cls: Class<T>):
			/////this.room = this.client.join("lobby", new Map<String,Dynamic>(), State);
			Lobby.join(this.client,this);

		};

		this.client.onClose = function() {
			trace("CLIENT CLOSE");
			Colyseus.isInit=false;
		};

		this.client.onError = function(message) {
			trace("CLIENT ERROR: " + message);
			trace("TODO :  onError Stencyl Block for message "+message);
		};

			
   } // init
   
   
   public  function isInitialized():Bool{
		var retval:Bool=false;
		
		return Colyseus.isInit;
	} //Colyseus.isInit
	

	private function onUpdate(e:Event):Void {
	}

	public function send(theString:String){
		if(!Colyseus.isInit)return;
		if(RoomType=="RAW" && rawroom[rawRoomCounter]!=null && rawroom[rawRoomCounter].room != null){
			rawroom[rawRoomCounter].room.send(""+theString);
		}
		if(RoomType=="TURN" && turnroom!=null && turnroom.room != null){
			if(theString.length > 0){
				turnroom.room.send("TURNDATA="+theString+"=TURNDATA");
			}
		}
		if(RoomType=="LOCK" && lockroom!=null && lockroom.room != null){
			lockroom.room.send(""+theString);
		}
	} //sendString
	
	public function getRoomID():String{
		if(!Colyseus.isInit)return "";
		if(RoomType=="RAW"){
			if(rawroom[rawRoomCounter]!=null) return rawroom[rawRoomCounter].room.id;
		}
		if(RoomType=="TURN"){
			if(turnroom!=null) return turnroom.room.id;
		}
		if(RoomType=="LOCK"){
			if(lockroom!=null) return lockroom.room.id;
		}
		return "";
	} // getRoomID
	
	public function createRoom(RoomName:String, roomType:String):Void{
		if(isBusySwitchingRoom)return;
		
		isBusySwitchingRoom=true;
		RoomType=roomType;
		
		var theOptions:Map<String, Dynamic>=new Map<String,Dynamic>();
		theOptions.set("RoomName", ""+RoomName);
		theOptions.set("PlayerName", PlayerName);
		theOptions.set("CreateOrJoin", "CREATE");
		theOptions.set("ApplicationID", ApplicationID);
		theOptions.set("PlayerID", PlayerID);
		theOptions.set("RoomID", "");
		theOptions.set("nrOfSeats", NrOfSeats);
		
		if(roomType=="RAW"){
			//rawRoomCounter++;
			
			if(rawroom[rawRoomCounter]!=null){
				if(rawroom[rawRoomCounter].isJoined){
					rawroom[rawRoomCounter].room.leave();
			
				}
			}
			var createRoomTimer = new haxe.Timer(500);  
			createRoomTimer.run = function() {
				createRoomTimer.stop();
				rawroom[rawRoomCounter]=new Raw();
				rawroom[rawRoomCounter].join(this.client, this, theOptions);
			//	rawroom[rawRoomCounter].room.name=""+RoomName;
				var createRoomTimer2 = new haxe.Timer(500);  
				createRoomTimer2.run = function() {
					createRoomTimer2.stop();
					//lobby room .. add player to roomid
					//var roomplayers:Array<Dynamic>=Lobby.RoomPlayers.get(rawroom[rawRoomCounter].room.id);
					//roomplayers.push(""+PlayerID);
					//Lobby.RoomPlayers.set(rawroom[rawRoomCounter].room.id, roomplayers);
					
					isBusySwitchingRoom=false;
				}
			}
		}
		if(roomType=="TURN"){
			if(turnroom!=null){
				if(turnroom.isJoined){
					turnroom.room.leave();
			
				}
			}
			var createRoomTimer = new haxe.Timer(500);  
			createRoomTimer.run = function() {
				createRoomTimer.stop();
				turnroom=new Turn();
trace("CreateRoom Turn: ");				
				turnroom.join(this.client, this, theOptions);
			
				var createRoomTimer2 = new haxe.Timer(500);  
				createRoomTimer2.run = function() {
					createRoomTimer2.stop();
					//lobby room .. add player to roomid
					//var roomplayers:Array<Dynamic>=Lobby.RoomPlayers.get(turnroom.room.id);
					//roomplayers.push(""+PlayerID);
					//Lobby.RoomPlayers.set(turnroom.room.id, roomplayers);

					if(turnroom != null && turnroom.room != null && turnroom.room.id != null && turnroom.room.id.length > 0){
trace("Lobby.addRoomInfo : "+turnroom.room.id+"  playerid: "+PlayerID);											
						Lobby.addRoomInfo(""+turnroom.room.id+"@"+PlayerID);
					
					}
					isBusySwitchingRoom=false;
				}
			}
		}
		if(roomType=="LOCK"){
			if(lockroom!=null){
				if(lockroom.isJoined){
					lockroom.room.leave();
			
				}
			}
			var createRoomTimer = new haxe.Timer(500);  
			createRoomTimer.run = function() {
				createRoomTimer.stop();
				lockroom=new Lock();
trace("CreateRoom Lock");				
				lockroom.join(this.client, this, theOptions);
				var createRoomTimer2 = new haxe.Timer(500);  
				createRoomTimer2.run = function() {
					createRoomTimer2.stop();
					//lobby room .. add player to roomid
					isBusySwitchingRoom=false;
				}
			}
		}
	} //createRoom
	
	public function leaveRoom(roomType:String):Void{
		
		if(roomType=="RAW"){
			rawroom[rawRoomCounter].room.leave();
			// lobby room remove player from roomid
		}
		if(roomType=="TURN"){
trace("Leaving room TURN");			
			turnroom.room.leave();
			// lobby room remove player from roomid
				
					Lobby.addRoomInfo(""+turnroom.room.id+"%"+PlayerID);
		}
		if(roomType=="LOCK"){
			lockroom.room.leave();
			// lobby room remove player from roomid
		}
	} // leaveRoom
	
	public function joinRoom(id:String, roomType:String):Void{
		if(isBusySwitchingRoom)return;
		isBusySwitchingRoom=true;
		var theOptions:Map<String, Dynamic>=new Map<String,Dynamic>();
		theOptions.set("CreateOrJoin", "JOIN");
		theOptions.set("PlayerName", PlayerName);
		theOptions.set("PlayerID", PlayerID);
		theOptions.set("RoomID", ""+id);
		theOptions.set("ApplicationID", ApplicationID);
		
		
		
		RoomType=roomType;
trace("JOINING the options: "+theOptions+"                   RoomType: "+roomType);
				
		var doNotJoin:Bool=false;
		
		if(roomType=="RAW"){

			//rawRoomCounter++;
						
			if(rawroom[rawRoomCounter]!=null){
				if(rawroom[rawRoomCounter].isJoined){
					if(rawroom[rawRoomCounter].room.id != id){
						rawroom[rawRoomCounter].room.leave();
						
					}else{
							doNotJoin=true;
					}
			
				}
			}
			if(!doNotJoin){
				var joinTimer = new haxe.Timer(500);  
				joinTimer.run = function() {
					joinTimer.stop();
trace(" Now joining room : "+id);
					rawroom[rawRoomCounter]=new Raw();
					rawroom[rawRoomCounter].join(this.client, this, theOptions);
					var joinTimer2 = new haxe.Timer(500);  
					joinTimer2.run = function() {
						joinTimer2.stop();
						//lobby room .. add player to roomid
						isBusySwitchingRoom=false;
					}
				}
			}
		} // raw
		if(roomType=="TURN"){
			doNotJoin=false;
			if(turnroom!=null){
				if(turnroom.isJoined){
					if(turnroom.room.id != id){
						turnroom.room.leave();
					}else{
						doNotJoin=true;
					}
				}
			}
			if(!doNotJoin){
				var joinTimer = new haxe.Timer(500);  
				joinTimer.run = function() {
					joinTimer.stop();
trace(" Now joining room : "+id);
					turnroom=new Turn();
					turnroom.join(this.client, this, theOptions);
					var joinTimer2 = new haxe.Timer(500);  
					joinTimer2.run = function() {
						joinTimer2.stop();
						//lobby room .. add player to roomid
						
						//var roomplayers:Array<Dynamic>=Lobby.RoomPlayers.get(turnroom.room.id);
						//roomplayers.push(""+PlayerID);
						//Lobby.RoomPlayers.set(turnroom.room.id, roomplayers);
						Lobby.addRoomInfo(""+turnroom.room.id+"@"+PlayerID);
						isBusySwitchingRoom=false;
					}
				}
			} // dontjoin
		} // turn
		if(roomType=="LOCK"){
			doNotJoin=false;
			if(lockroom!=null){
				if(lockroom.isJoined){
					if(lockroom.room.id != id){
						lockroom.room.leave();
					}else{
						doNotJoin=true;
					}
				}

			} // !=null
			if(!doNotJoin){
				var joinTimer = new haxe.Timer(500);  
				joinTimer.run = function() {
					joinTimer.stop();
trace(" Now joining room : "+id);
					lockroom=new Lock();
					lockroom.join(this.client, this, theOptions);
					var joinTimer2 = new haxe.Timer(500);  
					joinTimer2.run = function() {
						joinTimer2.stop();
						//lobby room .. add player to roomid
						isBusySwitchingRoom=false;
					}
				} 
			} // donotjoin
		} // Lock
	} // join
	//public function getRoomList(roomType:String):Map<String,Dynamic>{
	public function getRoomList(roomType:String):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		//var retval:Map<String,Dynamic>=new Map<String, Dynamic>();
		retval=Lobby.RoomList.get((""+roomType).toUpperCase());
		if(retval==null)retval=new Array<Dynamic>();
		return retval;
	}
	
	public function getPlayerID(playerName:String):String{
		if(!Colyseus.isInit)return "";
		return ""+Lobby.LobbyPlayerIDs.get(""+playerName);
		//return ""+PlayerID;
	}
	
	public function getRoomInfo(roomType:String, roomID:String, property:String):Dynamic{
		var retval:Dynamic=null;
	
		if(property=="roomname"){
				
					if(roomType == "RAW" || roomType == "TURN" || roomType == "LOCK"){
					
						var roomNames:Map<String, Dynamic>=Lobby.RoomNames.get((""+roomType).toUpperCase());
						//var theName=roomNames.get(""+rawroom[rawRoomCounter].room.id);
						var theName=roomNames.get(""+roomID);
						if(theName!=null){
							return theName;
						}
					}
				
		}
		if(property == "playernames"){
				if(roomType == "RAW"){
					retval=new Array<Dynamic>();
					if(rawroom[rawRoomCounter] != null){
						if(rawroom[rawRoomCounter].playerNames != null){
							retval=rawroom[rawRoomCounter].playerNames;
						}
					}
				}
				if(roomType == "TURN"){
					if(turnroom==null)return new Array<Dynamic>();
					return turnroom.playerNames;
				}
				if(roomType == "LOCK"){
					if(lockroom==null)return new Array<Dynamic>();
					return lockroom.playerNames;
				}
				if(roomType == "LOBBY"){
					return Lobby.LobbyPlayerNames;
				}
		}
		
		// Number of players in room : length playerNames list  : rawroom[rawRoomCounter].playerNames.length
		if(property== "clients"){
			if(roomType == "RAW"){
				var retval:Int=0;
				if(rawroom[rawRoomCounter] != null){
					if(rawroom[rawRoomCounter] != null){
						retval=rawroom[rawRoomCounter].playerNames.length;
					}
				}
				return retval;
			}
			if(roomType == "TURN"){
				var retval:Int=0;
				if(Lobby.RoomPlayers != null){
					if(Lobby.RoomPlayers.get(""+roomID) != null){
						retval=Lobby.RoomPlayers.get(""+roomID).length;
					}
				}
//trace("Get Clients retval: "+retval);	
				return retval;
			}
			if(roomType == "LOCK"){
				var retval:Int=0;
				if(lockroom != null){
					if(lockroom.playerNames!=null){
						retval=lockroom.playerNames.length;
					}
				}
				return retval;
			}
		}
		
		return retval;
	}
	
	public function setMaxPlayers(nrOfPlayers:Float){
		if(RoomType=="TURN"){
			if(turnroom!=null){
				send("SETMAXPLAYERS="+nrOfPlayers);
			}
		}
	} // 
	
	public function getNrOfPlayers(NRPlayerRoomID:String){
		if(RoomType=="TURN"){
			if(turnroom!=null){
				send("GETNRPLAYERS="+NRPlayerRoomID);
			}
		}
	} // 
	
	public function getNrOfSeats():Float{
		var retval:Float=-1.0;
		if(RoomType=="TURN"){
			if(turnroom!=null){
				retval=turnroom.getNrOfSeats();
			}
		} // turntype
		return retval;
	}
	
	public function setNrOfSeats(_nrOfSeats:Float){
		// Prepare the join-options for the nr of seats
		NrOfSeats=_nrOfSeats;
	}
	
	private var oldAllPlayers:Map<String, Dynamic>=new Map<String, Dynamic>();
	public function getPlayerPosForID(_PlayerID:String):Float{
		var retval:Float=-1.0;
		if(RoomType=="TURN"){
			if(turnroom!=null){
				// Get All Players for ID
				if(Utils.mapCount(turnroom.AllPlayers) > 0){
					//if(oldAllPlayers != turnroom.AllPlayers){
						trace("  AllPlayers : "+turnroom.AllPlayers);
//						oldAllPlayers=turnroom.AllPlayers;
	//				}
					
				
					for(item in turnroom.AllPlayers.keys()){
				//		trace(" Player ID from AllPlayers : "+turnroom.AllPlayers.get(item).playerName);
					} // for items
				} // if allplayers
			} // if turnroom
		} // turntype
		
		return retval;
	}
	
	public function getLastPlayerPos():Float{
		var retval:Float=-1.0;
		return retval;
	}
	
	
	public function getBetweenPlayers():Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		return retval;
	}
	
	public function isTurn():Bool{
		var retval:Bool=false;
		if(RoomType=="TURN"){
			if(turnroom!=null){
				retval = (getActiveSeatNR() == getSeat());
			}
		}
			return retval;
	}
	public function nextTurn(){
		// Give the next seat control
		if(RoomType=="TURN"){
			if(turnroom!=null){
				// Send Message Next Turn To Server
				send("NEXTTURN");
				
			}
		}
	}
	public function getSeat():Float{
		var retval:Float=-1.0;
		if(RoomType=="TURN"){
			if(turnroom!=null){
				retval=Std.parseFloat(""+turnroom.getSeatNR());
				
			}
		}
		if(RoomType=="LOCK"){
			if(lockroom!=null){
				retval=Std.parseFloat(""+lockroom.getSeatNR());
				
			}
		}
		return retval;
	}
	
	public function getActiveSeatNR():Float{
		var retval:Float=0;
		if(RoomType=="TURN"){
			if(turnroom!=null){
				retval=Std.parseFloat(""+turnroom.getActiveSeatNR());
			}
		}
		return retval;
	}
	
	public function getPlayerInSeat(seatNr: Float): String{
		var retval:String="";
		if(RoomType=="TURN"){
			if(turnroom!=null){
				var tempSeat=turnroom.ColyseusTurnSeatMap.get(""+seatNr);
				if(tempSeat==null)retval=""; else retval=""+tempSeat;
				
				
			}
		}
		return retval;
	}
	
	public function getActivePlayer():String{
		var retval:String="";
		if(RoomType=="TURN"){
			if(turnroom!=null){
				retval=""+turnroom.getActivePlayerID();
			}
		}
		return retval ;
	} // getActivePlayer
	
	public function doLockRequest(lockString:String, LockID:Number,lockFunc:Dynamic){
		trace(" LockID: "+LockID);
		trace("lockString: "+lockString);
		trace(" Function : "+lockFunc);
	}
	
	public function lockRequest(RoomOrData:String, lockData:String, lockFunc:Dynamic){
		if(RoomType=="LOCK"){
			if(lockroom!=null){
				lockroom.onLockData(RoomOrData, lockData, lockFunc);
			}
		}
	} // lockRequest
	
	public function releaseLock(RoomOrData:String, lockData:String){
		if(RoomType=="LOCK"){
			if(lockroom!=null){
				lockroom.releaseLock(RoomOrData, lockData);
			}
		}
	} // releaseLock

		public function getLockedBy(IDorName:String):String{
			var retval:String="";
			if(RoomType=="LOCK"){
				if(lockroom!=null){
						var id = lockroom.lockedBy;
						if(id==null)id="";
						if(IDorName == "ID"){
							retval = id;
						}else{
							
							for(p in lockroom.playerNames){
								if(getPlayerID(p) == id) retval=p;
							}
						}
				}
			}		
			return retval;
		}
	public function getDataLockState():Bool{
		var retval:Bool=false;
		if(RoomType=="LOCK"){
			if(lockroom!=null){
				var getLockState:String = lockroom.dataLockState;
				if(getLockState != null){
					if(getLockState == "ALLOW"){
						retval=true;
					}
				}
			}
		}		
		return retval;
	} // getLockDataState
		
		
		// ----- LOCK -----
		public function initLockData(initMap:Map<String, Dynamic>){
			// request room lock
			// when room lock 
			// send initData
			// unlock room
//trace("InitLockData Map: "+initMap);
			for(key in initMap.keys()){
//trace("Key : "+key+" value: "+initMap.get(key));
					// if value == PlayerNr
				
			}
		} // initLockData
		
		// [for rule name [ rule1 ] add [ if [ get [ [playerpos] + [direction] ] ] = [0] ] 
		public function addRule(ruleName:String, RuleText:String){
				var ruleList:Array<Dynamic>=RuleMap.get(ruleName);
				if(ruleList == null) ruleList=new Array<Dynamic>();
				ruleList.push(""+RuleText);
				
				RuleMap.set(ruleName, ruleList);
trace("AddRule Rule: "+ruleName+" has actions: "+ruleList);				
				
		} //addRule

		public function setPlayerPos(playerPos:Float){
			PlayerPos=playerPos;
		}// setPlayerPos
		public function setDirection(direction:Float){
			Direction=direction;
		}// setDirection
		public function getPlayerPos():Float{
			return PlayerPos;
		} // getPlayerPos
		public function getDirection():Float{
			return Direction;
		} // getDirection
		
		//Colyseus.colyseus.addRuleIfGet((Colyseus.colyseus.getPlayerPos() + Colyseus.colyseus.getDirection()),0)
		// result : RuleList.push("if get((10+1)) = 1");
		public function addRuleIfGet(Condition:Dynamic, IfGetValue:Dynamic):String{
					return "if get "+Condition+" = "+IfGetValue;
					
				return "";
		} //addRuleIfGet

		//olyseus.colyseus.addRuleIfList((Colyseus.colyseus.getPlayerPos() + Colyseus.colyseus.getDirection()),_CompareList)
		// result RuleList.push("if get((10+1)) in [1,3,5,6]");
		public function addRuleIfList(Condition:Dynamic, IfList:Array<Dynamic>):String{
				return "if "+Condition+" in "+IfList;
				
		} //addRuleIfList

		//Colyseus.colyseus.addRuleSetVariable("objectValue",Colyseus.colyseus.addRuleGetMap((Colyseus.colyseus.getPlayerPos() + Colyseus.colyseus.getDirection())))
		//RuleList.push("abc = get((23))");
		public function addRuleSetVariable(VariableName:String, Value:Dynamic):String{
				return ""+VariableName+" = "+Value;
				
		} //addRuleSetVariabl
		
		//Colyseus.colyseus.addRuleGetVariable("objectValue")
		//	RuleList.push("set((10+1+1), abc)"); // abc is the variable here
		public function addRuleGetVariable(VariableName:String):String{
				return ""+VariableName;
		} //addRuleGetVariable

		// Colyseus.colyseus.addRuleSetMap(Colyseus.colyseus.getPlayerPos(),0)	
		// RuleList.push("set(10, 32)");		
		public function addRuleSetMap(MapKey:Dynamic, Value:Dynamic):String{
				return "set "+MapKey+","+Value;

		} //addRuleSetMap

		// Colyseus.colyseus.addRuleSetMap(Colyseus.colyseus.getPlayerPos(),0)	
		// RuleList.push("set(10, 32)");		
		public function addRuleGetMap(MapKey:Dynamic):String{
				return "get "+MapKey;

		} //addRuleSetMap

		
		// code="Colyseus.colyseus.addRuleSetPlayerPos(~);"  
		public function addRuleSetPlayerPos(pos:Float){
				setPlayerPos(pos);
trace("Rule: Set PlayerPos : "+pos);				

		}
		// in logic setPlayerPos
		
		
		public function doLogic(){
			var conditionOK:Bool = true;
			for(ruleKey in RuleMap.keys()){
				for(condition in cast(RuleMap.get(ruleKey), Array<Dynamic>)){
					if(conditionOK){
trace("Execute condition: "+condition);						
						conditionOK=interp(condition);
					}
				}
			}
			
		}
		
		
	
		public function unitTest() {
			
			//trace ("Hello World");
			var condition:String="";
			DataMap.set("one", 1);
			DataMap.set("11", 1 );
			DataMap.set("12", 1);
			DataMap.set("23", 23);
			DataMap.set("44", 44);
			DataMap.set("32", 32);
			
			// For each command in list
			var RuleList:Array<Dynamic>=new Array<Dynamic>();
			RuleList.push("one = 1");
			RuleList.push("if get((10+1)) = 1");
			RuleList.push("if get((10+1)) in [1,3,5,6]");
			RuleList.push("if get((10+1)) = get((10+2))");
			RuleList.push("if get((10+1)) = one");
			RuleList.push("abc = get((23))");
			RuleList.push("def = get((23+21))");
			RuleList.push("var1 = 32");
			RuleList.push("ghi = get(var1)");
			RuleList.push("set(10, get(32)");
			RuleList.push("set(10, 32)");
			RuleList.push("set(10, 32)");
			RuleList.push("set((10+1+1), abc)");
			var conditionOK:Bool = true;
			// for(ruleKey in RuleMap.keys())}
			// for(condition in RuleMap.get(ruleKey)){
			for(condition in RuleList){
				if(conditionOK){
					conditionOK=interp(condition);
				}
			}
			
		}
		
		public function interp(ConditionText:String):Bool{
			var retval:Bool=true;
//trace("condition: "+ConditionText);
			var spaceSplit:Array<Dynamic>=ConditionText.split(" ");
//trace(" SpaceSplit : "+spaceSplit);
			if(ConditionText.toUpperCase().indexOf("IF") == 0){
	
				var conditionOne:Dynamic;
				var conditionTwo:Dynamic;
				var conditionStyle:String="";
				// evaluate condition
				if((""+spaceSplit[1]).toUpperCase().indexOf("GET") == 0){
					conditionOne=getVal(""+spaceSplit[2]);
				}
				if((""+spaceSplit[2]).toUpperCase().indexOf("IN") == 0){
					conditionStyle="in" ;
				}
				if((""+spaceSplit[3])=="="){
					conditionStyle="equal" ;
					if((""+spaceSplit[4]).toUpperCase().indexOf("GET") == 0){
						conditionTwo=getVal(""+spaceSplit[5]);
					}else{
						// Check if evaluation is a number
						var converted:Int=Std.parseInt(""+spaceSplit[4]);
trace(" Converted: "+spaceSplit[4]+" to " +converted);

						if(Math.isNaN(converted)){
trace("It is a variable (instead of a number) .. so get the variable from the ConditionMap!");							
						}
					}
					
				}
				
				
				retval=true;
			}
			
			return retval;
		} // interp
	
		public function getVal(getString:String):Dynamic{
			var retval:Dynamic="";
			var getValue:String="";
			//var withoutGet:String=StringTools.trim(getString).substring(3, getString.length);
			var withoutGet:String=getString;
			var toNr:Int=Std.parseInt(""+withoutGet);
trace(" getVal string: "+getString+" Without Get: "+withoutGet+" to Nr: "+toNr);	
			// Math.isNaN(value)
			if(!Math.isNaN(toNr))getValue=withoutGet; else getValue=""+toNr;
			retval=DataMap.get(getValue);
trace(" retval will be : "+retval);	
			
			return retval;
		}
	


 	
		
} // Colyseus Class


