// Lobby
import io.colyseus.serializer.schema.Schema;
import io.colyseus.*;
import com.stencyl.utils.Utils;
import com.stencyl.behavior.Script.*;

class LobbyPlayer extends Schema {
	@:type("string")
	public var playerName: String = "";
	@:type("string")
	public var ApplicationID:String="";
	@:type("string")
	public var playerID: String = "";
	 @:type("string")
     public var roomInfo:String = "" ;

}

class LobbyState extends Schema {
	@:type("map", LobbyPlayer)
	public var players: MapSchema<LobbyPlayer> = new MapSchema<LobbyPlayer>();

}


class Lobby{
	//public static var room:Room<LobbyState>;
	public  var room:Room<LobbyState>;
	
	private static var colyseus:Colyseus;
	public var offsetTime:Float=0;
	public var serverTime:Float=0;
	public var askTime:Float=0;
	private var isPendingGetTime:Bool=false;
	private var isAllowedInfo:Bool=false;
	public var lastAskedTime:Float=-1;
	
	
	public  var RoomList:Map<String, Array<Dynamic>>; // =new Map<String, Array<Dynamic>>();
	public  var RoomPlayers:Map<String, Array<Dynamic>>; // =new Map<String, Array<Dynamic>>();
	public  var RoomNames:Map<String, Map<String,Dynamic>>; // =new Map<String, Map<String,Dynamic>>();
	
	public  var LobbyPlayerNames:Array<Dynamic>; // = new Array<Dynamic>();
	public  var LobbyPlayerIDs:Map<String,Dynamic>; // = new Map<String,Dynamic>();
	
	
	public function new(){
		RoomList=new Map<String, Array<Dynamic>>();
		RoomPlayers=new Map<String, Array<Dynamic>>();
		RoomNames=new Map<String, Map<String,Dynamic>>();
	
		LobbyPlayerNames = new Array<Dynamic>();
		LobbyPlayerIDs = new Map<String,Dynamic>();
		
		
	}
	
	public static function debug(debugString:String){
		Colyseus.debug(debugString);
		
	} // debug
	
	
	
	private  function getInfoOnRooms(client:Client){
		var roomTypes:Array<Dynamic>=new Array<Dynamic>();
		// Get Room Information for all the different roomTypes
		roomTypes.push("raw");
		roomTypes.push("turn");
		roomTypes.push("lock");
		//roomTypes.push("lobby");
		
		isAllowedInfo=true; // initialize info gathering
		
		var AvailableRoomsTimer = new haxe.Timer(1000);  
		
		AvailableRoomsTimer.run = function() {
			if(!isAllowedInfo){
debug("Stopping AvailableRoomstimer ...");			
				AvailableRoomsTimer.stop(); 
				return;
			}
			if(!colyseus.isInitialized()) return;
			if(room == null){
debug("AvailableRoomsTimer : lobby room is null!");			
				isAllowedInfo=false;
				return;
			}
			// check each roomtype  (state,chat,turnbased)
			for( room_type in roomTypes){
				client.getAvailableRooms(room_type, function(rooms, ?err) {
					//if (err != null) trace("ERROR! " + err);
					
					
					var roomIDs:Array<Dynamic>=new Array<Dynamic>();
					var roomNames:Map<String, String>=new Map<String,String>();
					
					for (room in rooms) {
//debug("AvailableRoomsTimer. RoomList "+colyseus.ApplicationID+" room.metadata.ApplicationID: "+room.metadata.ApplicationID);
						if(room.metadata.ApplicationID == ""+colyseus.ApplicationID){
//debug("AvailableRoomsTimer. RoomList roomIDs.push: "+room.roomId);
							roomIDs.push(""+room.roomId);
						
							// Metadata is set in the Room (Raw.hx and are the options that have been provided to create the room) 
							//{ PlayerName => PL8015, CreateOrJoin => CREATE, clientId => w3pWYeLh5, RoomName => Raw9071, requestId => 14, RoomID =>  }
							roomNames.set(""+room.roomId,""+room.metadata.RoomName);
						}
						
					}
					RoomList.set((""+room_type).toUpperCase(), roomIDs);
					RoomNames.set((""+room_type).toUpperCase(), roomNames);
				});
			} // for all roomtypes
			
		} // AvailableRoomsTimer
		
	} // getInfoOnRooms




	
	// when joining or leaving rooms the information is send to all the players in the lobby server so that they know what is going on
	// An @ sign in the roomInfo means JOINing the room
	// An % sign in the roomInfo means LEAVing the room
	public  function addRoomInfo(roomInfo:String){
			if(roomInfo.indexOf("null") < 0){
				room.send("ADDROOMINFO."+roomInfo);
			}else{
//trace("addRoomInfo : something is NULL so don't add this roomInfo");			
			}
	} // addRoomInfo



	public function getServerTime():Float{
		var retval:Float=0;
		#if html5
			retval=Date.now().getTime()+offsetTime;
		#else
			retval=(Sys.time()*1000)+offsetTime;
			
		#end
		
			if(colyseus != null && colyseus.isInitialized() && !isPendingGetTime){
				// Request new Time by setting isPendingGetTime to false
				//		var PendingGetTimer = new haxe.Timer(10000);   // each x millisecondsn
				//	PendingGetTimer.run = function() { isPendingGetTime=false; PendingGetTimer.stop();};
				
				isPendingGetTime=true;
debug(" REQUESTTIME (GetServerTime: ) ......      Getting the new servertime (calc offset) since it was bad : "+retval);				
				//		askTime=Date.now().getTime(); // difference between html5 and cpp (windows/ios/linux)
				#if html5
					askTime=Date.now().getTime();
				#else
					askTime=(Sys.time()*1000);
			
				#end
		
				room.send("GETSERVERTIME:"+askTime+":"+colyseus.PlayerID+":");
				
			}		
		
		
		return retval;
		
	} // getServerTime
	 

	
	public  function join(client:Client, colyseus_:Colyseus){
	    colyseus=colyseus_;
		
		var options:Map<String,Dynamic>=new Map<String,Dynamic>();
		options.set("PlayerName", colyseus.PlayerName);
		options.set("PlayerID", colyseus.PlayerID);
		options.set("ApplicationID", colyseus.ApplicationID);
		
		room = client.join("lobby", options, LobbyState);
		LobbyPlayerNames=new Array<Dynamic>();
		
		getInfoOnRooms(client);

		room.onJoin = function() {
		
			room.state.players.onAdd = function(player, key) {
				if(player.ApplicationID == colyseus.ApplicationID){
					if(!Utils.contains(LobbyPlayerNames, ""+player.playerName)){
						LobbyPlayerNames.push(""+player.playerName);
						LobbyPlayerIDs.set(""+player.playerName, player.playerID);
					}
				} // appid
				
			}

			room.state.players.onChange = function(player, key) {
//trace("Lobby ADDROOMINFO? Lobby.onChange: "+player+""+key);
			}
			

			room.state.players.onRemove = function(player, key) {
debug("room.state.players.onRemove (STOP roomlist getting ) removing player.id = "+player.playerID+" colyseus.PlayerID = "+colyseus.PlayerID);
				// Notify getInfoOnRooms to stop
				if(player.playerID == colyseus.PlayerID){
					isAllowedInfo=false;
					colyseus.callErrorBlock("Player removed from lobby");
				}
				if(player.ApplicationID == colyseus.ApplicationID){
					LobbyPlayerNames.remove(""+player.playerName);
					RoomPlayers.remove(""+player.playerName);
					LobbyPlayerIDs.remove(""+player.playerName);
				}
			}
		}; // onJoin

		room.onStateChange = function(state) {
//debug("LobbySTATE_CHANGE: " + Std.string(state));
debug("Lobby . onStateChange  "+state.players);
			// extract the roomInfo
			// Lobby STATE CHANGE: { players => MapSchema (3) { 0IMNsJKpA => { playerName => P973977, ApplicationID => TicTacToe1, playerID => ntKtqo8hj, roomInfo => jQHsg13GJ+ntKtqo8hj; }, 6bKz32Zof => { playerName => P327152, ApplicationID => TicTacToe1, playerID => 4xkrOmUX3, roomInfo => jQHsg13GJ+ntKtqo8hj;jQHsg13GJ+4xkrOmUX3; }, SIrMV7YIw => { playerName => P538453, ApplicationID => TicTacToe1, playerID => 0plgSW8dG, roomInfo =>  } } }
			// roomInfo => jQHsg13GJ@ntKtqo8hj; }
			// roomInfo => jQHsg13GJ@ntKtqo8hj;jQHsg13GJ@4xkrOmUX3; }
			// roomInfo => jQHsg13GJ%ntKtqo8hj;jQHsg13GJ@4xkrOmUX3; }
//.hx:183: Lobby STATE CHANGE: { players => MapSchema (1) { 1zprdWzBO => { playerName => PL8802, ApplicationID => RAWClient1, playerID => N4gN2NdMy, roomInfo => RETURNTIME=N4gN2NdMy:1582355345084 } } }
			var roomInfoList=getListFromState(""+state.players, "roomInfo");
debug("Lobby . onStateChange  RoomInfoList: "+roomInfoList);			
			// Erase all roomplayer information : We will rebuilt the map
			//[0ItHTjOHw@LcxioxSxz;,0ItHTjOHw@gMRXsZE-z;]
			RoomPlayers=new Map<String, Array<Dynamic>>();
			for(roomInfo in roomInfoList){
				// split on ;
				var roomList:Array<Dynamic>=roomInfo.split(";");
				for(roomPart in roomList){
					// add player when @ sign
					var roomAndPlayer:Array<Dynamic>;
					if(roomPart.indexOf("@") > -1){
						roomAndPlayer=roomPart.split("@");
//trace("RoomPlayersDebug : "+roomAndPlayer);						
						var room_id:String=roomAndPlayer[0];
						var player_id:String=roomAndPlayer[1];
						var roomplayers=RoomPlayers.get(room_id);
						if(roomplayers == null) roomplayers=new Array<Dynamic>();
						
						if(roomplayers.indexOf(player_id)<0){ // if not found : add
								roomplayers.push(player_id);
						}
	
						if(room_id.length > 0 && roomplayers != null){
							RoomPlayers.set(room_id, roomplayers);
						}
					}else{
						if(roomPart.indexOf("%") > -1){
							// remove
							roomAndPlayer=roomPart.split("%");
							var room_id:String=roomAndPlayer[0];
							var player_id:String=roomAndPlayer[1];
							var roomplayers=RoomPlayers.get(room_id);
							if(roomplayers == null) roomplayers=new Array<Dynamic>();
							if(roomplayers.indexOf(player_id)>-1){
								roomplayers.remove(player_id);
							}
	
							if(room_id.length > 0 && roomplayers != null){					
								RoomPlayers.set(room_id, roomplayers);
							}
						}else{
							if(roomPart.indexOf("RETURNTIME") > -1){
								var returnTimeSplit:Array<Dynamic>=roomInfo.split(":");
								// returnTimeSplit[1] == id, [2] = servertime
								// askTime
								if(colyseus!=null){
									// Did we receive our own servertime-request
									if(returnTimeSplit[1] == colyseus.PlayerID){
										var newOffset:Float=0;
										var receivedTime:Float=Std.parseFloat(returnTimeSplit[2]);
										newOffset=receivedTime-askTime;
										#if html5
											serverTime=Date.now().getTime()+newOffset;
										#else
											serverTime=(Sys.time()*1000)+newOffset;
										#end
debug(" returntime newOffset: "+newOffset+"  (receivedTime: "+receivedTime+" askTime: "+askTime+" calculated time: "+serverTime+" toString: "+Date.fromTime(serverTime)+"");
										offsetTime=newOffset;

									} // returnsplit
								} // colyseus?
							}
						} 
					}
				} // each roomPart
			} // each roominfo
		
		};

		room.onMessage = function(message) {
debug("Lobby.onMessage : " + Std.string(message));
		};

		room.onError = function(message) {
			trace("Lobby.onError : " + message);
			colyseus.callErrorBlock(message);
		};

		room.onLeave = function() {
			isAllowedInfo=false;
			trace("Lobby LEAVE");
		}
	} // onJoin
	//
	
	private  function getListFromState(Source:String, Search:String):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		// roomInfo => jQHsg13GJ+ntKtqo8hj; }
		// roomInfo => jQHsg13GJ+ntKtqo8hj;jQHsg13GJ+4xkrOmUX3; }
			// Find SEARCH in SOURCE
			var part:String=Source;
			var found:Bool=true;
debug(" lobby: getListFromState : Source = "+Source);			
			while(found){
				var searchIndex=part.indexOf(""+Search);
				if(searchIndex > -1){
					// add three to the search length for " =>"
					part=part.substring(searchIndex+Search.length+3, part.length);
					// Search to the first }
					var endIndex=part.indexOf("}");
					var getPart=StringTools.trim(part.substring(0,endIndex));

					if(getPart.length > 0){

						retval.push(getPart);
					}
					
				}else{
					found=false;
				}
			}
debug(" lobby: getListFromState : retval = "+retval);						
		return retval;
	}
} // Class Lobby

// --------------------