// Turn
import io.colyseus.serializer.schema.Schema;
import io.colyseus.*;
import com.stencyl.utils.Utils;

class TurnPlayer extends Schema {
	@:type("string")
	public var theString: Dynamic = "NULL";
	@:type("string")
	public var playerName:String = "";
	@:type("string")
	public var playerID:String = "";
	@:type("number")
	public var SeatNR:Int=0;
	@:type("string")
	public var ActivePlayer:String="";
	@:type("number")
    public var PlayerPos:Int=-1;
    @:type("number")
    public var lastPlayerPos:Int=-1;
    @:type("number")
    public var nrOfSeats:Int=0;

}

class TurnState extends Schema {
	@:type("map", TurnPlayer)
	public var players: MapSchema<TurnPlayer> = new MapSchema<TurnPlayer>();
	
}


class Turn{
	public var room:Room<TurnState>;
	public var isJoined:Bool=false;
	//public  var ColyseusTurnDataList:Array<Dynamic>=new Array<Dynamic>();
	public  var ColyseusDataList:Array<Dynamic>=new Array<Dynamic>();
	private  var colyseus:Colyseus;
	
	
	public var NRPlayersMap:Map<String, Float>=new Map<String, Float>();
	//public var ExtensionPlayer:TurnPlayer=null;
	public var AllPlayers:Map<String, TurnPlayer>=new Map<String, TurnPlayer>();
	
	private var nrOfSeats:Float=0;
	
	
	
	private var oldTurnData:String="";
	
	private var activePlayerInstance:ActivePlayer;
	
	public static function debug(debugString:String){
	/*
		var theClass=Type.resolveClass("METools");
//trace("resolveClass: "+theClass);
		if(theClass != null) {
			var fl: Dynamic = Reflect.field(theClass, "debug"); //ok,works

			Reflect.callMethod(theClass, fl, [debugString]); 
		}		else trace(""+debugString);
		*/
		//trace(""+debugString);
		Colyseus.debug(debugString);
	} // debug

	
	public function new(){
		isJoined=false;
	
		ColyseusDataList=new Array<Dynamic>();
	 } // new
	 
	 
	 
	public function join(client:Client, colyseus_:Colyseus,theOptions:Map<String, Dynamic>){
	    colyseus=colyseus_;
		
		activePlayerInstance=new ActivePlayer(colyseus);
		
		isJoined=true;

		room = client.join("turn",theOptions, TurnState);
		
		
		
		room.onJoin = function() {
			isJoined=true;
			
			
			
trace("ONJOIN : theOptions: "+theOptions);			
			room.state.players.onAdd = function(player, key) {
trace("Turn.onJoin.onAdd : "+player);	
				//ExtensionPlayer=player;
				AllPlayers.set(""+player.playerID, player);
				
				activePlayerInstance.addPlayerName(""+player.playerName);

				// Why do we need to push this to the data ??
				//ColyseusDataList.push(""+player.theString+","+player.playerID);
				//ColyseusDataList.push(""+player.theString);
	
				activePlayerInstance.addSeatMap(""+player.SeatNR, player.playerID);
				

				activePlayerInstance.getSeatInfo(player);
					// TO BE DONE : remove nrofseats : we use players and seat information
					//nrOfSeats=player.nrOfSeats;
				
			}

			room.state.players.onChange = function(player, key) {
				AllPlayers.set(""+player.playerID, player);
				//
				// Let the Client code handle the data (!)
				//
trace("Turn Data DataList Change: "+player.theString+"  player id: "+player.playerID+" getActivePlayerID: "+getActivePlayerID());
trace("Turn Data DataList Change Changed key: "+key+"  GetActivePlayerID: "+getActivePlayerID());
				
					var theData:String=""+player.theString;

				// we only accept data from the active player
				if(getActivePlayerID() == player.playerID){

trace(" ADD to ColyseusDataList :      Turn Data DataList Change push : "+theData);									
					ColyseusDataList.push(""+theData);
				}
				activePlayerInstance.getSeatInfo(player);
				// TO BE DONE : Remove NrOfSeats from TURN.HX on serverside as well!
				//nrOfSeats=player.nrOfSeats;
			}
			

			room.state.players.onRemove = function(player, key) {
trace("Turn.onRemove  ", key);
trace("Turn remove player : "+player.playerName);
				AllPlayers.set(""+player.playerID, null);
								
				activePlayerInstance.removeSeatMap(""+player.playerName,""+player.SeatNR);
				
				activePlayerInstance.getSeatInfo(player);
				// TO BE DONE : Remove Nr Of Seats on server side as well!
				// nrOfSeats=player.nrOfSeats;
			}
		}; // onJoin

//room.state.onChange = (changes) => {		
		room.onStateChange = function(state) {
			var State:String=Std.string(state);
			
			trace("STATECHANGE: " + State);
			
		};

		room.onMessage = function(message) {
trace("Turn.onMessage : " + Std.string(message));
			var receivedMessage:String=""+Std.string(message);
			
			
//			NRPLAYERS.Tu6gpaf1_.1
			if(receivedMessage.toUpperCase().indexOf("NRPLAYERS") > -1){
trace("NRPlayers: "+receivedMessage);				
				var dotInfo:Array<Dynamic>=receivedMessage.split(".");
				NRPlayersMap.set(""+dotInfo[1],Std.parseFloat(""+dotInfo[2]));
trace("NRPlayers result of roomid: "+dotInfo[1]+" = "+dotInfo[2]);				
			}
		};

		room.onError = function(message) {
			trace("Turn.onError : " + message);
			colyseus.callErrorBlock(message);
		};

		room.onLeave = function() {
			trace("Turn LEAVE :"+room.id);
			//ExtensionPlayer=null;	
			isJoined=false;
		}
	} // join function
	
	private static function getListFromState(Source:String, Search:String):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		// roomInfo => jQHsg13GJ+ntKtqo8hj; }
		// roomInfo => jQHsg13GJ+ntKtqo8hj;jQHsg13GJ+4xkrOmUX3; }
			// Find SEARC in SOURCE
			var part:String=Source;
			var found:Bool=true;
			while(found){
				var searchIndex=part.indexOf(""+Search);
				if(searchIndex > -1){
					// add three to the search length for " =>"
					part=part.substring(searchIndex+Search.length+3, part.length);
					// Search to the first }
					var endIndex=part.indexOf("}");
					var getPart=StringTools.trim(part.substring(0,endIndex));

					if(getPart.length > 0){
//trace("GetPart: "+getPart+ "  push  it");	
						retval.push(getPart);
					}
					
				}else{
					found=false;
				}
			}
		return retval;
	}	
	
	
	public function getSeatNR():Int{
		return activePlayerInstance.getSeatNR();
	}
		
	
	public function getActivePlayerID():String{
		return activePlayerInstance.getActivePlayerID();
	}
	
	public function getActiveSeatNR():Int{
		return activePlayerInstance.getActiveSeatNR();
	}

	public function getPlayerInSeat(seatNR:String):String{
		return activePlayerInstance.getPlayerInSeat(seatNR);
	}
	
	public function getPlayerNames():Array<Dynamic>{
		return activePlayerInstance.getPlayerNames();
	}
	
	public function setActiveSeatNR(seatNR:Float){
		activePlayerInstance.setActiveSeatNR(seatNR);
	}
	
	
	//
} // Class Turn

// --------------------