//
// Raw - roomtype
//
import io.colyseus.serializer.schema.Schema;
import io.colyseus.*;
import com.stencyl.utils.Utils;


import com.stencyl.behavior.Script.*;

class RawPlayer extends Schema {
	@:type("string")
	public var theString: Dynamic = "NULL";
	@:type("string")
	public var playerName:String = "";
	@:type("string")
	public var playerID:String = "";
	@:type("number")
	public var SeatNR:Int=0;
	@:type("string")
	public var ActivePlayer:String="";

}

class RawState extends Schema {
	@:type("map", RawPlayer)
	public var players: MapSchema<RawPlayer> = new MapSchema<RawPlayer>();
	
}


class Raw{
	private  var colyseus:Colyseus;

	public var room:Room<RawState>;
	public var isJoined:Bool=false;  // this is used in Colyseus.hx to determine if the stencylRoom was joined or not

	public  var ColyseusDataList:Array<Dynamic>=new Array<Dynamic>();
	
	private static var activePlayerInstance:ActivePlayer;
	
	public static function debug(debugString:String){
	/*
		var theClass=Type.resolveClass("METools");
//trace("resolveClass: "+theClass);
		if(theClass != null) {
			var fl: Dynamic = Reflect.field(theClass, "debug"); //ok,works

			Reflect.callMethod(theClass, fl, [debugString]); 
		}		else trace(""+debugString);
		*/
		//trace(""+debugString);
		Colyseus.debug(debugString);
	} // debug
	
	public function new(){
		isJoined=false;
		
debug(" Raw : new init");		
		ColyseusDataList=new Array<Dynamic>();
	 } // new
	 
	public function join(client:Client, colyseus_:Colyseus,theOptions:Map<String, Dynamic>){
	    colyseus=colyseus_;
		isJoined=true;
debug("Raw.Join colyseus: "+colyseus);		
		activePlayerInstance=new ActivePlayer(colyseus);
debug("Raw.Join room = client.join");		
		room = client.join("raw",theOptions, RawState);
debug("Raw.Join room aftger join is "+room);

		room.onJoin = function() {
			isJoined=true;
debug("ONJOIN : theOptions: "+theOptions);			
		room.state.players.onAdd = function(player, key) {
debug("Raw.onJoin.onAdd : "+player);	
		
				activePlayerInstance.addPlayerName(""+player.playerName);

				// Why do we need to push this to the data ??
				// Is that to let the room know that we have the player name joined?
				//			ColyseusDataList.push(""+player.theString+","+player.playerID);
				//		ColyseusDataList.push(""+player.theString);
		
				activePlayerInstance.addSeatMap(""+player.SeatNR, player.playerID);
	
				activePlayerInstance.getSeatInfo(player);
	
		}

		room.state.players.onChange = function(player, key) {
//debug("onChange : "+player.theString);			
trace("Raw onChange: "+player.theString);
				//ColyseusDataList.push(""+player.theString+","+player.playerID);
				ColyseusDataList.push(""+player.theString);
				activePlayerInstance.getSeatInfo(player);
		}

		room.state.players.onRemove = function(player, key) {
debug("Raw.onRemove  "+ key);
debug("Raw remove player : "+player.playerName);


				activePlayerInstance.removeSeatMap(""+player.playerName,""+player.SeatNR);
					
				
				// Do we still need this? We can compare the playerlist with the new playerlist... like OLD 
				//ColyseusDataList.push("LEFTROOM,"+player.playerID);
				
				activePlayerInstance.getSeatInfo(player);
			}
		}; // onJoin

		room.onStateChange = function(state) {
			debug("RAW: STATE CHANGE: " + Std.string(state));

		};

		room.onMessage = function(message) {
			debug("Raw.onMessage : " + Std.string(message));
		};

		room.onError = function(message) {
			debug("Raw.onError : " + message);
			
			if(getGameAttribute("ColyseusErrorCounter") == null) setGameAttribute("ColyseusErrorCounter", 0);
			setGameAttribute("ColyseusErrorCounter", getGameAttribute("ColyseusErrorCounter")+1);
			
			colyseus.callErrorBlock(message);
		};

		room.onLeave = function() {
			debug("Raw LEAVE room id:"+room.id);
			
			isJoined=false;
		}
	} // onJoin
	//
	
		
	public function getSeatNR():Int{
		return activePlayerInstance.getSeatNR();
	}
		
	
	public function getActivePlayerID():String{
		return activePlayerInstance.getActivePlayerID();
	}
	
	public function getActiveSeatNR():Int{
		return activePlayerInstance.getActiveSeatNR();
	}

	public function getPlayerInSeat(seatNR:String):String{
		return activePlayerInstance.getPlayerInSeat(seatNR);
	}
	
	public function getPlayerNames():Array<Dynamic>{
		return activePlayerInstance.getPlayerNames();
	}
				
	public function setActiveSeatNR(seatNR:Float){
		activePlayerInstance.setActiveSeatNR(seatNR);
	}
	
				
} // Class Raw

// --------------------