
import com.stencyl.utils.Utils;

import com.stencyl.Engine;



import flash.display.BitmapData;
import flash.geom.Matrix;
import com.stencyl.Engine;

#if cpp
        import cpp.Lib;
#elseif neko
        import neko.Lib;
#else
        #if android
                import openfl.Lib;
        #end
#end

#if android
        import openfl.utils.JNI;
#end

class Gallery
{
	private static var CallBackFunc:Dynamic=null;
   	public static var GalleryImagePath:String="NOTFOUND"; 
	public static var SaveFileName:String="";
	public static var orientation:String="6";
	public static var tags:Map<String,Dynamic>=new Map<String, Dynamic>();

	#if ios
		private static var SayGallery = Lib.load("Gallery","init_Gallery",2);
		private static var SayGalleryDir = Lib.load("Gallery","mkdir",1);
	#else
		#if android
			private static var SayGallery:Dynamic;
			private static var SayGalleryDir:Dynamic;
			private static var SayGalleryOrientation:Dynamic;
		#end

	#end

	public static function writeFileToPNG(filename:String){
		var destination:String=""+filename;
// Call the encode function of the BitmapData which is the Image
#if ( js || flash )
#else
		if(sys.FileSystem.exists(filename)){
			var img=sys.io.File.getBytes(filename);
   			var bm = BitmapData.loadFromHaxeBytes(img);
			var png = bm.encode (bm.rect, new openfl.display.PNGEncoderOptions());
			// Get the bytes from the PNG file
			var b = haxe.io.Bytes.alloc(png.length);
			png.position = 0; 
			var bytes:haxe.io.Bytes = haxe.io.Bytes.alloc(png.length);
			while (png.bytesAvailable > 0) {
   				var position = png.position;  
   				bytes.set(position, png.readByte());
			}
			// Write the File
			sys.io.File.saveBytes (destination, bytes);
		} // if exist
#end
	} // writefileToPNG
	
	// function gets called when we have a selected file
	public static function callback(deviceFile:String):Void {
		var elems:Array<String> = deviceFile.split(";");
		GalleryImagePath=""+elems[0];
// The data is raw when it is from android
#if android
//writeFileToPNG(GalleryImagePath);
#end
#if ios
	var tags=getImageInfo(""+GalleryImagePath);
	if(tags != null){
		orientation=""+tags.get("Orientation");
	}
#end
		// Do the call-back function
		if(CallBackFunc != null)CallBackFunc();
	}


	// The App-Directory is a local storage for the App .. There is a domain/sandbox for each app
	public static function getAppDir(){
		var retval:String="";
		#if ios
			retval=""+getAppDir();
		#end
		return retval;	
	}
	public static function getImageInfo(theFile:String){
		var retval=new Map<String,Dynamic>();
		return retval;
	}	
	//
	// Take the image and call the call-back function (wrapper-block)
	//
 	public static function getGalleryImage(theFile:String, func:Dynamic){
		SaveFileName=""+theFile;
                CallBackFunc=func;

		#if ios
			// Remove the file first (When you have a static block that selects a new file and overwrites only in the domain-directory)
			// This is more efficient use of storage. When the app would select all files the storage would double
			if(sys.FileSystem.exists(theFile)){
				sys.FileSystem.deleteFile(theFile);
			}
			// get the Image and (over)write the file
                        SayGallery(callback,""+theFile);
		#else
			#if android
				if(SayGallery == null){
					// include:  <android extension="com.hello.SayGallery.Gallery" />
					// file:    dependencies/android/src/com/hello/SayHello/Hello.java
					SayGallery = JNI.createStaticMethod("com/gallery/SayGallery/Gallery", "Say", "(Lorg/haxe/lime/HaxeObject;Ljava/lang/String;)V", true);
				}
				//openfl.Lib.postUICallback( function(){
					var ar:Array<Dynamic> = [Gallery, theFile];
					SayGallery(ar);
				// } );
			#end
                #end

	} // getGalleryImage

	public static function MkDir(DirName:String):String{
		var retval:String="";
	
		#if ios
                        retval=""+SayGalleryDir(""+DirName);
		#else
			#if android
				if(SayGalleryDir == null){
					// include:  <android extension="com.hello.SayGallery.Gallery" />
					// file:    dependencies/android/src/com/hello/SayHello/Hello.java
					SayGalleryDir = JNI.createStaticMethod("com/gallery/SayGallery/Gallery", "mkdir", "(Ljava/lang/String;)Ljava/lang/String;", true);
				}
				var ar:Array<Dynamic>=new Array<Dynamic>() ;
				ar.push(""+DirName);
				retval=""+SayGalleryDir(ar);
			#else
				// If any other device = root directory
				#if windows	
					retval="c:/temp";
				#else	
					retval="/tmp";
				#end
			#end
                #end

		return retval;
	} // make local directory
	
	public static function RotateImage(bitmapData:BitmapData,degree:Float):BitmapData{
		
		var m:Matrix = new Matrix();
		var x=bitmapData.width/2;
		var y=bitmapData.height/2;
		var p:flash.geom.Point = m.transformPoint(new flash.geom.Point(x, y));
		m.translate(-p.x, -p.y);
		m.rotate(degree*(Math.PI/180));
		m.translate(p.x, p.y);
		
		var newBitmap:BitmapData = new BitmapData( bitmapData.height, bitmapData.width, true , 0);
		var matrix:Matrix = new Matrix();
		matrix.rotate( degree*(Math.PI/180) );
		if ( degree == 90 ) {
			matrix.translate( bitmapData.height, 0 );
		} else if ( degree == -90 || degree == 270 ) {
			matrix.translate( 0, bitmapData.width );
		} else if ( degree == 180 ) {
			newBitmap = new BitmapData( bitmapData.width, bitmapData.height, true );
			matrix.translate( bitmapData.width, bitmapData.height );
		}
		if(degree == 90)
			newBitmap.draw( bitmapData, matrix, null, null, null, true );
		else
			newBitmap.draw( bitmapData, m, null, null, null, true );
		return newBitmap;
	} // rotateImage

	public static function getOrientation():String{
		var retval="";
			#if android
				if(SayGalleryOrientation == null){
					// include:  <android extension="com.hello.SayGallery.Gallery" />
					// file:    dependencies/android/src/com/hello/SayHello/Hello.java
					SayGalleryOrientation = JNI.createStaticMethod("com/gallery/SayGallery/Gallery", "getOrientation", "()Ljava/lang/String;", true);
				}
				var ar:Array<Dynamic>=new Array<Dynamic>() ;
				retval=""+SayGalleryOrientation(ar);
			#end
#if ios
		retval=""+orientation;
#end
		return retval;

	}

	public static function getInfo():String{
		var retval="";
		var filename=""+GalleryImagePath;
#if (js  ||  flash )
#else
			if(sys.FileSystem.exists(filename)){
				tags=getImageInfo(filename);
				retval=""+tags;
			} // if file exists
#end
		return retval;
	} // getInfo

	public static function getImage():BitmapData{
		var retval=new BitmapData(320,320);
		//var filename=""+GalleryImagePath+""+SaveFileName;
		var filename=""+GalleryImagePath;
		//var filename=""+SaveFileName;
		// Does imagepath contains a valid filename?
		if(filename.indexOf(".") > -1){
#if js 
#else
#if flash 
#else
			if(sys.FileSystem.exists(filename)){
				var img= sys.io.File.getBytes(filename);
				var _DisplayImage = BitmapData.loadFromHaxeBytes(img);
 				retval=_DisplayImage.clone();
			} // if file exists
#end
#end
		} // if valid filename
		return retval;
	} // getImage
}// Class


