package com.gallery.SayGallery; 

// Toast
import 	android.widget.Toast;


// Information on selected file 
import	android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
// Copy File
import java.io.*;
import java.nio.channels.FileChannel;

// Image Select
import android.content.Intent;
// Location on device
import android.net.Uri;
import android.provider.MediaStore;
import android.database.Cursor;
import org.haxe.lime.HaxeObject;

import android.media.ExifInterface; // For file information (rotation)



import org.haxe.extension.Extension; // for extending extension
import android.content.Context; // for mainContext
import android.app.Activity.*;

// Alert box
import android.app.AlertDialog;
import android.content.DialogInterface;

public class Gallery extends Extension {
   	public static org.haxe.lime.HaxeObject callback;
        public static int typeActivity;
	public static int orientation=0;
	public static String theFileName="";
	public static String selectedImagePath="";


	private static final int SELECT_FILE = 1;
	private static final int REQUEST_CAMERA = 0;

	// Full path of the selected file
	public String getFullPathUri(Uri l){
		String retval="";

		String[] proj = { MediaStore.Images.Media.DATA };
		try{
     			Cursor cursor = mainContext.getContentResolver().query(l, proj, null, null, null);
			try{
				int column_index = cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
				try{
	        			cursor.moveToFirst();
	        			retval=""+cursor.getString(column_index);
				}catch(Exception c){}
			}catch(Exception b){}
		}catch(Exception a){}
		return retval;
	 } // getFullPathUri

	// Copy Selected file to the local domain of the application 
	public static boolean copyFile(String from, String to) {
		try {
			int end = from.toString().lastIndexOf("/");
			String str1 = from.toString().substring(0, end);
			String str2 = from.toString().substring(end+1, from.length());
			int end2 = to.toString().lastIndexOf("/");
			String str3 = to.toString().substring(0, end2);
			String str4 = to.toString().substring(end2+1, to.length());
			File source = new File(str1, str2);
			File destination= new File(str3, str4);
			if (source.exists()) {
				FileChannel src = new FileInputStream(source).getChannel();
				FileChannel dst = new FileOutputStream(destination).getChannel();
				dst.transferFrom(src, 0, src.size());
				src.close();
				dst.close();
			} // source exist?
			return true;
		} catch (Exception e) {
			return false;
        	}
	} // CopyFile 


	@Override public boolean onActivityResult (int requestCode, int resultCode, Intent data) {

//if (resultCode != -1){
 		  //Toast.makeText(mainContext, "canceled code:"+resultCode, Toast.LENGTH_SHORT).show();
//}else{
		if(resultCode == -1){

			// App-Domain/Direcotry/Sandbox File Location
			try{
				FManager filemanager = new FManager(mainContext);
				filemanager.init();
				String destination = filemanager.getTmpFileName(""+theFileName);


				String source=""+getFullPathUri(data.getData());
				// Copy File
				copyFile(source,destination);
				// CallBack : The callback pointer should be the Haxe Class (not the callback-function!) !!
				callback.call("callback", new Object[] {""+destination+""});
			}catch(Exception e){}
		} // resultCode (Cancel == 0 , Selecting File == -1)
		return true;
	} // runActi
	

	public static void getPath(){
Intent photoPickerIntent = new Intent(Intent.ACTION_PICK);
photoPickerIntent.setType("image/*");
mainActivity.startActivityForResult(photoPickerIntent, SELECT_FILE);    
/*
 		Intent intent = new Intent(android.provider.MediaStore.ACTION_IMAGE_CAPTURE );
        	intent.putExtra( android.provider.MediaStore.EXTRA_OUTPUT, ""+theFileName);
            	mainActivity.startActivityForResult(intent, REQUEST_CAMERA);
*/
        } // getPath

	

	// HaxeObject should be the Haxe Class
	public static void Say(org.haxe.lime.HaxeObject c, String thefilename){
		callback=c;
		theFileName=""+thefilename;
		getPath();
	} // Say

	public static String getOrientation(){
		return ""+orientation;
	}

	public static String mkdir(String nothing){
		String retval="/private/MyDir";
 		try{
                       FManager filemanager = new FManager(mainContext);
                       filemanager.init();
                       retval = filemanager.getTmpFileName("");
                       //retval=""+getFullPathUri(data.getData());
			
		}catch(Exception e){}
		return ""+retval;
	} // Say


} // Extends class
