//
// Documentation ..
// Add doc
//
#include <hx/CFFI.h>
#import <AssetsLibrary/AssetsLibrary.h>
#import "../include/Gallery.h"
#import <UIKit/UIAlert.h>

#import <UIKit/UIKit.h>
#import <Foundation/Foundation.h>

@interface NMEAppDelegate : NSObject <UIApplicationDelegate>
@end
//
// Trying to avoid crash on ImagePickerController when it is in Landscape !!
// 
@implementation NMEAppDelegate(TestController)
// Fixed LandScape:
/*
	// Prevent crash when UIImagePickerController is used in Landscape (ios 7)
 	-(NSUInteger)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window{
	 	if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad) {
			return UIInterfaceOrientationMaskAll;
 		}else{
 			return UIInterfaceOrientationMaskAllButUpsideDown;
 		}
 	}// supportedinterface
*/
@end


// Subclassing UIImagePickerController to try to tweak the interface and avoid crash on Landscape
@interface NonRotatingUIImagePickerController : UIImagePickerController
@end

@implementation NonRotatingUIImagePickerController

	- (BOOL)shouldAutorotate{
    		return NO;
	}

	-(UIInterfaceOrientation)preferredInterfaceOrientationForPresentation{
    		return UIInterfaceOrientationPortrait;
	} 
/*
	// make modal
	- (UIModalPresentationStyle)modalPresentationStyle{
    		if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad){
        		return UIModalPresentationFormSheet;
    		}
    		return [super modalPresentationStyle];
	}
*/
@end

@interface TestController : UIViewController <UIImagePickerControllerDelegate, UINavigationControllerDelegate>
	@property int counter;
	@property (retain, atomic) NSString *aFile;
	- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info;
	- (void) display;
@end


@implementation TestController
@synthesize aFile;

	// Alert Box - Debug
	-(void) display{
     		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Speak" message:self.aFile delegate:NULL cancelButtonTitle:@"OK" otherButtonTitles: nil];
     		[alert show];
	}


	-(void) viewDidAppear:(BOOL)animated{
    		[super viewDidAppear:YES];
   		 // irritating - use of counter ... maybe dismiss modal? : when omitted the imagepicker is executed over and over again
    		if(self.counter < 1){
        
			UIImagePickerController *imagePickerController = [[NonRotatingUIImagePickerController alloc] init];
			//UIImagePickerController *imagePickerController = [[UIImagePickerController alloc] init];
        		imagePickerController.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
        		//imagePickerController.sourceType = UIImagePickerControllerSourceTypeGallery ;
        		imagePickerController.delegate = self;
			[self presentViewController:imagePickerController animated:YES completion:nil];
        
        		self.counter++;
    		} // if self.counter < 1
	} // viewDidAppear

#pragma mark - Image Picker Controller delegate methods

	- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    
		UIWindow *window = [UIApplication sharedApplication].keyWindow;
		// Attempt to get rid of the controller
		[picker dismissViewControllerAnimated:YES completion:^{[self dismissViewControllerAnimated:YES completion:nil];}];
		[window makeKeyAndVisible];

		NSData *imageData = UIImageJPEGRepresentation([info objectForKey:UIImagePickerControllerOriginalImage],1.0);
		UIImage *tempImage = [UIImage imageWithData:imageData];
		// Your own domain
		NSString* domain = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) objectAtIndex:0];
		domain = [domain stringByAppendingString:@"/"];
		domain = [domain stringByAppendingString:self.aFile]; 
		[imageData writeToFile:domain atomically:YES];
		// Call Back the Haxe Function
		const char *c_domain=[domain UTF8String];
		gallery::call_callbackGallery(c_domain);
	} // didFinishPicking

	- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
		//UIWindow *window = [UIApplication sharedApplication].keyWindow;
		//[picker dismissViewControllerAnimated:YES completion:^{[self dismissViewControllerAnimated:YES completion:nil];}];
		UIWindow *window = [UIApplication sharedApplication].keyWindow;
		// Attempt to get rid of the controller
		[picker dismissViewControllerAnimated:YES completion:^{[self dismissViewControllerAnimated:YES completion:nil];}];
		[window makeKeyAndVisible];
	} // DidCancel

	namespace gallery 
	{ 

		value *callback_function= NULL;
/*
		const char* getAppDir (){
        		NSString* domain = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) objectAtIndex:0];
        		const char *cfilename=[domain UTF8String];
        		return cfilename;
     		}
*/



		const void call_callbackGallery(const char* strdir){
			val_call1(*callback_function ,alloc_string(strdir));
		}

		const char* mkdirectory(const char *dir){
			NSString *dirname=[NSString stringWithFormat:@"%s",dir];
 // Create Directory for this App
                        NSString* path = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) objectAtIndex:0];
                        path = [path stringByAppendingString:@"/"];
                        NSString *filePathAndDirectory;
                        NSError *error;
                        filePathAndDirectory = [path stringByAppendingString:dirname];
                        [[NSFileManager defaultManager] createDirectoryAtPath:filePathAndDirectory withIntermediateDirectories:NO attributes:nil error:&error];
        		const char *cfilename=[filePathAndDirectory UTF8String];
        		return cfilename;
		}

		// This function is called from Haxe
 		const void initGallery(value func, const char *theFilename){
			// Initialize the callback function
			val_check_function(func,1);
    			callback_function = alloc_root();
    			*callback_function= func;
			
/*
			// Create Directory for this App
			NSString* path = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) objectAtIndex:0];
    			path = [path stringByAppendingString:@"/"];
    			BOOL doesExist = [[NSFileManager defaultManager] fileExistsAtPath:[path stringByAppendingString:@"tmp"]];
    			NSString *filePathAndDirectory;
    			NSError *error;
    			filePathAndDirectory = [path stringByAppendingString:@"tmp"];
    			[[NSFileManager defaultManager] createDirectoryAtPath:filePathAndDirectory withIntermediateDirectories:NO attributes:nil error:&error];
*/
   
			// Present a controller and pass the filename to be saved
			NSString *n=[NSString stringWithFormat:@"%s",theFilename];
			TestController *wn = [[TestController alloc] init];
			// Store the FileName into the TestController view
   			wn.aFile=n;
			UIViewController *a = [[[[UIApplication sharedApplication] delegate] window] rootViewController];
    			// a.view.backgroundColor=UIColor.redColor; // make the background red 
    			[a.view addSubview:wn.view];
    			[a addChildViewController:wn];
		} // initGallary
	} // namespace 

@end
// End of implementation of TestController


