//
//
// Lobby Server
//
// Login for multiplayer games
//
// Author: MdotEdot
//
// Use at your own risk!
//
// Special thanks to SadiQ for his support and advice!
//
//
// REPLACE : all nme. to openfl.
import nme.net.URLLoader;
import nme.net.URLLoaderDataFormat;
import nme.net.URLRequest;
import nme.events.Event;
import nme.events.IOErrorEvent;
import nme.display.*;
//import nme.display.DisplayObject;


import com.stencyl.Engine;
import com.stencyl.behavior.Script;
import com.stencyl.behavior.ActorScript;
import com.stencyl.models.actor.ActorType;


//
// Lobby Server
//
// Connects players to eachother in Rooms
//   getCurrentRoom, getAllRooms, getAllPlayers, 
//

class Lobby{


	// All default settings go into initialization since we do a disconnect sometimes ...
	private static var script:Script;
   	private static var heartTimer:haxe.Timer;

	private static var exectimer:Float=0; // for elapsedTime Between call and onData
        public static var elapsedTime:Float=-1;



	private static var isHeart:Bool;
	private static var Heart:Float; // heartbeat should be > 2 .. I once had local server so much stressed on 1 that it wasn't workable
	private static var HeartDate:String;


	// Connection errors
	public static var errorList:Array<Dynamic>;


	private static var debug:Bool=false;
	// dbURL = 192.168.x.x:/database/stencyl.php
	// we will add ?a=  (a is the parameter that is used in stencyl.php)
	private static var dbURL:String="";

	private static var callers:Map<String,String>;
	private static var callFunctions:Map<String,Dynamic>;

	private static var roomFunc:Dynamic;
	private static var loginFunc:Dynamic;
	private static var createFunc:Dynamic;
	private static var initFunc:Dynamic;


	private static var isConnect:Bool;

	private static var AppID:String;
	private static var SecretID:Float=0;

	private static var loginState:String;
	public static var roomState:String;
	public static var joinState:String;
	public static var isChanged:Bool;
	public static var isAskChange:Bool;

	private static var joinId:Float;


	// Your playernumber
	//private static var PlayerID:Float;
public static var PlayerID:Float;
	//private static var PlayerName:String;
public static var PlayerName:String;

	// the active player (it is NOT-0 so it is not the active player from the start)
	private static var CurrentPlayerID:Float;
	private static var CurrentPlayerName:String;
	public static var TurnState:Int;
	private static var TurnTime:Float;
	// Currentroom players
	private static var RoomName:String;
	private static var JoinRoom:String;  // attempting join room
	private static var RoomID:Float;
	private static var CurrentRoom:String;
	//private static var CurrentRoomPlayerNames:Array<Dynamic>;
	//private static var CurrentRoomPlayerIDs:Array<Dynamic>;
	private static var Extra:String;
	// Seat in room
	private static var Seat:Float;

     
     
	
	//private static var Rooms:Map<String, Array<Dynamic>>; // when we need a request id .. multiple queries ? Well : not now!
	private static var Rooms:Map<String, String>;
	private static var Players:Map<String, Dynamic>;

	// Shared Data
	//private static var SharedListData:Array<Dynamic>;


	private static function initialization(){
		isHeart=false;
		Heart=0;
		HeartDate="";


		errorList=new Array<Dynamic>();


		dbURL="";

		callers=new Map<String,String>();
		callFunctions=new Map<String,Dynamic>();

		roomFunc=null;
		loginFunc=null;
		createFunc=null;
		initFunc=null;


		isConnect=false;

		loginState="";
		roomState="";
		joinState="";
		isChanged=false;
		isAskChange=false;

		joinId=0;


		PlayerID=0;
		PlayerName="";
		RoomID=0;
		RoomName="";
		JoinRoom="";

		CurrentPlayerID=-12354;
		CurrentPlayerName="1231-name";
		TurnState=0;
		TurnTime=-1;
		Extra="";		// Extra room information to join .. such as a type indicator Four / Five in a row, biljarts : snooker, pool
		CurrentRoom="";
		//CurrentRoomPlayerNames=new Array<Dynamic>();
		//CurrentRoomPlayerIDs=new Array<Dynamic>();
		Seat=0;

     
     
	
		//Rooms=new Map<String,Array<Dynamic>>();
		Rooms=new Map<String,String>();
		Players=new Map<String, Dynamic>();

		//SecretID=0;

	}
	//
	// Debug on/off
	//
	public static function setDebug(sw:Bool){
//debug=false;
		debug=sw;
	}
	//
	// -- 
	// Create connection to the server with ID that is made 
	// available to the Lobby administrator
	//
	// SecretID = ScoreID = secret number that is not transfered  on the network but is encoded
	//
	// Note: There can be only one URL connection for the game
	//
	public static function connect(URL:String, ID:String, secret:Float, func:Dynamic){
		//
		// We reset all the variables
		//    Because the extension user can re-use the init/connect block
		//
		initialization();
		//
		// What are the connection details
		dbURL=URL;	
		#if (openfl >= "4.0.0")
		 script = new com.stencyl.behavior.Script();
		#else
                script = new com.stencyl.behavior.Script(Engine.engine);
		#end
		if(initFunc == null)initFunc=func;
		isConnect=false;
		AppID=ID;
		SecretID=secret;
		var callID=getCallID("initFunc",func);

if(debug)trace("Init - call id : "+callID);

		  //var scd=makeCode();
 		var scd=MultiPlay.makeCode(AppID,SecretID); 

		var args:Array<String>=new Array<String>();

		args.push("lobby");
		args.push("init");
		args.push(""+callID);
		args.push(""+AppID);
		args.push(""+scd[0]);
		args.push(""+scd[1]);
		call(callID,args);

		

//		call(callID,Base64.encode("lobby")+","+Base64.encode("init")+","+Base64.encode(""+callID)+","+Base64.encode(""+AppID)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",");
	} // remember URL to call the mysql functions 

	// Logout player -> removePlayer
	// update table null set time and 0 on elapsed_turn;
	public static function Logout(func:Dynamic){
		// Inform extension that you are no longer connected
		isConnect=false;
		// 
		var callID=getCallID("logoutFunc",func);
if(debug)trace("Init - call id : "+callID);
		  //var scd=makeCode();
 		var scd=MultiPlay.makeCode(AppID,SecretID); 

		var args:Array<String>=new Array<String>();

		args.push("lobby");
		args.push("logout");
		args.push(""+callID);
		args.push(""+PlayerID);
		args.push(""+AppID);
		args.push(""+scd[0]);
		args.push(""+scd[1]);
		call(callID,args);

		
	} // remember URL to call the mysql functions 


	//
	// Store the function to the callers
	//
	public static function getCallID(callFunction:String, function_pointer:Dynamic):String{
		var retval="";
		var found=true;
		while(found){
			retval="C"+Std.random(23000);
			var chk:String=callers.get(retval);
			if(chk == null){
				found=false;
				callers.set(retval,""+callFunction);
				callFunctions.set(retval, function_pointer);
			}
		}
		return retval;
	}

	// Lobby: Is Connected?
	public static function isConnected():Bool{
			return isConnect;
	}

	//
	// The wrapper functions are stored in teh callFunctions Map
	//
	// We needed to do this because when wrappers are inside other wrappers the synchronisation
	// got lost and wrapper functions were repeatedly called in wrong places!!!
	//
	public static function callBack(callID:String){
		var callback:Dynamic;
		if(callID.length > 0){
			callback=callFunctions.get(callID);
			var func=callers.get(callID);
trace("Calling the callback function that we stored("+callID+") : "+callback+" name of func: "+func);
			if(""+func == "setRoomDataFunc"){

				// This is setRoomData
			}
			if(""+func == "afterTurn"){
				TurnState=2;
			}
			if(callback!=null)callback();
		}	
	}


	public static function onError(e:Event){
if(debug)trace("onError called: "+e);
if(debug)trace("ERROR ERROR ERROR onError Called : "+e);
		var cvt=""+e;
//Error=""+e;
		errorList.push(""+Date.now()+" = "+cvt.substring(cvt.indexOf("text=")+5));
//isConnect=false;
		if(cvt.indexOf("?=c") > -1){
			roomState="ERROR";
			var callID:String=cvt.substring(cvt.indexOf("?c=")+3, cvt.indexOf("&"));
if(debug)trace("onError callback possibility : callID: "+callID);
                	callBack(callID); // call the inside block functions
		}

        } // onError

    private static function onData(e:Event){
                // get the Call ID from the data
                var e_str:String=""+e;

                //elapsedTime=time()-exectimer;

if(debug)trace("In onData: "+e_str);
                var callID:String=e_str.substring(e_str.indexOf("?c=")+3, e_str.indexOf("&"));

				#if (openfl >= "4.0.0")
					var result=MultiPlay.Base64_URL_decode(cast(e.target, URLLoader).data);
					if(debug)trace("Data: "+cast(e.target, URLLoader).data+" Decoded: "+result);
				
				#else
					var result=MultiPlay.Base64_URL_decode(e.target.data);
					if(debug)trace("Data: "+e.target.data+" Decoded: "+result);
				#end


                var items=result.split(",");
if(debug)trace("CallID?: items[0]: "+items[0]);
		var chcode=""+items[0];
                if(items.length > 0 && chcode.charAt(0)=="C"){
                        dataActions(items);
                } // if items and items-first-element contains a C for callID

        }// onData



        //
        // items does contain elements, otherwise this will not be called
        //
        private static function dataActions(items:Array<String>){
	     var text_func=callers.get(items[0]);
if(debug)trace("Inside dataAction : callID: "+items[0]+" text_func: "+text_func);

		if(text_func=="initFunc"){
trace("Inside initFunc checker .. what is the result of the checkCode: items1 : "+items[2]);
			if(items[2] == "BAD"){
				isConnect=false;
			}else{
				isConnect=false;
				if(items[2] == "OK") isConnect=true;
				var callback=callFunctions.get(items[0]);
				if(callback!=null) callback();
			}
		}
		if(text_func == "createLoginFunc"){
			// result=> items[2]
if(debug)trace("createLoginFunc Result: "+items[2]);
			loginState=""+items[2];
			roomState=""+items[2];
			// handle the result inside the callback function using the blocks 
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();
		}
		if(text_func == "login"){
			loginState=""+items[2];
			roomState=""+items[2];
			PlayerID=Std.parseFloat(""+items[5]);
			PlayerName=""+items[6];
			// handle the result inside the callback function using the blocks 
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();
		}
		if(text_func == "LoginGuest"){
			loginState=""+items[2];
			roomState=""+items[2];
			PlayerID=Std.parseFloat(""+items[5]);
			PlayerName=""+items[6];
			// handle the result inside the callback function using the blocks 
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();
		}
		if(text_func == "logoutFunc"){
			PlayerID=0;
			PlayerName="";
			isConnect=false;
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();
		}
		if(text_func == "createRoomFunc"){
			roomState=""+items[2];
			RoomID=Std.parseFloat(""+items[9]);
			// We do not do anything with items[10] which is the room_type .. we only query rooms or create/join with the extra addition
if(debug)trace("RoomID after create : "+RoomID+"  roomState: "+roomState);
			// handle the result inside the callback function using the blocks 
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();


		}
		if(text_func == "LeaveRoomFunc" && items.length > 1){
			roomState=""+items[2];
			joinState=""+items[2];
			RoomName="";
			CurrentRoom="";
			RoomID=0;
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();
		}
		if(text_func == "JoinRoomFunc"){
			roomState=""+items[2];
			RoomID=Std.parseFloat(""+items[9]);
			// We join a room so we should not change our playerinfo?!?
			//PlayerID=Std.parseFloat(""+items[5]);
			//PlayerName=""+items[6];
			joinState=""+items[2];
			Seat=Std.parseFloat(""+items[4]);	
trace("RoomID after create : "+RoomID+"  roomState: "+roomState);

trace("JoinRoomFunc  0 : "+items[0]);
trace("JoinRoomFunc  1 : "+items[1]);
trace("JoinRoomFunc : "+items[2]);
trace("JoinRoomFunc : "+items[3]);
trace("JoinRoomFunc : "+items[4]);
trace("JoinRoomFunc 5 : "+items[5]);
trace("JoinRoomFunc 6 : "+items[6]);
trace("JoinRoomFunc 7 : "+items[7]);
trace("JoinRoomFunc Force TurnTime: 8 : "+items[8]);
trace("JoinRoomFunc room_id: 9 : "+items[9]);
trace("JoinRoomFunc roomname:(JoinRoom) = "+JoinRoom);
			TurnTime=Std.parseFloat(""+items[8]);
			if(joinState == "OK"){
				PlayerID=Std.parseFloat(""+items[5]);
				RoomName=""+JoinRoom;
				CurrentRoom=JoinRoom;
			}else{
				RoomName="";
				CurrentRoom="";	
			}
			Heart=Std.parseInt(""+items[3]);
			if(isHeart){
if(debug)trace("Trying to stop heart!");
				heartTimer.stop();
				isHeart=false;
			}

  			if(Heart > 0 && !isHeart){
if(debug)trace("Creating heartbeat timer! Heart = "+Heart);
                                isHeart=true;
                                heartTimer=new haxe.Timer(Std.parseInt(""+Heart)*1000);
                                heartTimer.run=function():Void{
if(debug)trace("In Heart!");
                                        if(AppID.length > 0 && PlayerID > 0 && isConnect){
     						var callID=getCallID("getheart",null);
                        			var scd=MultiPlay.makeCode(AppID,SecretID);
                        			var args:Array<String>=new Array<String>();
                        			args.push("lobby");
                        			args.push("getheart");
                        			args.push(""+callID);
                        			args.push(""+AppID);
                        			args.push(""+PlayerID);
						args.push(""+scd[0]);
                        			args.push(""+scd[1]);
                        			call(callID,args);
                                        } // if we still have a game_id and playerid
                                } // heartTimer
                        } // heart?
			// handle the result inside the callback function using the blocks 
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();
		}
		if(text_func == "requestRoomsFunc" && items.length > 3){
		
			roomState=items[2];
			// We do not do anything with the_extra information .. Since we query the roomdata based on the extra and therefore the data
			// is only limited to the query. We might later decide that we want to query across other room-types.
			var the_extra=items[3];
if(debug)trace("The type is: "+the_extra);
			if(items[5] != null){
				var roomdata=MultiPlay.Base64_URL_decode(items[5]);
				var YSplit=roomdata.split("YxY"); // each room
				var RoomNumber=0;
				var RoomName="";
if(debug)trace("YSplit : "+YSplit);
				for(yy in YSplit){
					if(yy != null){
						var XSplit=yy.split("XxX"); // room name // players
if(debug)trace("XSplit : "+XSplit);
						//for(xx in XSplit ){
						if(XSplit != null && XSplit.length > 1){
						
							var WSplit=XSplit[1].split("WxW"); //  room information
if(debug)trace("WSplit : "+YSplit);
							if(WSplit != null && WSplit.length > 0){
								Rooms.set(""+WSplit[1], ""+MultiPlay.Base64_URL_decode(WSplit[2]));
								RoomNumber=Std.parseInt(WSplit[1]);
								RoomName=MultiPlay.Base64_URL_decode(WSplit[2]);
		
							}  // WxW Room information
							if(XSplit[2] != null){
								var vv=XSplit[2].split("VxV");
								if(vv != null && vv.length > 0){
									var m:Map<String,String>=new Map<String,String>();
									for(v in vv){
										var QSplit=v.split("QxQ");
if(debug)trace("QSplit : "+QSplit);
										if(QSplit.length > 1){
if(debug)trace("QSplit [1] :"+MultiPlay.Base64_URL_decode(QSplit[1])+" decoded: "+MultiPlay.Base64_URL_decode(QSplit[0]));
											m.set(""+MultiPlay.Base64_URL_decode(QSplit[1]), ""+MultiPlay.Base64_URL_decode(QSplit[0]));
										}
									} // VxV and QxQ
									Players.set(""+RoomNumber, m);
								}
							} // XSplit[2] == Players
						} // XSplit data?
					} // Y Split data?
				} // y-data 
			} // if not null (items[4])
			var callback=callFunctions.get(items[0]);
			if(callback!=null) callback();
		} // RoomData

	} //dataActions

	//
	// Lobby Server
	//
	// Login, createRoom, joinRoom, leaveRoom, getPlayers, nextPlayer, currentPlayer
	//
	public static function login(email:String, password:String, loginfunc:Dynamic){
		var param:String="";

		// Make current Player Empty
		CurrentPlayerID=-2361611;
		CurrentPlayerName="";
		CurrentRoom="";

		PlayerID=0;	// Make sure that you have no login : when it fails
		if(AppID.length > 0){
			//var scd=makeCode();
			var callID=getCallID("login",loginfunc);

	 		var scd=MultiPlay.makeCode(AppID,SecretID);

			var args:Array<String>=new Array<String>();
			args.push("lobby");
			args.push("login");
			args.push(""+callID);
			args.push(""+AppID);
			args.push((""+email).toUpperCase());
			args.push((""+password).toUpperCase());
			args.push(""+scd[0]);
			args.push(""+scd[1]);
			call(callID,args);
trace("Login attempt :"+args);


			
		//	param="gamedata,login,"+AppID+","+email+","+password+","+scd[0]+","+scd[1]+","; // call Lobby function getGameData
		//	var callId=getCallID("loginFunc",loginfunc);
		//	loginFunc=loginfunc;
		//	param=Base64.encode("gamedata")+","+Base64.encode("login")+","+Base64.encode(callId)+","+Base64.encode(""+AppID)+","+Base64.encode(""+email)+","+Base64.encode(""+password)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+","; // call Lobby function getGameData
if(debug)trace("Login parameters: : "+param);
		//	loginState="";
		//	//call(callId,param);
		}else{
			// No if Debug .. just say that there is no connection!
			trace("Not connected to server! Use Lobby: Server URL: AppID: SecretID: block!!");
		}
	}

	public static function loginGuest(loginfunc:Dynamic){
		var param:String="";
		PlayerID=0;
		CurrentRoom="";
		if(AppID.length > 0){
			var callId=getCallID("LoginGuest",loginfunc);

                        var scd=MultiPlay.makeCode(AppID,SecretID);

                        var args:Array<String>=new Array<String>();
                        args.push("lobby");
                        args.push("loginguest");
                        args.push(""+callId);
                        args.push(""+AppID);
                        args.push("-1");
                        args.push(""+scd[0]);
                        args.push(""+scd[1]);
if(debug)trace("LoginGuest: "+args);
                        call(callId,args);



			//param=Base64.encode("gamedata")+","+Base64.encode("loginguest")+","+Base64.encode(callId)+","+Base64.encode(""+AppID)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+","; // call Lobby function getGameData
if(debug)trace("LoginGuest parameters: : "+param);
			//call(callId,param);
		} // connected?
		else{
if(debug)trace("Not connected to server! Use Lobby: Server URL: AppID: SecretID: block!!");
		}
	}

	//

	//
	//
	//
	public static function create(email:String, password:String, username:String,  createLoginfunc:Dynamic){
		var param:String="";
		if(AppID.length > 0 && isConnect){
			var callID=getCallID("createLoginFunc",createLoginfunc);

                        var scd=MultiPlay.makeCode(AppID,SecretID);

			loginState="";
			joinState="";
                        var args:Array<String>=new Array<String>();
                        args.push("lobby");
                        args.push("create");
                        args.push(""+callID);
                        args.push(""+AppID);
                        args.push((""+email).toUpperCase());
                        args.push((""+password).toUpperCase());
                        args.push(""+username);
                        args.push(""+scd[0]);
                        args.push(""+scd[1]);
                        call(callID,args);

		} // if connected?
		else{
if(debug)trace("Not connected to server! Use Lobby: Server URL: AppID: SecretID: block!!");
		}
	}


	// Search rooms
	public static function requestRooms(extra:String, roomfunc:Dynamic){
		if(PlayerID > 0 && AppID.length > 0){
			var callID=getCallID("requestRoomsFunc", roomfunc);
			
			Rooms=new Map<String,String>(); // we request new rooms, so empty the Map
		

                        var scd=MultiPlay.makeCode(AppID,SecretID);

                        var args:Array<String>=new Array<String>();
                        args.push("lobby");
                        args.push("requestrooms");
                        args.push(""+callID);
                        args.push(""+AppID);
			args.push(""+extra);
                        args.push(""+scd[0]);
                        args.push(""+scd[1]);
                        call(callID,args);

		}
	} // eof requestRooms

	public static function getRooms():Map<String,String>{
		var retval:Map<String, String>=new Map<String, String>();
		if(PlayerID > 0 && AppID.length > 0){
			// Map inside a map ? 
			retval=Rooms;
		} // Player logged in?
if(debug)trace("getRooms : List of Rooms with active players!("+retval);
		return retval;
		
	} // eof getRooms

	// Problems with CCP compilation when we use Float even when we convert it to String ourselves in the Map 
	public static function getPlayers(IDorNAME:String, Room:String):Map<String,Dynamic>{
		var retval:Map<String,Dynamic>=new Map<String,Dynamic>();
		var _Room=""+Room;
		//
		// Map inside a Map ???
		// Rooms.get(""+_extra).get(""+r); .. We will omit extra for now since we want the information of the room instead of other rooms
		//
		if(IDorNAME=="NAME" && Rooms!=null){
			for(r in Rooms.keys()){
				if(Rooms.get(""+r)==""+Room){
					_Room=""+r;
				}
			}
		}
		var tempplayers:Map<String,String>=Players.get(""+_Room);
		if(tempplayers != null && Players != null){
			for(k in tempplayers.keys()){
				var p:Map<String,String>=new Map<String,String>();	
				retval.set(""+k,""+Players.get(""+_Room).get(k));
			}
		}
		return retval;
	}

	// ---------------------------
        // Network connection routines
        // ---------------------------
        // Call : arguments that are send to the server : CallID to communicate the result with this extension
        // onData: Return data function
        // onError: What do we do with the errors?
        // callback: Based on the data received we are doing the call-back function store in the extension for the callID
        //
        private static function call(CallID:String, Args:Array<String>){
                var str:String="";


                // Store the timer
                //exectimer=time();

                // Convert each argument into a Base64 encoded string
                for(arg in Args){
if(debug)trace("Sending Data : "+arg+" encode the arg: "+MultiPlay.Base64_URL_encode(arg));
                        str=str+MultiPlay.Base64_URL_encode(arg)+",";
                }
                var url_encode:String=MultiPlay.Base64_URL_encode(str);
if(debug)trace("encrypted send: "+url_encode);

                var execUrl=""+dbURL+"?c="+CallID+"&a="+url_encode+"&t="+MultiPlay.Base64_URL_encode(""+Date.now());
if(debug)if(debug)trace("Calling :"+execUrl);
                var r:URLRequest=new URLRequest(execUrl);
                var ul:URLLoader=new URLLoader();
                ul.addEventListener( IOErrorEvent.IO_ERROR, onError);
                ul.addEventListener(Event.COMPLETE,onData);
                ul.load(r);
        } // eof call




	public static function getState(theState:String):String{
		var retval:String="";
		if(theState == "LOGIN") retval=""+loginState;
		if(theState == "JOIN") retval=""+joinState;
		if(theState=="CREATE") retval=""+roomState;
		return retval;
		
	}

	public static function getLoginState():String{
		return loginState;
	}

	public static function getRoomState():String{
		return roomState;
	}


	// MakeCode
	private static function makeCode():Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		return retval;
	}

/*
	public static function getPlayersInRoom(RoomNR:Float,requestID:Float):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		if(PlayerID > 0 && AppID.length > 0){
			var rooms=Rooms.get("ID"+requestID);
			if(rooms!=null){
				var cnt=1;
				for(r in rooms){
					if(cnt == Std.parseInt(""+RoomNR)){
						var pc=0;
						while(pc < r[1].length){
							retval.push(Base64.decode(r[1][pc]));
							pc++;
						} // all players
					} // is this the room we want to inspect?
					cnt++;
				} //  all rooms
			}	 // rooms ?
		} // Player logged in?
		return retval;
	}
*/

	// Create Room
           //     Lobby.createRoom("AGDGPBBD",(("" + "Room") + ("" + randomInt(Math.floor(100), Math.floor(999)))),4,"TURN",10,56,function myCreateRoom() {});
	//
	public static function createRoom(RoomName:String, NrPlayers:Float, HeartBeat:Float, turnTime:Float, _extra:String, roomfunc:Dynamic){
		// Make sure that the data on current room is gone before we join/create
		//CurrentRoomPlayerNames=new Array<Dynamic>();
		//CurrentRoomPlayerIDs=new Array<Dynamic>();
		//CurrentPlayerID=PlayerID;
		//CurrentPlayerName=PlayerName;
		CurrentRoom=""+RoomName;
		TurnTime=turnTime;
		Extra=_extra;

		roomState="";

			loginState="";
			joinState="";
trace("Create Room : PlayerID: "+PlayerID+" AppID: "+AppID);
		if(PlayerID > 0 && AppID.length > 0){
if(debug)trace("createRoom : "+RoomName);
if(debug)trace("AppID: "+AppID+" RoomName: "+RoomName+" NrPlayers: "+NrPlayers+"  HeartBeat: "+HeartBeat+"  roomFunc: "+roomfunc);
			var callID=getCallID("createRoomFunc",roomfunc);

                        var scd=MultiPlay.makeCode(AppID,SecretID);

                        var args:Array<String>=new Array<String>();
                        args.push("lobby");
                        args.push("createroom");
                        args.push(""+callID);
                        args.push(""+AppID);
			args.push(""+RoomName);
			args.push(""+NrPlayers);
			args.push(""+HeartBeat);
			args.push(""+TurnTime);
			args.push(""+PlayerID);
			args.push(""+PlayerName);
			args.push(""+Extra);
                        args.push(""+scd[0]);
                        args.push(""+scd[1]);
                        call(callID,args);
			//var scd=makeCode();
			//var callId=getCallID("createRoomFunc",roomfunc);
			//var param=Base64.encode("gamedata")+","+Base64.encode("createroom")+","+Base64.encode(""+callId)+","+Base64.encode(""+AppID)+","+Base64.encode(""+RoomName)+","+Base64.encode(""+NrPlayers)+","+Base64.encode(""+RoomType)+","+Base64.encode(""+HeartBeat)+","+Base64.encode(""+TurnTime)+","+Base64.encode(""+requestID)+","+Base64.encode(""+PlayerID)+","+Base64.encode(""+PlayerName)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
//if(debug)trace("Create parameters: : "+param);
			//call(callId,param);
		} // player logged in?
	} // create Room


	//
	// joinRoom
	//
	public static function joinRoom(RoomName:String, joinfunc:Dynamic){
		// Make sure that the data on current room is gone before we join/create
		//CurrentRoomPlayerNames=new Array<Dynamic>();
		//CurrentRoomPlayerIDs=new Array<Dynamic>();
		JoinRoom=""+RoomName;
		// Make variable on Current Player empty
		CurrentPlayerID=-23235;
		CurrentPlayerName="";

		roomState="";
		if(PlayerID > 0 && AppID.length > 0){
if(debug)trace("joinRoom : "+RoomName);
			var callID=getCallID("JoinRoomFunc",joinfunc);

                        var scd=MultiPlay.makeCode(AppID,SecretID);

                        var args:Array<String>=new Array<String>();
                        args.push("lobby");
                        args.push("joinroom");
                        args.push(""+callID);
                        args.push(""+AppID);
			args.push(""+RoomName);
			args.push(""+PlayerID);
			args.push(""+PlayerName);
                        args.push(""+scd[0]);
                        args.push(""+scd[1]);
                        call(callID,args);
			//var scd=makeCode();
			//var callId=getCallID("joinFunc",joinfunc);
			//var param=Base64.encode("gamedata")+","+Base64.encode("joinroom")+","+Base64.encode(""+callId)+","+Base64.encode(""+AppID)+","+Base64.encode(""+RoomName)+","+Base64.encode(""+PlayerID)+","+Base64.encode(""+PlayerName)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
			//call(callId,param);
		} // player logged in?
	} // joinRoom


	// Leave Room
	public static function leaveRoom( RoomName: String, leaveFunc:Dynamic){
		// Remove all data from player
		roomState="";
		// Leave room => No seat
		Seat=0;
		CurrentRoom="";
		//
		//
if(debug)trace("Leaving Room and what are the PlayerIDs!");
if(debug)trace("PlayerID: "+PlayerID);
		if(PlayerID > 0 && AppID.length > 0){
if(debug)trace("in LeaveRoom function!");
			if(isHeart){
if(debug)trace("Trying to stop heart!");
				heartTimer.stop();
			}
			isHeart=false;
			var callID=getCallID("LeaveRoomFunc",leaveFunc);

                        var scd=MultiPlay.makeCode(AppID,SecretID);

                        var args:Array<String>=new Array<String>();
                        args.push("lobby");
                        args.push("leaveroom");
                        args.push(""+callID);
                        args.push(""+AppID);
			args.push(""+RoomName);
			args.push(""+PlayerID);
                        args.push(""+scd[0]);
                        args.push(""+scd[1]);
if(debug)trace("Calling leaveroom function: "+args);
                        call(callID,args);
		} // player logged in?
		
	} // leaveRoom

	// Get Players in ACTIVE room
	// HeartBeat data in current room
	public static function getPlayerNames( ):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();

		//return CurrentRoomPlayerNames;

		return retval;
	} // playerNames in currentroom (heartbeat data)

	// HeartBeat data on current room
	public static function getPlayerIDs( ):Array<Dynamic>{
		//return CurrentRoomPlayerIDs;
		return new Array<Dynamic>();
	} // playerIDs in currentroom (heartbeat data)

	public static function getSeat():Float{
		return Seat;
	}
	public static function getBeat():Float{
		return Heart;
	}
	public static function getForce():Float{
		return TurnTime;
	}
	public static function getHeart():String{
		return ""+HeartDate;
	}


	public static function getErrors():Array<Dynamic>{
		return errorList;
	}
	public static function getPlayerID():Float{
		return PlayerID;
	}
	public static function getPlayerName():String{
		return PlayerName;
	}

	public static function getInfo(PorR:String, IDorName:String):String{
		var retval="";
		if(PorR == "PLAYER" && IDorName == "ID") retval=""+PlayerID;
		if(PorR == "PLAYER" && IDorName == "NAME") retval=""+PlayerName;
		if(PorR == "ROOM" && IDorName == "ID") retval=""+RoomID;
		if(PorR == "ROOM" && IDorName == "NAME") retval=""+RoomName;
		return retval;
	}

	public static function getSFB(What:String):Float{
		var retval:Float=-1;
		if(What == "SEAT") retval=getSeat();
		if(What == "FORCE") retval=getForce();
		if(What == "BEAT") retval=getBeat();
		return retval;
	}


        
        
} // class
//
// EOF file
//
