#if js
	import js.Browser;
	import js.html.*;
#end

import com.stencyl.Engine;
import flash.display.*;
import StringTools;
import com.stencyl.behavior.Script;
import com.stencyl.utils.Utils;

class WEBCAM{
        private static var WSIZE=10;
        private static var HSIZE=10;
	private static var gridsize=40;
	private static var script:Script;
	public static var isWEBCAMinit:Bool=false;
#if js
	private static var WEBCAMcanvas:js.html.CanvasElement;
	private static var WEBCAMctx:js.html.CanvasRenderingContext2D;
 	private static var WEBCAMcontent:js.html.Element;
#end
    public static function getWEBCAMData(_name:String, _property:String):String{
                var retval:String="";
		if(isWEBCAMinit){
#if js
	
                        var sretval=""+js.Lib.eval("if(document.getElementById('WEBCAMdata1') != null)document.getElementById('WEBCAMdata1').value;");
			if(sretval.length > 30) retval=""+sretval;
#end
		//console("Value: "+retval);	
		}
                return ""+retval;
        } //getWEBCAMData


 	public static function WEBCAMinit(){
		isWEBCAMinit=true;
#if js
		WEBCAMcanvas	= cast(js.Browser.document.getElementsByTagName("canvas").item(0),js.html.CanvasElement);
 		WEBCAMctx     = cast(WEBCAMcanvas.getContext2d(), js.html.CanvasRenderingContext2D) ;
		WEBCAMcontent = js.Browser.document.getElementById("openfl-content");

		script=new Script();

		// Create WEBCAMdata1 input element for communication to HaXe
		native(" var WEBCAMdata1=document.createElement('input'); WEBCAMdata1.id='WEBCAMdata1'; WEBCAMdata1.style.position='absolute'; WEBCAMdata1.style.top='681px'; WEBCAMdata1.style.left='1px'; WEBCAMdata1.style.width='930px'; WEBCAMdata1.style.height='32px'; WEBCAMdata1.style.visibility='hidden'; document.body.appendChild(WEBCAMdata1);");

#end
		console("INIT Called");

	} // init

	public static function native(code:String){
#if js
		js.Lib.eval(""+code);
#end
	}

	public static function console(text:String){
trace("Text: "+text);
		native("console.log('"+text+"');");
	}

	public static function webstreamdata(_x:Float, _y:Float, _width:Float, _height:Float,  _name:String,_toBlocks:Bool=false){
		if(!isWEBCAMinit)WEBCAMinit();
		//gridsize=4;
		gridsize=10;
		//SIZE=Std.parseInt(""+(_width/gridsize));
		//WSIZE=40;
		//HSIZE=30;
		WSIZE=16;
		HSIZE=12;
		
#if js
		var toBlocks:Bool=true;
		native("
			document.getElementById('WEBCAMdata1').value=''; // reset error/retval
			var divfl=document.getElementById('openfl-content');

			// capture canvas (stream) image : Hide?
			var webcamCanvas=document.createElement('canvas'); webcamCanvas.id='webcamCanvas'; 
			webcamCanvas.style.position='absolute'; webcamCanvas.style.top='64px'; webcamCanvas.style.left='381px'; webcamCanvas.style.width='"+_width+"px'; webcamCanvas.style.height='"+_height+"';  
			webcamCanvas.style.visiblity='hidden';
			webcamCanvas.style.opacity = '0'
			webcamCanvas.style.transform=' scaleX(-1)';  // flip horizontal
			document.body.appendChild(webcamCanvas); 
			//var ctx1=div1.getContext('2d');

			var children = document.getElementById('openfl-content').childNodes;
			// loop through children .. check children[i].nodeName.toUpperCase().indexOf('CANVAS') > -1  and set canvas=children[i];
			//var canvas=div1;
		        //var context = canvas.getContext('2d');

			var video=document.createElement('video'); 
			video.id='"+_name+"';
			video.style.transform=' scaleX(-1)'
			video.style.position='absolute';
video.addEventListener('click', function(event) { 

var cv = document.getElementsByTagName('canvas').item(0);
//cv.style.width='1024px';
// This Works:
/*
var x=event.clientX;
var y=event.clientY;

var ev = new MouseEvent('mousedown', { 'clientX': x, 'clientY': y }); 
cv.dispatchEvent(ev);
ev = new MouseEvent('mouseup', { 'clientX': x, 'clientY': y }); 
cv.dispatchEvent(ev);
*/
var x=event.clientX;
var y=event.clientY;

var ev = new MouseEvent('mousedown', { 'clientX': x, 'clientY': y }); 
cv.dispatchEvent(ev);
ev = new MouseEvent('mouseup', { 'clientX': x, 'clientY': y }); 
cv.dispatchEvent(ev);

}); // addEventListener
			video.style.width='"+_width+"px'; video.style.height='"+_height+"px'; video.style.left='"+_x+"px'; video.style.top='"+_y+"px';
			video.autoplay=false;
			//video.style.visibility='hidden';
			video.style.backgroundColor='#99aaff';
//			document.body.appendChild(video);
document.body.insertBefore(video, document.body.firstChild);

  			var videoObj = { video: true };
			var errBack = function(error) {
				document.getElementById('WEBCAMdata1').value='-1';
                		console.log('Video capture error: ', error.code); 
            		};
  			if(navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
                			navigator.mediaDevices.getUserMedia(videoObj).then(function(stream) {
                    			video.src = window.URL.createObjectURL(stream);
                    			video.play();
                		});
            		}
            		else if(navigator.getUserMedia) { // Standard
                                navigator.getUserMedia(videoObj, function(stream) {
                                        video.src = stream;
                                        video.play();
                                }, errBack);
                        } else if(navigator.webkitGetUserMedia) { // WebKit-prefixed
                                navigator.webkitGetUserMedia(videoObj, function(stream){
                                        video.src = window.webkitURL.createObjectURL(stream);
                                        video.play();
                                }, errBack);
                        } else if(navigator.mozGetUserMedia) { // Mozilla-prefixed
                                navigator.mozGetUserMedia(videoObj, function(stream){
                                        video.src = window.URL.createObjectURL(stream);
                                        video.play();
                                }, errBack);
                        } // which navigator
		");
		native("
			if("+toBlocks+"){
				setTimeout(function timert(){
					var width="+_width+";
					var height="+_height+";
					var bits=4; // color bytes (r,g,b,alpha)
					var gridsize="+gridsize+";
					var WEBCAMcanvas=document.getElementById('webcamCanvas');
					var context=WEBCAMcanvas.getContext('2d');
					context.drawImage(document.getElementById('"+_name+"'), 0,0,width,height);
// flip horizontal = flickering
//context.translate(width,0);
//context.scale(-1,1);

					var imgData=context.getImageData(0,0,width,height);
					var pixels  = imgData.data;
					var allpixs='';
					var grid=[];
					var gridcounter=0;
					var i=0;
//console.log('pixels.length : '+pixels.length+' should be 19200*4 = 76800');
					while (i < pixels.length) {
						// Black White instead of grayscale < 64
						var grayscale=(pixels[i] * .3 + pixels[i+1] * .59 + pixels[i+2] * .11)<64?0:254; 
						// Black White instead of grayscale
						var grayscale2=(pixels[i] * .3 + pixels[i+1] * .59 + pixels[i+2] * .11)<64?0:254; 

/*
for(k=0; k < gridsize; k++){
pixels[i+(k*gridsize*(width*bits))]=pixels[i+(k*gridsize*(width*bits))]*.3;
pixels[i+(k*gridsize*(width*bits))+1]=pixels[i+(k*gridsize*(width*bits))+1]*.59;
pixels[i+(k*gridsize*(width*bits))+2]=pixels[i+(k*gridsize*(width*bits))+2]*.11;
}
*/
						var ccounter=0;
						for(var j=0; j < gridsize*(gridsize*bits) && (i+j) < pixels.length ; j+=(gridsize*bits)){
							for(var k=0; k < gridsize*bits && i+k+j < pixels.length; k=k+bits){
								if(grayscale == grayscale2){
									ccounter++;		
								}
        							grayscale2 = (pixels[i+k+j] * .3 + pixels[i+k+j+1] * .59 + pixels[i+k+j+2] * .11) < 64 ?0:254;
							}
						}//for j
						grid[gridcounter++]=ccounter>(gridsize*gridsize)/2 && grayscale > 0 ? '_' : 'X';

						//if(i%(width*bits) == (width*bits)-bits){
						//if(i%(width*bits) > ((width-gridsize)*bits)){
						if(i%(width*bits) == 0){
							//i=i+(gridsize*width*bits);		//skip one gridsize-row
							//i=i+((gridsize*width)*bits);		//skip one gridsize-row
							//i=i+(gridsize*(width*bits));		//skip one gridsize-row
							//i=i+((width/gridsize)*bits);		//skip one gridsize-row
							i=i+((gridsize*width)*bits);		//skip one gridsize-row
						} // if rest of line = end of line§
						
						i=i+(gridsize*bits); // colorbits;
					}//for all pixels

//TURN OFF ON Final Version
					// SHOW BLOCKS ?!?
					context.putImageData(imgData,0,0);
					var data = WEBCAMcanvas.toDataURL('image/png');
/*
     var img=document.getElementById('img2');
	var cnv=document.createElement('WEBCAMcanvas');
	cnv.width=img.width;
	cnv.height=img.height;
	var WEBCAMctx=cnv.getContext('2d');
	WEBCAMctx.drawImage(img,0,0);
	var imgdata=cnv.toDataURL('image/png' );
	img.src=imgdata;
*/
	
					// Set return data
					//document.getElementById('WEBCAMdata1').value=''+grid;
var rt='';
var ag=0;
var XCounter=0;
while(ag < grid.length){
	rt=rt+grid[ag];
	if(grid[ag]=='X')XCounter++;
	ag++;
}
if(XCounter > grid.length - 10)rt='';
//console.log('GridLength: '+grid.length+'  rt length : '+rt.length);
					document.getElementById('WEBCAMdata1').value=''+rt;

					// Call time function again to do it all over
					setTimeout(function(){timert();},100); 
				},2000); //setTimeOut initially 5 seconds  the repeat is above!!
			} // if Blocks
		"); // native

#end
	} // streamData


	public static function WebCamgetBitmapData():BitmapData{
		var bmp:BitmapData=new BitmapData(0,0);
#if js
		return bmp;
/*
		var _name='webcamCanvas';	
		var _property='toDataURL("image/png")';
		var code:String="var el=document.getElementById('"+_name+"');if(el != null)el.toDataURL('image/png');";
		var str:String=""+js.Lib.eval(code);
*/
		//var grid:Array<String>=getWEBCAMData('WEBCAMdata1','value').split(',');
		var grid:Array<String>=getWEBCAMData('WEBCAMdata1','value').split(',');

//com.stencyl.behavior.Script.setGameAttribute("Debug", ""+str);
//bmp = BitmapData.fromBase64 (str, "image/png");

var gridw=160;
bmp=new flash.display.BitmapData(gridw,gridw);
bmp.fillRect(new flash.geom.Rectangle(0,0,160,160), 0);
/*
var gridcounter=0;
var bj=0;
while(bj < gridw){
	var bi=0;
	while(bi < gridw){
		var g=grid[gridcounter++];
		if(Std.parseInt(""+g) < 1){
	 		//bmp.setPixel(bi,bj,16000);
			bmp.fillRect(new flash.geom.Rectangle(bi*10,bj*10,10,10), 316000);

		} //if grid
		bi++;
	} //bi
	bj++;
} // bj
*/
#end
		return bmp;
	}//getBitmapdata

	public static function WebCamgetImage(){
#if js
///com.stencyl.behavior.Script.setGameAttribute("Debug", "Hi");
		//com.stencyl.behavior.Script.setGameAttribute("IMG", captureScreenshot());
		//com.stencyl.behavior.Script.setGameAttribute("IMGINS", new BitmapWrapper(new Bitmap((getGameAttribute("IMG")))));
		
js.Lib.eval(" var img2=document.createElement('img'); img2.id='img2'; img2.style.position='absolute'; img2.style.top='1px'; img2.style.left='1px'; img2.style.width='230px'; img2.style.height='232px'; document.body.appendChild(img2);img2.src='assets/data/abc.png';img2.style.backgroundColor='#15ee0a';");

var img2=cast(js.Browser.document.getElementById('img2'),js.html.ImageElement);
var b:flash.display.BitmapData=new flash.display.BitmapData(250,250);
for(bj in 0 ... 200){
	for(bi in 0 ... 200){
	 b.setPixel(bi,bj,(bi+bj)*3);
	}
}
//cast(getGameAttribute("IMGINS"), BitmapDataWrapper).
//com.stencyl.behavior.Script.setGameAttribute("IMGINS", new BitmapWrapper(new Bitmap(b)));
com.stencyl.behavior.Script.setGameAttribute("Debug", "img2: "+img2);
var isrc=img2.src;

js.Lib.eval("
     var img=document.getElementById('img2');
	var cnv=document.createElement('WEBCAMcanvas');
	cnv.width=img.width;
	cnv.height=img.height;
	var WEBCAMctx=cnv.getContext('2d');
	WEBCAMctx.drawImage(img,0,0);
	var dataURL=cnv.toDataURL('image/png' );
	document.getElementById('WEBCAMdata1').value=dataURL;
	");


#end
	} //getImage

        public static function disp(str:String){
                var lines=new Array<String>();
                for(i in 0 ... WSIZE){
                        var line=str.substring(i*WSIZE, (i*WSIZE)+WSIZE);
//console(line);
                } // for size
        } //disp

	// difference between two frames
        public static function diff1(str1:String,str2:String):String{
		var retval:String="";
if(str1 == str2) return ""; 
		for(i in 0 ... str1.length){
			if(str1.charAt(i) != str2.charAt(i)){
				retval=retval+"X";
			}else{
				retval=retval+"_";
			}
		}
		return ""+retval;
	}// diff1

        public static function diff(str1:String,str2:String):Float{
		var retval:Float=-1;
                var lines1=new Array<String>();
                var lines2=new Array<String>();
if(str1 == str2) return -1; 
                for(i in 0 ... HSIZE){
                        var line=str1.substring(i*WSIZE, (i*WSIZE)+WSIZE);
                        lines1.push(""+line);
                        line=str2.substring(i*WSIZE, (i*WSIZE)+WSIZE);
                        lines2.push(""+line);
                }
                var maxcounter=0;
                var startdiff=0;
                var linec=0;
                while(linec < HSIZE){
                        var L1=lines1[linec];
                        var L2=lines2[linec];
                        var counter=0;
                        for(i in 0 ... WSIZE){
                                var a=L1.substr(i,1);
                                var b=L2.substr(i,1);
                                if(a!=b){
                                        counter++;
                                        var checkc=0;
                                        var linecc=linec;
                                        var diff_found=true;
                                        while(linecc < HSIZE && diff_found){
                                                // column
                                                diff_found=false;
                                                while(i+checkc < WSIZE &&
lines1[linecc].substr(i+checkc,1) !=
lines2[linecc].substr(i+checkc,1)){
                                                        checkc++;
                                                        diff_found=true;
                                                        counter++;
                                                }
                                                checkc=0;
                                                linecc++;
                                        }
                                        if(counter > maxcounter){
                                                startdiff=(linec*WSIZE)+i;
                                                maxcounter=counter;
                                        }
                                }// search more diffences
                        }
                        linec++;
                }
		if(maxcounter > 10){	
                	retval=Std.parseFloat(""+startdiff);
		}else{
			retval=-1;
		}
//console("Line : "+str1);
//console("Line : "+str2.substr(0, startdiff)+"X"+str2.substr(startdiff+1, str2.length));

//com.stencyl.behavior.Script.setGameAttribute("Debug", "MaxCounter: "+maxcounter+" startdiff: "+startdiff);
		
		return retval;
        } // diff



    public static function difftest() {
        var p:Int = 5000;
        var str1:String =
"AAAAAAAAAABBBBBBBBBBCCCCCCCCCCDDDDDDDDDDEEEEEEEEEEFFFFFFFFFFGGGGGGGGGHHHHHHHHHHIIIIIIIIIIJJJJJJJJJJKKKKKKKKKKLLLLLLLLLL";
        var str2:String =
"AAAAAAAAAABBBBBBBBBBCCCCCCCCCCDDDDDDDDDDEEEEExEEEEFFFFFFFFFFGGGGxxGGGHHHHHHHHHHIIxxxIIIIIJJJJJJJJJJKKKKKKKxxKLLLLLLLxxx";
disp(str1);
trace("==========");
disp(str2);
trace("==========");
        diff(str1,str2);


    }

	public static function reverse7( str :String ) : String{
		var b = "";
		var j = 0;
		for ( i in 0...str.length ) {
				b = str.charAt(i) + b;
		}
		return b;
	} //reverse7


	public static function reverse(s:String):String{
		return reverse7(s);
	}

} // WEBCAM

