import openfl.display3D.*;
import openfl.display.*;

import com.stencyl.Engine;
import com.stencyl.behavior.*;
import com.stencyl.behavior.Script.*;
import com.stencyl.models.*;
import com.stencyl.graphics.*;

import openfl.events.Event;
import org.zamedev.particles.*;
import org.zamedev.particles.loaders.ParticleLoader;
import org.zamedev.particles.renderers.DefaultParticleRenderer;

class Zame extends Sprite{

	public static var engine:com.stencyl.Engine;  // passed in by the extension block 
	
	// Private Variables
	private static var isInit:Bool=false;
	private static var Particles:Map<String,Dynamic>=new Map<String,Dynamic>();
	private static var theCanvas:Sprite=new Sprite();
	private static var renderer:Dynamic = 	null;
	
	private static function init(){
		isInit=true;
		if(engine == null || engine.colorLayer == null){
			isInit=false;
			return;
		}
		// Hide the colorLayer to show the stuff (Without this it will run ' behind ' stencyl
		engine.colorLayer.alpha=0; // Make the color layer transparent even if you have a color set!
		
		Particles=new Map<String,Dynamic>();
		theCanvas=new Sprite();
		
		renderer=DefaultParticleRenderer.createInstance();
		theCanvas.addChild(cast renderer);
		engine.root.stage.addChild(theCanvas);
		//  Optional
		//	engine.getGameAttribute("Actor").addChild(theCanvas); // You can add canvas to an actor 
		//

	}
	
	// -------------------------
	// BLOCKS
	// -------------------------
	
	public static function createParticle(ParticleName:String){
		
		if(!isInit)init();
		
       
       	var ps = new ParticleSystem().__initialize() ;
	  
		renderer.addParticleSystem(ps);
		
		Particles.set(""+ParticleName, ps);
		
	}  // createParti

	// loadParticle
	public static function loadParticle(ParticleName:String, FileName:String){
		
		if(!isInit)init();
      
        var ps = ParticleLoader.load(FileName);
	  
		renderer.addParticleSystem(ps);
		
		Particles.set(""+ParticleName, ps);
		
	} // loadParticle
	public static function getParticle(ParticleName:String):Dynamic{
		
		var retval:Dynamic = Particles.get(""+ParticleName);
		var isNull:Bool=false;
		if(retval == null){
			isNull = true;
		}
		return retval;
	}
	
	
	public static function setImageProperty(ParticleName:String, PropertyValue:BitmapData){
	  	if(!isInit)init();

		var ps = Particles.get(""+ParticleName);

		renderer.removeParticleSystem(ps);
		
		var bmp:BitmapData=new BitmapData(1,1);
		
		if(PropertyValue != null)bmp=PropertyValue;
		
		if(ps == null){
			ps = new ParticleSystem().__initialize() ;
		}
		ps.textureBitmapData = bmp;
		
		renderer.addParticleSystem(ps);
		Particles.set(""+ParticleName, ps);
    } // bitMap

	public static function setNumberProperty(ParticleName:String, PropertyName:String, PropertyValue:Float){
		if(!isInit)init();
		var propname:String = StringTools.trim(PropertyName).toUpperCase();
		var propvalue:Float = Std.parseFloat(""+PropertyValue);
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return;
		if(propname == "DURATION") ps.duration=propvalue;
	    if(propname == "PARTICLELIFESPAN") ps.particleLifespan=propvalue;
		if(propname == "PARTICLELIFESPANVARIANCE") ps.particleLifespanVariance = propvalue;
		if(propname == "SPEED") ps.speed = propvalue;
		if(propname == "SPEEDVARIANCE") ps.speedVariance  = propvalue;
		if(propname == "ANGLE") ps.angle = propvalue;
		if(propname == "ANGLEVARIANCE") ps.angleVariance  = propvalue;
		if(propname == "STARTPARTICLESIZE") ps.startParticleSize  = propvalue;
		if(propname == "STARTPARTICLESIZEVARIANCE") ps.startParticleSizeVariance  = propvalue;
		if(propname == "FINISHPARTICLESIZE") ps.finishParticleSize  = propvalue;
		if(propname == "FINISHPARTICLESIZEVARIANCE") ps.finishParticleSizeVariance  = propvalue;
		if(propname == "MINRADIUS") ps.minRadius  = propvalue;
		if(propname == "MINRADIUSVARIANCE") ps.minRadiusVariance = propvalue;
		if(propname == "MAXRADIUS") ps.maxRadius  = propvalue;
		if(propname == "MAXRADIUSVARIANCE") ps.maxRadiusVariance  = propvalue;
		if(propname == "ROTATIONSTART") ps.rotationStart  = propvalue;
		if(propname == "ROTATIONSTARTVARIANCE") ps.rotationStartVariance = propvalue;
		if(propname == "ROTATIONEND") ps.rotationEnd = propvalue;
		if(propname == "ROTATIONENDVARIANCE") ps.rotationEndVariance  = propvalue;
		if(propname == "RADIALACCELERATION") ps.radialAcceleration  = propvalue;
		if(propname == "RADIALACCELARTIONVARIANCE") ps.radialAccelerationVariance = propvalue;
		if(propname == "TANGENTIALACCELERATION") ps.tangentialAcceleration  = propvalue;
		if(propname == "TANGENTIALACCELERATIONVARIANCE") ps.tangentialAccelerationVariance  = propvalue;
		if(propname == "ROTATEPERSECOND") ps.rotatePerSecond  = propvalue;
		if(propname == "ROTATEPERSECONDVARIANCE") ps.rotatePerSecondVariance = propvalue;
		if(propname == "PARTICLESCALEX") ps.particleScaleX  = propvalue;
		if(propname == "PARTICLESCALEY") ps.particleScaleY  = propvalue;
		if(propname == "PARTICLESCALESIZE") ps.particleScaleSize  = propvalue;
		if(propname == "YCOORDMULTIPLIER") ps.yCoordMultiplier  = propvalue;
		if(propname == "EMISSIONFREQ") ps.emissionFreq  = propvalue;
	  
	  
	}// numberproperty
	
	public static function getNumberProperty(ParticleName:String, PropertyName:String):Float{
		if(!isInit)init();
		
		var propname:String = StringTools.trim(PropertyName).toUpperCase();
	
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return -1;
		if(propname == "DURATION") return ps.duration;
	    if(propname == "PARTICLELIFESPAN") return ps.particleLifespan;
		if(propname == "PARTICLELIFESPANVARIANCE") return ps.particleLifespanVariance;
		if(propname == "SPEED") return ps.speed;
		if(propname == "SPEEDVARIANCE")return  ps.speedVariance;
		if(propname == "ANGLE") return ps.angle;
		if(propname == "ANGLEVARIANCE")return  ps.angleVariance;
		if(propname == "STARTPARTICLESIZE")return  ps.startParticleSize;
		if(propname == "STARTPARTICLESIZEVARIANCE")return  ps.startParticleSizeVariance;
		if(propname == "FINISHPARTICLESIZE") return ps.finishParticleSize;
		if(propname == "FINISHPARTICLESIZEVARIANCE")return  ps.finishParticleSizeVariance  ;
		if(propname == "MINRADIUS") return ps.minRadius  ;
		if(propname == "MINRADIUSVARIANCE")return  ps.minRadiusVariance ;
		if(propname == "MAXRADIUS")return  ps.maxRadius ;
		if(propname == "MAXRADIUSVARIANCE")return  ps.maxRadiusVariance ;
		if(propname == "ROTATIONSTART")return  ps.rotationStart ;
		if(propname == "ROTATIONSTARTVARIANCE")return  ps.rotationStartVariance;
		if(propname == "ROTATIONEND")return  ps.rotationEnd ;
		if(propname == "ROTATIONENDVARIANCE")return  ps.rotationEndVariance;
		if(propname == "RADIALACCELERATION")return  ps.radialAcceleration;
		if(propname == "RADIALACCELARTIONVARIANCE")return  ps.radialAccelerationVariance;
		if(propname == "TANGENTIALACCELERATION")return  ps.tangentialAcceleration ;
		if(propname == "TANGENTIALACCELERATIONVARIANCE")return  ps.tangentialAccelerationVariance;
		if(propname == "ROTATEPERSECOND")return  ps.rotatePerSecond ;
		if(propname == "ROTATEPERSECONDVARIANCE")return  ps.rotatePerSecondVariance ;
		if(propname == "PARTICLESCALEX")return  ps.particleScaleX ;
		if(propname == "PARTICLESCALEY")return  ps.particleScaleY ;
		if(propname == "PARTICLESCALESIZE")return  ps.particleScaleSize;
		if(propname == "YCOORDMULTIPLIER")return  ps.yCoordMultiplier ;
		if(propname == "EMISSIONFREQ")return  ps.emissionFreq  ;
		return 0;
	  
	  
	}// getnumberproperty
	
	public static function setIntProperty(ParticleName:String, PropertyName:String, PropertyValue:Float){
		var intval:Int=Std.parseInt(""+PropertyValue);
	    var propname:String = StringTools.trim(PropertyName).toUpperCase();
		var propvalue:Float = Std.parseFloat(""+PropertyValue);
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return;
		
		if(propname == "EMITTERTYPE") ps.emitterType  = intval;
		if(propname == "MAXPARTICLES") ps.maxParticles  = intval;
		if(propname == "POSITIONTYPE") ps.positionType  = intval;
		if(propname == "BLENDFUNCSOURCE") ps.blendFuncSource  = intval;
		if(propname == "BLENDFUNCDESTINATION") ps.blendFuncDestination  = intval;
	
	
	}// setIntProperty
	
	public static function getIntProperty(ParticleName:String, PropertyName:String):Float{
		var intval:Int=0;
	    var propname:String = StringTools.trim(PropertyName).toUpperCase();
		
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return 0;
		
		if(propname == "EMITTERTYPE") intval=ps.emitterType ;
		if(propname == "MAXPARTICLES")intval= ps.maxParticles ;
		if(propname == "POSITIONTYPE") intval=ps.positionType ;
		if(propname == "BLENDFUNCSOURCE") intval=ps.blendFuncSource ;
		if(propname == "BLENDFUNCDESTINATION") intval=ps.blendFuncDestination  ;
		
		return Std.parseFloat(""+intval);
	
	}// getIntProperty
	
	public static function setBoolProperty(ParticleName:String, PropertyName:String, PropertyValue:Bool){
		var propname:String = StringTools.trim(PropertyName).toUpperCase();
		var propvalue:Bool =PropertyValue;
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return;
		
		if(propname == "ACTIVE") ps.active  = propvalue;
		if(propname == "RESTART") ps.restart  = propvalue;
		if(propname == "FORCESQUARETEXTURE") ps.forceSquareTexture  = propvalue;
	

	} //setBool
	
	
	public static function getBoolProperty(ParticleName:String, PropertyName:String):Bool{
		var retval:Bool=false;
		var propname:String = StringTools.trim(PropertyName).toUpperCase();
		
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return false;
		
		if(propname == "ACTIVE") retval = ps.active  ;
		if(propname == "RESTART") retval = ps.restart;
		if(propname == "FORCESQUARETEXTURE") retval = ps.forceSquareTexture ;
	
		return retval;
	} //getBool
	
	public static function setVectorProperty(ParticleName:String, PropertyName:String, X:Float, Y:Float){
	    var propname:String = StringTools.trim(PropertyName).toUpperCase();
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return;
	
		if(propname == "GRAVITY"){ ps.gravity.x = X;ps.gravity.y = Y; }
		if(propname == "SOURCEPOSITION"){ ps.sourcePosition.x = X;ps.sourcePosition.y = Y; }
		if(propname == "SOURCEPOSITIONVARIANCE"){ ps.sourcePositionVariance.x = X;ps.sourcePositionVariance.y = Y; }
	
	}
	
	// Color does not work on HTML5 and native
	public static function setColorProperty(ParticleName:String, PropertyName:String, PropertyValue:Dynamic){
	    var propname:String = StringTools.trim(PropertyName).toUpperCase();
		var ps = Particles.get(""+ParticleName);
		if(ps == null) return;
	
		var theColor:Int=cast(PropertyValue, Int);
		var red:Int=com.stencyl.utils.Utils.getRed(theColor);	
		var green:Int=com.stencyl.utils.Utils.getGreen(theColor);	
		var blue:Int=com.stencyl.utils.Utils.getBlue(theColor);	
	
		
		if(propname == "STARTCOLOR"){
			ps.startColor.r  = Std.parseFloat(""+red);
			ps.startColor.g  = Std.parseFloat(""+green);
			ps.startColor.b  = Std.parseFloat(""+blue);
			ps.startColor.a = 1.0;

		}
		if(propname == "FINISHCOLOR"){
			ps.finishColor.r  = Std.parseFloat(""+red);
			ps.finishColor.g  = Std.parseFloat(""+green);
			ps.finishColor.b  = Std.parseFloat(""+blue);
			ps.finishColor.a = 1.0;

		}
		if(propname == "STARTCOLORVARIANCE"){
			ps.startColorVariance.r  = Std.parseFloat(""+red);
			ps.startColorVariance.g  = Std.parseFloat(""+green);
			ps.startColorVariance.b  = Std.parseFloat(""+blue);
			ps.startColorVariance.a = 1.0;
		}
		if(propname == "FINISHCOLORVARIANCE"){
			ps.finishColorVariance.r  = Std.parseFloat(""+red);
			ps.finishColorVariance.g  = Std.parseFloat(""+green);
			ps.finishColorVariance.b  = Std.parseFloat(""+blue);
			ps.finishColorVariance.a  = 1.0;


		
		}
	
		
		
	} // setColorProtery

	
	
	
	
	// emit = position 
	public static function launchParticle(ParticleName:String, X:Float, Y:Float){
		var ps=Particles.get(""+ParticleName);
		if(ps != null){
			ps.emit(Std.parseInt(""+X), Std.parseInt(""+Y));
		}
	}// emit
	
	public static function setPosition(ParticleName:String, X:Float, Y:Float){
		var ps=Particles.get(""+ParticleName);
		if(ps != null){
			ps.sourcePosition.x=Std.parseInt(""+X);
			ps.sourcePosition.y=Std.parseInt(""+Y);
			
		}
	}// set pos
	
	public static function removeParticle(ParticleName:String){
		var ps=Particles.get(""+ParticleName);
		if(ps == null){
			return;
		}
		renderer.removeParticleSystem(ps);
		Particles.set(""+ParticleName, null);
		
	} // removeParticle
	
	//obsolete?
	public static function reset(ParticleName:String){
		if(!isInit)init();
		var ps=Particles.get(""+ParticleName);
		if(ps != null){
			ps.reset();
			renderer.removeParticleSystem(ps);
			Particles.set(""+ParticleName, null);
		}else{
			trace(" PS "+ParticleName+"  is NULL!");
		}
	}
	public static function exit(){
		isInit=false;
		engine.root.stage.removeChild(theCanvas);
		engine.colorLayer.alpha=1; // reset color layer
	} // exit
	
	
	public static function update(ParticleName:String){
		var ps=Particles.get(""+ParticleName);
		if(ps != null){
			ps.__update();
		}
	}//pudate
} // Zame


