// Generated by Haxe 4.0.0-rc.2+77068e1
(function () { "use strict";
class Config {
	static convertStringToMap(options) {
		var map = new haxe_ds_StringMap();
		var colonString = options.substring(1,options.length - 1);
		var colons = colonString.split(",");
		var _g = 0;
		while(_g < colons.length) {
			var colon = colons[_g];
			++_g;
			var prop = colon.split(":");
			var propertyName = StringTools.trim(prop[0]);
			var propertyValue = StringTools.trim(prop[1]);
			if(__map_reserved[propertyName] != null) {
				map.setReserved(propertyName,propertyValue);
			} else {
				map.h[propertyName] = propertyValue;
			}
		}
		return map;
	}
}
Config.__name__ = true;
class HxOverrides {
	static cca(s,index) {
		var x = s.charCodeAt(index);
		if(x != x) {
			return undefined;
		}
		return x;
	}
	static substr(s,pos,len) {
		if(len == null) {
			len = s.length;
		} else if(len < 0) {
			if(pos == 0) {
				len = s.length + len;
			} else {
				return "";
			}
		}
		return s.substr(pos,len);
	}
	static remove(a,obj) {
		var i = a.indexOf(obj);
		if(i == -1) {
			return false;
		}
		a.splice(i,1);
		return true;
	}
	static iter(a) {
		return { cur : 0, arr : a, hasNext : function() {
			return this.cur < this.arr.length;
		}, next : function() {
			return this.arr[this.cur++];
		}};
	}
}
HxOverrides.__name__ = true;
class Lambda {
	static indexOf(it,v) {
		var i = 0;
		var v2 = $getIterator(it);
		while(v2.hasNext()) {
			var v21 = v2.next();
			if(v == v21) {
				return i;
			}
			++i;
		}
		return -1;
	}
}
Lambda.__name__ = true;
class MainServer {
	static main() {
		var gameServer = new colyseus_server_Server({ server : js_node_Http.createServer()});
		gameServer.register("chat",server_rooms_ChatRoom);
		gameServer.register("chat_with_options",server_rooms_ChatRoom,{ custom_options : "you can use me on Room#onInit"});
		gameServer.register("state_handler",server_rooms_StateHandlerRoom);
		gameServer.register("lobby",server_rooms_Lobby);
		gameServer.register("raw",server_rooms_Raw);
		gameServer.register("turn",server_rooms_Turn);
		gameServer.register("lock",server_rooms_Lock);
		gameServer.register("auth",server_rooms_AuthRoom);
		gameServer.register("create_or_join",server_rooms_CreateOrJoinRoom);
		gameServer.onShutdown(function() {
			haxe_Log.trace("game server is going down.",{ fileName : "src/MainServer.hx", lineNumber : 37, className : "MainServer", methodName : "main"});
			return null;
		});
		gameServer.listen(3567);
		haxe_Log.trace("-- listening on 0.0.0.0:" + 3567 + "... --",{ fileName : "src/MainServer.hx", lineNumber : 43, className : "MainServer", methodName : "main"});
	}
}
MainServer.__name__ = true;
Math.__name__ = true;
class Std {
	static string(s) {
		return js_Boot.__string_rec(s,"");
	}
	static parseInt(x) {
		var v = parseInt(x, x && x[0]=="0" && (x[1]=="x" || x[1]=="X") ? 16 : 10);
		if(isNaN(v)) {
			return null;
		}
		return v;
	}
}
Std.__name__ = true;
class StringTools {
	static isSpace(s,pos) {
		var c = HxOverrides.cca(s,pos);
		if(!(c > 8 && c < 14)) {
			return c == 32;
		} else {
			return true;
		}
	}
	static ltrim(s) {
		var l = s.length;
		var r = 0;
		while(r < l && StringTools.isSpace(s,r)) ++r;
		if(r > 0) {
			return HxOverrides.substr(s,r,l - r);
		} else {
			return s;
		}
	}
	static rtrim(s) {
		var l = s.length;
		var r = 0;
		while(r < l && StringTools.isSpace(s,l - r - 1)) ++r;
		if(r > 0) {
			return HxOverrides.substr(s,0,l - r);
		} else {
			return s;
		}
	}
	static trim(s) {
		return StringTools.ltrim(StringTools.rtrim(s));
	}
}
StringTools.__name__ = true;
var colyseus_server_Room = require("colyseus").Room;
var colyseus_server_Server = require("colyseus").Server;
var colyseus_server_schema_Schema = require("@colyseus/schema").Schema;
var colyseus_server_schema_MapSchema = require("@colyseus/schema").MapSchema;
class colyseus_server_schema_MapSchemaUtil {
	static get(m,k) {
		return m[k];
	}
	static set(m,k,v) {
		m[k] = v;
	}
	static delete(m,k) {
		return delete m[k];
	}
}
colyseus_server_schema_MapSchemaUtil.__name__ = true;
var colyseus_server_schema_ExternDecorator = require("@colyseus/schema");
class haxe_Log {
	static formatOutput(v,infos) {
		var str = Std.string(v);
		if(infos == null) {
			return str;
		}
		var pstr = infos.fileName + ":" + infos.lineNumber;
		if(infos != null && infos.customParams != null) {
			var _g = 0;
			var _g1 = infos.customParams;
			while(_g < _g1.length) {
				var v1 = _g1[_g];
				++_g;
				str += ", " + Std.string(v1);
			}
		}
		return pstr + ": " + str;
	}
	static trace(v,infos) {
		var str = haxe_Log.formatOutput(v,infos);
		if(typeof(console) != "undefined" && console.log != null) {
			console.log(str);
		}
	}
}
haxe_Log.__name__ = true;
class haxe_ds__$StringMap_StringMapIterator {
	constructor(map,keys) {
		this.map = map;
		this.keys = keys;
		this.index = 0;
		this.count = keys.length;
	}
	hasNext() {
		return this.index < this.count;
	}
	next() {
		var _this = this.map;
		var key = this.keys[this.index++];
		if(__map_reserved[key] != null) {
			return _this.getReserved(key);
		} else {
			return _this.h[key];
		}
	}
}
haxe_ds__$StringMap_StringMapIterator.__name__ = true;
class haxe_ds_StringMap {
	constructor() {
		this.h = { };
	}
	setReserved(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	getReserved(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	existsReserved(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	remove(key) {
		if(__map_reserved[key] != null) {
			key = "$" + key;
			if(this.rh == null || !this.rh.hasOwnProperty(key)) {
				return false;
			}
			delete(this.rh[key]);
			return true;
		} else {
			if(!this.h.hasOwnProperty(key)) {
				return false;
			}
			delete(this.h[key]);
			return true;
		}
	}
	keys() {
		return HxOverrides.iter(this.arrayKeys());
	}
	arrayKeys() {
		var out = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) {
			out.push(key);
		}
		}
		if(this.rh != null) {
			for( var key in this.rh ) {
			if(key.charCodeAt(0) == 36) {
				out.push(key.substr(1));
			}
			}
		}
		return out;
	}
	toString() {
		var s_b = "";
		s_b += "{";
		var keys = this.arrayKeys();
		var _g = 0;
		var _g1 = keys.length;
		while(_g < _g1) {
			var i = _g++;
			var k = keys[i];
			s_b += k == null ? "null" : "" + k;
			s_b += " => ";
			s_b += Std.string(Std.string(__map_reserved[k] != null ? this.getReserved(k) : this.h[k]));
			if(i < keys.length - 1) {
				s_b += ", ";
			}
		}
		s_b += "}";
		return s_b;
	}
}
haxe_ds_StringMap.__name__ = true;
class js__$Boot_HaxeError extends Error {
	constructor(val) {
		super();
		this.val = val;
		if(Error.captureStackTrace) {
			Error.captureStackTrace(this,js__$Boot_HaxeError);
		}
	}
}
js__$Boot_HaxeError.__name__ = true;
class js_Boot {
	static __string_rec(o,s) {
		if(o == null) {
			return "null";
		}
		if(s.length >= 5) {
			return "<...>";
		}
		var t = typeof(o);
		if(t == "function" && (o.__name__ || o.__ename__)) {
			t = "object";
		}
		switch(t) {
		case "function":
			return "<function>";
		case "object":
			if(o.__enum__) {
				var e = $hxEnums[o.__enum__];
				var n = e.__constructs__[o._hx_index];
				var con = e[n];
				if(con.__params__) {
					s += "\t";
					var tmp = n + "(";
					var _g = [];
					var _g1 = 0;
					var _g2 = con.__params__;
					while(_g1 < _g2.length) {
						var p = _g2[_g1];
						++_g1;
						_g.push(js_Boot.__string_rec(o[p],s));
					}
					return tmp + _g.join(",") + ")";
				} else {
					return n;
				}
			}
			if(((o) instanceof Array)) {
				var l = o.length;
				var i;
				var str = "[";
				s += "\t";
				var _g3 = 0;
				var _g11 = l;
				while(_g3 < _g11) {
					var i1 = _g3++;
					str += (i1 > 0 ? "," : "") + js_Boot.__string_rec(o[i1],s);
				}
				str += "]";
				return str;
			}
			var tostr;
			try {
				tostr = o.toString;
			} catch( e1 ) {
				var e2 = ((e1) instanceof js__$Boot_HaxeError) ? e1.val : e1;
				return "???";
			}
			if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
				var s2 = o.toString();
				if(s2 != "[object Object]") {
					return s2;
				}
			}
			var k = null;
			var str1 = "{\n";
			s += "\t";
			var hasp = o.hasOwnProperty != null;
			for( var k in o ) {
			if(hasp && !o.hasOwnProperty(k)) {
				continue;
			}
			if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
				continue;
			}
			if(str1.length != 2) {
				str1 += ", \n";
			}
			str1 += s + k + " : " + js_Boot.__string_rec(o[k],s);
			}
			s = s.substring(1);
			str1 += "\n" + s + "}";
			return str1;
		case "string":
			return o;
		default:
			return String(o);
		}
	}
}
js_Boot.__name__ = true;
var js_node_Http = require("http");
class server_rooms_Active {
	constructor(_players) {
		this.RoomPlayerIDs = [];
		this.activeSeatNR = 0;
		this.activePlayerID = "";
		this.freeSeats = [];
		this.seatCounter = -1;
		this.players = _players;
		this.RoomPlayerIDs = [];
	}
	setActiveSeatNR(seatNR) {
		haxe_Log.trace("setActiveSeatNR set seat nr to be active: " + seatNR,{ fileName : "src/server/rooms/Active.hx", lineNumber : 23, className : "server.rooms.Active", methodName : "setActiveSeatNR"});
		var _g = 0;
		var _g1 = this.RoomPlayerIDs;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(colyseus_server_schema_MapSchemaUtil.get(this.players,p).SeatNR == seatNR) {
				this.activeSeatNR = colyseus_server_schema_MapSchemaUtil.get(this.players,p).SeatNR;
				this.activePlayerID = colyseus_server_schema_MapSchemaUtil.get(this.players,p).playerID;
				colyseus_server_schema_MapSchemaUtil.get(this.players,p).ActivePlayer = colyseus_server_schema_MapSchemaUtil.get(this.players,p).playerID;
				this.activePlayerID = colyseus_server_schema_MapSchemaUtil.get(this.players,p).playerID;
				this.activeSeatNR = seatNR;
				var _g2 = 0;
				var _g11 = this.RoomPlayerIDs;
				while(_g2 < _g11.length) {
					var ap = _g11[_g2];
					++_g2;
					colyseus_server_schema_MapSchemaUtil.get(this.players,ap).ActivePlayer = this.activePlayerID;
				}
			}
		}
	}
	getActivePlayer() {
		var lastPlayer = "";
		var _g = 0;
		var _g1 = this.RoomPlayerIDs;
		while(_g < _g1.length) {
			var ap = _g1[_g];
			++_g;
			if(lastPlayer.length < 1) {
				lastPlayer = colyseus_server_schema_MapSchemaUtil.get(this.players,ap).ActivePlayer;
			}
			if(colyseus_server_schema_MapSchemaUtil.get(this.players,ap).ActivePlayer != null && colyseus_server_schema_MapSchemaUtil.get(this.players,ap).ActivePlayer.length > 0) {
				if(lastPlayer != colyseus_server_schema_MapSchemaUtil.get(this.players,ap).ActivePlayer) {
					var nextPlayer = this.findNextActivePlayer();
				}
				lastPlayer = colyseus_server_schema_MapSchemaUtil.get(this.players,ap).ActivePlayer;
			}
		}
		if(lastPlayer.length < 1) {
			this.findNextActivePlayer();
		}
	}
	addPlayerName(id,PlayerName) {
		var freeNr = -1;
		if(Lambda.indexOf(this.RoomPlayerIDs,id) < 0) {
			this.RoomPlayerIDs.push(id);
		}
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerName = "" + PlayerName;
		var _g = 0;
		var _g1 = this.freeSeats.length;
		while(_g < _g1) {
			var i = _g++;
			if(freeNr == -1) {
				if(this.freeSeats[i] > -1) {
					freeNr = this.freeSeats[i];
					HxOverrides.remove(this.freeSeats,this.freeSeats[i]);
				}
			}
		}
		if(freeNr == -1) {
			freeNr = ++this.seatCounter;
		}
		haxe_Log.trace("addPlayer : " + id + " with seatnr: " + freeNr,{ fileName : "src/server/rooms/Active.hx", lineNumber : 80, className : "server.rooms.Active", methodName : "addPlayerName"});
		haxe_Log.trace("Length of RoomPlayerIDS: " + this.RoomPlayerIDs.length,{ fileName : "src/server/rooms/Active.hx", lineNumber : 81, className : "server.rooms.Active", methodName : "addPlayerName"});
		if(this.RoomPlayerIDs.length < 2) {
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).ActivePlayer = colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID;
			this.activePlayerID = colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID;
			this.activeSeatNR = freeNr;
			haxe_Log.trace("ActivePlayerID: " + this.activePlayerID,{ fileName : "src/server/rooms/Active.hx", lineNumber : 86, className : "server.rooms.Active", methodName : "addPlayerName"});
			haxe_Log.trace("ActiveSeatNR  : " + this.activeSeatNR,{ fileName : "src/server/rooms/Active.hx", lineNumber : 87, className : "server.rooms.Active", methodName : "addPlayerName"});
		}
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).SeatNR = freeNr;
		this.getSeatInfo();
	}
	findNextActivePlayer() {
		var retval = "";
		var smallestSeat = 1000;
		var smallestSeatPlayerID = "";
		var smallestPlayerIndex = "";
		var findCounter = 1;
		while(retval.length < 1 && findCounter < 1000) {
			var _g = 0;
			var _g1 = this.RoomPlayerIDs;
			while(_g < _g1.length) {
				var p = _g1[_g];
				++_g;
				if(colyseus_server_schema_MapSchemaUtil.get(this.players,p).SeatNR < smallestSeat) {
					smallestSeat = colyseus_server_schema_MapSchemaUtil.get(this.players,p).SeatNR;
					smallestSeatPlayerID = colyseus_server_schema_MapSchemaUtil.get(this.players,p).playerID;
					smallestPlayerIndex = p;
				}
				if(retval.length < 1 && colyseus_server_schema_MapSchemaUtil.get(this.players,p).SeatNR == this.activeSeatNR + findCounter) {
					retval = colyseus_server_schema_MapSchemaUtil.get(this.players,p).playerID;
					this.activeSeatNR = colyseus_server_schema_MapSchemaUtil.get(this.players,p).SeatNR;
					this.activePlayerID = retval;
					var _g2 = 0;
					var _g11 = this.RoomPlayerIDs;
					while(_g2 < _g11.length) {
						var ap = _g11[_g2];
						++_g2;
						colyseus_server_schema_MapSchemaUtil.get(this.players,ap).ActivePlayer = retval;
					}
				}
			}
			++findCounter;
		}
		if(retval.length < 1) {
			retval = smallestSeatPlayerID;
			this.activeSeatNR = smallestSeat;
			this.activePlayerID = retval;
			var _g3 = 0;
			var _g12 = this.RoomPlayerIDs;
			while(_g3 < _g12.length) {
				var ap1 = _g12[_g3];
				++_g3;
				colyseus_server_schema_MapSchemaUtil.get(this.players,ap1).ActivePlayer = retval;
			}
		}
		return retval;
	}
	removePlayer(id) {
		HxOverrides.remove(this.RoomPlayerIDs,id);
		this.freeSeats.push(colyseus_server_schema_MapSchemaUtil.get(this.players,id).SeatNR);
		haxe_Log.trace(" Removing player ID : " + id + " And find next Player ...",{ fileName : "src/server/rooms/Active.hx", lineNumber : 151, className : "server.rooms.Active", methodName : "removePlayer"});
		if(this.activePlayerID == colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID) {
			var nextPlayer = this.findNextActivePlayer();
			haxe_Log.trace("FindNextActivePlayer : " + nextPlayer,{ fileName : "src/server/rooms/Active.hx", lineNumber : 154, className : "server.rooms.Active", methodName : "removePlayer"});
		}
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).SeatNR = 0;
		colyseus_server_schema_MapSchemaUtil.delete(this.players,id);
	}
	getSeatInfo() {
		var _g = 0;
		var _g1 = this.RoomPlayerIDs;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			colyseus_server_schema_MapSchemaUtil.get(this.players,p).ActivePlayer = this.activePlayerID;
		}
	}
	getRoomPlayers() {
		return this.RoomPlayerIDs;
	}
}
server_rooms_Active.__name__ = true;
class server_rooms_AuthRoom extends colyseus_server_Room {
	constructor(presence) {
		super(presence);
	}
}
server_rooms_AuthRoom.__name__ = true;
class server_rooms_ChatRoom extends colyseus_server_Room {
	constructor() {
		super();
		this.maxClients = 4;
	}
	onInit(options) {
		haxe_Log.trace("ChatRoom created!",{ fileName : "src/server/rooms/ChatRoom.hx", lineNumber : 12, className : "server.rooms.ChatRoom", methodName : "onInit", customParams : [options]});
	}
	onJoin(client,options,auth) {
		this.broadcast("" + client.sessionId + " joined.");
		return null;
	}
	onLeave(client,consented) {
		this.broadcast("" + client.sessionId + " left.");
		return null;
	}
	onMessage(client,data) {
		haxe_Log.trace("ChatRoom received message from",{ fileName : "src/server/rooms/ChatRoom.hx", lineNumber : 27, className : "server.rooms.ChatRoom", methodName : "onMessage", customParams : [client.sessionId,":",data]});
		this.broadcast("(" + client.sessionId + ") " + Std.string(data.message));
	}
	onDispose() {
		haxe_Log.trace("Dispose ChatRoom",{ fileName : "src/server/rooms/ChatRoom.hx", lineNumber : 32, className : "server.rooms.ChatRoom", methodName : "onDispose"});
		return null;
	}
}
server_rooms_ChatRoom.__name__ = true;
class server_rooms_CreateOrJoinRoom extends colyseus_server_Room {
	constructor() {
		super();
		this.maxClients = 4;
	}
	onInit(options) {
		haxe_Log.trace("CREATING NEW ROOM",{ fileName : "src/server/rooms/CreateOrJoinRoom.hx", lineNumber : 11, className : "server.rooms.CreateOrJoinRoom", methodName : "onInit"});
	}
	onJoin(client,options,auth) {
		haxe_Log.trace("JOINING ROOM",{ fileName : "src/server/rooms/CreateOrJoinRoom.hx", lineNumber : 14, className : "server.rooms.CreateOrJoinRoom", methodName : "onJoin"});
		return null;
	}
	onLeave(client,consented) {
		haxe_Log.trace("ChatRoom:",{ fileName : "src/server/rooms/CreateOrJoinRoom.hx", lineNumber : 19, className : "server.rooms.CreateOrJoinRoom", methodName : "onLeave", customParams : [client.sessionId,"left!"]});
		return null;
	}
	requestJoin(options,isNew) {
		if(options.create) {
			if(options.create) {
				return isNew;
			} else {
				return false;
			}
		} else {
			return this.clients.length > 0;
		}
	}
}
server_rooms_CreateOrJoinRoom.__name__ = true;
class server_rooms_LobbyPlayer extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.playerName = "";
		this.ApplicationID = "";
		this.playerID = "";
		this.roomInfo = "";
	}
}
server_rooms_LobbyPlayer.__name__ = true;
class server_rooms_Lobby extends colyseus_server_Room {
	constructor(presence) {
		super(presence);
	}
	onInit(options) {
		haxe_Log.trace("Lobby created!",{ fileName : "src/server/rooms/Lobby.hx", lineNumber : 32, className : "server.rooms.Lobby", methodName : "onInit", customParams : [options]});
		this.roomInfo = "";
		this.myState = new server_rooms_LobbyState();
		this.setState(this.myState);
		this.setMetadata(options);
	}
	onJoin(client,options,auth) {
		var msg = Config.convertStringToMap("" + Std.string(options));
		var PlayerName = __map_reserved["PlayerName"] != null ? msg.getReserved("PlayerName") : msg.h["PlayerName"];
		if(PlayerName == null) {
			PlayerName = "";
		}
		var ApplicationID = __map_reserved["ApplicationID"] != null ? msg.getReserved("ApplicationID") : msg.h["ApplicationID"];
		if(ApplicationID == null) {
			ApplicationID = "";
		}
		var PlayerID = __map_reserved["PlayerID"] != null ? msg.getReserved("PlayerID") : msg.h["PlayerID"];
		if(PlayerID == null) {
			PlayerID = "";
		}
		this.myState.createPlayer(client.sessionId);
		this.myState.addPlayerName(client.sessionId,PlayerName);
		this.myState.addPlayerID(client.sessionId,PlayerID);
		this.myState.setApplicationID(client.sessionId,ApplicationID);
		return null;
	}
	onLeave(client,consented) {
		this.myState.removePlayer(client.sessionId);
		return null;
	}
	onMessage(client,data) {
		haxe_Log.trace("Lobby received message from",{ fileName : "src/server/rooms/Lobby.hx", lineNumber : 63, className : "server.rooms.Lobby", methodName : "onMessage", customParams : [client.sessionId,":",data]});
		if(("" + Std.string(data)).indexOf("GETSERVERTIME:") > -1) {
			var dataList = data.split(":");
			var returnPlayerID = "";
			if(dataList.length > 1) {
				returnPlayerID = dataList[2];
				this.roomInfo += "RETURNTIME:" + returnPlayerID + ":" + new Date().getTime() + ";";
				this.myState.addRoomInfo(client.sessionId,this.roomInfo);
			}
		}
		if(("" + Std.string(data)).indexOf("ADDROOMINFO.") > -1) {
			this.roomInfo += "" + Std.string(data.substring(("" + Std.string(data)).indexOf("ADDROOMINFO.") + 12,data.length)) + ";";
			haxe_Log.trace("addRoomInfo to the client(s) ",{ fileName : "src/server/rooms/Lobby.hx", lineNumber : 78, className : "server.rooms.Lobby", methodName : "onMessage"});
			this.myState.addRoomInfo(client.sessionId,this.roomInfo);
		}
	}
	onDispose() {
		haxe_Log.trace("Dispose Lobby",{ fileName : "src/server/rooms/Lobby.hx", lineNumber : 85, className : "server.rooms.Lobby", methodName : "onDispose"});
		return null;
	}
}
server_rooms_Lobby.__name__ = true;
class server_rooms_LobbyState extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.players = new colyseus_server_schema_MapSchema();
	}
	createPlayer(id) {
		colyseus_server_schema_MapSchemaUtil.set(this.players,id,new server_rooms_LobbyPlayer());
	}
	removePlayer(id) {
		colyseus_server_schema_MapSchemaUtil.delete(this.players,id);
	}
	addPlayerName(id,PlayerName) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerName = "" + PlayerName;
	}
	addPlayerID(id,PlayerID) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID = "" + PlayerID;
	}
	setApplicationID(id,applicationID) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).ApplicationID = "" + applicationID;
	}
	addRoomInfo(id,RoomInfo) {
		var thePlayers = RoomInfo.split(";");
		var thePlayerMap = new haxe_ds_StringMap();
		var newRoomInfo = "";
		if(RoomInfo.indexOf("RETURNTIME") > -1) {
			newRoomInfo = RoomInfo;
		} else {
			var _g = 0;
			while(_g < thePlayers.length) {
				var player = thePlayers[_g];
				++_g;
				if(player.indexOf("%") > -1) {
					var tempName = player.split("%")[0];
					var isFound = false;
					var item = new haxe_ds__$StringMap_StringMapIterator(thePlayerMap,thePlayerMap.arrayKeys());
					while(item.hasNext()) {
						var item1 = item.next();
						if(item1 == tempName) {
							isFound = true;
						}
					}
					if(isFound) {
						thePlayerMap.remove(tempName);
					}
				}
				if(player.indexOf("@") > -1) {
					var tempName1 = player.split("@");
					var key = "" + Std.string(tempName1[0]);
					var value = "" + Std.string(tempName1[1]);
					if(__map_reserved[key] != null) {
						thePlayerMap.setReserved(key,value);
					} else {
						thePlayerMap.h[key] = value;
					}
				}
			}
			var toReturn = [];
			var player1 = thePlayerMap.keys();
			while(player1.hasNext()) {
				var player2 = player1.next();
				newRoomInfo = player2 + "@" + (__map_reserved[player2] != null ? thePlayerMap.getReserved(player2) : thePlayerMap.h[player2]) + ";" + newRoomInfo;
			}
		}
		haxe_Log.trace(" new RoomInfo: " + newRoomInfo,{ fileName : "src/server/rooms/Lobby.hx", lineNumber : 150, className : "server.rooms.LobbyState", methodName : "addRoomInfo"});
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).roomInfo = newRoomInfo;
	}
}
server_rooms_LobbyState.__name__ = true;
class server_rooms_Lock extends colyseus_server_Room {
	constructor(presence) {
		super(presence);
	}
	onInit(options) {
		haxe_Log.trace("Lock created!",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 14, className : "server.rooms.Lock", methodName : "onInit", customParams : [options]});
		this.myState = new server_rooms_LockState();
		this.setState(this.myState);
		this.setMetadata(options);
	}
	onJoin(client,options,auth) {
		haxe_Log.trace("options " + Std.string(options),{ fileName : "src/server/rooms/Lock.hx", lineNumber : 23, className : "server.rooms.Lock", methodName : "onJoin"});
		var msg = Config.convertStringToMap("" + Std.string(options));
		var PlayerName = __map_reserved["PlayerName"] != null ? msg.getReserved("PlayerName") : msg.h["PlayerName"];
		if(PlayerName == null) {
			PlayerName = "";
		}
		var RoomName = __map_reserved["RoomName"] != null ? msg.getReserved("RoomName") : msg.h["RoomName"];
		if(PlayerName == null) {
			RoomName = "ROOM0";
		}
		var PlayerID = __map_reserved["PlayerID"] != null ? msg.getReserved("PlayerID") : msg.h["PlayerID"];
		if(PlayerID == null) {
			PlayerID = "";
		}
		this.myState.createPlayer(client.sessionId);
		this.myState.addPlayerName(client.sessionId,PlayerName);
		this.myState.addPlayerID(client.sessionId,PlayerID);
		this.myState.getActivePlayer();
		return null;
	}
	onLeave(client,consented) {
		this.myState.removePlayer(client.sessionId);
		return null;
	}
	onMessage(client,data) {
		haxe_Log.trace("message from " + client.sessionId + ":" + Std.string(data),{ fileName : "src/server/rooms/Lock.hx", lineNumber : 52, className : "server.rooms.Lock", methodName : "onMessage"});
		var isData = true;
		if(("" + Std.string(data)).indexOf("SETACTIVESEATNR") > -1) {
			this.myState.setActiveSeatNR(client.sessionId,"" + Std.string(data));
			isData = false;
		}
		if(("" + Std.string(data)).indexOf("LOCKROOM*") == 0) {
			this.myState.lockRoom(client.sessionId,"" + Std.string(data));
			isData = false;
		}
		if(("" + Std.string(data)).indexOf("UNLOCKROOM*") == 0) {
			this.myState.unLockRoom(client.sessionId,"" + Std.string(data));
			isData = false;
		}
		if(("" + Std.string(data)).indexOf("LOCKREQUEST*") == 0) {
			var lockParts = ("" + Std.string(data)).split("*");
			var lockID = "" + lockParts[1];
			var requestData = lockParts[2];
			haxe_Log.trace("LockRequest Received: ID=" + lockID + " lockData=" + requestData,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 85, className : "server.rooms.Lock", methodName : "onMessage"});
			isData = false;
			this.myState.onLockRequest(client.sessionId,lockID,"" + requestData);
		}
		if(("" + Std.string(data)).indexOf("REQUESTLOCK*") == 0) {
			haxe_Log.trace("RequestLock Received : calling requestDataLock?",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 97, className : "server.rooms.Lock", methodName : "onMessage"});
			isData = false;
		}
		if(("" + Std.string(data)).indexOf("REQUESTDATALOCK*") == 0) {
			haxe_Log.trace("RequestDataLock Received : calling requestDataLock",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 103, className : "server.rooms.Lock", methodName : "onMessage"});
			this.myState.requestDataLock(client.sessionId,"" + Std.string(data));
			isData = false;
		}
		if(("" + Std.string(data)).indexOf("UNLOCKDATA*") == 0) {
			this.myState.unlockData(client.sessionId,"" + Std.string(data));
			isData = false;
		}
		if(("" + Std.string(data)).indexOf("LOCKDATA*") == 0) {
			haxe_Log.trace(" Lockdata message received with data :" + Std.string(data),{ fileName : "src/server/rooms/Lock.hx", lineNumber : 116, className : "server.rooms.Lock", methodName : "onMessage"});
			this.myState.setData(client.sessionId,"" + Std.string(data));
			isData = false;
		}
		if(("" + Std.string(data)).indexOf("GETLOCKDATA*") == 0) {
			haxe_Log.trace("GETLOCKDATA requested!",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 122, className : "server.rooms.Lock", methodName : "onMessage"});
			this.myState.getData(client.sessionId);
			isData = false;
		}
		if(isData) {
			this.myState.updateString(client.sessionId,"" + Std.string(data));
			this.myState.getSeatInfo();
		}
	}
	onDispose() {
		haxe_Log.trace("Dispose Lock",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 133, className : "server.rooms.Lock", methodName : "onDispose"});
		return null;
	}
	requestJoin(options,isNew) {
		var retval = false;
		var oldMax = this.maxClients;
		var PlayerName = "";
		var ActionType = "";
		this.maxClients = 100;
		var prop = Config.convertStringToMap("" + Std.string(options));
		var PlayerName1 = __map_reserved["PlayerName"] != null ? prop.getReserved("PlayerName") : prop.h["PlayerName"];
		var PlayerID = __map_reserved["PlayerID"] != null ? prop.getReserved("PlayerID") : prop.h["PlayerID"];
		var ActionType1 = __map_reserved["CreateOrJoin"] != null ? prop.getReserved("CreateOrJoin") : prop.h["CreateOrJoin"];
		var RoomID1 = __map_reserved["RoomID"] != null ? prop.getReserved("RoomID") : prop.h["RoomID"];
		if(PlayerName1 == null) {
			PlayerName1 = "";
		}
		if(PlayerID == null) {
			PlayerID = "";
		}
		if(ActionType1 == null) {
			ActionType1 = "";
		}
		if(RoomID1 == null) {
			RoomID1 = "";
		}
		haxe_Log.trace("Request join : this.roomId: |" + this.roomId + "| Type: |" + ActionType1 + "| PlayerName: |" + PlayerName1 + "| PlayerID: |" + PlayerID + "| OldMax: |" + oldMax + "| ",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 160, className : "server.rooms.Lock", methodName : "requestJoin"});
		if(ActionType1 != "JOIN" && ("" + oldMax).indexOf("Infinity") > -1) {
			retval = true;
		} else if(ActionType1 == "JOIN") {
			if(this.roomId == RoomID1) {
				retval = true;
			} else {
				retval = false;
			}
		} else {
			retval = false;
		}
		haxe_Log.trace("retval = " + (retval == null ? "null" : "" + retval) + "  if retval is true we join room: " + this.roomId + "| | ",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 175, className : "server.rooms.Lock", methodName : "requestJoin"});
		return retval;
	}
}
server_rooms_Lock.__name__ = true;
class server_rooms_LockPlayer extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.theString = "NULL";
		this.playerName = "TestPlayerName";
		this.playerID = "";
		this.lockState = "";
		this.lockData = "";
		this.SeatNR = 0;
		this.ActivePlayer = "";
	}
}
server_rooms_LockPlayer.__name__ = true;
class server_rooms_LockState extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.seperateSplit = "@|;|@";
		this.oldNewSplit = "@$,$@";
		this.equalSplit = "@=@";
		this.lockTimeMap = new haxe_ds_StringMap();
		this.lockUserMap = new haxe_ds_StringMap();
		this.lockMap = new haxe_ds_StringMap();
		this.DataMap = new haxe_ds_StringMap();
		this.lockState = "";
		this.players = new colyseus_server_schema_MapSchema();
		this.active = new server_rooms_Active(this.players);
	}
	createPlayer(id) {
		colyseus_server_schema_MapSchemaUtil.set(this.players,id,new server_rooms_LockPlayer());
	}
	removePlayer(id) {
		this.active.removePlayer(id);
	}
	setActiveSeatNR(id,data) {
		var setActiveSeatList = data.split("SETACTIVESEATNR:");
		this.active.setActiveSeatNR(Std.parseInt("" + setActiveSeatList[1]));
	}
	getActivePlayer() {
		this.active.getActivePlayer();
	}
	updateString(id,theString_) {
		haxe_Log.trace("Update String: " + theString_,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 369, className : "server.rooms.LockState", methodName : "updateString"});
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).theString = theString_;
	}
	getSeatInfo() {
		this.active.getSeatInfo();
	}
	addPlayerName(id,PlayerName) {
		this.active.addPlayerName(id,PlayerName);
	}
	addPlayerID(id,PlayerID) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID = "" + PlayerID;
	}
	lockRoom(id,requestData) {
		haxe_Log.trace("LOCKROOM: Going to attempt to lock the room: investigate state",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 427, className : "server.rooms.LockState", methodName : "lockRoom"});
		var reason = "";
		var lockParts = ("" + requestData).split("*");
		var lockID = "" + lockParts[1];
		haxe_Log.trace("LOCKROOM:  LockID: " + lockID,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 434, className : "server.rooms.LockState", methodName : "lockRoom"});
		if(this.lockState == "") {
			this.lockState = new Date().getTime() + "=" + requestData;
			haxe_Log.trace("LOCKROOM: Lock Acquired by : " + id + " with lockstate: " + this.lockState,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 437, className : "server.rooms.LockState", methodName : "lockRoom"});
			var sendText = "ONLOCKACCEPT*" + lockID + "*" + requestData + "*" + new Date().getTime();
			haxe_Log.trace("LOCKROOM: Send acept : " + sendText,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 442, className : "server.rooms.LockState", methodName : "lockRoom"});
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = sendText;
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = reason;
		} else {
			haxe_Log.trace("LOCKROOM: Lock Denied for  : " + id,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 446, className : "server.rooms.LockState", methodName : "lockRoom"});
			reason = "ROOM_ALREADY_LOCKED*" + this.lockState;
			var sendText1 = reason + "*" + lockID + "*" + new Date().getTime();
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = sendText1;
			haxe_Log.trace("LOCKROOM: Send denylock: " + sendText1 + " reason: " + reason,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 452, className : "server.rooms.LockState", methodName : "lockRoom"});
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = reason;
		}
	}
	unLockRoom(id,requestData) {
		haxe_Log.trace("UNLOCKROOM: Attempt to release ROOM lock",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 458, className : "server.rooms.LockState", methodName : "unLockRoom"});
		if(this.lockState.length > 0) {
			this.lockState = "";
			var tmp = new Date().getTime();
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = "UNLOCKROOM*" + "*" + tmp;
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = "ROOMLOCKRELEASED";
		} else {
			var tmp1 = new Date().getTime();
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = "ROOMUNLOCKDENIED_ALLREADY" + "*" + tmp1;
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = "ROOMUNLOCKDENIED_ALLREADY";
		}
	}
	requestDataLock(id,requestData) {
		var isOK = true;
		var playerID = colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID;
		var requestLocks = [];
		if(requestData.indexOf(this.seperateSplit) < 0) {
			isOK = false;
		}
		var requestDataList = requestData.split(this.seperateSplit);
		var objectCounter = 1;
		var reason = "";
		while(objectCounter < requestDataList.length && isOK) {
			var objectString = requestDataList[objectCounter];
			if(objectString.length > 0) {
				var object = objectString.split(this.equalSplit)[0];
				var oldValue = objectString.split(this.equalSplit)[1].split(this.oldNewSplit)[0];
				var newValue = objectString.split(this.oldNewSplit)[1];
				haxe_Log.trace("Lock Object: " + object + " oldValue: " + oldValue + " newValue: " + newValue,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 489, className : "server.rooms.LockState", methodName : "requestDataLock"});
				var tmp;
				var _this = this.lockMap;
				if(!(__map_reserved[object] != null ? _this.existsReserved(object) : _this.h.hasOwnProperty(object))) {
					var _this1 = this.DataMap;
					tmp = (__map_reserved[object] != null ? _this1.getReserved(object) : _this1.h[object]) == oldValue;
				} else {
					tmp = false;
				}
				if(tmp) {
					requestLocks.push(object);
					var _this2 = this.lockMap;
					if(__map_reserved[object] != null) {
						_this2.setReserved(object,newValue);
					} else {
						_this2.h[object] = newValue;
					}
					var _this3 = this.lockUserMap;
					if(__map_reserved[object] != null) {
						_this3.setReserved(object,playerID);
					} else {
						_this3.h[object] = playerID;
					}
					var this1 = this.lockTimeMap;
					var value = "" + new Date().getTime();
					var _this4 = this1;
					if(__map_reserved[object] != null) {
						_this4.setReserved(object,value);
					} else {
						_this4.h[object] = value;
					}
				} else {
					var _this5 = this.lockMap;
					if(__map_reserved[object] != null ? _this5.existsReserved(object) : _this5.h.hasOwnProperty(object)) {
						reason = "Key :" + object + " is in lockmap : release the lock please!!!!!";
					} else {
						var _this6 = this.DataMap;
						if((__map_reserved[object] != null ? _this6.getReserved(object) : _this6.h[object]) != oldValue) {
							var _this7 = this.DataMap;
							reason = " value: " + (__map_reserved[object] != null ? _this7.getReserved(object) : _this7.h[object]) + " Not equal to oldvalue: " + oldValue;
						}
					}
					isOK = false;
				}
			}
			++objectCounter;
		}
		if(!isOK) {
			var _g = 0;
			while(_g < requestLocks.length) {
				var requestObject = requestLocks[_g];
				++_g;
				this.lockMap.remove(requestObject);
				var _this8 = this.lockUserMap;
				if(__map_reserved[requestObject] != null) {
					_this8.setReserved(requestObject,"");
				} else {
					_this8.h[requestObject] = "";
				}
				var _this9 = this.lockTimeMap;
				if(__map_reserved[requestObject] != null) {
					_this9.setReserved(requestObject,"0");
				} else {
					_this9.h[requestObject] = "0";
				}
			}
			haxe_Log.trace("Send denylock with reason: " + reason,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 516, className : "server.rooms.LockState", methodName : "requestDataLock"});
			var tmp1 = new Date().getTime();
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = "DENYLOCK*" + reason + "*" + tmp1;
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = "DENYLOCK";
		} else {
			haxe_Log.trace("Send acknowledge",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 522, className : "server.rooms.LockState", methodName : "requestDataLock"});
			var tmp2 = new Date().getTime();
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = "LOCKACKNOWLEDGE*" + requestData + "*" + tmp2;
		}
	}
	onLockRequest(id,lockID,requestData) {
		var isOK = true;
		var playerID = colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID;
		var requestLocks = [];
		var reason = "";
		if(requestData.length > 0 && requestData.indexOf(this.seperateSplit) < 0) {
			isOK = false;
			reason = "invalid lockstring (must end with " + this.seperateSplit + " ;) :" + requestData + " : ONLOCKDENY";
		}
		var requestDataList = requestData.split(this.seperateSplit);
		var objectCounter = 0;
		while(objectCounter < requestDataList.length && isOK) {
			var objectString = requestDataList[objectCounter];
			if(objectString.length > 0) {
				var object = objectString.split(this.equalSplit)[0];
				var newValue = objectString.split(this.equalSplit)[1].split(this.oldNewSplit)[0];
				var oldValue = objectString.split(this.oldNewSplit)[1];
				var _this = this.DataMap;
				haxe_Log.trace("Lock Object: " + object + " oldValue: " + oldValue + " newValue: " + newValue + " mapdata: " + (__map_reserved[object] != null ? _this.getReserved(object) : _this.h[object]),{ fileName : "src/server/rooms/Lock.hx", lineNumber : 552, className : "server.rooms.LockState", methodName : "onLockRequest"});
				var tmp;
				var _this1 = this.lockMap;
				if(!(__map_reserved[object] != null ? _this1.existsReserved(object) : _this1.h.hasOwnProperty(object))) {
					var _this2 = this.DataMap;
					tmp = (__map_reserved[object] != null ? _this2.getReserved(object) : _this2.h[object]) == oldValue;
				} else {
					tmp = false;
				}
				if(tmp) {
					requestLocks.push(object);
					var _this3 = this.lockMap;
					if(__map_reserved[object] != null) {
						_this3.setReserved(object,newValue);
					} else {
						_this3.h[object] = newValue;
					}
					var _this4 = this.lockUserMap;
					if(__map_reserved[object] != null) {
						_this4.setReserved(object,playerID);
					} else {
						_this4.h[object] = playerID;
					}
					var this1 = this.lockTimeMap;
					var value = "" + new Date().getTime();
					var _this5 = this1;
					if(__map_reserved[object] != null) {
						_this5.setReserved(object,value);
					} else {
						_this5.h[object] = value;
					}
				} else {
					var _this6 = this.DataMap;
					if((__map_reserved[object] != null ? _this6.getReserved(object) : _this6.h[object]) != oldValue) {
						reason = "object != oldvalue : OUTOFSYNC";
					}
					var _this7 = this.lockMap;
					if(__map_reserved[object] != null ? _this7.existsReserved(object) : _this7.h.hasOwnProperty(object)) {
						reason = "Lock exists on lockmap : ONLOCKDENY";
					}
					isOK = false;
				}
			}
			++objectCounter;
		}
		if(!isOK) {
			var _g = 0;
			while(_g < requestLocks.length) {
				var requestObject = requestLocks[_g];
				++_g;
				haxe_Log.trace("Unlock object: " + requestObject + "",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 573, className : "server.rooms.LockState", methodName : "onLockRequest"});
				this.lockMap.remove(requestObject);
				var _this8 = this.lockUserMap;
				if(__map_reserved[requestObject] != null) {
					_this8.setReserved(requestObject,"");
				} else {
					_this8.h[requestObject] = "";
				}
				var _this9 = this.lockTimeMap;
				if(__map_reserved[requestObject] != null) {
					_this9.setReserved(requestObject,"0");
				} else {
					_this9.h[requestObject] = "0";
				}
			}
			var sendText = reason + "*" + lockID + "*" + new Date().getTime();
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = sendText;
			haxe_Log.trace("Send denylock: " + sendText + " reason : " + reason,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 581, className : "server.rooms.LockState", methodName : "onLockRequest"});
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = reason;
		} else {
			var _g1 = 0;
			while(_g1 < requestLocks.length) {
				var requestObject1 = requestLocks[_g1];
				++_g1;
				haxe_Log.trace("Unlock object (acknowledge : accept) object: " + requestObject1,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 587, className : "server.rooms.LockState", methodName : "onLockRequest"});
				var _this10 = this.lockMap;
				var newValue1 = __map_reserved[requestObject1] != null ? _this10.getReserved(requestObject1) : _this10.h[requestObject1];
				var _this11 = this.DataMap;
				if(__map_reserved[requestObject1] != null) {
					_this11.setReserved(requestObject1,newValue1);
				} else {
					_this11.h[requestObject1] = newValue1;
				}
				this.lockMap.remove(requestObject1);
				var _this12 = this.lockUserMap;
				if(__map_reserved[requestObject1] != null) {
					_this12.setReserved(requestObject1,"");
				} else {
					_this12.h[requestObject1] = "";
				}
				var _this13 = this.lockTimeMap;
				if(__map_reserved[requestObject1] != null) {
					_this13.setReserved(requestObject1,"0");
				} else {
					_this13.h[requestObject1] = "0";
				}
			}
			var sendText1 = "";
			sendText1 = "ONLOCKACCEPT*" + lockID + "*" + requestData + "*" + new Date().getTime();
			haxe_Log.trace("Send acept : " + sendText1,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 597, className : "server.rooms.LockState", methodName : "onLockRequest"});
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = sendText1;
		}
	}
	unlockData(id,requestData) {
		var requestDataList = requestData.split(this.seperateSplit);
		var objectCounter = 0;
		while(objectCounter < requestDataList.length) {
			var objectString = requestDataList[objectCounter];
			if(objectString.length > 0) {
				var object = objectString.split(this.equalSplit)[0];
				var oldValue = objectString.split(this.equalSplit)[1].split(this.oldNewSplit)[0];
				var newValue = objectString.split(this.oldNewSplit)[1];
				var _this = this.lockUserMap;
				if((__map_reserved[object] != null ? _this.getReserved(object) : _this.h[object]) == colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID) {
					this.lockMap.remove(object);
					this.lockUserMap.remove(object);
					this.lockTimeMap.remove(object);
				}
			}
			++objectCounter;
		}
		var tmp = new Date().getTime();
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = "UNLOCKDATA*" + requestData + "*" + tmp;
	}
	getData(id) {
		var toClient = "";
		var objectKey = this.DataMap.keys();
		while(objectKey.hasNext()) {
			var objectKey1 = objectKey.next();
			var _this = this.DataMap;
			var objValue = __map_reserved[objectKey1] != null ? _this.getReserved(objectKey1) : _this.h[objectKey1];
			if(objValue == null) {
				objValue = "";
			}
			toClient = toClient + objectKey1 + this.equalSplit + objValue + this.oldNewSplit + objValue + this.seperateSplit;
		}
		var tmp = new Date().getTime();
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = "" + tmp;
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = "" + toClient;
		haxe_Log.trace("Sending lockState: " + colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 642, className : "server.rooms.LockState", methodName : "getData"});
		haxe_Log.trace("Sending lockData: " + colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 643, className : "server.rooms.LockState", methodName : "getData"});
	}
	setData(id,data) {
		var setDataList = data.split(this.seperateSplit);
		haxe_Log.trace(" (setdata) Contents of setDataList : " + Std.string(setDataList),{ fileName : "src/server/rooms/Lock.hx", lineNumber : 648, className : "server.rooms.LockState", methodName : "setData"});
		var objectCounter = 0;
		while(objectCounter < setDataList.length) {
			var objectString = setDataList[objectCounter];
			if(objectString.indexOf(this.oldNewSplit) > -1) {
				var object = objectString.split(this.equalSplit)[0];
				var newValue = objectString.split(this.equalSplit)[1].split(this.oldNewSplit)[0];
				haxe_Log.trace(" (setdata) object=" + object + "   newValue=" + newValue + " ",{ fileName : "src/server/rooms/Lock.hx", lineNumber : 657, className : "server.rooms.LockState", methodName : "setData"});
				var _this = this.DataMap;
				if(__map_reserved[object] != null) {
					_this.setReserved(object,newValue);
				} else {
					_this.h[object] = newValue;
				}
			}
			++objectCounter;
		}
		if(objectCounter > 1) {
			var tmp = new Date().getTime();
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState = "" + tmp;
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData = "" + data;
			haxe_Log.trace("Sending lockState: " + colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockState,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 666, className : "server.rooms.LockState", methodName : "setData"});
			haxe_Log.trace("Sending lockData: " + colyseus_server_schema_MapSchemaUtil.get(this.players,id).lockData,{ fileName : "src/server/rooms/Lock.hx", lineNumber : 667, className : "server.rooms.LockState", methodName : "setData"});
		}
	}
}
server_rooms_LockState.__name__ = true;
class server_rooms_Raw extends colyseus_server_Room {
	constructor(presence) {
		super(presence);
	}
	onInit(options) {
		haxe_Log.trace("Raw created!",{ fileName : "src/server/rooms/Raw.hx", lineNumber : 11, className : "server.rooms.Raw", methodName : "onInit", customParams : [options]});
		this.myState = new server_rooms_RawState();
		this.setState(this.myState);
		this.setMetadata(options);
	}
	onJoin(client,options,auth) {
		haxe_Log.trace("options " + Std.string(options),{ fileName : "src/server/rooms/Raw.hx", lineNumber : 18, className : "server.rooms.Raw", methodName : "onJoin"});
		var msg = Config.convertStringToMap("" + Std.string(options));
		var PlayerName = __map_reserved["PlayerName"] != null ? msg.getReserved("PlayerName") : msg.h["PlayerName"];
		if(PlayerName == null) {
			PlayerName = "";
		}
		var RoomName = __map_reserved["RoomName"] != null ? msg.getReserved("RoomName") : msg.h["RoomName"];
		if(PlayerName == null) {
			RoomName = "ROOM0";
		}
		var PlayerID = __map_reserved["PlayerID"] != null ? msg.getReserved("PlayerID") : msg.h["PlayerID"];
		if(PlayerID == null) {
			PlayerID = "";
		}
		this.myState.createPlayer(client.sessionId);
		this.myState.addPlayerName(client.sessionId,PlayerName);
		this.myState.addPlayerID(client.sessionId,PlayerID);
		this.myState.getActivePlayer();
		return null;
	}
	onLeave(client,consented) {
		this.myState.removePlayer(client.sessionId);
		return null;
	}
	onMessage(client,data) {
		haxe_Log.trace("Raw received message from",{ fileName : "src/server/rooms/Raw.hx", lineNumber : 46, className : "server.rooms.Raw", methodName : "onMessage", customParams : [client.sessionId,":",data]});
		var isHandled = false;
		if(("" + Std.string(data)).indexOf("SETACTIVESEATNR") > -1) {
			this.myState.setActiveSeatNR(client.sessionId,"" + Std.string(data));
			isHandled = true;
		}
		if(!isHandled) {
			this.myState.updateString(client.sessionId,"" + Std.string(data));
		}
	}
	onDispose() {
		haxe_Log.trace("Dispose Raw",{ fileName : "src/server/rooms/Raw.hx", lineNumber : 59, className : "server.rooms.Raw", methodName : "onDispose"});
		return null;
	}
	requestJoin(options,isNew) {
		var retval = false;
		var oldMax = this.maxClients;
		var PlayerName = "";
		var ActionType = "";
		this.maxClients = 100;
		var prop = Config.convertStringToMap("" + Std.string(options));
		var PlayerName1 = __map_reserved["PlayerName"] != null ? prop.getReserved("PlayerName") : prop.h["PlayerName"];
		var PlayerID = __map_reserved["PlayerID"] != null ? prop.getReserved("PlayerID") : prop.h["PlayerID"];
		var ActionType1 = __map_reserved["CreateOrJoin"] != null ? prop.getReserved("CreateOrJoin") : prop.h["CreateOrJoin"];
		var RoomID1 = __map_reserved["RoomID"] != null ? prop.getReserved("RoomID") : prop.h["RoomID"];
		if(PlayerName1 == null) {
			PlayerName1 = "";
		}
		if(PlayerID == null) {
			PlayerID = "";
		}
		if(ActionType1 == null) {
			ActionType1 = "";
		}
		if(RoomID1 == null) {
			RoomID1 = "";
		}
		haxe_Log.trace("Request join : this.roomId: |" + this.roomId + "| Type: |" + ActionType1 + "| PlayerName: |" + PlayerName1 + "| PlayerID: |" + PlayerID + "| OldMax: |" + oldMax + "| ",{ fileName : "src/server/rooms/Raw.hx", lineNumber : 85, className : "server.rooms.Raw", methodName : "requestJoin"});
		if(ActionType1 != "JOIN" && ("" + oldMax).indexOf("Infinity") > -1) {
			retval = true;
		} else if(ActionType1 == "JOIN") {
			if(this.roomId == RoomID1) {
				retval = true;
			} else {
				retval = false;
			}
		} else {
			retval = false;
		}
		return retval;
	}
}
server_rooms_Raw.__name__ = true;
class server_rooms_RawPlayer extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.SeatNR = 0;
		this.theString = "NULL";
		this.playerName = "TestPlayerName";
		this.playerID = "";
		this.ActivePlayer = "";
		this.SeatNR = 0;
	}
}
server_rooms_RawPlayer.__name__ = true;
class server_rooms_RawState extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.players = new colyseus_server_schema_MapSchema();
		this.active = new server_rooms_Active(this.players);
	}
	createPlayer(id) {
		colyseus_server_schema_MapSchemaUtil.set(this.players,id,new server_rooms_RawPlayer());
	}
	setActiveSeatNR(id,data) {
		var setActiveSeatList = data.split("SETACTIVESEATNR:");
		this.active.setActiveSeatNR(Std.parseInt("" + setActiveSeatList[1]));
	}
	removePlayer(id) {
		this.active.removePlayer(id);
	}
	updateString(id,theString_) {
		var tempString = theString_ + "%%%" + new Date().getTime();
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).theString = tempString;
		haxe_Log.trace("Update String: " + tempString,{ fileName : "src/server/rooms/Raw.hx", lineNumber : 152, className : "server.rooms.RawState", methodName : "updateString"});
	}
	getActivePlayer() {
		this.active.getActivePlayer();
	}
	addPlayerName(id,PlayerName) {
		this.active.addPlayerName(id,PlayerName);
	}
	addPlayerID(id,PlayerID) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID = "" + PlayerID;
	}
}
server_rooms_RawState.__name__ = true;
class server_rooms_StateHandlerRoom extends colyseus_server_Room {
	constructor(presence) {
		super(presence);
	}
	onInit(options) {
		haxe_Log.trace("StateHandlerRoom created!",{ fileName : "src/server/rooms/StateHandlerRoom.hx", lineNumber : 12, className : "server.rooms.StateHandlerRoom", methodName : "onInit", customParams : [options]});
		this.myState = new server_rooms_State();
		this.setState(this.myState);
	}
	onJoin(client,options,auth) {
		this.myState.createPlayer(client.sessionId);
		return null;
	}
	onLeave(client,consented) {
		this.myState.removePlayer(client.sessionId);
		return null;
	}
	onMessage(client,data) {
		haxe_Log.trace("StateHandlerRoom received message from",{ fileName : "src/server/rooms/StateHandlerRoom.hx", lineNumber : 28, className : "server.rooms.StateHandlerRoom", methodName : "onMessage", customParams : [client.sessionId,":",data]});
		if(("" + Std.string(data)).indexOf("=") > -1) {
			this.myState.updateString(client.sessionId,"" + Std.string(data));
		} else {
			this.myState.movePlayer(client.sessionId,data);
		}
	}
	onDispose() {
		haxe_Log.trace("Dispose StateHandlerRoom",{ fileName : "src/server/rooms/StateHandlerRoom.hx", lineNumber : 37, className : "server.rooms.StateHandlerRoom", methodName : "onDispose"});
		return null;
	}
}
server_rooms_StateHandlerRoom.__name__ = true;
class server_rooms_Player extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.x = Math.floor(Math.random() * 400);
		this.y = Math.floor(Math.random() * 400);
		this.theString = "NULL";
	}
}
server_rooms_Player.__name__ = true;
class server_rooms_State extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.players = new colyseus_server_schema_MapSchema();
	}
	createPlayer(id) {
		colyseus_server_schema_MapSchemaUtil.set(this.players,id,new server_rooms_Player());
	}
	removePlayer(id) {
		colyseus_server_schema_MapSchemaUtil.delete(this.players,id);
	}
	movePlayer(id,movement) {
		if(movement.x != null) {
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).x += movement.x * 10;
		}
		if(movement.y != null) {
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).y += movement.y * 10;
		}
	}
	updateString(id,theString_) {
		haxe_Log.trace("Update String: " + theString_,{ fileName : "src/server/rooms/StateHandlerRoom.hx", lineNumber : 87, className : "server.rooms.State", methodName : "updateString"});
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).theString = theString_;
	}
}
server_rooms_State.__name__ = true;
class server_rooms_Turn extends colyseus_server_Room {
	constructor(presence) {
		super(presence);
	}
	onInit(options) {
		var theOptions = Config.convertStringToMap("" + Std.string(options));
		haxe_Log.trace("Turn created!",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 15, className : "server.rooms.Turn", methodName : "onInit", customParams : [options]});
		haxe_Log.trace("Turn created theOptions:",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 16, className : "server.rooms.Turn", methodName : "onInit", customParams : [theOptions.toString()]});
		this.myState = new server_rooms_TurnState();
		this.PlayerCounter = 0;
		this.nrOfSeats = Std.parseInt("" + Std.string(__map_reserved["nrOfSeats"] != null ? theOptions.getReserved("nrOfSeats") : theOptions.h["nrOfSeats"]));
		this.setState(this.myState);
		this.setMetadata(options);
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
		haxe_Log.trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 22, className : "server.rooms.Turn", methodName : "onInit"});
	}
	onJoin(client,options,auth) {
		haxe_Log.trace("options " + Std.string(options),{ fileName : "src/server/rooms/Turn.hx", lineNumber : 26, className : "server.rooms.Turn", methodName : "onJoin"});
		var msg = Config.convertStringToMap("" + Std.string(options));
		var PlayerName = __map_reserved["PlayerName"] != null ? msg.getReserved("PlayerName") : msg.h["PlayerName"];
		if(PlayerName == null) {
			PlayerName = "";
		}
		var RoomName = __map_reserved["RoomName"] != null ? msg.getReserved("RoomName") : msg.h["RoomName"];
		if(PlayerName == null) {
			RoomName = "ROOM0";
		}
		var PlayerID = __map_reserved["PlayerID"] != null ? msg.getReserved("PlayerID") : msg.h["PlayerID"];
		if(PlayerID == null) {
			PlayerID = "";
		}
		this.myState.createPlayer(client.sessionId);
		this.myState.addPlayerID(client.sessionId,PlayerID);
		this.myState.addPlayerName(client.sessionId,PlayerName);
		if(this.PlayerCounter + 1 < this.nrOfSeats) {
			this.PlayerCounter++;
			this.myState.setPlayerPos(client.sessionId,this.PlayerCounter);
			this.myState.setLastPlayerPos(client.sessionId,-1);
			this.myState.setNrOfSeats(client.sessionId,this.nrOfSeats);
		}
		return null;
	}
	onLeave(client,consented) {
		this.myState.setLastPlayerPos(client.sessionId,-1);
		this.myState.setPlayerPos(client.sessionId,-1);
		this.myState.removePlayer(client.sessionId);
		return null;
	}
	onMessage(client,data) {
		var isHandled = false;
		haxe_Log.trace("Turn received message from",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 61, className : "server.rooms.Turn", methodName : "onMessage", customParams : [client.sessionId,":",data]});
		if(("" + Std.string(data)).indexOf("SETACTIVESEATNR") > -1) {
			this.myState.setActiveSeatNR(client.sessionId,"" + Std.string(data));
			isHandled = true;
		}
		if(("" + Std.string(data)).indexOf("TURNDATA") > -1) {
			this.myState.setData(client.sessionId,"" + Std.string(data));
			isHandled = true;
		}
		if(("" + Std.string(data)).indexOf("NEXTTURN") > -1) {
			var dummyValue = this.myState.findNextActivePlayer();
			isHandled = true;
		}
		if(("" + Std.string(data)).indexOf("SETMAXPLAYERS") > -1) {
			var MaxPlayersStr = ("" + Std.string(data)).split("=")[1];
			var maxPlayers = Std.parseInt("" + MaxPlayersStr);
			this.maxClients = maxPlayers;
			isHandled = true;
		}
		if(!isHandled) {
			this.myState.updateString(client.sessionId,"" + Std.string(data));
		}
		this.myState.getSeatInfo();
	}
	onDispose() {
		haxe_Log.trace("Dispose Turn",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 99, className : "server.rooms.Turn", methodName : "onDispose"});
		return null;
	}
	requestJoin(options,isNew) {
		var retval = false;
		var oldMax = this.maxClients;
		var PlayerName = "";
		var ActionType = "";
		this.maxClients = 100;
		var prop = Config.convertStringToMap("" + Std.string(options));
		var PlayerName1 = __map_reserved["PlayerName"] != null ? prop.getReserved("PlayerName") : prop.h["PlayerName"];
		var PlayerID = __map_reserved["PlayerID"] != null ? prop.getReserved("PlayerID") : prop.h["PlayerID"];
		var ActionType1 = __map_reserved["CreateOrJoin"] != null ? prop.getReserved("CreateOrJoin") : prop.h["CreateOrJoin"];
		var RoomID1 = __map_reserved["RoomID"] != null ? prop.getReserved("RoomID") : prop.h["RoomID"];
		var MaxPlayers = __map_reserved["MaxPlayers"] != null ? prop.getReserved("MaxPlayers") : prop.h["MaxPlayers"];
		if(PlayerName1 == null) {
			PlayerName1 = "";
		}
		if(PlayerID == null) {
			PlayerID = "";
		}
		if(ActionType1 == null) {
			ActionType1 = "";
		}
		if(RoomID1 == null) {
			RoomID1 = "";
		}
		if(MaxPlayers == null) {
			MaxPlayers = "";
		}
		if(MaxPlayers != "") {
			this.maxClients = Std.parseInt(MaxPlayers);
		}
		haxe_Log.trace("Request join : this.roomId: |" + this.roomId + "| Type: |" + ActionType1 + "| PlayerName: |" + PlayerName1 + "| PlayerID: |" + PlayerID + "| OldMax: |" + oldMax + "| ",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 130, className : "server.rooms.Turn", methodName : "requestJoin"});
		if(ActionType1 != "JOIN" && ("" + oldMax).indexOf("Infinity") > -1) {
			retval = true;
		} else if(ActionType1 == "JOIN") {
			if(this.roomId == RoomID1) {
				retval = true;
			} else {
				retval = false;
			}
		} else {
			retval = false;
		}
		return retval;
	}
}
server_rooms_Turn.__name__ = true;
class server_rooms_TurnPlayer extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.theString = "NULL";
		this.playerName = "TestPlayerName";
		this.playerID = "";
		this.SeatNR = 0;
		this.ActivePlayer = "";
	}
}
server_rooms_TurnPlayer.__name__ = true;
class server_rooms_TurnState extends colyseus_server_schema_Schema {
	constructor() {
		super();
		this.seperateSplit = "@|;|@";
		this.oldNewSplit = "@$,$@";
		this.equalSplit = "@=@";
		this.TurnDataMap = new haxe_ds_StringMap();
		this.players = new colyseus_server_schema_MapSchema();
		this.active = new server_rooms_Active(this.players);
	}
	createPlayer(id) {
		colyseus_server_schema_MapSchemaUtil.set(this.players,id,new server_rooms_TurnPlayer());
	}
	removePlayer(id) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).theString = "";
		this.active.removePlayer(id);
	}
	findNextActivePlayer() {
		return this.active.findNextActivePlayer();
	}
	updateString(id,theString_) {
		haxe_Log.trace("Update String: " + theString_,{ fileName : "src/server/rooms/Turn.hx", lineNumber : 317, className : "server.rooms.TurnState", methodName : "updateString"});
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).theString = "" + theString_;
	}
	setPlayerPos(id,playerPos) {
		if(colyseus_server_schema_MapSchemaUtil.get(this.players,id) != null) {
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).PlayerPos = playerPos;
		}
	}
	setLastPlayerPos(id,lastPlayerPos) {
		if(colyseus_server_schema_MapSchemaUtil.get(this.players,id) != null) {
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).lastPlayerPos = lastPlayerPos;
		}
	}
	setNrOfSeats(id,nrOfSeats) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).nrOfSeats = nrOfSeats;
	}
	addPlayerName(id,PlayerName) {
		this.active.addPlayerName(id,PlayerName);
	}
	addPlayerID(id,PlayerID) {
		colyseus_server_schema_MapSchemaUtil.get(this.players,id).playerID = "" + PlayerID;
	}
	getSeatInfo() {
		this.active.getSeatInfo();
	}
	setActiveSeatNR(id,data) {
		var setActiveSeatList = data.split("SETACTIVESEATNR:");
		this.active.setActiveSeatNR(Std.parseInt("" + setActiveSeatList[1]));
	}
	setData(id,data) {
		var setDataList = data.split(this.seperateSplit);
		haxe_Log.trace(" (TURNsetdata) Contents of setDataList : " + Std.string(setDataList),{ fileName : "src/server/rooms/Turn.hx", lineNumber : 386, className : "server.rooms.TurnState", methodName : "setData"});
		var objectCounter = 0;
		while(objectCounter < setDataList.length) {
			var objectString = setDataList[objectCounter];
			if(objectString.indexOf(this.oldNewSplit) > -1) {
				var object = objectString.split(this.equalSplit)[0];
				var newValue = objectString.split(this.equalSplit)[1].split(this.oldNewSplit)[0];
				haxe_Log.trace(" (setdata) object=" + object + "   newValue=" + newValue + " ",{ fileName : "src/server/rooms/Turn.hx", lineNumber : 394, className : "server.rooms.TurnState", methodName : "setData"});
				var _this = this.TurnDataMap;
				if(__map_reserved[object] != null) {
					_this.setReserved(object,newValue);
				} else {
					_this.h[object] = newValue;
				}
			}
			++objectCounter;
		}
		if(objectCounter > 1) {
			colyseus_server_schema_MapSchemaUtil.get(this.players,id).theString = "" + data;
		}
		var _g = 0;
		var _g1 = this.active.getRoomPlayers();
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			colyseus_server_schema_MapSchemaUtil.get(this.players,p).theString = "" + data;
		}
	}
}
server_rooms_TurnState.__name__ = true;
function $getIterator(o) { if( o instanceof Array ) return HxOverrides.iter(o); else return o.iterator(); }
String.__name__ = true;
Array.__name__ = true;
Date.__name__ = "Date";
var __map_reserved = {};
Object.defineProperty(js__$Boot_HaxeError.prototype,"message",{ get : function() {
	return String(this.val);
}});
js_Boot.__toStr = ({ }).toString;
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LobbyPlayer.prototype,"playerName");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LobbyPlayer.prototype,"ApplicationID");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LobbyPlayer.prototype,"playerID");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LobbyPlayer.prototype,"roomInfo");
(colyseus_server_schema_ExternDecorator.type({ map : server_rooms_LobbyPlayer}))(server_rooms_LobbyState.prototype,"players");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LockPlayer.prototype,"theString");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LockPlayer.prototype,"playerName");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LockPlayer.prototype,"playerID");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LockPlayer.prototype,"lockState");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LockPlayer.prototype,"lockData");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_LockPlayer.prototype,"SeatNR");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_LockPlayer.prototype,"ActivePlayer");
(colyseus_server_schema_ExternDecorator.type({ map : server_rooms_LockPlayer}))(server_rooms_LockState.prototype,"players");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_RawPlayer.prototype,"theString");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_RawPlayer.prototype,"playerName");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_RawPlayer.prototype,"playerID");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_RawPlayer.prototype,"SeatNR");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_RawPlayer.prototype,"ActivePlayer");
(colyseus_server_schema_ExternDecorator.type({ map : server_rooms_RawPlayer}))(server_rooms_RawState.prototype,"players");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_Player.prototype,"x");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_Player.prototype,"y");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_Player.prototype,"theString");
(colyseus_server_schema_ExternDecorator.type({ map : server_rooms_Player}))(server_rooms_State.prototype,"players");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_TurnPlayer.prototype,"theString");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_TurnPlayer.prototype,"playerName");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_TurnPlayer.prototype,"playerID");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_TurnPlayer.prototype,"SeatNR");
(colyseus_server_schema_ExternDecorator.type("string"))(server_rooms_TurnPlayer.prototype,"ActivePlayer");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_TurnPlayer.prototype,"PlayerPos");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_TurnPlayer.prototype,"lastPlayerPos");
(colyseus_server_schema_ExternDecorator.type("number"))(server_rooms_TurnPlayer.prototype,"nrOfSeats");
(colyseus_server_schema_ExternDecorator.type({ map : server_rooms_TurnPlayer}))(server_rooms_TurnState.prototype,"players");
MainServer.main();
})();
