import { Schema } from "./Schema";
import { ArraySchema } from "./types/ArraySchema";
import { MapSchema } from "./types/MapSchema";
declare type FieldKey = string | number | symbol;
export declare class ChangeTree {
    changed: boolean;
    changes: FieldKey[];
    allChanges: FieldKey[];
    /**
     * `MapSchema` / `ArraySchema`
     */
    indexMap: Map<any, FieldKey>;
    indexChange: Map<any, FieldKey>;
    /**
     * parent link & field name
     */
    parent: ChangeTree;
    parentField: FieldKey;
    linkedTrees: ChangeTree[];
    protected trackAllChanges: boolean;
    constructor(parentField?: FieldKey, parent?: ChangeTree, trackAllChanges?: boolean);
    link(linkedTree: ChangeTree): void;
    change(field: FieldKey, isDelete?: boolean): void;
    mapIndex(instance: any, key: FieldKey): void;
    getIndex(instance: any): string | number | symbol;
    deleteIndex(instance: any): void;
    mapIndexChange(instance: any, key: FieldKey): void;
    getIndexChange(instance: any): string | number | symbol;
    deleteIndexChange(instance: any): void;
    changeAll(obj: Schema | ArraySchema | MapSchema): void;
    discard(): void;
}
export {};
