"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Schema_1 = require("./Schema");
var ArraySchema_1 = require("./types/ArraySchema");
var MapSchema_1 = require("./types/MapSchema");
var ChangeTree = /** @class */ (function () {
    function ChangeTree(parentField, parent, trackAllChanges) {
        if (parentField === void 0) { parentField = null; }
        if (trackAllChanges === void 0) { trackAllChanges = false; }
        this.changed = false;
        this.changes = [];
        this.allChanges = [];
        this.linkedTrees = [];
        this.parent = parent;
        this.parentField = parentField;
        this.trackAllChanges = trackAllChanges;
    }
    ChangeTree.prototype.link = function (linkedTree) {
        this.linkedTrees.push(linkedTree);
    };
    ChangeTree.prototype.change = function (field, isDelete) {
        if (isDelete === void 0) { isDelete = false; }
        this.changed = true;
        if (this.changes.indexOf(field) === -1) {
            this.changes.push(field);
        }
        var allChangesIndex = this.allChanges.indexOf(field);
        if (!isDelete && allChangesIndex === -1) {
            this.allChanges.push(field);
        }
        else if (isDelete && allChangesIndex >= 0) {
            // discard all-changes for removed items.
            this.allChanges.splice(allChangesIndex, 1);
        }
        if (this.parent) {
            this.parent.change(this.parentField);
        }
    };
    ChangeTree.prototype.mapIndex = function (instance, key) {
        if (!this.indexMap) {
            this.indexMap = new Map();
            this.indexChange = new Map();
        }
        this.indexMap.set(instance, key);
    };
    ChangeTree.prototype.getIndex = function (instance) {
        return this.indexMap && this.indexMap.get(instance);
    };
    ChangeTree.prototype.deleteIndex = function (instance) {
        this.indexMap.delete(instance);
    };
    ChangeTree.prototype.mapIndexChange = function (instance, key) {
        this.indexChange.set(instance, key);
    };
    ChangeTree.prototype.getIndexChange = function (instance) {
        return this.indexChange && this.indexChange.get(instance);
    };
    ChangeTree.prototype.deleteIndexChange = function (instance) {
        this.indexChange.delete(instance);
    };
    ChangeTree.prototype.changeAll = function (obj) {
        if (obj instanceof Schema_1.Schema) {
            var schema = obj._schema;
            for (var field in schema) {
                // ensure ArraySchema and MapSchema already initialized
                // on its structure have a valid parent.
                if ((obj[field] instanceof Schema_1.Schema ||
                    obj[field] instanceof ArraySchema_1.ArraySchema ||
                    obj[field] instanceof MapSchema_1.MapSchema) &&
                    !obj[field].$changes.parent.parent) {
                    obj[field].$changes.parent = this;
                }
                this.change(field);
            }
        }
        else {
            var keys = Object.keys(obj);
            for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                var key = keys_1[_i];
                this.change(key);
            }
        }
    };
    ChangeTree.prototype.discard = function () {
        this.changed = false;
        this.changes = [];
        if (this.indexChange) {
            this.indexChange.clear();
        }
    };
    return ChangeTree;
}());
exports.ChangeTree = ChangeTree;
