import { Definition, FilterCallback, Client, Context } from "./annotations";
import * as decode from "./encoding/decode";
import { ChangeTree } from "./ChangeTree";
export interface DataChange<T = any> {
    field: string;
    value: T;
    previousValue: T;
}
/**
 * Schema encoder / decoder
 */
export declare abstract class Schema {
    static _typeid: number;
    static _context: Context;
    static _schema: Definition;
    static _indexes: {
        [field: string]: number;
    };
    static _filters: {
        [field: string]: FilterCallback;
    };
    static _descriptors: PropertyDescriptorMap & ThisType<any>;
    protected $changes: ChangeTree;
    onChange?(changes: DataChange[]): any;
    onRemove?(): any;
    constructor(...args: any[]);
    readonly _schema: Definition;
    readonly _descriptors: PropertyDescriptorMap & ThisType<any>;
    readonly _indexes: {
        [field: string]: number;
    };
    readonly _filters: {
        [field: string]: FilterCallback;
    };
    readonly $changed: boolean;
    decode(bytes: any, it?: decode.Iterator): this;
    encode(root?: Schema, encodeAll?: boolean, client?: Client): any[];
    encodeFiltered(client: Client): any[];
    encodeAll(): any[];
    encodeAllFiltered(client: Client): any[];
    clone(): any;
    triggerAll(): void;
    toJSON(): {};
    private tryEncodeTypeId;
    private createTypeInstance;
}
