"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var spec_1 = require("./spec");
var encode = require("./encoding/encode");
var decode = require("./encoding/decode");
var ArraySchema_1 = require("./types/ArraySchema");
var MapSchema_1 = require("./types/MapSchema");
var ChangeTree_1 = require("./ChangeTree");
var EncodeSchemaError = /** @class */ (function (_super) {
    __extends(EncodeSchemaError, _super);
    function EncodeSchemaError() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return EncodeSchemaError;
}(Error));
function assertType(value, type, klass, field) {
    var typeofTarget;
    var allowNull = false;
    switch (type) {
        case "number":
        case "int8":
        case "uint8":
        case "int16":
        case "uint16":
        case "int32":
        case "uint32":
        case "int64":
        case "uint64":
        case "float32":
        case "float64":
            typeofTarget = "number";
            if (isNaN(value)) {
                console.log("trying to encode \"NaN\" in " + klass.constructor.name + "#" + field);
            }
            break;
        case "string":
            typeofTarget = "string";
            allowNull = true;
            break;
        case "boolean":
            // boolean is always encoded as true/false based on truthiness
            return;
    }
    if (typeof (value) !== typeofTarget && (!allowNull || (allowNull && value !== null))) {
        var foundValue = "'" + JSON.stringify(value) + "'" + (value && value.constructor && " (" + value.constructor.name + ")");
        throw new EncodeSchemaError("a '" + typeofTarget + "' was expected, but " + foundValue + " was provided in " + klass.constructor.name + "#" + field);
    }
}
function assertInstanceType(value, type, klass, field) {
    if (!(value instanceof type)) {
        throw new EncodeSchemaError("a '" + type.name + "' was expected, but '" + value.constructor.name + "' was provided in " + klass.constructor.name + "#" + field);
    }
}
function encodePrimitiveType(type, bytes, value, klass, field) {
    var encodeFunc = encode[type];
    if (value === undefined) {
        bytes.push(spec_1.NIL);
    }
    else {
        assertType(value, type, klass, field);
    }
    if (encodeFunc) {
        encodeFunc(bytes, value);
        return true;
    }
    else {
        return false;
    }
}
function decodePrimitiveType(type, bytes, it) {
    var decodeFunc = decode[type];
    if (decodeFunc) {
        return decodeFunc(bytes, it);
    }
    else {
        return null;
    }
}
/**
 * Schema encoder / decoder
 */
var Schema = /** @class */ (function () {
    // allow inherited classes to have a constructor
    function Schema() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        // fix enumerability of fields for end-user
        Object.defineProperties(this, {
            $changes: { value: new ChangeTree_1.ChangeTree(), enumerable: false, writable: true },
        });
        var descriptors = this._descriptors;
        if (descriptors) {
            Object.defineProperties(this, descriptors);
        }
    }
    Object.defineProperty(Schema.prototype, "_schema", {
        get: function () { return this.constructor._schema; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Schema.prototype, "_descriptors", {
        get: function () { return this.constructor._descriptors; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Schema.prototype, "_indexes", {
        get: function () { return this.constructor._indexes; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Schema.prototype, "_filters", {
        get: function () { return this.constructor._filters; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Schema.prototype, "$changed", {
        get: function () { return this.$changes.changed; },
        enumerable: true,
        configurable: true
    });
    Schema.prototype.decode = function (bytes, it) {
        if (it === void 0) { it = { offset: 0 }; }
        var changes = [];
        var schema = this._schema;
        var indexes = this._indexes;
        var fieldsByIndex = {};
        Object.keys(indexes).forEach(function (key) {
            var value = indexes[key];
            fieldsByIndex[value] = key;
        });
        var totalBytes = bytes.length;
        // skip TYPE_ID of existing instances
        if (bytes[it.offset] === spec_1.TYPE_ID) {
            it.offset += 2;
        }
        var _loop_1 = function () {
            var index = bytes[it.offset++];
            if (index === spec_1.END_OF_STRUCTURE) {
                return "break";
            }
            var field = fieldsByIndex[index];
            var type = schema[field];
            var value = void 0;
            var change = void 0; // for triggering onChange
            var hasChange = false;
            if (type._schema) {
                if (decode.nilCheck(bytes, it)) {
                    it.offset++;
                    value = null;
                }
                else {
                    value = this_1["_" + field] || this_1.createTypeInstance(bytes, it, type);
                    value.decode(bytes, it);
                }
                hasChange = true;
            }
            else if (Array.isArray(type)) {
                type = type[0];
                change = [];
                var valueRef_1 = this_1["_" + field] || new ArraySchema_1.ArraySchema();
                value = valueRef_1.clone();
                var newLength_1 = decode.number(bytes, it);
                var numChanges = Math.min(decode.number(bytes, it), newLength_1);
                hasChange = (numChanges > 0);
                // FIXME: this may not be reliable. possibly need to encode this variable during
                // serializagion
                var hasIndexChange = false;
                // ensure current array has the same length as encoded one
                if (value.length > newLength_1) {
                    // decrease removed items from number of changes.
                    // no need to iterate through them, as they're going to be removed.
                    value.splice(newLength_1).forEach(function (itemRemoved, i) {
                        if (itemRemoved && itemRemoved.onRemove) {
                            itemRemoved.onRemove();
                        }
                        if (valueRef_1.onRemove) {
                            valueRef_1.onRemove(itemRemoved, newLength_1 + i);
                        }
                    });
                }
                for (var i = 0; i < numChanges; i++) {
                    var newIndex = decode.number(bytes, it);
                    var indexChangedFrom = void 0; // index change check
                    if (decode.indexChangeCheck(bytes, it)) {
                        decode.uint8(bytes, it);
                        indexChangedFrom = decode.number(bytes, it);
                        hasIndexChange = true;
                    }
                    // // Simplified method?
                    // let isNew = (
                    //     (value[newIndex] !== valueRef[newIndex]) ||
                    //     (value[newIndex] === undefined && valueRef[newIndex] === undefined)
                    // ) && indexChangedFrom === undefined;
                    var isNew = (!hasIndexChange && !value[newIndex]) || (hasIndexChange && indexChangedFrom === undefined);
                    if (type.prototype instanceof Schema) {
                        var item = void 0;
                        if (isNew) {
                            item = this_1.createTypeInstance(bytes, it, type);
                        }
                        else if (indexChangedFrom !== undefined) {
                            item = valueRef_1[indexChangedFrom];
                        }
                        else {
                            item = valueRef_1[newIndex];
                        }
                        if (!item) {
                            item = this_1.createTypeInstance(bytes, it, type);
                            isNew = true;
                        }
                        if (decode.nilCheck(bytes, it)) {
                            it.offset++;
                            if (valueRef_1.onRemove) {
                                valueRef_1.onRemove(item, newIndex);
                            }
                            continue;
                        }
                        item.decode(bytes, it);
                        value[newIndex] = item;
                    }
                    else {
                        value[newIndex] = decodePrimitiveType(type, bytes, it);
                    }
                    if (isNew) {
                        if (valueRef_1.onAdd) {
                            valueRef_1.onAdd(value[newIndex], newIndex);
                        }
                    }
                    else if (valueRef_1.onChange) {
                        valueRef_1.onChange(value[newIndex], newIndex);
                    }
                    change.push(value[newIndex]);
                }
            }
            else if (type.map) {
                type = type.map;
                var valueRef = this_1["_" + field] || new MapSchema_1.MapSchema();
                value = valueRef.clone();
                var length = decode.number(bytes, it);
                hasChange = (length > 0);
                // FIXME: this may not be reliable. possibly need to encode this variable during
                // serializagion
                var hasIndexChange = false;
                var previousKeys = Object.keys(valueRef);
                for (var i = 0; i < length; i++) {
                    // `encodeAll` may indicate a higher number of indexes it actually encodes
                    // TODO: do not encode a higher number than actual encoded entries
                    if (bytes[it.offset] === undefined ||
                        bytes[it.offset] === spec_1.END_OF_STRUCTURE) {
                        break;
                    }
                    // index change check
                    var previousKey = void 0;
                    if (decode.indexChangeCheck(bytes, it)) {
                        decode.uint8(bytes, it);
                        previousKey = previousKeys[decode.number(bytes, it)];
                        hasIndexChange = true;
                    }
                    var hasMapIndex = decode.numberCheck(bytes, it);
                    var isSchemaType = typeof (type) !== "string";
                    var newKey = (hasMapIndex)
                        ? previousKeys[decode.number(bytes, it)]
                        : decode.string(bytes, it);
                    var item = void 0;
                    var isNew = (!hasIndexChange && !valueRef[newKey]) || (hasIndexChange && previousKey === undefined && hasMapIndex);
                    if (isNew && isSchemaType) {
                        item = this_1.createTypeInstance(bytes, it, type);
                    }
                    else if (previousKey !== undefined) {
                        item = valueRef[previousKey];
                    }
                    else {
                        item = valueRef[newKey];
                    }
                    if (decode.nilCheck(bytes, it)) {
                        it.offset++;
                        if (item && item.onRemove) {
                            item.onRemove();
                        }
                        if (valueRef.onRemove) {
                            valueRef.onRemove(item, newKey);
                        }
                        delete value[newKey];
                        continue;
                    }
                    else if (!isSchemaType) {
                        value[newKey] = decodePrimitiveType(type, bytes, it);
                    }
                    else {
                        item.decode(bytes, it);
                        value[newKey] = item;
                    }
                    if (isNew) {
                        if (valueRef.onAdd) {
                            valueRef.onAdd(item, newKey);
                        }
                    }
                    else if (valueRef.onChange) {
                        valueRef.onChange(item, newKey);
                    }
                }
            }
            else {
                value = decodePrimitiveType(type, bytes, it);
                hasChange = true;
            }
            if (hasChange && this_1.onChange) {
                changes.push({
                    field: field,
                    value: change || value,
                    previousValue: this_1["_" + field]
                });
            }
            this_1["_" + field] = value;
        };
        var this_1 = this;
        while (it.offset < totalBytes) {
            var state_1 = _loop_1();
            if (state_1 === "break")
                break;
        }
        if (this.onChange && changes.length > 0) {
            this.onChange(changes);
        }
        return this;
    };
    Schema.prototype.encode = function (root, encodeAll, client) {
        var _this = this;
        if (root === void 0) { root = this; }
        if (encodeAll === void 0) { encodeAll = false; }
        var encodedBytes = [];
        var endStructure = function () {
            if (_this !== root) {
                encodedBytes.push(spec_1.END_OF_STRUCTURE);
            }
        };
        // skip if nothing has changed
        if (!this.$changes.changed && !encodeAll) {
            endStructure();
            return encodedBytes;
        }
        var schema = this._schema;
        var indexes = this._indexes;
        var filters = this._filters;
        var changes = (encodeAll || client)
            ? this.$changes.allChanges
            : this.$changes.changes;
        var _loop_2 = function (i, l) {
            var field = changes[i];
            var type = schema[field];
            var filter = (filters && filters[field]);
            // const value = (filter && this.$allChanges[field]) || changes[field];
            var value = this_2["_" + field];
            var fieldIndex = indexes[field];
            // skip unchagned fields
            if (value === undefined) {
                return "continue";
            }
            var bytes = [];
            if (type._schema) {
                if (client && filter) {
                    // skip if not allowed by custom filter
                    if (!filter.call(this_2, client, value, root)) {
                        return "continue";
                    }
                }
                encode.number(bytes, fieldIndex);
                // encode child object
                if (value) {
                    assertInstanceType(value, type, this_2, field);
                    this_2.tryEncodeTypeId(bytes, type, value.constructor);
                    bytes = bytes.concat(value.encode(root, encodeAll, client));
                }
                else {
                    // value has been removed
                    encode.uint8(bytes, spec_1.NIL);
                }
            }
            else if (Array.isArray(type)) {
                encode.number(bytes, fieldIndex);
                // total of items in the array
                encode.number(bytes, value.length);
                var arrayChanges = ((encodeAll || client)
                    ? value.$changes.allChanges
                    : value.$changes.changes).filter(function (index) { return _this["_" + field][index] !== undefined; });
                // ensure number of changes doesn't exceed array length
                var numChanges = arrayChanges.length;
                // number of changed items
                encode.number(bytes, numChanges);
                var isChildSchema = typeof (type[0]) !== "string";
                // assert ArraySchema was provided
                assertInstanceType(this_2["_" + field], ArraySchema_1.ArraySchema, this_2, field);
                // encode Array of type
                for (var j = 0; j < numChanges; j++) {
                    var index = arrayChanges[j];
                    var item = this_2["_" + field][index];
                    if (client && filter) {
                        // skip if not allowed by custom filter
                        if (!filter.call(this_2, client, item, root)) {
                            continue;
                        }
                    }
                    if (isChildSchema) { // is array of Schema
                        encode.number(bytes, index);
                        var indexChange = value.$changes.getIndexChange(item);
                        if (indexChange !== undefined) {
                            encode.uint8(bytes, spec_1.INDEX_CHANGE);
                            encode.number(bytes, indexChange);
                        }
                        assertInstanceType(item, type[0], this_2, field);
                        this_2.tryEncodeTypeId(bytes, type[0], item.constructor);
                        bytes = bytes.concat(item.encode(root, encodeAll, client));
                    }
                    else {
                        encode.number(bytes, index);
                        if (!encodePrimitiveType(type[0], bytes, item, this_2, field)) {
                            console.log("cannot encode", schema[field]);
                            continue;
                        }
                    }
                }
                if (!encodeAll) {
                    value.$changes.discard();
                }
            }
            else if (type.map) {
                // encode Map of type
                encode.number(bytes, fieldIndex);
                // TODO: during `encodeAll`, removed entries are not going to be encoded
                var keys = (encodeAll || client)
                    ? value.$changes.allChanges
                    : value.$changes.changes;
                encode.number(bytes, keys.length);
                var previousKeys = Object.keys(this_2["_" + field]);
                var isChildSchema = typeof (type.map) !== "string";
                // assert MapSchema was provided
                assertInstanceType(this_2["_" + field], MapSchema_1.MapSchema, this_2, field);
                for (var i_1 = 0; i_1 < keys.length; i_1++) {
                    var key = (typeof (keys[i_1]) === "number" && previousKeys[keys[i_1]]) || keys[i_1];
                    var item = this_2["_" + field][key];
                    var mapItemIndex = this_2["_" + field]._indexes.get(key);
                    if (client && filter) {
                        // skip if not allowed by custom filter
                        if (!filter.call(this_2, client, item, root)) {
                            continue;
                        }
                    }
                    if (encodeAll) {
                        if (item !== undefined) {
                            mapItemIndex = undefined;
                        }
                        else {
                            // previously deleted items are skipped during `encodeAll`
                            continue;
                        }
                    }
                    // encode index change
                    var indexChange = value.$changes.getIndexChange(item);
                    if (item && indexChange !== undefined) {
                        encode.uint8(bytes, spec_1.INDEX_CHANGE);
                        encode.number(bytes, this_2["_" + field]._indexes.get(indexChange));
                    }
                    if (mapItemIndex !== undefined) {
                        encode.number(bytes, mapItemIndex);
                    }
                    else {
                        // TODO: remove item
                        encode.string(bytes, key);
                    }
                    if (item && isChildSchema) {
                        assertInstanceType(item, type.map, this_2, field);
                        this_2.tryEncodeTypeId(bytes, type.map, item.constructor);
                        bytes = bytes.concat(item.encode(root, encodeAll, client));
                    }
                    else if (item !== undefined) {
                        encodePrimitiveType(type.map, bytes, item, this_2, field);
                    }
                    else {
                        encode.uint8(bytes, spec_1.NIL);
                    }
                }
                if (!encodeAll) {
                    value.$changes.discard();
                    // TODO: track array/map indexes per client?
                    if (!client) {
                        this_2["_" + field]._updateIndexes();
                    }
                }
            }
            else {
                if (client && filter) {
                    // skip if not allowed by custom filter
                    if (!filter.call(this_2, client, value, root)) {
                        return "continue";
                    }
                }
                encode.number(bytes, fieldIndex);
                if (!encodePrimitiveType(type, bytes, value, this_2, field)) {
                    console.log("cannot encode", schema[field]);
                    return "continue";
                }
            }
            encodedBytes = encodedBytes.concat(bytes);
        };
        var this_2 = this;
        for (var i = 0, l = changes.length; i < l; i++) {
            _loop_2(i, l);
        }
        // flag end of Schema object structure
        endStructure();
        if (!encodeAll && !client) {
            this.$changes.discard();
        }
        return encodedBytes;
    };
    Schema.prototype.encodeFiltered = function (client) {
        return this.encode(this, false, client);
    };
    Schema.prototype.encodeAll = function () {
        return this.encode(this, true);
    };
    Schema.prototype.encodeAllFiltered = function (client) {
        return this.encode(this, true, client);
    };
    Schema.prototype.clone = function () {
        var cloned = new (this.constructor);
        var schema = this._schema;
        for (var field in schema) {
            cloned[field] = this[field];
        }
        return cloned;
    };
    Schema.prototype.triggerAll = function () {
        if (!this.onChange) {
            return;
        }
        var changes = [];
        var schema = this._schema;
        for (var field in schema) {
            if (this[field] !== undefined) {
                changes.push({
                    field: field,
                    value: this[field],
                    previousValue: undefined
                });
            }
        }
        this.onChange(changes);
    };
    Schema.prototype.toJSON = function () {
        var schema = this._schema;
        var obj = {};
        for (var field in schema) {
            obj[field] = this["_" + field];
        }
        return obj;
    };
    Schema.prototype.tryEncodeTypeId = function (bytes, type, targetType) {
        if (type._typeid !== targetType._typeid) {
            encode.uint8(bytes, spec_1.TYPE_ID);
            encode.uint8(bytes, targetType._typeid);
        }
    };
    Schema.prototype.createTypeInstance = function (bytes, it, type) {
        if (bytes[it.offset] === spec_1.TYPE_ID) {
            it.offset++;
            var anotherType = this.constructor._context.get(decode.uint8(bytes, it));
            return new anotherType();
        }
        else {
            return new type();
        }
    };
    return Schema;
}());
exports.Schema = Schema;
