import { Schema } from './Schema';
/**
 * Data types
 */
export declare type PrimitiveType = "string" | "number" | "boolean" | "int8" | "uint8" | "int16" | "uint16" | "int32" | "uint32" | "int64" | "uint64" | "float32" | "float64" | typeof Schema;
export declare type DefinitionType = (PrimitiveType | PrimitiveType[] | {
    map: PrimitiveType;
});
export declare type Definition = {
    [field: string]: DefinitionType;
};
export declare type FilterCallback = (this: Schema, client: Client, instance: Schema, root?: Schema) => boolean;
export declare type Client = {
    sessionId: string;
} & any;
export declare class Context {
    types: {
        [id: number]: typeof Schema;
    };
    schemas: Map<typeof Schema, number>;
    has(schema: typeof Schema): boolean;
    get(typeid: number): typeof Schema;
    add(schema: typeof Schema): void;
}
export declare const globalContext: Context;
/**
 * `@type()` decorator for proxies
 */
export declare function type(type: DefinitionType, context?: Context): PropertyDecorator;
/**
 * `@filter()` decorator for defining data filters per client
 */
export declare function filter(cb: FilterCallback): PropertyDecorator;
