"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @author Ethan Davis
 * https://github.com/ethanent/gar
 */
exports.default = (function (sargs) {
    var props = {};
    var lones = [];
    var convertIfApplicable = function (value) { return (isNaN(value) ? (value.toString().toLowerCase() === 'true' ? true : (value.toString().toLowerCase() === 'false' ? false : value)) : Number(value)); };
    var removeStartHyphens = function (value) { return value.replace(/^\-+/g, ''); };
    for (var i = 0; i < sargs.length; i++) {
        var equalsIndex = sargs[i].indexOf('=');
        var isNextRefProp = sargs[i].charAt(0) === '-' && sargs.length - 1 >= i + 1 && sargs[i + 1].indexOf('=') === -1 && sargs[i + 1].charAt(0) !== '-';
        var argName = equalsIndex === -1 ? removeStartHyphens(sargs[i]) : removeStartHyphens(sargs[i].slice(0, equalsIndex));
        if (equalsIndex !== -1) {
            props[argName] = convertIfApplicable(sargs[i].slice(equalsIndex + 1));
        }
        else if (isNextRefProp) {
            props[argName] = convertIfApplicable(sargs[i + 1]);
            i++;
        }
        else if (sargs[i].charAt(0) === '-') {
            if (sargs[i].charAt(1) === '-') {
                props[argName] = true;
            }
            else {
                for (var b = 0; b < argName.length; b++) {
                    props[argName.charAt(b)] = true;
                }
            }
        }
        else {
            lones.push(convertIfApplicable(argName));
        }
    }
    return Object.assign(props, {
        '_': lones
    });
});
