"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var path = require("path");
var argv_1 = require("./argv");
var parser_1 = require("./parser");
function displayHelp() {
    console.log("\nschema-codegen [path/to/Schema.ts]\n\nUsage (C#/Unity)\n    schema-codegen src/Schema.ts --output client-side/ --csharp --namespace MyGame.Schema\n\nValid options:\n    --output: the output directory for generated client-side schema files\n    --csharp: generate files for C#/Unity\n    --cpp: generate files for C++\n    --hx: generate files for Haxe\n\nOptional:\n    --namespace: generate namespace on output code\n    --decorator: custom name for @type decorator to scan for");
    process.exit();
}
var args = argv_1.default(process.argv.slice(2));
if (args.help) {
    displayHelp();
}
var generatorId;
if (args.csharp) {
    generatorId = 'csharp';
}
else if (args.haxe) {
    generatorId = 'haxe';
}
else if (args.cpp) {
    generatorId = 'cpp';
}
var decoratorName = "type";
if (args.decorator) {
    decoratorName = args.decorator;
}
if (!args.output) {
    console.error("You must provide a valid --output directory.");
    displayHelp();
}
var generator;
try {
    generator = require('./' + generatorId).generate;
}
catch (e) {
    console.error("You must provide a valid generator as argument, such as: --csharp, --haxe or --cpp");
    displayHelp();
}
if (!fs.existsSync(args.output)) {
    console.log("Creating", args.output, "directory");
    fs.mkdirSync(args.output);
}
var classes = parser_1.parseFiles(args._, decoratorName);
var files = generator(classes, args);
files.forEach(function (file) {
    var outputPath = path.resolve(args.output, file.name);
    fs.writeFileSync(outputPath, file.content);
    console.log("generated:", file.name);
});
