"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("./types");
var typeMaps = {
    "string": "string",
    "number": "varint_t",
    "boolean": "bool",
    "int8": "int8_t",
    "uint8": "uint8_t",
    "int16": "int16_t",
    "uint16": "uint16_t",
    "int32": "int32_t",
    "uint32": "uint32_t",
    "int64": "int64_t",
    "uint64": "uint64_t",
    "float32": "float32_t",
    "float64": "float64_t",
};
var typeInitializer = {
    "string": '""',
    "number": "0",
    "boolean": "false",
    "int8": "0",
    "uint8": "0",
    "int16": "0",
    "uint16": "0",
    "int32": "0",
    "uint32": "0",
    "int64": "0",
    "uint64": "0",
    "float32": "0",
    "float64": "0",
};
/**
 * C++ Code Generator
 */
var capitalize = function (s) {
    if (typeof s !== 'string')
        return '';
    return s.charAt(0).toUpperCase() + s.slice(1);
};
var distinct = function (value, index, self) { return self.indexOf(value) === index; };
function generate(classes, args) {
    return classes.map(function (klass) { return ({
        name: klass.name + ".hpp",
        content: generateClass(klass, args.namespace, classes)
    }); });
}
exports.generate = generate;
function getInheritanceTree(klass, allClasses, includeSelf) {
    if (includeSelf === void 0) { includeSelf = true; }
    var currentClass = klass;
    var inheritanceTree = [];
    if (includeSelf) {
        inheritanceTree.push(currentClass);
    }
    while (currentClass.extends !== "Schema") {
        currentClass = allClasses.find(function (klass) { return klass.name == currentClass.extends; });
        inheritanceTree.push(currentClass);
    }
    return inheritanceTree;
}
function generateClass(klass, namespace, allClasses) {
    var propertiesPerType = {};
    var allRefs = [];
    klass.properties.forEach(function (property) {
        var type = property.type;
        if (!propertiesPerType[type]) {
            propertiesPerType[type] = [];
        }
        propertiesPerType[type].push(property);
        // keep all refs list
        if ((type === "ref" || type === "array" || type === "map")) {
            allRefs.push(property);
        }
    });
    var allProperties = getAllProperties(klass, allClasses);
    var createInstanceMethod = (allRefs.length === 0) ? "" :
        "\tSchema* createInstance(std::type_index type) {\n\t\t" + generateFieldIfElseChain(allRefs, function (property) { return "type == typeid(" + property.childType + ")"; }, function (property) { return "return new " + property.childType + "();"; }, function (property) { return typeMaps[property.childType] === undefined; }) + "\n\t\treturn " + klass.extends + "::createInstance(type);\n\t}";
    return types_1.getCommentHeader() + "\n#ifndef __SCHEMA_CODEGEN_" + klass.name.toUpperCase() + "_H__\n#define __SCHEMA_CODEGEN_" + klass.name.toUpperCase() + "_H__ 1\n\n#include \"schema.h\"\n#include <typeinfo>\n#include <typeindex>\n\n" + allRefs.
        filter(function (ref) { return ref.childType && typeMaps[ref.childType] === undefined; }).
        map(function (ref) { return ref.childType; }).
        concat(getInheritanceTree(klass, allClasses, false).map(function (klass) { return klass.name; })).
        filter(distinct).
        map(function (childType) { return "#include \"" + childType + ".hpp\""; }).
        join("\n") + "\n\nusing namespace colyseus::schema;\n\n" + (namespace ? "namespace " + namespace + " {" : "") + "\nclass " + klass.name + " : public " + klass.extends + " {\npublic:\n" + klass.properties.map(function (prop) { return generateProperty(prop); }).join("\n") + "\n\n\t" + klass.name + "() {\n\t\tthis->_indexes = " + generateAllIndexes(allProperties) + ";\n\t\tthis->_types = " + generateAllTypes(allProperties) + ";\n\t\tthis->_childPrimitiveTypes = " + generateAllChildPrimitiveTypes(allProperties) + ";\n\t\tthis->_childSchemaTypes = " + generateAllChildSchemaTypes(allProperties) + ";\n\t}\n\nprotected:\n" + Object.keys(propertiesPerType).map(function (type) {
        return generateGettersAndSetters(klass, type, propertiesPerType[type]);
    }).
        join("\n") + "\n\n" + createInstanceMethod + "\n};\n" + (namespace ? "}" : "") + "\n\n#endif\n";
}
function generateProperty(prop) {
    var property = "";
    var langType;
    var initializer = "";
    if (prop.childType) {
        var isUpcaseFirst = prop.childType.match(/^[A-Z]/);
        if (prop.type === "ref") {
            langType = prop.childType + "*";
            initializer = "new " + prop.childType + "()";
        }
        else if (prop.type === "array") {
            langType = (isUpcaseFirst)
                ? "ArraySchema<" + prop.childType + "*>"
                : "ArraySchema<" + typeMaps[prop.childType] + ">";
            initializer = langType + "()";
        }
        else if (prop.type === "map") {
            langType = (isUpcaseFirst)
                ? "MapSchema<" + prop.childType + "*>"
                : "MapSchema<" + typeMaps[prop.childType] + ">";
            initializer = langType + "()";
        }
    }
    else {
        langType = typeMaps[prop.type];
        initializer = typeInitializer[prop.type];
    }
    property += " " + langType + " " + prop.name;
    return "\t" + property + " = " + initializer + ";";
}
function generateGettersAndSetters(klass, type, properties) {
    var langType = typeMaps[type];
    var typeCast = "";
    var methodName = "get" + capitalize(type);
    if (type === "ref") {
        langType = "Schema*";
    }
    else if (type === "array") {
        langType = "ArraySchema<char*>";
        typeCast = "*(ArraySchema<char*> *)&";
    }
    else if (type === "map") {
        langType = "MapSchema<char*>";
        typeCast = "*(MapSchema<char*> *)&";
    }
    return "\t" + langType + " " + methodName + "(string field)\n\t{\n\t\t" + generateFieldIfElseChain(properties, function (property) { return "field == \"" + property.name + "\""; }, function (property) { return "return " + typeCast + " this->" + property.name + ";"; }) + "\n\t\treturn " + klass.extends + "::" + methodName + "(field);\n\t}\n\n\tvoid set" + capitalize(type) + "(string field, " + langType + " value)\n\t{\n\t\t" + generateFieldIfElseChain(properties, function (property) { return "field == \"" + property.name + "\""; }, function (property) {
        var isSchemaType = (typeMaps[property.childType] === undefined);
        if (type === "ref") {
            langType = property.childType + "*";
        }
        else if (type === "array") {
            typeCast = (isSchemaType)
                ? "*(ArraySchema<" + property.childType + "*> *)&"
                : "*(ArraySchema<" + typeMaps[property.childType] + "> *)&";
        }
        else if (type === "map") {
            typeCast = (isSchemaType)
                ? "*(MapSchema<" + property.childType + "*> *)&"
                : "*(MapSchema<" + typeMaps[property.childType] + "> *)&";
        }
        return "this->" + property.name + " = " + typeCast + "value;";
    }) + "\n\t}";
}
function generateFieldIfElseChain(properties, ifCallback, callback, filter) {
    if (filter === void 0) { filter = function (_) { return true; }; }
    var chain = "";
    var uniqueChecks = [];
    properties.filter(filter).forEach(function (property, i) {
        var check = ifCallback(property);
        if (uniqueChecks.indexOf(check) === -1) {
            uniqueChecks.push(check);
        }
        else {
            return;
        }
        if (i === 0) {
            chain += "if ";
        }
        else {
            chain += " else if ";
        }
        chain += "(" + check + ")\n\t\t{\n\t\t\t" + callback(property) + "\n\n\t\t}";
    });
    return chain;
}
function generateAllIndexes(properties) {
    return "{" + properties.map(function (property, i) { return "{" + i + ", \"" + property.name + "\"}"; }).join(", ") + "}";
}
function generateAllTypes(properties) {
    return "{" + properties.map(function (property, i) { return "{" + i + ", \"" + property.type + "\"}"; }).join(", ") + "}";
}
function generateAllChildSchemaTypes(properties) {
    return "{" + properties.map(function (property, i) {
        if (property.childType && typeMaps[property.childType] === undefined) {
            return "{" + i + ", typeid(" + property.childType + ")}";
        }
        else {
            return null;
        }
    }).filter(function (r) { return r !== null; }).join(", ") + "}";
}
function generateAllChildPrimitiveTypes(properties) {
    return "{" + properties.map(function (property, i) {
        if (typeMaps[property.childType] !== undefined) {
            return "{" + i + ", \"" + property.childType + "\"}";
        }
        else {
            return null;
        }
    }).filter(function (r) { return r !== null; }).join(", ") + "}";
}
function getAllProperties(klass, allClasses) {
    var properties = [];
    getInheritanceTree(klass, allClasses).reverse().forEach(function (klass) {
        properties = properties.concat(klass.properties);
    });
    return properties;
}
