"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("./types");
var typeMaps = {
    "string": "string",
    "number": "float",
    "boolean": "bool",
    "int8": "int",
    "uint8": "uint",
    "int16": "short",
    "uint16": "ushort",
    "int32": "int",
    "uint32": "uint",
    "int64": "long",
    "uint64": "ulong",
    "float32": "float",
    "float64": "double",
};
var typeInitializer = {
    "string": '""',
    "number": "0",
    "boolean": "false",
    "int8": "0",
    "uint8": "0",
    "int16": "0",
    "uint16": "0",
    "int32": "0",
    "uint32": "0",
    "int64": "0",
    "uint64": "0",
    "float32": "0",
    "float64": "0",
};
/**
 * C# Code Generator
 */
function generate(classes, args) {
    return classes.map(function (klass) { return ({
        name: klass.name + ".cs",
        content: generateClass(klass, args.namespace)
    }); });
}
exports.generate = generate;
function generateClass(klass, namespace) {
    var indent = (namespace) ? "\t" : "";
    return types_1.getCommentHeader() + "\n\nusing Colyseus.Schema;\n" + (namespace ? "\nnamespace " + namespace + " {" : "") + "\n" + indent + "public class " + klass.name + " : " + klass.extends + " {\n" + klass.properties.map(function (prop) { return generateProperty(prop, indent); }).join("\n\n") + "\n" + indent + "}\n" + (namespace ? "}" : "") + "\n";
}
function generateProperty(prop, indent) {
    if (indent === void 0) { indent = ""; }
    var typeArgs = "\"" + prop.type + "\"";
    var property = "public";
    var langType;
    var initializer = "";
    if (prop.childType) {
        var isUpcaseFirst = prop.childType.match(/^[A-Z]/);
        if (prop.type === "ref") {
            langType = (isUpcaseFirst)
                ? prop.childType
                : typeMaps[prop.childType];
        }
        else if (prop.type === "array") {
            langType = (isUpcaseFirst)
                ? "ArraySchema<" + prop.childType + ">"
                : "ArraySchema<" + typeMaps[prop.childType] + ">";
        }
        else if (prop.type === "map") {
            langType = (isUpcaseFirst)
                ? "MapSchema<" + prop.childType + ">"
                : "MapSchema<" + typeMaps[prop.childType] + ">";
        }
        if (isUpcaseFirst) {
            typeArgs += ", typeof(" + langType + ")";
        }
        else {
            typeArgs += ", \"" + prop.childType + "\"";
        }
        initializer = "new " + langType + "()";
    }
    else {
        langType = typeMaps[prop.type];
        initializer = typeInitializer[prop.type];
    }
    property += " " + langType + " " + prop.name;
    return "\t" + indent + "[Type(" + prop.index + ", " + typeArgs + ")]\n\t" + indent + property + " = " + initializer + ";";
}
