"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("./types");
var typeMaps = {
    "string": "String",
    "number": "Dynamic",
    "boolean": "Bool",
    "int8": "Int",
    "uint8": "UInt",
    "int16": "Int",
    "uint16": "UInt",
    "int32": "Int32",
    "uint32": "UInt",
    "int64": "Int64",
    "uint64": "UInt",
    "float32": "Float",
    "float64": "Float",
};
var typeInitializer = {
    "string": '""',
    "number": "0",
    "boolean": "false",
    "int8": "0",
    "uint8": "0",
    "int16": "0",
    "uint16": "0",
    "int32": "0",
    "uint32": "0",
    "int64": "0",
    "uint64": "0",
    "float32": "0",
    "float64": "0",
};
/**
 * C++ Code Generator
 */
var capitalize = function (s) {
    if (typeof s !== 'string')
        return '';
    return s.charAt(0).toUpperCase() + s.slice(1);
};
var distinct = function (value, index, self) { return self.indexOf(value) === index; };
function generate(classes, args) {
    return classes.map(function (klass) { return ({
        name: klass.name + ".hx",
        content: generateClass(klass, args.namespace, classes)
    }); });
}
exports.generate = generate;
function getInheritanceTree(klass, allClasses, includeSelf) {
    if (includeSelf === void 0) { includeSelf = true; }
    var currentClass = klass;
    var inheritanceTree = [];
    if (includeSelf) {
        inheritanceTree.push(currentClass);
    }
    while (currentClass.extends !== "Schema") {
        currentClass = allClasses.find(function (klass) { return klass.name == currentClass.extends; });
        inheritanceTree.push(currentClass);
    }
    return inheritanceTree;
}
function generateClass(klass, namespace, allClasses) {
    return types_1.getCommentHeader() + "\n\n" + (namespace ? "package " + namespace + ";" : "") + "\nimport io.colyseus.serializer.schema.Schema;\n\nclass " + klass.name + " extends " + klass.extends + " {\n" + klass.properties.map(function (prop) { return generateProperty(prop); }).join("\n") + "\n}\n";
}
function generateProperty(prop) {
    var langType;
    var initializer = "";
    var typeArgs = "\"" + prop.type + "\"";
    if (prop.childType) {
        var isUpcaseFirst = prop.childType.match(/^[A-Z]/);
        if (isUpcaseFirst) {
            typeArgs += ", " + prop.childType;
        }
        else {
            typeArgs += ", \"" + prop.childType + "\"";
        }
        if (prop.type === "ref") {
            langType = "" + prop.childType;
            initializer = "new " + prop.childType + "()";
        }
        else if (prop.type === "array") {
            langType = (isUpcaseFirst)
                ? "ArraySchema<" + prop.childType + ">"
                : "ArraySchema<" + typeMaps[prop.childType] + ">";
            initializer = "new " + langType + "()";
        }
        else if (prop.type === "map") {
            langType = (isUpcaseFirst)
                ? "MapSchema<" + prop.childType + ">"
                : "MapSchema<" + typeMaps[prop.childType] + ">";
            initializer = "new " + langType + "()";
        }
    }
    else {
        langType = typeMaps[prop.type];
        initializer = typeInitializer[prop.type];
    }
    return "\t@:type(" + typeArgs + ")\n\tpublic var " + prop.name + ": " + langType + " = " + initializer + ";\n";
}
