"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ts = require("typescript");
var fs_1 = require("fs");
var types_1 = require("./types");
var currentClass;
function inspectNode(node, context, decoratorName) {
    switch (node.kind) {
        case ts.SyntaxKind.ClassDeclaration:
            currentClass = new types_1.Class();
            var heritageClauses = node.heritageClauses;
            if (heritageClauses && heritageClauses.length > 0) {
                currentClass.extends = heritageClauses[0].types[0].getText();
            }
            context.addClass(currentClass);
            break;
        // case ts.SyntaxKind.PropertyDeclaration:
        //     break;
        case ts.SyntaxKind.ExtendsKeyword:
            console.log(node.getText());
            break;
        case ts.SyntaxKind.Identifier:
            if (node.getText() === decoratorName && node.parent.kind !== ts.SyntaxKind.ImportSpecifier) {
                var prop = node.parent.parent.parent;
                var propDecorator = node.parent.parent.parent.decorators;
                // ignore if "type" identifier doesn't have a decorator.
                if (!propDecorator) {
                    break;
                }
                var typeDecorator = propDecorator.find((function (decorator) {
                    return decorator.expression.expression.escapedText === decoratorName;
                })).expression;
                var property = new types_1.Property();
                property.name = prop.name.escapedText;
                currentClass.addProperty(property);
                var typeArgument = typeDecorator.arguments[0];
                if (ts.isIdentifier(typeArgument)) {
                    property.type = "ref";
                    property.childType = typeArgument.text;
                }
                else if (typeArgument.kind == ts.SyntaxKind.ObjectLiteralExpression) {
                    property.type = "map";
                    property.childType = typeArgument.properties[0].initializer.text;
                }
                else if (typeArgument.kind == ts.SyntaxKind.ArrayLiteralExpression) {
                    property.type = "array";
                    property.childType = typeArgument.elements[0].text;
                }
                else {
                    property.type = typeArgument.text;
                }
            }
            if (node.parent.kind === ts.SyntaxKind.ClassDeclaration) {
                currentClass.name = node.getText();
            }
            break;
    }
    ts.forEachChild(node, function (n) { return inspectNode(n, context, decoratorName); });
}
function parseFiles(fileNames, decoratorName) {
    if (decoratorName === void 0) { decoratorName = "type"; }
    var context = new types_1.Context();
    fileNames.forEach(function (fileName) {
        var sourceFile = ts.createSourceFile(fileName, fs_1.readFileSync(fileName).toString(), ts.ScriptTarget.ES2018, true);
        inspectNode(sourceFile, context, decoratorName);
    });
    return context.getSchemaClasses();
}
exports.parseFiles = parseFiles;
