"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var VERSION = JSON.parse(fs.readFileSync(__dirname + "/../../package.json").toString()).version;
var COMMENT_HEADER = "\nTHIS FILE HAS BEEN GENERATED AUTOMATICALLY\nDO NOT CHANGE IT MANUALLY UNLESS YOU KNOW WHAT YOU'RE DOING\n\nGENERATED USING @colyseus/schema " + VERSION + "\n";
function getCommentHeader(singleLineComment) {
    if (singleLineComment === void 0) { singleLineComment = "//"; }
    return "" + COMMENT_HEADER.split("\n").map(function (line) { return singleLineComment + " " + line; }).join("\n");
}
exports.getCommentHeader = getCommentHeader;
var Context = /** @class */ (function () {
    function Context() {
        this.classes = [];
    }
    Context.prototype.getSchemaClasses = function () {
        var _this = this;
        return this.classes.filter(function (klass) {
            if (_this.isSchemaClass(klass)) {
                return true;
            }
            else {
                var parentClass = klass;
                while (parentClass = _this.getParentClass(parentClass)) {
                    if (_this.isSchemaClass(parentClass)) {
                        return true;
                    }
                }
            }
            return false;
        });
    };
    Context.prototype.addClass = function (currentClass) {
        currentClass.context = this;
        this.classes.push(currentClass);
    };
    Context.prototype.getParentClass = function (klass) {
        return this.classes.find(function (c) { return c.name === klass.extends; });
    };
    Context.prototype.isSchemaClass = function (klass) {
        return klass.properties.length > 0;
    };
    return Context;
}());
exports.Context = Context;
var Class = /** @class */ (function () {
    function Class() {
        this.properties = [];
    }
    Class.prototype.addProperty = function (property) {
        var parentKlass = this;
        property.index = this.properties.length;
        while ((parentKlass = this.context.classes.find(function (k) { return k.name === parentKlass.extends; }))) {
            property.index += parentKlass.properties.length;
        }
        this.properties.push(property);
    };
    return Class;
}());
exports.Class = Class;
var Property = /** @class */ (function () {
    function Property() {
    }
    return Property;
}());
exports.Property = Property;
