"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Clock = require("@gamestdio/clock");
var Delayed_1 = require("./Delayed");
var ClockTimer = /** @class */ (function (_super) {
    __extends(ClockTimer, _super);
    function ClockTimer(autoStart) {
        if (autoStart === void 0) { autoStart = false; }
        var _this = _super.call(this, autoStart) || this;
        _this.delayed = [];
        return _this;
    }
    ClockTimer.prototype.tick = function () {
        _super.prototype.tick.call(this);
        var i = this.delayed.length;
        while (i--) {
            var delayed = this.delayed[i];
            if (delayed.active) {
                delayed.tick(this.deltaTime);
            }
            else {
                this.delayed.splice(i, 1);
                continue;
            }
        }
    };
    ClockTimer.prototype.setInterval = function (handler, time) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var delayed = new Delayed_1.Delayed(handler, args, time, Delayed_1.Type.Interval);
        this.delayed.push(delayed);
        return delayed;
    };
    ClockTimer.prototype.setTimeout = function (handler, time) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var delayed = new Delayed_1.Delayed(handler, args, time, Delayed_1.Type.Timeout);
        this.delayed.push(delayed);
        return delayed;
    };
    ClockTimer.prototype.clear = function () {
        var i = this.delayed.length;
        while (i--) {
            this.delayed[i].clear();
        }
        this.delayed = [];
    };
    return ClockTimer;
}(Clock));
exports.ClockTimer = ClockTimer;
