"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Type;
(function (Type) {
    Type[Type["Interval"] = 0] = "Interval";
    Type[Type["Timeout"] = 1] = "Timeout";
})(Type = exports.Type || (exports.Type = {}));
var Delayed = /** @class */ (function () {
    function Delayed(handler, args, time, type) {
        this.active = true;
        this.paused = false;
        this.elapsedTime = 0;
        this.handler = handler;
        this.args = args;
        this.time = time;
        this.type = type;
    }
    Delayed.prototype.tick = function (deltaTime) {
        if (this.paused) {
            return;
        }
        this.elapsedTime += deltaTime;
        if (this.elapsedTime >= this.time) {
            this.execute();
        }
    };
    Delayed.prototype.execute = function () {
        this.handler.apply(this, this.args);
        if (this.type === Type.Timeout) {
            this.active = false;
        }
        else {
            this.elapsedTime -= this.time;
        }
    };
    Delayed.prototype.reset = function () {
        this.elapsedTime = 0;
    };
    Delayed.prototype.pause = function () {
        this.paused = true;
    };
    Delayed.prototype.resume = function () {
        this.paused = false;
    };
    Delayed.prototype.clear = function () {
        this.active = false;
    };
    return Delayed;
}());
exports.Delayed = Delayed;
