<div align="center">
  <a href="https://github.com/colyseus/colyseus">
    <img src="media/header.png?raw=true" />
  </a>
  <br>
  <br>
  <a href="https://npmjs.com/package/colyseus">
    <img src="https://img.shields.io/npm/dm/colyseus.svg?style=for-the-badge&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QAAKqNIzIAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAAHdElNRQfjAgETESWYxR33AAAAtElEQVQoz4WQMQrCQBRE38Z0QoTcwF4Qg1h4BO0sxGOk80iCtViksrIQRRBTewWxMI1mbELYjYu+4rPMDPtn12ChMT3gavb4US5Jym0tcBIta3oDHv4Gwmr7nC4QAxBrCdzM2q6XqUnm9m9r59h7Rc0n2pFv24k4ttGMUXW+sGELTJjSr7QDKuqLS6UKFChVWWuFkZw9Z2AAvAirKT+JTlppIRnd6XgaP4goefI2Shj++OnjB3tBmHYK8z9zAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE5LTAyLTAxVDE4OjE3OjM3KzAxOjAwGQQixQAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxOS0wMi0wMVQxODoxNzozNyswMTowMGhZmnkAAAAZdEVYdFNvZnR3YXJlAHd3dy5pbmtzY2FwZS5vcmeb7jwaAAAAAElFTkSuQmCC">
  </a>
  <a href="https://patreon.com/endel" title="Donate to this project using Patreon">
    <img src="https://img.shields.io/badge/endpoint.svg?url=https%3A%2F%2Fshieldsio-patreon.herokuapp.com%2Fendel&style=for-the-badge" alt="Patreon donate button"/>
  </a>
  <a href="http://discuss.colyseus.io" title="Discuss on Forum">
    <img src="https://img.shields.io/badge/discuss-on%20forum-brightgreen.svg?style=for-the-badge&colorB=0069b8&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QAAKqNIzIAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAAHdElNRQfjAgETDROxCNUzAAABB0lEQVQoz4WRvyvEARjGP193CnWRH+dHQmGwKZtFGcSmxHAL400GN95ktIpV2dzlLzDJgsGgGNRdDAzoQueS/PgY3HXHyT3T+/Y87/s89UANBKXBdoZo5J6L4K1K5ZxHfnjnlQUf3bKvkgy57a0r9hS3cXfMO1kWJMza++tj3Ac7/LY343x1NA9cNmYMwnSS/SP8JVFuSJmr44iFqvtmpjhmhBCrOOazCesq6H4P3bPBjFoIBydOk2bUA17I080Es+wSZ51B4DIA2zgjSpYcEe44Js01G0XjRcCU+y4ZMrDeLmfc9EnVd5M/o0VMeu6nJZxWJivLmhyw1WHTvrr2b4+2OFqra+ALwouTMDcqmjMAAAAldEVYdGRhdGU6Y3JlYXRlADIwMTktMDItMDFUMTg6MTM6MTkrMDE6MDAC9f6fAAAAJXRFWHRkYXRlOm1vZGlmeQAyMDE5LTAyLTAxVDE4OjEzOjE5KzAxOjAwc6hGIwAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAAASUVORK5CYII=" alt="Discussion forum" />
  </a>
  <a href="https://discord.gg/RY8rRS7">
    <img src="https://img.shields.io/discord/525739117951320081.svg?style=for-the-badge&colorB=7581dc&logo=discord&logoColor=white">
  </a>
  <h3>
    Multiplayer Game Server for Node.js. <br /><a href="https://docs.colyseus.io/">View documentation</a>
  </h3>
</div>

Colyseus is a Authoritative Multiplayer Game Server for Node.js. It allows you
to focus on your gameplay instead of bothering about networking.

The mission of this framework is to be the easiest solution for creating your
own multiplayer games in JavaScript.

This framework is fairly new and is being evolved constantly. You're encouraged
to take a look on [some games being developed with
it](https://discuss.colyseus.io/category/5/showcase) and make your own!

## What Colyseus provides to you:

- WebSocket-based communication
- Simple API in the server-side and client-side.
- Automatic state synchronization between server and client.
- Matchmaking clients into game sessions
- Scale vertically or horizontally

## What Colyseus won't provide:

- Game Engine: Colyseus is agnostic of the engine you're using. Need Physics? Add your own logic / package.
- Database: It's up to you to configure and select which database you'd like to use.

See [roadmap](https://github.com/colyseus/colyseus/wiki/Roadmap) for our future plans.

### Official client integration

- [JavaScript/TypeScript](https://github.com/colyseus/colyseus.js)
- [Defold Engine](https://github.com/colyseus/colyseus-defold) ([defold.com](https://www.defold.com/))
- [Haxe](https://github.com/colyseus/colyseus-hx) ([haxe.org](https://haxe.org/))
- [Cocos2d-x](https://github.com/colyseus/colyseus-cocos2d-x) ([cocos2d-x.org](https://cocos2d-x.org/))
- [Construct 3](https://github.com/colyseus/colyseus-construct3) ([construct3.net](https://www.construct.net/))
- [Unity](https://github.com/colyseus/colyseus-unity3d) ([unity3d.com](https://unity3d.com/))

### Tools

- [@colyseus/proxy](https://github.com/colyseus/proxy) - Proxy & Service Discovery for scaling Colyseus
- [@colyseus/monitor](https://github.com/colyseus/colyseus-monitor) - A Web Monitoring Panel for Colyseus
- [@colyseus/loadtest](https://github.com/colyseus/colyseus-loadtest) - Utility tool for load testing Colyseus

### Community client integration

- [Java](https://github.com/doorbash/colyseus-java)
- [Objective-C](https://github.com/swittk/Colyseus-ObjC)
- [Construct2](https://github.com/Keevle/Colyseus-for-C2)

### Usage examples

See the [official examples](https://github.com/colyseus/colyseus-examples) for
usage reference with the latest version of Colyseus.

- [Colyseus + PixiJS Boilerplate](https://colyseus-pixijs-boilerplate.herokuapp.com/) ([source-code](https://github.com/endel/colyseus-pixijs-boilerplate)) - Simplistic agar.io implementation using [PixiJS](https://github.com/pixijs/pixi.js)
- [Tic Tac Toe](https://tictactoe-colyseus.herokuapp.com) ([source-code](https://github.com/endel/tic-tac-toe)) - Simple Tic Tac Toe using [PixiJS](https://github.com/pixijs/pixi.js)
- (outdated: v0.8.x) [tanx](https://playcanvas.com/project/367035/overview/tanxcolyseus) ([source-code](https://github.com/endel/tanx)) - Multiplayer tanks game, originally from [PlayCanvas](https://tanx.io/)
- (outdated: v0.4.x) [React Example](https://colyseus-react-example.herokuapp.com) ([source-code](https://github.com/endel/colyseus-react-example)) - Example integrating with [ReactJS](https://github.com/facebook/react)
- (outdated: v0.3.x) [LD35 entry: dotower](http://ludumdare.com/compo/ludum-dare-35/?action=preview&uid=50958) ([source-code](https://github.com/endel/LD35)) - Simple experimental MOBA using [PixiJS](https://github.com/pixijs/pixi.js)

# Contributors

Thanks goes to these wonderful people ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore -->
| [<img src="https://avatars3.githubusercontent.com/u/130494?v=4" width="100px;"/><br /><sub><b>Endel Dreyer</b></sub>](https://twitter.com/endel)<br />[💻](https://github.com/colyseus/colyseus/commits?author=endel "Code") [📖](https://github.com/colyseus/colyseus/commits?author=endel "Documentation") [💡](#example-endel "Examples") | [<img src="https://avatars2.githubusercontent.com/u/20824844?v=4" width="100px;"/><br /><sub><b>AnubisCode</b></sub>](https://github.com/AnubisCode)<br />[🐛](https://github.com/colyseus/colyseus/issues?q=author%3AAnubisCode "Bug reports") [💻](https://github.com/colyseus/colyseus/commits?author=AnubisCode "Code") [💵](#financial-AnubisCode "Financial") [🤔](#ideas-AnubisCode "Ideas, Planning, & Feedback") | [<img src="https://avatars0.githubusercontent.com/u/763609?v=4" width="100px;"/><br /><sub><b>Kyle J. Kemp</b></sub>](http://seiyria.com)<br />[💬](#question-seiyria "Answering Questions") [🐛](https://github.com/colyseus/colyseus/issues?q=author%3Aseiyria "Bug reports") [💻](https://github.com/colyseus/colyseus/commits?author=seiyria "Code") [🤔](#ideas-seiyria "Ideas, Planning, & Feedback") | [<img src="https://avatars1.githubusercontent.com/u/1041315?v=4" width="100px;"/><br /><sub><b>Abhishek Hingnikar</b></sub>](https://github.com/darkyen)<br />[💬](#question-darkyen "Answering Questions") [🐛](https://github.com/colyseus/colyseus/issues?q=author%3Adarkyen "Bug reports") [🤔](#ideas-darkyen "Ideas, Planning, & Feedback") [👀](#review-darkyen "Reviewed Pull Requests") | [<img src="https://avatars2.githubusercontent.com/u/21344385?v=4" width="100px;"/><br /><sub><b>Federico</b></sub>](https://twitter.com/Federkun)<br />[🐛](https://github.com/colyseus/colyseus/issues?q=author%3AFederkun "Bug reports") [💻](https://github.com/colyseus/colyseus/commits?author=Federkun "Code") | [<img src="https://avatars0.githubusercontent.com/u/853683?v=4" width="100px;"/><br /><sub><b>OYED</b></sub>](https://oyed.io)<br />[💬](#question-oyed "Answering Questions") [🐛](https://github.com/colyseus/colyseus/issues?q=author%3Aoyed "Bug reports") [💵](#financial-oyed "Financial") [🤔](#ideas-oyed "Ideas, Planning, & Feedback") | [<img src="https://avatars0.githubusercontent.com/u/13785893?v=4" width="100px;"/><br /><sub><b>Derwish</b></sub>](https://github.com/derwish-pro)<br />[🐛](https://github.com/colyseus/colyseus/issues?q=author%3Aderwish-pro "Bug reports") [🔧](#tool-derwish-pro "Tools") |
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| [<img src="https://avatars2.githubusercontent.com/u/2755221?v=4" width="100px;"/><br /><sub><b>VF</b></sub>](https://github.com/havingfunq)<br />[🐛](https://github.com/colyseus/colyseus/issues?q=author%3Ahavingfunq "Bug reports") [🤔](#ideas-havingfunq "Ideas, Planning, & Feedback") | [<img src="https://avatars0.githubusercontent.com/u/18367963?v=4" width="100px;"/><br /><sub><b>Wenish</b></sub>](http://wenish.github.io/portfolio/)<br />[🐛](https://github.com/colyseus/colyseus/issues?q=author%3AWenish "Bug reports") |
<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/kentcdodds/all-contributors) specification.
Contributions of any kind are welcome!

# Contributing

We encourage you to contribute to Colyseus! Please check out the [Contributing
guide](.github/CONTRIBUTING.md) for guidelines about how to proceed. Join us!

Everyone interacting in Colyseus and its sub-projects' codebases, issue trackers
and chat rooms is expected to follow the [code of conduct](CODE_OF_CONDUCT.md).

## License

MIT
