"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const timer_1 = __importStar(require("@gamestdio/timer"));
exports.Clock = timer_1.default;
exports.Delayed = timer_1.Delayed;
const nanoid_1 = __importDefault(require("nanoid"));
// Core classes
var Server_1 = require("./Server");
exports.Server = Server_1.Server;
var Room_1 = require("./Room");
exports.Room = Room_1.Room;
var Protocol_1 = require("./Protocol");
exports.Protocol = Protocol_1.Protocol;
var RegisteredHandler_1 = require("./matchmaker/RegisteredHandler");
exports.RegisteredHandler = RegisteredHandler_1.RegisteredHandler;
var LocalPresence_1 = require("./presence/LocalPresence");
exports.LocalPresence = LocalPresence_1.LocalPresence;
var RedisPresence_1 = require("./presence/RedisPresence");
exports.RedisPresence = RedisPresence_1.RedisPresence;
var MemsharedPresence_1 = require("./presence/MemsharedPresence");
exports.MemsharedPresence = MemsharedPresence_1.MemsharedPresence;
// Serializers
var FossilDeltaSerializer_1 = require("./serializer/FossilDeltaSerializer");
exports.FossilDeltaSerializer = FossilDeltaSerializer_1.FossilDeltaSerializer;
var SchemaSerializer_1 = require("./serializer/SchemaSerializer");
exports.SchemaSerializer = SchemaSerializer_1.SchemaSerializer;
var Serializer_1 = require("./serializer/Serializer");
exports.serialize = Serializer_1.serialize;
var nonenumerable_1 = require("nonenumerable");
exports.nosync = nonenumerable_1.nonenumerable;
function generateId() { return nanoid_1.default(9); }
exports.generateId = generateId;
function isValidId(id) { return id && /^[a-zA-Z0-9_\-]{9}$/.test(id); }
exports.isValidId = isValidId;
