class Config {
    public static inline var PORT:Int = 3567;

    public static function convertStringToMap(options:String):Map<String, Dynamic>{
	var map:Map<String, Dynamic>=new Map<String, Dynamic>();
	var colonString:String=options.substring(1, options.length-1);
	var colons:Array<Dynamic>=colonString.split(",");
	for(colon in colons){
		var prop:Array<Dynamic>=colon.split(":");
		var propertyName:String=StringTools.trim(prop[0]);
		var propertyValue:String=StringTools.trim(prop[1]);
//trace("PropName: |"+propertyName+"| value: |"+propertyValue+"|");
		map.set(propertyName, propertyValue);
	}
	
	return map;
    }
}

@:enum abstract RoomID(String) from String to String {
    var CHAT = 'chat';
    var CHAT_WITH_OPTIONS = 'chat_with_options';
    var STATE_HANDLER = 'state_handler';
    var AUTH = 'auth';
    var CREATE_OR_JOIN = 'create_or_join';
	var LOBBY =  "lobby";
	var RAW =  "raw";
	var TURN =  "turn";
	var LOCK =  "lock";
}
