package server.rooms;
import js.node.vm.Script;
import colyseus.server.Room;
import colyseus.server.schema.Schema;
using colyseus.server.schema.Schema.MapSchemaUtil;

class LobbyPlayer extends Schema implements ISchema {

	@:type(STRING)
	public var playerName:String;
	@:type(STRING)
	public var ApplicationID:String;
	@:type(STRING)
	public var playerID:String;
	@:type(STRING)
	public var roomInfo:String;

	public function new() {
		playerName="";
		ApplicationID="";
		playerID="";
		roomInfo="";
   	}
}

class Lobby extends Room {

    var myState:LobbyState;
	var roomInfo:String;

    override function onInit (options:Dynamic) {
        trace("Lobby created!", options);
	roomInfo="";
        myState = new LobbyState();
        setState(myState);
	setMetadata(options);
    }

    override function onJoin (client, ?options:Dynamic, ?auth:Dynamic) {
  	var msg:Map<String, Dynamic>=Config.convertStringToMap(""+options);

        var PlayerName:String   =       msg.get("PlayerName");
        if(PlayerName==null) PlayerName="";
        var ApplicationID:String   =       msg.get("ApplicationID");
        if(ApplicationID==null) ApplicationID="";
        var PlayerID:String   =       msg.get("PlayerID");
        if(PlayerID==null) PlayerID="";


        myState.createPlayer(client.sessionId);
	myState.addPlayerName(client.sessionId, PlayerName);
	myState.addPlayerID(client.sessionId, PlayerID);
	myState.setApplicationID(client.sessionId, ApplicationID);
        return null;
    }

    override function onLeave (client, ?consented:Bool) {
        myState.removePlayer(client.sessionId);
        return null;
    }

   override function onMessage (client, data:Dynamic) {
trace("Lobby received message from", client.sessionId, ":", data);
	if( (""+data).indexOf("GETSERVERTIME:") > -1){
		var dataList:Array<Dynamic>=data.split(":");
		var returnPlayerID:String="";
		if(dataList.length > 1){
			returnPlayerID=dataList[2];
			roomInfo+="RETURNTIME:"+returnPlayerID+":"+Date.now().getTime()+";";
			//myState.addRoomInfo(client.sessionId, "RETURNTIME:"+returnPlayerID+":"+Date.now().getTime());
			myState.addRoomInfo(client.sessionId, roomInfo);
		}
	}

	if( (""+data).indexOf("ADDROOMINFO.") > -1 ){
		//added room info: " roomID=playerID "
		roomInfo+=""+data.substring( (""+data).indexOf("ADDROOMINFO.")+12,data.length )+";";
trace("addRoomInfo to the client(s) ");
		myState.addRoomInfo(client.sessionId, roomInfo);
	}

    } // onMessage

    override function onDispose () {
        trace("Dispose Lobby");
        return null;
    }
}

class LobbyState extends Schema implements ISchema {
    @:type({map: LobbyPlayer})
    public var players:MapSchema<LobbyPlayer>;

    public var something:String = "This attribute won't be sent to the client-side";

    public function new() {
        players = new MapSchema<LobbyPlayer>();
    }

    public function createPlayer(id: String) {
        players.set(id, new LobbyPlayer());
    }

    public function removePlayer (id: String) {
        players.delete(id);
    }

	public function addPlayerName(id:String, PlayerName:String){
                players.get(id).playerName=""+PlayerName;
        }
	public function addPlayerID(id:String, PlayerID:String){
                players.get(id).playerID=""+PlayerID;
        }
	public function setApplicationID(id:String, applicationID:String){
                players.get(id).ApplicationID=""+applicationID;
        }

	public function addRoomInfo(id:String, RoomInfo:String){
//trace("Player : "+id+" gets roomInfo: "+RoomInfo);
// Only leave players in the roomInfo data that didn't have a leave '%' signature
		var thePlayers:Array<Dynamic>=RoomInfo.split(";");
		var thePlayerMap:Map<String, String>=new Map<String,String>();
		var newRoomInfo:String="";
		
		if(RoomInfo.indexOf("RETURNTIME") > -1){
			newRoomInfo=RoomInfo;
		}else{

			for(player in thePlayers){
				if(player.indexOf("%") > -1){
					var tempName:String=player.split("%")[0];
					var isFound:Bool=false;
					for(item in thePlayerMap) if(item == tempName) isFound=true;
					if(isFound){
						thePlayerMap.remove(tempName);
	
					}
				} // removeplayer
				if(player.indexOf("@") > -1){
					var tempName:Array<Dynamic>=player.split("@");
					thePlayerMap.set(""+tempName[0], ""+tempName[1]);
				} // addPlayer
			}
	
			var toReturn:Array<Dynamic> = new Array<Dynamic>();
			for (player in thePlayerMap.keys()){
				newRoomInfo=player+"@"+thePlayerMap.get(player)+";"+newRoomInfo;
			}
		}
trace(" new RoomInfo: "+newRoomInfo);	
		players.get(id).roomInfo=newRoomInfo;
	}
}
//
//
//
//

