
package server.rooms;
import js.node.vm.Script;
import colyseus.server.Room;
import colyseus.server.schema.Schema;
using colyseus.server.schema.Schema.MapSchemaUtil;

class Lock extends Room {

    public var myState:LockState;


    override function onInit (options:Dynamic) {
trace("Lock created!", options);

        myState = new LockState();
        setState(myState);
	setMetadata(options); // is from serverside - Room

    }

    override function onJoin (client, ?options:Dynamic, ?auth:Dynamic) {
trace("options "+options);
	var msg:Map<String, Dynamic>=Config.convertStringToMap(""+options);

	
	var PlayerName:String	= 	msg.get("PlayerName");
	if(PlayerName==null) PlayerName="";
	var RoomName:String	= 	msg.get("RoomName");
	if(PlayerName==null) RoomName="ROOM0";
	var PlayerID:String	= 	msg.get("PlayerID");
	if(PlayerID==null) PlayerID="";

        myState.createPlayer(client.sessionId);
	myState.addPlayerName(client.sessionId, PlayerName);
	myState.addPlayerID(client.sessionId, PlayerID);

        //myState.findNextActivePlayer();
	// TO BE DONE : single Class call
        myState.getActivePlayer();
//trace(" onJoin: client: "+client+" joined roomName: "+RoomName);

        return null;
    }

    override function onLeave (client, ?consented:Bool) {
        myState.removePlayer(client.sessionId);
        return null;
    }

   override function onMessage (client, data:Dynamic) {
trace("message from "+client.sessionId+":"+data);
//message from6CPY0uKRK:LOCKREQUEST*LockRequest1*weqrqewr*

	var isData:Bool=true;
	// for both new as old mechanism
	if((""+data).indexOf("SETACTIVESEATNR") > -1){
                myState.setActiveSeatNR(client.sessionId, ""+data);
		isData=false;
        }

	if((""+data).indexOf("LOCKROOM*") == 0){
		myState.lockRoom(client.sessionId, ""+data);
		isData=false;
	}
	if((""+data).indexOf("UNLOCKROOM*") == 0){
		myState.unLockRoom(client.sessionId, ""+data);
		isData=false;
	}


	//
	// OnEvent Lock system
	//
	if((""+data).indexOf("LOCKREQUEST*") == 0){
//message LOCKREQUEST*PlayerMove1*188@=@0@$,$@1000@|;|@189@=@1000@$,$@0@|;|@*
		var lockParts:Array<String>=(""+data).split("*");
//k.hx:46: message from VEMLRBZgi:LOCKREQUEST*CharacterSend*LOCKDATA*SECRETDISPLAY=YUVCSVCXNX,YUVCSVCXNX;*

		var lockID:String=""+lockParts[1];
		// lockstring parts[2]
	//	lockStrings.set(client.sesionId+"."+lockID, lockParts[2]);
		//var requestData:String=lockParts[2]+lockParts[3];
		var requestData:String=lockParts[2];
trace("LockRequest Received: ID="+lockID+" lockData="+requestData);
		isData=false;
		//myState.onLockRequest(client.sessionId, lockID, ""+requestData);
		myState.onLockRequest(client.sessionId, lockID, ""+requestData);
	
	} // lockRequest




	// Old non-event mechanism
	if((""+data).indexOf("REQUESTLOCK*") == 0){
trace("RequestLock Received : calling requestDataLock?");
		isData=false;
	}

	// Old non-event mechanism
	if((""+data).indexOf("REQUESTDATALOCK*") == 0){
trace("RequestDataLock Received : calling requestDataLock");
		myState.requestDataLock(client.sessionId, ""+data);
		isData=false;
	}

	// Old non-event mechanism
	if((""+data).indexOf("UNLOCKDATA*") == 0){
		myState.unlockData(client.sessionId, ""+data);
		isData=false;
	}
	
	// Old non-event mechanism
	if((""+data).indexOf("LOCKDATA*") == 0){
trace(" Lockdata message received with data :"+data);
		myState.setData(client.sessionId, ""+data);
		isData=false;
	}

	if((""+data).indexOf("GETLOCKDATA*") == 0){
trace("GETLOCKDATA requested!");
		myState.getData(client.sessionId);
		isData=false;
	}
	if(isData){
		myState.updateString(client.sessionId, ""+data);
  		myState.getSeatInfo();
	}
    }

    override function onDispose () {
trace("Dispose Lock");
        return null;
    }
   //override function requestJoin (options:Dynamic, ?isNew: Bool):haxe.extern.EitherType<Float, Bool> {
   override function requestJoin (options:Dynamic, ?isNew: Bool){
	var retval:Bool=false;

	var oldMax=this.maxClients;

	var PlayerName:String	= 	"";
	var ActionType:String   =	"";

	this.maxClients=100;


	var prop:Map<String, Dynamic>=Config.convertStringToMap(""+options);
	
	var PlayerName:String	= 	prop.get("PlayerName");
	var PlayerID:String	= 	prop.get("PlayerID");
	var ActionType:String   =	prop.get("CreateOrJoin");
	var RoomID:String   	=	prop.get("RoomID");
	//var RoomID:String   	=	""+this.roomId;
	if(PlayerName==null) PlayerName="";
	if(PlayerID==null) PlayerID="";
	if(ActionType==null) ActionType="";	
	if(RoomID==null) RoomID="";	

trace('Request join : this.roomId: |'+this.roomId+'| Type: |'+ActionType+ '| PlayerName: |'+PlayerName+ '| PlayerID: |'+PlayerID+'| OldMax: |'+ oldMax+'| ');
	if(ActionType!="JOIN" && (""+oldMax).indexOf("Infinity") > -1){
		 retval=true;
	} else {
		if(ActionType=="JOIN"){
			if(this.roomId == RoomID){
			 	retval=true;
			}else{
				retval=false;
			}
		}else{
			 retval=false;
		}
	}

trace('retval = '+retval+'  if retval is true we join room: '+this.roomId+'| | ');
	return retval;
    } // requestJoin
}
/*

"string"	utf8 strings	maximum byte size of 4294967295
"number"	auto-detects the int or float type to be used. (adds an extra byte on output)	0 to 18446744073709551615
"boolean"	true or false	0 or 1
"int8"	signed 8-bit integer	-128 to 127
"uint8"	unsigned 8-bit integer	0 to 255
"int16"	signed 16-bit integer	-32768 to 32767
"uint16"	unsigned 16-bit integer	0 to 65535
"int32"	signed 32-bit integer	-2147483648 to 2147483647
"uint32"	unsigned 32-bit integer	0 to 4294967295
"int64"	signed 64-bit integer	-9223372036854775808 to 9223372036854775807
"uint64"	unsigned 64-bit integer	0 to 18446744073709551615
"float32"	single-precision floating-point number	-3.40282347e+38 to 3.40282347e+38
"float64"	double-precision floating-point number	-1.7976931348623157e+308 to 1.7976931348623157e+308
*/

class LockPlayer extends Schema implements ISchema {

	@:type(STRING)
	public var theString:String;
	@:type(STRING)
	public var playerName:String;
	@:type(STRING)
	public var playerID:String;
	@:type(STRING)
	public var lockState:String;
	@:type(STRING)
	public var lockData:String;
        @:type(NUMBER)
        public var SeatNR:Int;
        @:type(STRING)
        public var ActivePlayer:String;


	//public function new() {
	public	function new() {
		theString="NULL";
		//playerNames=new Array<Dynamic>();
		//playerNames.push("TestPlayerName");
		playerName="TestPlayerName";
		playerID="";
		lockState="";
		lockData="";
		SeatNR=-0;
        	ActivePlayer="";
		
   	}
}

class LockState extends Schema implements ISchema {
    @:type({map: LockPlayer})
    public var players:MapSchema<LockPlayer>;

    public var something:String = "This attribute won't be sent to the client-side";
    public var lockState:String="";
	private var DataMap:Map<String,String>=new Map<String,String>();
	// Lock Information
	private var lockMap:Map<String,String>=new Map<String,String>(); // for the locks
	private var lockUserMap:Map<String,String>=new Map<String,String>();
	private var lockTimeMap:Map<String,String>=new Map<String,String>();

	private var active:Active;

/*
	// TO BE DONE : Refactor this to Single Class
        public var seatCounter:Int=-1;
	public var freeSeats:Array<Dynamic>=new Array<Dynamic>();
        public var activePlayerID:String="";
        public var activeSeatNR:Int=0;
        public var RoomPlayerIDs:Array<Dynamic>=new Array<Dynamic>();
*/

	public var equalSplit="@=@";
	public var oldNewSplit="@$,$@";
	public var seperateSplit="@|;|@";
	//public var equalSplit="=";
	//public var oldNewSplit=",";
	//public var seperateSplit=";";
     

    public function new() {
        players = new MapSchema<LockPlayer>();
	active =  new Active(players);
    }

    public function createPlayer(id: String) {
        players.set(id, new LockPlayer());
    }

    public function removePlayer (id: String) {

		active.removePlayer(id);

/*

	RoomPlayerIDs.remove(id);
	// TO BE DONE : Single Class Call
        freeSeats.push(players.get(id).SeatNR);
trace(" Removing player ID : "+id+" And find next Player ...");
        // Check if the player leaving is the activeplayer
        //   IF leavingplayer == activeplayer : findNextActivePlayer
        if(activePlayerID  == players.get(id).playerID){
		var nextPlayer = findNextActivePlayer();
trace("FindNextActivePlayer : "+nextPlayer);
        }

        players.delete(id);
*/

    }




/*
 	// TO BE DONE : Refactor to single Class for all roomtypes
    public function findNextActivePlayer():String{
           var retval:String="";
           var smallestSeat:Int=1000;
           var smallestSeatPlayerID:String="";
           var smallestPlayerIndex="";
trace("Find NExt Active. Current ActiveSeatNr: "+activeSeatNR);
           // loop through the players
            for(p in RoomPlayerIDs){
               if(players.get(p).SeatNR < smallestSeat) {
                    smallestSeat=players.get(p).SeatNR;
                    smallestSeatPlayerID=players.get(p).playerID;
                    smallestPlayerIndex=p;
                }
                // check if there is a seat available after current activePlayerID
                if(retval.length < 1 && players.get(p).SeatNR == activeSeatNR+1){
trace("NExt active Seatnr : "+(activeSeatNR+1)+" Matches player : "+players.get(p).playerID);
                       retval=players.get(p).playerID;
                       activeSeatNR=players.get(p).SeatNR;
                       activePlayerID=retval;
                      // Set ActivePlayer in playerproperties
                       for(ap in RoomPlayerIDs){
                           players.get(ap).ActivePlayer=retval;
                       }
                    } // NextSeat available?
            } // for all players in room
trace("SmallestSeat found: "+smallestSeat);
trace("Is playerID after current active? :"+retval.length);
            // If no player after current player
            if(retval.length < 1){
trace(" No : there is no player after ");
                retval=smallestSeatPlayerID;
                activeSeatNR=smallestSeat;
                activePlayerID=retval;
                for(ap in RoomPlayerIDs){
                   players.get(ap).ActivePlayer=retval;
                }
	    } // select smallest seatnr as activeseatnr
trace("PlayerID which is Active: "+retval);
               return retval;
        } // findNextActivePlayer
*/




	public function setActiveSeatNR(id:String, data:String){
                var setActiveSeatList:Array<String>=data.split("SETACTIVESEATNR:");
                active.setActiveSeatNR(Std.parseInt(""+setActiveSeatList[1]));
        } // setActiveSeatNR


	public function getActivePlayer(){
                active.getActivePlayer();
        }
/*

	public function getActivePlayer(){
		var lastPlayer:String="";
                for(ap in RoomPlayerIDs){
			if(lastPlayer.length < 1) lastPlayer=players.get(ap).ActivePlayer;
			if(players.get(ap).ActivePlayer!=null && players.get(ap).ActivePlayer.length > 0){
				if(lastPlayer!=players.get(ap).ActivePlayer){
					var nextPlayer = findNextActivePlayer();
				}
                   		lastPlayer=players.get(ap).ActivePlayer;
			}
                }
		if(lastPlayer.length < 1) findNextActivePlayer();
	}// getActivePlayer
*/


	public function updateString(id:String, theString_: String){
trace("Update String: "+theString_);
		players.get(id).theString=theString_;
	}


	  public function getSeatInfo(){
		active.getSeatInfo();

/*
                for(p in RoomPlayerIDs){
                        players.get(p).ActivePlayer=activePlayerID;
                }
*/
        } // seatInfo


	public function addPlayerName(id:String, PlayerName:String){
		active.addPlayerName(id, PlayerName);

/*

    		if(Lambda.indexOf(RoomPlayerIDs, id) < 0){
                        RoomPlayerIDs.push(id);
                }
                players.get(id).playerName=""+PlayerName;
                var freeNr:Int=-1;
                for(i in 0 ... freeSeats.length){
                        if(freeNr==-1){
                                if(freeSeats[i]>-1){
                                         freeNr=freeSeats[i];
                                        freeSeats.remove(freeSeats[i]);
                                }
                        }
                } // for freeseats
                if(freeNr==-1)freeNr=++seatCounter;
trace("addPlayer : "+id+" with seatnr: "+freeNr);
trace("Length of RoomPlayerIDS: "+RoomPlayerIDs.length);
                if(RoomPlayerIDs.length < 2){
                        players.get(id).ActivePlayer=players.get(id).playerID;
                        activePlayerID=players.get(id).playerID;
                        activeSeatNR=freeNr;
trace("ActivePlayerID: "+activePlayerID);
trace("ActiveSeatNR  : "+activeSeatNR);
                }

                players.get(id).SeatNR=freeNr;
                getSeatInfo();
*/
	}


	public function addPlayerID(id:String, PlayerID:String){
		players.get(id).playerID=""+PlayerID;
	}
	//
	// Changed for new  mechanism : onEvent handlers
	//
	public function lockRoom(id:String, requestData:String){
trace("LOCKROOM: Going to attempt to lock the room: investigate state");
		// Receiving LockRequest
		// Set Time to data
		// Set client.sessionId to data
		var reason:String="";
		var lockParts:Array<String>=(""+requestData).split("*");
		var lockID:String=""+lockParts[1];
trace("LOCKROOM:  LockID: "+lockID);
		if(lockState==""){
			lockState=(Date.now().getTime())+"="+requestData;
trace("LOCKROOM: Lock Acquired by : "+id+" with lockstate: "+lockState);
			//players.get(id).lockState=lockState;
			//players.get(id).lockData="ROOM";

			var sendText:String="ONLOCKACCEPT*"+lockID+"*"+requestData+"*"+(Date.now().getTime());
trace("LOCKROOM: Send acept : "+sendText);
			players.get(id).lockState=sendText;
			players.get(id).lockData=reason;
		}else{
trace("LOCKROOM: Lock Denied for  : "+id);
			//players.get(id).lockState="ROOMLOCKDENIED";
			//players.get(id).lockData="ROOMLOCKDENIED";
			reason="ROOM_ALREADY_LOCKED*"+lockState; 
			var sendText:String=reason+"*"+lockID+"*"+(Date.now().getTime());
			players.get(id).lockState=sendText;
trace("LOCKROOM: Send denylock: "+sendText+" reason: "+reason);
			players.get(id).lockData=reason;
		}
	} // lockRoom

	public function unLockRoom(id:String, requestData:String){
trace("UNLOCKROOM: Attempt to release ROOM lock");
		// Receiving LockRequest
		// Set Time to data
		// Set client.sessionId to data
		if(lockState.length > 0){
			lockState="";
			players.get(id).lockState="UNLOCKROOM*"+"*"+(Date.now().getTime());
			players.get(id).lockData="ROOMLOCKRELEASED";
		}else{
			players.get(id).lockState="ROOMUNLOCKDENIED_ALLREADY"+"*"+(Date.now().getTime());
			players.get(id).lockData="ROOMUNLOCKDENIED_ALLREADY";
		}
	} // unlock entire room

	public function requestDataLock(id:String, requestData:String){
		var isOK:Bool=true;
		var playerID:String=players.get(id).playerID;
		var requestLocks:Array<String>=new Array<String>();
		// requestdata split into object , oldvalue and value
		// object,oldValue,newValue; object,oldValue,newValue; object,oldValue,newValue; 
		if(requestData.indexOf(seperateSplit) < 0) isOK=false;
		var requestDataList:Array<String>=requestData.split(seperateSplit);
		var objectCounter=1;
		var reason:String="";
		while(objectCounter < requestDataList.length && isOK){
			var objectString:String=requestDataList[objectCounter];	
			if(objectString.length > 0){
				var object:String=objectString.split(equalSplit)[0]; // @=@
				var oldValue:String=objectString.split(equalSplit)[1].split(oldNewSplit)[0]; // @$,$@
				var newValue:String=objectString.split(oldNewSplit)[1]; // @$,$@

trace("Lock Object: "+object+" oldValue: "+oldValue+" newValue: "+newValue);
				if(!lockMap.exists(object) && DataMap.get(object) == oldValue){ // only allow change / lock when the Map contains the client-oldvalue
				//if(!lockMap.exists(object) ){
					requestLocks.push(object);
					lockMap.set(object, newValue);
					lockUserMap.set(object,playerID); 
					lockTimeMap.set(object,""+Date.now().getTime()); 
				}else{
					if(lockMap.exists(object)){
						 reason="Key :"+object+" is in lockmap : release the lock please!!!!!";
					}else{
						if(DataMap.get(object) != oldValue) {
							reason=" value: "+DataMap.get(object)+" Not equal to oldvalue: "+oldValue;
						}
					}
					isOK=false;
				} // if not exists in lockMap and Map has the oldvalue
			} // ifObjectString
			objectCounter++;	
		} // objectCounter && isOK
		if(!isOK){
			// release all previouslocks
			for(requestObject in requestLocks){
				lockMap.remove(requestObject);
				lockUserMap.set(requestObject,""); 
				lockTimeMap.set(requestObject,"0"); 
			}
trace("Send denylock with reason: "+reason);
			// Send Deny lock
			players.get(id).lockState="DENYLOCK*"+reason+"*"+(Date.now().getTime());
			players.get(id).lockData="DENYLOCK";
		}else{
			// We acknowledge the locks
trace("Send acknowledge");
			players.get(id).lockState="LOCKACKNOWLEDGE*"+requestData+"*"+(Date.now().getTime());
		}
	} // changeLockData

	//
	// onLock Events
	//
	public function onLockRequest(id:String, lockID:String, requestData:String){
		var isOK:Bool=true;
		var playerID:String=players.get(id).playerID;
		var requestLocks:Array<String>=new Array<String>();
		var reason:String="";
//188@=@0@$,$@1000 @|;|@ 189@=@1000@$,$@0 @|;|@
		// requestdata split into object , oldvalue and value
		// object,oldValue,newValue; object,oldValue,newValue; object,oldValue,newValue; 
		if(requestData.length > 0 && requestData.indexOf(seperateSplit) < 0){
			isOK=false; 
			reason="invalid lockstring (must end with "+seperateSplit+" ;) :"+requestData+" : ONLOCKDENY"; // invalid lockstring
		}
// LOCKREQUEST*PlayerMove1*137@=@0@$,$@1000@|;|@138@=@1000@$,$@0@|;|@*

		var requestDataList:Array<String>=requestData.split(seperateSplit);
		var objectCounter=0;
		while(objectCounter < requestDataList.length && isOK){
			var objectString:String=requestDataList[objectCounter];	
			if(objectString.length > 0){
				var object:String=objectString.split(equalSplit)[0]; // @=@
				var newValue:String=objectString.split(equalSplit)[1].split(oldNewSplit)[0]; // @$,$@
				var oldValue:String=objectString.split(oldNewSplit)[1]; // @$,$@
trace("Lock Object: "+object+" oldValue: "+oldValue+" newValue: "+newValue+" mapdata: "+DataMap.get(object));
				if(!lockMap.exists(object) && DataMap.get(object) == oldValue){ // only allow change / lock when the Map contains the client-oldvalue
					requestLocks.push(object);
					lockMap.set(object, newValue);
					lockUserMap.set(object,playerID); 
					lockTimeMap.set(object,""+Date.now().getTime()); 
				}else{
					if(DataMap.get(object) != oldValue){
						reason="object != oldvalue : OUTOFSYNC";
					}
					if(lockMap.exists(object)){
						reason="Lock exists on lockmap : ONLOCKDENY";
					}
					isOK=false;
				} // if not exists in lockMap and Map has the oldvalue
			} // ifObjectString
			objectCounter++;	
		} // objectCounter && isOK
		if(!isOK){
			// release all previouslocks
			for(requestObject in requestLocks){
trace("Unlock object: "+requestObject+""); 
					lockMap.remove(requestObject);
					lockUserMap.set(requestObject,""); 
					lockTimeMap.set(requestObject,"0"); 
			}
			// Send Deny lock
			var sendText:String=reason+"*"+lockID+"*"+(Date.now().getTime());
			players.get(id).lockState=sendText;
trace("Send denylock: "+sendText+" reason : "+reason);
			players.get(id).lockData=reason;
		}else{
			// We acknowledge the locks
			// Set the new DataMap
				for(requestObject in requestLocks){
trace("Unlock object (acknowledge : accept) object: "+requestObject);
					var newValue:String=lockMap.get(requestObject);
					DataMap.set(requestObject, newValue);
					lockMap.remove(requestObject);
					lockUserMap.set(requestObject,""); 
					lockTimeMap.set(requestObject,"0"); 
                        	} // for 

			var sendText:String="";
			sendText="ONLOCKACCEPT*"+lockID+"*"+requestData+"*"+(Date.now().getTime());
trace("Send acept : "+sendText);
			players.get(id).lockState=sendText;
			
		}
	} // onLockRequest





	// Do we check if we locked the data ? Or should this be done on Client side?
	public function unlockData(id:String, requestData:String){
		var requestDataList:Array<String>=requestData.split(seperateSplit);
		var objectCounter=0;
		while(objectCounter < requestDataList.length){
			var objectString:String=requestDataList[objectCounter];	
			if(objectString.length > 0){
					var object:String=objectString.split(equalSplit)[0]; // @=@
					var oldValue:String=objectString.split(equalSplit)[1].split(oldNewSplit)[0]; // @$,$@
					var newValue:String=objectString.split(oldNewSplit)[1]; // @$,$@
				if(lockUserMap.get(object) == players.get(id).playerID){
					lockMap.remove(object);
					lockUserMap.remove(object);
					lockTimeMap.remove(object);
				}
				
			} // ifObjectString
			objectCounter++;	
		} // objectCounter 
		players.get(id).lockState="UNLOCKDATA*"+requestData+"*"+(Date.now().getTime());
	} // unlockData


	public function getData(id:String){
		var toClient:String="";
		for(objectKey in DataMap.keys()){
			var objValue:String=DataMap.get(objectKey);
			// Why is 0 here? That is the old data?!? that will never be matching!!
			//toClient=toClient+objectKey+",0,"+objValue+seperateSplit;	
			if(objValue == null)objValue="";
			//toClient=toClient+objectKey+oldNewSplit+objValue+oldNewSplit+objValue+seperateSplit;	
			toClient=toClient+objectKey+equalSplit+objValue+oldNewSplit+objValue+seperateSplit;	
		}
		players.get(id).lockState=""+(Date.now().getTime());
		players.get(id).lockData=""+toClient;
trace("Sending lockState: "+players.get(id).lockState); 
trace("Sending lockData: "+players.get(id).lockData); 
	} //getdata

	public function setData(id:String, data:String){
		var setDataList:Array<String>=data.split(seperateSplit);
trace(" (setdata) Contents of setDataList : "+setDataList);
//LOCKDATA*0@=@0@$,$@,1@=@1@$,$@,2@=@1@$,$@,3@=@0@$,$@,4@=@1@$,$@,5@=@0@$,$@,6@=@0@$,$@,7@=@1@$,$@,8@=@0@$,$@,9@=@0@$,$@,10@=@0@$,$@,11@=@0@$,$@,12@=@1@$,$@,13@=@0@$,$@,14@=@0@$,$@,15@=@1@$,$@,16@=@1@$,$@,17@=@1@$,$@,18@=@1@$,$@,19@=@0@$,$@,20@=@1@$,$@,21@=@0@$,$@,22@=@0@$,$@,23@=@0@$,$@,24@=@0@$,$@,25@=@1@$,$@,26@=@0@$,$@,27@=@0@$,$@,28@=@0@$,$@,29@=@0@$,$@,30@=@1@$,$@,31@=@0@$,$@,32@=@0@$,$@,33@=@0@$,$@,34@=@0@$,$@,35@=@0@$,$@,36@=@0@$,$@,37@=@1@$,$@,38@=@1@$,$@,39@=@1@$,$@,40@=@1001@$,$@,41@=@1@$,$@,42@=@1@$,$@,43@=@0@$,$@,44@=@0@$,$@,45@=@0@$,$@,46@=@0@$,$@,47@=@1
		//var objectCounter=1;
		var objectCounter=0;
		while(objectCounter < setDataList.length){
			var objectString:String=setDataList[objectCounter];	
			if(objectString.indexOf(oldNewSplit) > -1){
				var object:String=objectString.split(equalSplit)[0]; // @=@
				var newValue:String=objectString.split(equalSplit)[1].split(oldNewSplit)[0]; // @$,$@
trace( " (setdata) object="+object+"   newValue="+newValue+" ");
				DataMap.set(object, newValue);
			} // ifObjectString
			objectCounter++;	
		}// while length
		if(objectCounter > 1){
			// Do Not Send * : so client can pick up on only data changes instead of lock/unlock/deny etc..
			players.get(id).lockState=""+(Date.now().getTime());
			players.get(id).lockData=""+data;
trace("Sending lockState: "+players.get(id).lockState); 
trace("Sending lockData: "+players.get(id).lockData); 
		}
	} //setdata
} //lock class

