package server.rooms;
import js.node.vm.Script;
import colyseus.server.Room;
import colyseus.server.schema.Schema;
using colyseus.server.schema.Schema.MapSchemaUtil;

class Turn extends Room {

    var myState:TurnState;
	var PlayerCounter:Int;
	var nrOfSeats:Int;

    override function onInit (options:Dynamic) {
	var theOptions:Map<String, Dynamic>=Config.convertStringToMap(""+options);
trace("Turn created!", options);
trace("Turn created theOptions:", theOptions);
        myState = new TurnState();
	PlayerCounter=0;
	nrOfSeats=Std.parseInt(""+theOptions.get("nrOfSeats"));
        setState(myState);
	setMetadata(options);
for(i in 0 ... 10)trace("TODO : Set A TimeOUT on ActivePlayer .. when time too long : disconnect activeplayer and do a nextActive");
    }

    override function onJoin (client, ?options:Dynamic, ?auth:Dynamic) {
trace("options "+options);
	var msg:Map<String, Dynamic>=Config.convertStringToMap(""+options);
	
	var PlayerName:String	= 	msg.get("PlayerName");
	if(PlayerName==null) PlayerName="";
	var RoomName:String	= 	msg.get("RoomName");
	if(PlayerName==null) RoomName="ROOM0";
	var PlayerID:String	= 	msg.get("PlayerID");
	if(PlayerID==null) PlayerID="";

        myState.createPlayer(client.sessionId);
	myState.addPlayerID(client.sessionId, PlayerID);
	myState.addPlayerName(client.sessionId, PlayerName);

	if(PlayerCounter+1 < nrOfSeats){
		PlayerCounter++;
		myState.setPlayerPos(client.sessionId, PlayerCounter);
		myState.setLastPlayerPos(client.sessionId, -1);
		myState.setNrOfSeats(client.sessionId, nrOfSeats);
	}

	

        return null;
    }

    override function onLeave (client, ?consented:Bool) {
	myState.setLastPlayerPos(client.sessionId, -1);
	myState.setPlayerPos(client.sessionId, -1);
        myState.removePlayer(client.sessionId);
        return null;
    }

   override function onMessage (client, data:Dynamic) {
	var isHandled:Bool=false;
trace("Turn received message from", client.sessionId, ":", data);
	if((""+data).indexOf("SETACTIVESEATNR") > -1){
                myState.setActiveSeatNR(client.sessionId, ""+data);
                isHandled=true;
        }


	if((""+data).indexOf("TURNDATA") > -1){
 		myState.setData(client.sessionId, ""+data);
		isHandled=true;
	}

	if((""+data).indexOf("NEXTTURN") > -1){
		var dummyValue=myState.findNextActivePlayer();
		isHandled=true;
	}
	if((""+data).indexOf("SETMAXPLAYERS") > -1){
		var MaxPlayersStr:String=(""+data).split("=")[1];
		var maxPlayers:Int=Std.parseInt(""+MaxPlayersStr);
		this.maxClients=maxPlayers;
		isHandled=true;
	}
/*
	if((""+data).indexOf("GETNRPLAYERS") > -1){
trace("GETNRPLAYERS RECEIVED");
		var RoomID:String=(""+data).split("=")[1];
trace("GETNRPLAYERS Requested RoomID: "+RoomID);
			//broadcast("NRPLAYERS."+this.roomId+"."+this.nrOfPlayers);
		isHandled=true;
	} // getmaxplayers
*/
	if(!isHandled){
		myState.updateString(client.sessionId, ""+data);
	}
	myState.getSeatInfo();
    }

    override function onDispose () {
trace("Dispose Turn");
        return null;
    }
   //override function requestJoin (options:Dynamic, ?isNew: Bool):haxe.extern.EitherType<Float, Bool> {
   override function requestJoin (options:Dynamic, ?isNew: Bool){
	var retval:Bool=false;

	var oldMax=this.maxClients;

	var PlayerName:String	= 	"";
	var ActionType:String   =	"";

	this.maxClients=100;


	var prop:Map<String, Dynamic>=Config.convertStringToMap(""+options);
	
	var PlayerName:String	= 	prop.get("PlayerName");
	var PlayerID:String	= 	prop.get("PlayerID");
	var ActionType:String   =	prop.get("CreateOrJoin");
	var RoomID:String   	=	prop.get("RoomID");
	var MaxPlayers:String   =       prop.get("MaxPlayers");
	if(PlayerName==null) PlayerName="";
	if(PlayerID==null) PlayerID="";
	if(ActionType==null) ActionType="";	
	if(RoomID==null) RoomID="";	
	if(MaxPlayers==null) MaxPlayers="";	

	if(MaxPlayers!=""){
		this.maxClients=Std.parseInt(MaxPlayers);
	}
trace('Request join : this.roomId: |'+this.roomId+'| Type: |'+ActionType+ '| PlayerName: |'+PlayerName+ '| PlayerID: |'+PlayerID+'| OldMax: |'+ oldMax+'| ');
	if(ActionType!="JOIN" && (""+oldMax).indexOf("Infinity") > -1){
		 retval=true;
	} else {
		if(ActionType=="JOIN"){
			if(this.roomId == RoomID){
			 	retval=true;
			}else{
				retval=false;
			}
		}else{
			 retval=false;
		}
	}

	return retval;
    } // requestJoin
}
/*
var STRING = "string"; // utf8 strings	maximum byte size of 4294967295
	var NUMBER = "number"; // auto-detects the int or float type to be used. (adds an extra byte on output)	0 to 18446744073709551615
	var BOOLEAN = "boolean"; // true or false	0 or 1
	var INT8 = "int8"; // signed 8-bit integer	-128 to 127
	var UINT8 = "uint8"; // unsigned 8-bit integer	0 to 255
	var INT16 = "int16"; // signed 16-bit integer	-32768 to 32767
	var UINT16 = "uint16"; // unsigned 16-bit integer	0 to 65535
	var INT32 = "int32"; // signed 32-bit integer	-2147483648 to 2147483647
	var UINT32 = "uint32"; // unsigned 32-bit integer	0 to 4294967295
	var INT64 = "int64"; // signed 64-bit integer	-9223372036854775808 to 9223372036854775807
	var UINT64 = "uint64"; // unsigned 64-bit integer	0 to 18446744073709551615
	var FLOAT32 = "float32"; // single-precision floating-point number	-3.40282347e+38 to 3.40282347e+38
	var FLOAT64 = "float64"; // double-precision floating-point number	-1.7976931348623157e+308 to 1.7976931348623157e+308

*/

class TurnPlayer extends Schema implements ISchema {

	@:type(STRING)
	public var theString:String;
	@:type(STRING)
	public var playerName:String;
	@:type(STRING)
	public var playerID:String;
	@:type(NUMBER)
	public var SeatNR:Int;
	@:type(STRING)
	public var ActivePlayer:String;
	@:type(NUMBER)
	public var PlayerPos:Int;
	@:type(NUMBER)
	public var lastPlayerPos:Int;
	@:type(NUMBER)
	public var nrOfSeats:Int;
	


	public function new() {
		theString="NULL";
		//playerNames=new Array<Dynamic>();
		//playerNames.push("TestPlayerName");
		playerName="TestPlayerName";
		playerID="";
		SeatNR=-0;
		ActivePlayer="";
   	}
}

class TurnState extends Schema implements ISchema {
    @:type({map: TurnPlayer})
    public var players:MapSchema<TurnPlayer>;
   private var TurnDataMap:Map<String,String>=new Map<String,String>();

     public var equalSplit="@=@";
        public var oldNewSplit="@$,$@";
        public var seperateSplit="@|;|@";


    public var something:String = "This attribute won't be sent to the client-side";
	private var active:Active;

/*

	public var freeSeats:Array<Dynamic>=new Array<Dynamic>();
	public var seatCounter:Int=-1;
	public var activePlayerID:String="";
	public var activeSeatNR:Int=0;
	public var RoomPlayerIDs:Array<Dynamic>=new Array<Dynamic>();
*/

    public function new() {
        players = new MapSchema<TurnPlayer>();
	 active=new Active(players);

    }

    public function createPlayer(id: String) {
        players.set(id, new TurnPlayer());

    }

	public function nextTurn(id:String):String{
		return findNextActivePlayer();
	}

    public function removePlayer (id: String) {

	// Set All the state variable to empty
	players.get(id).theString="";

	    active.removePlayer(id);
/*

	RoomPlayerIDs.remove(id);

trace("REMOVE PLAYeR id: "+id+" With Seatnr: "+players.get(id).SeatNR);

	freeSeats.push(players.get(id).SeatNR);
trace("What are the freeSeats: "+freeSeats);

trace("What is the active Player: "+activePlayerID);
	// Check if the player leaving is the activeplayer
	//   IF leavingplayer == activeplayer : findNextActivePlayer
	if(activePlayerID  == players.get(id).playerID){
trace("The leaving player is the ActivePlayer!");
		trace("FindNextActivePlayer : "+findNextActivePlayer());
	}
	players.get(id).SeatNR=0;
	

        players.delete(id);
*/

    } // removePlayer

	public function findNextActivePlayer():String{
		return active.findNextActivePlayer();
	}

/*
	public function findNextActivePlayer():String{
		var retval:String="";
		var smallestSeat:Int=1000;
		var smallestSeatPlayerID:String="";
		var smallestPlayerIndex="";
trace("Find NExt Active. Current ActiveSeatNr: "+activeSeatNR);
		// loop through the players
		for(p in RoomPlayerIDs){
			if(players.get(p).SeatNR < smallestSeat) {
				smallestSeat=players.get(p).SeatNR;
				smallestSeatPlayerID=players.get(p).playerID;
				smallestPlayerIndex=p;
			}
			// check if there is a seat available after current activePlayerID
			if(retval.length < 1 && players.get(p).SeatNR == activeSeatNR+1){
trace("NExt active Seatnr : "+(activeSeatNR+1)+" Matches player : "+players.get(p).playerID);
				retval=players.get(p).playerID;
				activeSeatNR=players.get(p).SeatNR;
				activePlayerID=retval;
				// Set ActivePlayer in playerproperties	
				for(ap in RoomPlayerIDs){
					players.get(ap).ActivePlayer=retval;
				}
			} // NextSeat available?
			
		} // for all players in room
trace("SmallestSeat found: "+smallestSeat);
trace("Is playerID after current active? :"+retval.length);
		// If no player after current player
		if(retval.length < 1){
trace(" No : there is no player after ");
			retval=smallestSeatPlayerID;
			activeSeatNR=smallestSeat;
			activePlayerID=retval;
			for(ap in RoomPlayerIDs){
				players.get(ap).ActivePlayer=retval;
			}
		} // select smallest seatnr as activeseatnr
trace("PlayerID which is Active: "+retval);
		
		
		return retval;
	} // findNextActivePlayer
*/



	public function updateString(id:String, theString_: String){
trace("Update String: "+theString_);
		players.get(id).theString=""+theString_;
	}

	public function setPlayerPos(id:String, playerPos:Int){
		if(players.get(id) != null) players.get(id).PlayerPos=playerPos;
	}
	public function setLastPlayerPos(id:String, lastPlayerPos:Int){
		if(players.get(id) != null)		players.get(id).lastPlayerPos=lastPlayerPos;
	}
	public function setNrOfSeats(id:String, nrOfSeats:Int){
		players.get(id).nrOfSeats=nrOfSeats;
	}

	public function addPlayerName(id:String, PlayerName:String){

		active.addPlayerName(id, PlayerName);
/*
		if(Lambda.indexOf(RoomPlayerIDs, id) < 0){
			RoomPlayerIDs.push(id);
		}
		players.get(id).playerName=""+PlayerName;
		var freeNr:Int=-1;
		for(i in 0 ... freeSeats.length){
			if(freeNr==-1){
				if(freeSeats[i]>-1){
					 freeNr=freeSeats[i];
					freeSeats.remove(freeSeats[i]);
				}
			}
		} // for freeseats
		if(freeNr==-1)freeNr=++seatCounter;
trace("addPlayer : "+id+" with seatnr: "+freeNr);
trace("Length of RoomPlayerIDS: "+RoomPlayerIDs.length);
		if(RoomPlayerIDs.length < 2){
			players.get(id).ActivePlayer=players.get(id).playerID;
			activePlayerID=players.get(id).playerID;
			activeSeatNR=freeNr;
trace("ActivePlayerID: "+activePlayerID);
trace("ActiveSeatNR  : "+activeSeatNR);
		}
		
		players.get(id).SeatNR=freeNr;
		getSeatInfo();
*/
	} // addPlayerName

	public function addPlayerID(id:String, PlayerID:String){
		players.get(id).playerID=""+PlayerID;
	}

	public function getSeatInfo(){
		active.getSeatInfo();
	}
/*
	public function getSeatInfo(){
		for(p in RoomPlayerIDs){
			players.get(p).ActivePlayer=activePlayerID;
		}
	} // seatInfo
*/

	public function setActiveSeatNR(id:String, data:String){
                var setActiveSeatList:Array<String>=data.split("SETACTIVESEATNR:");
		active.setActiveSeatNR(Std.parseInt(""+setActiveSeatList[1]));
	} // setActiveSeatNR
		
   public function setData(id:String, data:String){
                var setDataList:Array<String>=data.split(seperateSplit);
trace(" (TURNsetdata) Contents of setDataList : "+setDataList);
                //var objectCounter=1;
                var objectCounter=0;
                while(objectCounter < setDataList.length){
                        var objectString:String=setDataList[objectCounter];
                        if(objectString.indexOf(oldNewSplit) > -1){
                                var object:String=objectString.split(equalSplit)[0]; // @=@
                                var newValue:String=objectString.split(equalSplit)[1].split(oldNewSplit)[0]; // @$,$@
trace( " (setdata) object="+object+"   newValue="+newValue+" ");
                                TurnDataMap.set(object, newValue);
                        } // ifObjectString
                        objectCounter++;
                }// while length
                if(objectCounter > 1){
                        // Do Not Send * : so client can pick up on only data changes instead of lock/unlock/deny etc..
			players.get(id).theString=""+data;
                }
		for(p in active.getRoomPlayers()){
			players.get(p).theString=""+data;
		}
        } //setdata


}

