// Lock
//
// DataMap locking mechanism. The server checks if the requested lock on the mapdata can be made
// If there was a lock from another client : lockDenied
// If the request has data from the client that are different from the data on the server : lockOutOfSync
//
// TO BE DONE :
//
// * lockTime out .. when request lock is made but the server does not respond in a timely matter
// * Clean out Room Locking : work around = use active player information to be the 'master'
// 
import io.colyseus.serializer.schema.Schema;
import io.colyseus.*;
import com.stencyl.utils.Utils;

class LockPlayer extends Schema {
	@:type("string")
	public var theString: Dynamic = "NULL";
	@:type("string")
	public var playerName:String = "";
	@:type("string")
	public var playerID:String = "";
	@:type("string")
	public var lockState:String = "";
	@:type("string")
	public var lockData:String = "";
	@:type("number")
	public var SeatNR:Int=0;
	@:type("string")
	public var ActivePlayer:String="";

}

class LockState extends Schema {
	@:type("map", LockPlayer)
	public var players: MapSchema<LockPlayer> = new MapSchema<LockPlayer>();
}


class Lock{
	public var room:Room<LockState>;
	public var isJoined:Bool=false;

	public var ColyseusDataList:Array<Dynamic>=new Array<Dynamic>();

	private  static var colyseus:Colyseus;
	
	private var isLockFunc:Bool=false;  // wrapper onLock 
	private var lockFunc:Dynamic=null; //  wrapper  onLock
	public var dataLockState:String="DENY";
	
	
	private static var equalSplit="@=@";
	private static var oldNewSplit="@$,$@";
	private static var seperateSplit="@|;|@";

		
	private var changeCounter:Int=0;
	public var lockedBy:String="";
	
	private var joinTimer:haxe.Timer=null;
	private var debugCounter:Int=0;

	private var activePlayerInstance:ActivePlayer;
	
	public static function debug(debugString:String){
		Colyseus.debug(debugString);
		
	} // debug
	

	public function new(){
		isJoined=false;
debug(" Lock : new init");		
		ColyseusDataList=new Array<Dynamic>();
		lockFunc=null;
		dataLockState="DENY"; // TBD = evaluate if this is needed!
	 } // new
	
	
	 
	public function join(client:Client, colyseus_:Colyseus,theOptions:Map<String, Dynamic>){
	    colyseus=colyseus_;
		activePlayerInstance=new ActivePlayer(colyseus);
		room = client.join("lock",theOptions, LockState);
		room.onJoin = function() {
			isJoined=true;
			debugCounter=0;
debug("ONJOIN : theOptions: "+theOptions);			
			room.state.players.onAdd = function(player, key) {
debug("Lock.onJoin.onAdd : "+player);	
		
				activePlayerInstance.addPlayerName(""+player.playerName);
				activePlayerInstance.addSeatMap(""+player.SeatNR, player.playerID);
				activePlayerInstance.getSeatInfo(player);
				

debug(" Player lockState: "+player.lockState);				
					// TO BE DONE   Room Lock ?     Propably REMOVE this(!)  .. you can do it with activeplayer that sends init data of some sort
					if((""+player.lockState).indexOf(seperateSplit) > -1){

						if(player.playerID == colyseus.PlayerID || (""+player.lockState).indexOf("ROOM") > -1 ){
debug("(onAdd) Do Lock State for player: "+colyseus.PlayerID+" player.playerID: "+player.playerID);
							doLockState(""+player.lockState);
						}
					}
					//  END OF .. investigate REMOVE
				player.lockData="";
			} // onAdd

			room.state.players.onChange = function(player, key) {
debug("ON CHANGE LockState: "+player.lockState+" changeCounter = "+changeCounter+" , LockData: "+player.lockData);
				if((""+player.lockState).indexOf("*") > -1){
					var lockParts:Array<String>=player.lockState.split("*");
					var onPart=lockParts[0];
					var lockID:String=lockParts[1];
					var lockData:String=lockParts[2];
					var lockTime:Float=Std.parseFloat(lockParts[3]);
debug(" push data onPart: "+					                 onPart);
					if(onPart.indexOf("ONLOCKACCEPT") > -1){
debug(" ONLOCKACCEPT  : Push data: "+lockData+"  to colyseusdatalist ");						
						ColyseusDataList.push(""+lockData);
					}
				
				
					// TO BE DONE   Room Lock ?     Propably REMOVE this(!)  .. you can do it with activeplayer that sends init data of some sort
						if(player.playerID == colyseus.PlayerID || (""+player.lockState).indexOf("ROOM") > -1 ){
debug("(onChange) Do Lock State with playerid: "+colyseus.PlayerID+" player.playerID: "+player.playerID);					
							doLockState(""+player.lockState);
						}
				}else{
debug("(onChange) LockData Received: "+player.lockData);// Modifications on the ObjectMap
					ColyseusDataList.push(""+player.lockData);
				}
				activePlayerInstance.getSeatInfo(player);
			}

			room.state.players.onRemove = function(player, key) {
debug("Lock.onRemove  "+ key);
debug("Lock remove player : "+player.playerName);
				activePlayerInstance.removeSeatMap(""+player.playerName,""+player.SeatNR);
				activePlayerInstance.getSeatInfo(player);
			}
		}; // onJoin

		room.onStateChange = function(state) {
		};

		room.onMessage = function(message) {
debug("Lock.onMessage : " + Std.string(message));
			
		};

		room.onError = function(message) {
debug("Lock.onError : " + message);
			colyseus.callErrorBlock(message);
		};

		room.onLeave = function() {
debug("Lock LEAVE :"+room.id);
			if(joinTimer!=null)joinTimer.stop();
			isJoined=false;
		}
	} // onJoin
	
	public function doLockState(playerLockState:String){
		
debug("Colyseus.Lock.DoLockState="+playerLockState);
				// datalock:
				//ONLOCKACCEPT*LockRequest1*;25,1000,3;31,3,1000;*1572251978042
				// or (roomlock)
				// ONLOCKACCEPT*47QSRonVd*LOCKROOM*47QSRonVd*RoomLock*ROOM**1574066151884 changeCounter = 0 , LockData: 
				//
				// TO BE DONE : Investiage if this is still needed .. is it part of the new Locking mechanism or is this RoomLock?
				//
				if(playerLockState.indexOf("ONLOCKACCEPT*")>-1){
					var lockParts:Array<String>=playerLockState.split("*");
					var lockID:String=lockParts[1];
					if(lockParts[2] == "LOCKROOM"){
						lockID=lockParts[4];
debug(" RoomLock : lockID: "+lockID);						
					}
					var callFunc:Dynamic=colyseus.lockAccept.get(""+lockID);
					colyseus.lockIDs.set(lockID, null); // do not do an unlock since it is already unlocked!!!

					if(callFunc!=null)callFunc();
					
				} // onLockAccept
				
				if(playerLockState.indexOf("OUTOFSYNC*") > -1){
					var lockParts:Array<String>=playerLockState.split("*");
					var lockID:String=lockParts[1];

					var callFunc:Dynamic=colyseus.lockOutOfSync.get(""+lockID);
debug(" OUTOFSYNC : lockID: "+lockID+" playerLockState value: "+playerLockState+" ; function?: "+callFunc);
					// remove the lockID from the map
					colyseus.lockIDs.set(lockID, null);

					if(callFunc!=null){
						callFunc();
					}
				}
				
				if(playerLockState.indexOf("ONLOCKDENY*") > -1){
					
					var lockParts:Array<String>=playerLockState.split("*");
					var lockID:String=lockParts[1];
debug(" Denied : lockID: "+lockID);
					var callFunc:Dynamic=colyseus.lockDenied.get(""+lockID);
					// remove the lockID from the map
					colyseus.lockIDs.set(lockID, null);
					
					if(callFunc!=null)callFunc();
					
					
				}

				// TO BE DONE : TIMEOUT is calculated on Client side ... we need to loop through all the lockids and check the time they send them
				if(playerLockState.indexOf("ONLOCKTIMEOUT*") > -1){
					var lockParts:Array<String>=playerLockState.split("*");
					var lockID:String=lockParts[1];
debug(" TIMEOUT : lockID: "+lockID);
					var callFunc:Dynamic=colyseus.lockDenied.get(""+lockID);
					// remove the lockID from the map
					colyseus.lockIDs.set(lockID, null);
					
					if(callFunc!=null)callFunc();
				
				}

				// TO BE DONE : Evaluate if this still is needed!
				if(playerLockState.indexOf("LOCKACKNOWLEDGE*") > -1){
					if(lockFunc!=null){
debug("LOCKACK RECEIVED :  CALLING LOCKFUNC ");			
						dataLockState="ALLOW";
						lockFunc();
					}else{
						//isLockFunc=false;
						lockFunc=null;
					}
				}
				
				// TO BE DONE : Evaluate if this is still needed
				if(playerLockState.indexOf("DENYLOCK*") > -1){ // datalock denied
debug("THROW ERROR: Lock Data is denied");
			
					if(lockFunc!=null){
						dataLockState="DENY";
						lockFunc();
					}else{
					
						lockFunc=null;
					}
				}
				
				// TO BE DONE : Evaluate if this is still needed
				if(playerLockState.indexOf("UNLOCKDATA*") > -1){
debug(" UNLOCKING Data .. release Lock isLockFunc = false");
					dataLockState="ALLOW";
					isLockFunc=false;
					lockFunc=null;
				}
		
	} // doLockState


	
	// Lock Data Wrapper
	// For Room Lock the LockRequest = "ROOM" 
	// For Data Lock  : object:oldValue=newValue; object:oldValue=newValue; object:oldValue=newValue; 
	// You only get lock when the room-object-state is oldValue and none of the locks or requestlocks are present
	//
	// TO BE DONE : Evaluate if this still is needed!
	public function onLockData(RoomOrData:String, LockRequest:String, onLockFunc:Dynamic){ // false = unlock, true = lock
debug(" On Lock Data ");		
			lockFunc=onLockFunc;
			if(RoomOrData == "ROOM"){
				// Send "LOCKROOMREQUEST*"++"*"+LockRequest)
				room.send("LOCKROOM*"+colyseus.PlayerID+"*"+LockRequest);
			}
			if(RoomOrData == "DATA"){
				// Send "LOCKDATAREQUEST*"+LockRequest)
				// Send LockRequest
				 room.send("REQUESTDATALOCK*"+colyseus.PlayerID+"*"+LockRequest);
				 
			}
			
		
	} // onLock wrapper
	
	// For Room Lock the LockRequest = "ROOM" 
	//
	// TO BE DONE : Evaluate if this still is needed!
	public function releaseLock(RoomOrData:String, LockRequest:String){
		if(RoomOrData == "ROOM"){
			// Send "UNLOCKROOMREQUEST*ROOM"
			//if(colyseus.PlayerID == lockedBy){
				var sendText:String="UNLOCKROOM*"+colyseus.PlayerID+"*"+LockRequest;
debug(" unlock SendText				: "+sendText);
				room.send(sendText);
			//}
			
		}
		
		// TO BE DONE : Remove this  and remove the block selector ' data ' 
		if(RoomOrData == "DATA"){
			// Send "UNLOCKDATA*"+LockRequest)
			var unLockString:String = colyseus.lockStrings.get(""+LockRequest);
			colyseus.lockIDs.set(LockRequest, null);
			
			room.send("UNLOCKDATA*"+colyseus.PlayerID+"*"+unLockString);
			
		} 
	} // release Lock
	
	public function getSeatNR():Int{
		return activePlayerInstance.getSeatNR();
	} // getSeatNR
		
	public function getActivePlayerID():String{
		return activePlayerInstance.getActivePlayerID();
	} // getActivePlayerID
	
	public function getActiveSeatNR():Int{
		return activePlayerInstance.getActiveSeatNR();
	} // getActiveSeatNR

	public function getPlayerInSeat(seatNR:String):String{
		return activePlayerInstance.getPlayerInSeat(seatNR);
	} // getPlayerInSeat
	
	public function getPlayerNames():Array<Dynamic>{
		return activePlayerInstance.getPlayerNames();
	} // getPlayerNames
	public function setActiveSeatNR(seatNR:Float){
		activePlayerInstance.setActiveSeatNR(seatNR);
	}
		

} // Class Lock

// --------------------
