

import com.stencyl.Engine;
import com.stencyl.behavior.Script.*;
import io.colyseus.Client;
import io.colyseus.Room;

import com.stencyl.utils.*; // HashMap Count

class StencylClient{

	public var client:Client=null;
	public var stencylRooms:Map<String,StencylRoom>=new Map<String,StencylRoom>();
	private var roomCounter:Int=-1;
	

	public var isInit:Bool=true;
	private var isActive:Bool=true;
	
	public var isError:Bool = false; // if there is an onError you cannot use the rooms/client functions anymore unless you do a new init
	private var ColyseusErrorMessage:String="";	
		


	private  var PlayerID:String=""; // current PlayerID
		
    	        
	private   var errorFunc:Dynamic=null;
		
	private   var RoomInfo:Array<Dynamic>=new Array<Dynamic>();
	
    private   var Rooms:Map<String, Array<Dynamic>>=new Map<String,Array<Dynamic>>();
        
    private   var PlayerIDs:Map<String, Dynamic>=new Map();
	
    private   var ApplicationID:String="";

	private var ClientNumber:Int=-1;
	
	private var ActiveRoomType:String="";
	
	public function createRoom(client:Client, RoomType:String, theOptions:Map<String, Dynamic>){
		roomCounter++;
		ActiveRoomType=RoomType;
		if(Utils.mapContainsValue(theOptions, "JOIN")){
trace("JoinID: "+RoomType);			
			stencylRooms.set(""+roomCounter, new StencylRoom(client,RoomType, theOptions) );
			
		}else{
trace("Create Room with Handler: "+RoomType);
			
			stencylRooms.set(""+roomCounter, new StencylRoom(client,RoomType, theOptions) );
		}
		
	} // createRoom
	
	public function getColyseusClient():Client{
			return client;
	} //getColyseusClient
	
	public function getActiveRoomNumber():Int{
		return roomCounter;
	} // getActiveRoom
	
	public function getActiveColyseusRoom():Room<State>{
		var retval:Room<State>=null;
		var theStencylRoom:StencylRoom=stencylRooms.get(""+roomCounter);
		if(theStencylRoom!=null)retval=stencylRooms.get(""+roomCounter).getColyseusRoom();
		return retval;
	}
	
	public function getActiveStencylRoom():StencylRoom{
		return stencylRooms.get(""+roomCounter);
	}
	
	
	public function isInitialized():Bool{
			return isInit;
	} // isInitialized
	
	public function setInitialized(state:Bool){
		isInit=state;
	} //setInit
	
	public function new(clientNumber:Int, server:String){
		
			ClientNumber=clientNumber;
			client = new Client(server); // "ws://192.168.2.121:8567"
			
			//
			// Create Lobby or let the stencyl-user decide??
			//
		
			// Check for Errors
			var errorTimer:haxe.Timer=new haxe.Timer(100);
			errorTimer.run=function(){
				var theStencylRoom:StencylRoom=stencylRooms.get(""+roomCounter);
				//RoomID="";
				
				if(getGameAttribute("ColyseusErrorMessage") != null && getGameAttribute("ColyseusErrorMessage").length > 0){
					isError = true; 
	
					ColyseusErrorMessage=""+getGameAttribute("ColyseusErrorMessage");
					setGameAttribute("ColyseusErrorMessage", "");
//					if(errorFunc != null) errorFunc();
				}
			}; // errorTimer
	
		
		// list available rooms for connection
		var myTimer:haxe.Timer=new haxe.Timer(1000);
		myTimer.run=function():Void{
			// for each Type
			var RoomTypes:Array<String>=new Array<String>();
			RoomTypes.push("state_handler");
			RoomTypes.push("lock");
			RoomTypes.push("lobby");
			RoomTypes.push("turnbased");
			for(ActiveRoomType in RoomTypes){
				client.getAvailableRooms(ActiveRoomType, function(rooms, ?err) {
					if(!isActive) return;
					if(isError)return;
					if (err != null){
				
						var message="getAvailableRoom error " + err;
trace(message);
							if(getGameAttribute("ColyseusErrorMessage") == null)setGameAttribute("ColyseusErrorMessage", ""); setGameAttribute("ColyseusErrorMessage", ""+getGameAttribute("ColyseusErrorMessage")+" "+message); 
					
						this.close();
						return;
					}
					PlayerIDs=new Map<String, Dynamic>();
				
					RoomInfo=new Array<Dynamic>();
					var theRooms:Array<Dynamic>=new Array<Dynamic>();
//trace("Rooms data in Available: "+rooms);				
					for (room in rooms) {
			
				//	trace("roomId: " + room.roomId);
						RoomInfo.push("RoomID: "+room.roomId);
					//RoomID=room.roomId;
				//	trace("clients: " + room.clients);
						RoomInfo.push("Clients: "+room.clients);
					
						theRooms.push(""+room.roomId);
				//	trace("maxClients: " + room.maxClients);
//trace("metadata: " + room.metadata);
					
						RoomInfo.push("RoomMeta: "+room.metadata);
						var searchString:String="theClients => [";	// CPP clients use this notation
						if( (""+room.metadata).indexOf("theClients : [") >-1) searchString="theClients : ["; // HTML5 clients use this notation
						if( (""+room.metadata).indexOf(searchString) > -1){
							var part:String=(""+room.metadata).substr( (""+room.metadata).indexOf(searchString)+13, 2000);
						
							// room
							var thePlayers:Array<Dynamic>=(""+part).split(",");
							for(aPlayer in thePlayers){
								var anID:String=""+aPlayer.split("=")[0];
								var aName:String=""+aPlayer.split("=")[1];
							
//Rooms data in Available: [{ roomId => RtPbgo9aC, maxClients => 100, clients => 1, metadata => { RoomName => Room7892, theClients => [z64WfL2Qy=GUEST19523] } }]
								anID=StringTools.trim(StringTools.replace(anID, "[" , ""));
								aName=StringTools.replace(aName, "]" , "");
								aName=StringTools.replace(aName, "=" , "");
								aName=StringTools.trim(StringTools.replace(aName, "}" , ""));
	
								if(anID.indexOf(""+room.roomId) > -1){
	//trace("metadata roomid: "+room.roomId+"  AnID : " +anID+"  name "+aName);		
									if(aName.indexOf("----") < 0){	// When player is removed from room its name will be -------
										PlayerIDs.set(anID, aName);
										
									}
								}
	
							} // for all players in metadata
							
						}
					}
					Rooms.set(ActiveRoomType, theRooms);
				});
			} // for all roomtypes
			
		} // run.function
		
		client.onOpen = function() {
			trace("CLIENT OPEN, id => " + client.id);
			isInit=true;	  
			isError=false;
			PlayerID=client.id;
			
		};

		client.onMessage = function(message) {
			trace("CLIENT MESSAGE: " + Std.string(message));
		};

		client.onClose = function () {
			trace("CLIENT CLOSE");
		};

		client.onError = function (_message){
			
			var message="onError: CLIENT ERROR: " + _message;
			trace(message);
			if(getGameAttribute("ColyseusErrorMessage") == null)setGameAttribute("ColyseusErrorMessage", ""); setGameAttribute("ColyseusErrorMessage", ""+getGameAttribute("ColyseusErrorMessage")+" "+message); 
			isError=true;
			this.close();
			// Do we call the errorFunc()?
			// //					if(errorFunc != null) errorFunc();
			
		};
	}; // clientTimer.run function
	
	public function close(){
		if(client!=null){
			// Close the room when we are inside
			for(item in stencylRooms.keys()){
				var theStencylRoom=stencylRooms.get(item);
				if(theStencylRoom != null){
					var theColyseusRoom:Room=theStencylRoom.getColyseusRoom();
					if(theColyseusRoom != null){
						theColyseusRoom.leave();
					}
				}
			}
			isActive=false;
			client.close();
		}
	} // close
	
	public function getPlayerIDs():Map<String, Dynamic>{
		var retval:Map<String, Dynamic>=new Map();
		if(PlayerIDs != null) retval=PlayerIDs;
		return retval;
	}

	
		public function getRooms():Map<String, Array<Dynamic>>{
				return Rooms;
		}// getRooms

			public function getPlayerID():String{
					return PlayerID;
			}
} // Class

//
//
//

