

import com.stencyl.Engine;
import com.stencyl.behavior.Script.*;

import openfl.ui.Keyboard;
import openfl.display.*;
import openfl.events.KeyboardEvent;

import io.colyseus.Client;
import io.colyseus.Room;

import com.stencyl.utils.*; // HashMap Count


class StencylRoom{

	public var room:Room<State>=null;
	
		private var playerSeats:Map<String, Dynamic>=new Map<String,Dynamic>();
		public   var isError:Bool = false; // if there is an onError you cannot use the rooms/client functions anymore unless you do a new init
		public   var is_Leaving:Bool = true;

		private   var globalState:Dynamic=null;
		
		public var lockFunc:Dynamic=null;
		public var dataFunc:Dynamic=null;
		
		private var pingStart:Float=0;
	    
		
        
		private   var PlayerData:Map<String, Dynamic>=new Map<String,Dynamic>();
		private var roomType:String="";
        public   var RoomID:String="";   // current RoomID
		
        
				private var LockChangeData:String="";
		private   var ColyseusErrorMessage:String="";
		private   var errorFunc:Dynamic=null;
		
		private   var RoomInfo:Array<Dynamic>=new Array<Dynamic>();
	
        private   var Rooms:Map<String, Array<Dynamic>>=new Map<String,Array<Dynamic>>();
        
			private var ServerGrid:Array<Dynamic>=new Array<Dynamic>();
		
        private   var ApplicationID:String="";

	
	
	
	public function new(client:Client, RoomType:String, theOptions:Map<String,Dynamic>){
		//room=client.join("state_handler", theOptions )
		// RoomType holds JoinID when joining, otherwise the name of the room handler
		room=client.join(""+RoomType, theOptions);
		//client.join("state_handler", theOptions )
		roomType=""+RoomType;
		roomActions(RoomType,theOptions);
	}
	
	public function join(client:Client, RoomType:String, theOptions:Map<String,Dynamic>){
		//room=client.join("state_handler", theOptions )
		// RoomType holds JoinID when joining, otherwise the name of the room handler
		room=client.join(""+RoomType, theOptions);
		//client.join("state_handler", theOptions )
		roomType=""+RoomType;
		roomActions(RoomType,theOptions);
	}
	
	public function forcePing(){
		if(room != null){
			pingStart=Date.now().getTime();
//trace("pingStart: "+pingStart);						
			room.send("PING="+pingStart);
		} // room?
	}//forecPing
	
	private function roomActions(RoomType:String, theOptions:Map<String,Dynamic>){
			if(Colyseus.pingInterval > 0){
				var pingTimer = new haxe.Timer(Colyseus.pingInterval);  // LocalTimer
				pingTimer.run = function() {
					// If we are pingging ..
//trace("Colyseus.getPing: "+Colyseus.getPing());
					if(Colyseus.getPing()){
						forcePing();
					} // getPing?
				} // pingTimer funciton
			} // if pingInterval > 0
			
			
			room.onJoin = function() {
				trace("This options: "+theOptions);
				
				is_Leaving=false;
				RoomID=room.id;
				
				
			};

			room.onStateChange = function (state) {
				//trace("STATE CHANGE: " + Std.string(state));
				
//lyseus.hx:118: STATE CHANGE: {
//	players : {
//D8fWZmaEQ : {
//			ID : 74mjIFtRI, 
//Name : GUEST60614, 
//x : 397, 
//y : 297
				
				// If you want to do anything with the room variable you need to check for null!
				if(room != null){
					//getInfoOnPlayers(state);
					globalState=state;
					if(room.name != 'lobby'){
						
						
						setGameAttribute("ColyseusErrorMessage", ""); 
						ColyseusErrorMessage="";
						
					}
				}
			};

			room.onMessage = function (message) {
				trace("ROOM MESSAGE: " + Std.string(message));
				// If you want to do anything with the room variable you need to check for null!
				
			};

			room.onError = function (message) {
			
				if(getGameAttribute("ColyseusErrorMessage") == null)setGameAttribute("ColyseusErrorMessage", ""); setGameAttribute("ColyseusErrorMessage", ""+getGameAttribute("ColyseusErrorMessage")+" "+message); 
				trace("onError: ROOM ERROR: " + message);
				RoomID=null;
				trace("Room name: "+room.name);
				// If you want to do anything with the room variable you need to check for null!
				if(room != null){
					if(room.name != 'lobby'){
			
						room=null;
					}
				}
			};
			// TODO : Check if this fires when other players than the current player leave ...
			room.onLeave = function () {
				trace("ROOM LEAVE ");
				// If you want to do anything with the room variable you need to check for null!
				is_Leaving=true;
			}

			room.listen("players/:id", function(change) {
				// If you want to do anything with the room variable you need to check for null!
				var theData:Map<String,Dynamic>=new Map<String,Dynamic>();
				// The change.path.id is probably the client.id and not the room.sessionid
//trace("Change listen players id: "+change.value);				
				if (change.operation == "add") {
					trace("Add player" +change.value);
					trace(" Add Player ID: "+change.path.id);
					//
					// search first free seat
					//
					var isFreeSpot=false;
					for(seatnr in playerSeats.keys()){
						if(!isFreeSpot){
							if(playerSeats.get(""+seatnr) == ""){
								playerSeats.set(""+seatnr, change.path.id);
								isFreeSpot=true;
							}
						}
					}
					if(!isFreeSpot){
						playerSeats.set(""+(Utils.mapCount(playerSeats)+1), change.path.id);
					}
					
					

				} else if (change.operation == "remove") {
					trace("remove Player"+change.value);
					for(seatnr in playerSeats.keys()){
						if(playerSeats.get(""+seatnr) == change.value){
							playerSeats.set(""+seatnr, "");
						}
					}
				}
			}, true);

			room.listen("players/:id/:axis", function(change) {
//trace(" Change: "+change);
				// The change.path.id is probably the client.id and not the room.sessionid
				if (change.path.axis == "x") {
//trace(""+change.path.id+" x= "+change.value);
					PlayerData.set(""+change.path.id+".x",change.value);
				} else if (change.path.axis == "y") {

//trace(""+change.path.id+" y= "+change.value);
					PlayerData.set(""+change.path.id+".y",change.value);
				}
//trace("PlayerData:"+PlayerData);
			});
			// If not axis, id, string, number etc.. then it is a STAR !!!!
			room.listen("players/:id/:star", function(change){
				//trace(" players/:id/:* path : "+change.path+"  value: "+change.value);
				var starItem:String=""+change.path;
				if(starItem.indexOf("seatNr") > -1){
trace(" ValueFor "+change.path.id+".seatNr: "+change.value);		
					PlayerData.set(""+change.path.id+".seatNr", change.value);
				} // seatNr
				if(starItem.indexOf("time") > -1){
					
					var timeIntVal=Std.parseFloat(""+change.value);
					var diffTime=timeIntVal-pingStart;
					
					PlayerData.set(""+change.path.id+".time", timeIntVal);
					PlayerData.set(""+change.path.id+".pingTime", diffTime);
trace("ValueFor  PingTime: "+diffTime);					
				} // time
				
			if( (""+starItem).indexOf("LockData") > -1 ){
					var isData:Bool=true;
					if(change.value.length > 0){
						if(change.value.indexOf("ERROR") == 0){
trace("LOCKDATA IS ERRRORRRRRRRRRRRRRRRRRRRR"+change.value);						
							// No change will be made
							isData=false;
							// For the active Player : call errorTrigger
							if(change.path.id == Colyseus.getPlayerSessionID()){
								Colyseus.lockErrorMessage="SERVER_LOCK_ERROR";
								Colyseus.unlockPhase();
								shoutToScene("_customEvent_" +Colyseus.ERRORTrigger);
								
								
							}
						}
						if(change.value.indexOf("UNLOCK") == 0){
							isData=false;
							Colyseus.unlockPhase();
							// We ignore message on unlock
							//shoutToScene("_customEvent_" +Colyseus.OKTrigger);
						}
						if(change.value.indexOf("GETGRID=") == 0){
trace("GETGRID Return Value :"+change.value);
								if(change.path.id == Colyseus.getPlayerSessionID()){
							
									var serverData:String=change.value.substr(change.value.indexOf("GETGRID=")+8);
									serverData=serverData.substring(0,serverData.length-1);
									ServerGrid=serverData.split(",");
									
trace("ServerGrid = "+ServerGrid);	
									if(Colyseus.ServerGridFunc != null)Colyseus.ServerGridFunc(ServerGrid);								
								}
						}
						if(isData){
						// changeList
						/*
trace("Isdata : "+change.value+"  .. substring of =[ until ] ");							
							var changeList:Array<Dynamic>=new Array<Dynamic>();
						
							var modifyData:String=change.value.substr(change.value.indexOf("LOCKED=")+7);
							//modifyData=modifyData.substr(0,modifyData.length-1);
trace("ModifyData convert to changelist: "+modifyData);			
							changeList=modifyData.split(",");
trace("changeList splitted is : "+changeList);
							if(dataFunc != null) dataFunc(changeList);
							*/
							// We have a LOCKDATA
							// isdata = change.value = "LOCKED=coordinates"
							// Send Change
							if(change.value.indexOf("LOCKED=") ==  0){
								// Check if the data is from this client/player
trace("ChangePathID:"+change.path.id+" playersession:"+Colyseus.getPlayerSessionID());
								if(change.path.id == Colyseus.getPlayerSessionID()){
								
									var changedata="";
									for(changePoint in Colyseus.changeList){
										changedata=changedata+changePoint+",";
									}
									if(changedata.length > 0){
										room.send("GRIDDATA="+changedata);
									}
								}
							}
							if(change.value.indexOf("GRIDDATA=") == 0){
								// we have successfully changed the data on the server, now send unlock
								if(change.path.id == Colyseus.getPlayerSessionID()){
								
									var unlockdata="";
									for(unlockPoint in Colyseus.lockList){
										unlockdata=unlockdata+unlockPoint+",";
									}
									if(unlockdata.length > 0){
										room.send("UNLOCK="+unlockdata);
									}
								}	 // if we were the sending player/client
								// Call OKTrigger
								// Set the Data
								
								var modifyData:String=change.value.substr(change.value.indexOf("GRIDDATA=")+9);
							
trace("ModifyData send to Client: "+modifyData);			  //Client: 27=1002:0,21=0:1002,
								
								LockChangeData=modifyData;
								// Check if the Grid values are matching the old server values
								var isBad=false;
								if(modifyData.indexOf(",") > 0){
									LockChangeData="";
									var ServerGridPoints:Array<Dynamic>=modifyData.split(",");
									for(ServerDataPoint in ServerGridPoints){
										if(ServerDataPoint.indexOf("=") > -1){
											var ServerDataValues:Array<Dynamic>=ServerDataPoint.split("=");
											var ServerPos=Std.parseInt(ServerDataValues[0]);
											
											if(!isBad && ServerDataValues[1].indexOf(":") > 0){
												var ServerOldValue=Std.parseInt(ServerDataValues[1].split(":")[0]);
												var ServerNewValue=Std.parseInt(ServerDataValues[1].split(":")[1]);
											
												if(Colyseus.Grid[ServerPos]!=ServerOldValue){
													trace("Grid["+ServerPos+"]  value is : "+Colyseus.Grid[ServerPos]+" does it match the old server value?: "+ServerOldValue+ "  BAD  ");
													isBad=true;
												}else{
													trace("Grid["+ServerPos+"]  value is : "+Colyseus.Grid[ServerPos]+" does it match the old server value: "+ServerOldValue+ "  GOOD ");
												}
												LockChangeData=LockChangeData+ServerPos+"="+ServerNewValue+",";
										
											} // = ?
										} // if contains :
									} // datPoints
									
								} // if "=" in modifydata
trace("LockChangeData: "+LockChangeData);								
								setGameAttribute("ColyseusData", LockChangeData);
								if(isBad){
									Colyseus.lockErrorMessage="SERVER_MISMATCH_CLIENT";
										shoutToScene("_customEvent_"+Colyseus.ERRORTrigger);
								}else{
									shoutToScene("_customEvent_" +Colyseus.OKTrigger);
								}
								
								
							} // griddata received
						}	 // isData

					} // value.length
				
				} // is star?
		}); // 


		room.listen("players/:id/t", function(getTime){
				// room.listen gives information on other fields than :time using:  "players/:id/:time" 
				// getTime.path.id = playersessionid
				
			if( (""+getTime.path.time).indexOf("time") > -1 ){


				var timeSplitter=(""+getTime.value).split("=");
				var timeIntVal=Std.parseFloat(""+timeSplitter[1]);
				var diffTime=(Date.now().getTime())-timeIntVal;
				PlayerData.set(""+getTime.path.id+".pingTime", diffTime);
			}
		}
		);
		

	} // new
	
	public function getColyseusRoom(){
		return room;
	}
	
	public function isLeaving():Bool{
			return is_Leaving;
	}
	
	public function setLeaving(state:Bool){
			is_Leaving=state;
	}
	
	public function getData():Map<String,Dynamic>{
		return PlayerData;
	}
	public function getGlobalState():Dynamic{
		return globalState;
	}
	
	public function getRoomID():String{
			return RoomID;
	} 
	
	public function getPlayerSeats():Map<String, Dynamic>{
			return playerSeats;
	}
	public function setLockFunc(func:Dynamic){
		lockFunc=func;
	}
	public function setDataFunc(func:Dynamic){
		dataFunc=func;
	}
	public function getLockChangeData():String{
		return LockChangeData;
	} 
	public function getServerGrid():Array<Dynamic>{
			return ServerGrid;
	}
} // class