//
// Score extension 
//
// Author: MdotEdot
//
// Use at your own risk
//
// No backups or guarantees are made on the availability of servers.
// 
// The server to which you connect must supply you with application-id and secret-id.
//
// Supplies:
//           
//
//
// The  imports need to be changed for 3.3
//
import nme.net.URLLoader;
import nme.net.URLLoaderDataFormat;
import nme.net.URLRequest;
import nme.events.Event;
import nme.events.IOErrorEvent;
// 3.3 version:
//
//import openfl.net.URLLoader;
//import openfl.net.URLLoaderDataFormat;
//import openfl.net.URLRequest;
//import openfl.events.Event;
//import openfl.events.IOErrorEvent;
//
//
//
//


// Game Attributes
import com.stencyl.Engine;


//
// You could have multiple URL-sources and multiple AppIDs
//
class Score{

	// Connection
	private static var loader:URLLoader=null;
	// Every AppID its own isConnect?
	public static var isConnect:Map<String,Bool>=new Map<String, Bool>();
	private static var exectimer:Float=0;
	public static var elapsedTime:Float=-1;
	
        // CallBack functions
        private static var callFunctions:Map<String,Dynamic>=new Map<String, Dynamic>();
	// When you call a function it needs to remember where it is calling from
	private static var callers:Map<String,String>=new Map<String, String>();



	public static var debug:Bool=false;

	// dbURL = 192.168.x.x:/database/stencyl.php
	// we will add ?a=  (a is the parameter that is used in stencyl.php)
	// Each AppID can have a different URL to connect (Like multiple servers, a free one and a paid one for instance)
	private static var urls:Map<String,String>=new Map<String,String>();
	// Each AppID its own secret
	private static var SecretIDs:Map<String,Float>=new Map<String,Float>();
	private static var appIDs:Map<String,String>=new Map<String,String>();
	private static var RoomIDs:Map<String,String>=new Map<String,String>();
	private static var listTypes:Map<String, String>=new Map<String, String>();


	// Data Lists on each type (time, text, number) <- based on (request)ID
	private static var textLists:Map<String,Array<Dynamic>>=new Map<String, Array<Dynamic>>();
        private static var timeLists:Map<String,Array<Dynamic>>=new Map<String, Array<Dynamic>>();
        private static var numberLists:Map<String,Array<Dynamic>>=new Map<String, Array<Dynamic>>();
        private static var rowList:Map<String,Float>=new Map<String, Float>();
        private static var posList:Map<String,Float>=new Map<String, Float>();



	// First in First Out List .. 
	private static var Score:Map<String,Dynamic>=new Map<String,Dynamic>();
	// push.Array

        // The functions that are called
        // The AppID that the action is performed on : Multiple AppIDs should be possible in one game <- confirmed with :Chat:Stress.stencyl
        private static var callAppIDs:Map<String,Dynamic>=new Map<String, Dynamic>();


	// Display Extension debug-text
	public static function setDebug(sw:Bool){
		debug=sw;
	} 

	public static function getExecTime():Float{
		var retval:Float=0;
		return retval;
	}

	// Do we have a connection / bad situation
	public static function isScoreConnect(appID:String):Bool{
		return isConnect.get(""+appID);
	}


	// initialize : just passing of variables : no connection to server required at this stage
	public static function initScore(dburl:String, appID:String, secretID:Float, func:Dynamic){
		var callID=getCallID("init", appID, func);
//debug
if(func != null) func();
		urls.set(""+appID, dburl);
		SecretIDs.set(""+appID, secretID);
		isConnect.set(""+appID, false);

		appIDs.set(""+callID, ""+appID);


		var scd=MultiPlay.makeCode(appID,secretID); // make secure code and return scd[0] + scd[1]

		var args:Array<String>=new Array<String>();
                args.push("score");
                args.push("init");
                args.push(""+callID);
                args.push(""+appID);
                args.push(""+scd[0]);
                args.push(""+scd[1]);

                //call(args);
                call(callID, args);

	
	} //initMessage


	public static function setScore(AppID:String, RoomID:Float, type:String, name:String, value:Dynamic, func:Dynamic){
                // When we are done with setting the score .. continue
		var callID=getCallID("setscore", AppID, func);
                // Make Code makes a calculation based on the secret and the
		
                var secret=SecretIDs.get(""+AppID);
                //var scd=makeCode(secret,AppID);
		var scd=MultiPlay.makeCode(AppID,secret); // make secure code and return scd[0] + scd[1]
		// Store argument for future reference using the AppID
		appIDs.set(""+callID, ""+AppID);
		RoomIDs.set(""+AppID, ""+RoomID);

//var Message:String="";
//var PlayerID=0;
//		var param:String=""+Base64.encode("score")+","+Base64.encode("set")+","+Base64.encode(""+callID)+","+Base64.encode(""+AppID)+","+Base64.encode(""+RoomID)+","+Base64.encode(""+PlayerID)+","+Base64.encode(""+Message)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
//Debug("Calling messages.sendmessage: "+param+" time:"+Date.now());
                //call(callID,param);

                //var scd=makeCode(secret,AppID);
		var scd=MultiPlay.makeCode(AppID,secret); // make secure code and return scd[0] + scd[1]

		var args:Array<String>=new Array<String>();

                args.push("score");
                args.push("setscore");
                args.push(""+callID);
                args.push(""+AppID);
		args.push(""+name); // name
		args.push(""+Base64.encode(""+value)); // scorevalue -> Extra encoding to make sure that : and . are valid strings for time
		args.push(""+type); // type
		args.push(""+RoomID); // level
                args.push(""+scd[0]);
                args.push(""+scd[1]);

                //call(args);
                call(callID, args);
	} // setScore

	public static function request(AppID:String, Level:Float, type:String, nr:Float, order:String, _id:Float, func:Dynamic){

                var callID=getCallID("requestscore", AppID, func);
                // Make Code makes a calculation based on the secret and the
                //var scd=makeCode(secret,AppID);
                // Store argument for future reference using the AppID
                appIDs.set(""+callID, ""+AppID);
                RoomIDs.set(""+AppID, ""+Level);

                // Keep track of the type that we request
                listTypes.set(""+_id,type);
                var secret=SecretIDs.get(""+AppID);
                //var scd=makeCode(secret,AppID);
		var scd=MultiPlay.makeCode(AppID,secret); // make secure code and return scd[0] + scd[1]

                var args:Array<String>=new Array<String>();

                args.push("score");
                args.push("requestscore");
                args.push(""+callID);
                args.push(""+AppID);
		args.push(""+type);
		args.push(""+Level);
		args.push(""+order);
		args.push(""+nr);
		args.push(""+_id);
                args.push(""+scd[0]);
                args.push(""+scd[1]);

                //call(args);
                call(callID, args);

        } // request score

	//
	// Request PlayerScore : Will fill rows and pos variables for the player as well
	//
 // <block tag="Score_RequestPlayerScore" spec="Score: Request score from playername: %3 AppID: %0 Level: %1 get type: %2 with ID: %4" code="Score.requestPlayerScore(~,~,~,~,~,function MyFunc(){~ });" type="wrapper" color="cyan" returns="void">
	public static function requestPlayerScore(AppID:String, Level:Float, type:String, PlayerName:String, _id:Float, func:Dynamic){

                var callID=getCallID("requestplayerscore", AppID, func);
                // Make Code makes a calculation based on the secret and the
                var secret=SecretIDs.get(""+AppID);
                //var scd=makeCode(secret,AppID);
		var scd=MultiPlay.makeCode(AppID,secret); // make secure code and return scd[0] + scd[1]
                // Store argument for future reference using the AppID
                appIDs.set(""+callID, ""+AppID);
                RoomIDs.set(""+AppID, ""+Level);

                // Keep track of the type that we request
                listTypes.set(""+_id,type);


                var args:Array<String>=new Array<String>();

                args.push("score");
                args.push("requestplayerscore");
                args.push(""+callID);
                args.push(""+AppID);
		args.push(""+type);
		args.push(""+Level);
		args.push(""+PlayerName);
		args.push(""+_id);
                args.push(""+scd[0]);
                args.push(""+scd[1]);

                //call(args);
                call(callID, args);
	}

        //<block tag="Score__getPosition" spec="Score: Get position on scoreboard for ID: %0 Order: %1 " code="Score.getPosition(~,~)" type="normal" color="red" returns="number">
         //                               <c text="Ascending" code="&quot;Ascending&quot;"/>
         //                               <c text="Descending" code="&quot;Descending&quot;"/>
	public static function getPosition(ID:Float, Order:String):Float{
		var retval:Float=-1;
		var rows=rowList.get(""+ID);
		var pos=posList.get(""+ID);
		if(pos != null && rows != null){
			if(Order == "Descending"){
				pos = (rows-pos);
			}else{
				pos++;
			}
			retval=pos;
		}
		return retval;
	}


//        <block tag="Score_getNumberOfRows" spec="Score: Get number of rows on scoreboard for ID: %0 " code="Score.getNumberOfRows(~)" type="normal" color="red" returns="number">
	public static function getNumberOfRows(ID:Float):Float{
		var retval:Float=-1;
		var temp:Float=rowList.get(""+ID);
		return temp;
	}


	public static function getList(ID:Float):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		var type=listTypes.get(""+ID);
trace("GetLisT: Type : "+type);
		if(type == "Number"){
                        var temp=numberLists.get(""+ID);
			if(temp != null){
				for(i in temp){
					retval.push(i);
				}
			}
		}
		if(type == "Text"){
                        var temp=textLists.get(""+ID);
			if(temp != null){
				for(i in temp){
					
					retval.push(i);
				}
			}
		}
		if(type == "Time"){
                        var temp=timeLists.get(""+ID);
			if(temp != null){
				for(i in temp){
					retval.push(i);
				}
			}
		}
		if(retval == null) retval=new Array<Dynamic>();
trace("GetList : retval : "+retval);
   for (item in cast(retval, Array<Dynamic>)){
trace("Item: "+item);
   }
		return retval;
	}


	//
	//
	// If there are errors in communications : set Connected to false
	// We might want to overthink this when errors are sparse and the system can overcome the errors .....
	//
	public static function onError(e:Event){
		var cvt=""+e;
                if(cvt.indexOf("?=c") > -1){
                        var callID:String=cvt.substring(cvt.indexOf("?c=")+3, cvt.indexOf("&"));
Debug("onError callback possibility : callID: "+callID);
			var appID=appIDs.get(""+callID);
			// Maybe we do not need to do this??!?
			isConnect.set(""+appID, false);
			// No function call ?
			callBack(callID);
		} // if we have callID information in the onError call?!?
	} // onError

public static inline function time():Float {
        #if flash
            return Date.now().getTime();
        #else
            return haxe.Timer.stamp()*1000;
//        #elseif cpp
            // return haxe.Timer.stamp()*1000;
        #end
}
	//
	private static function onData(e:Event){
                // get the Call ID from the data
                var e_str:String=""+e;

                elapsedTime=time()-exectimer;


if(debug)trace("In onData: "+e_str);
                var callID:String=e_str.substring(e_str.indexOf("?c=")+3, e_str.indexOf("&"));
				#if (openfl >= "4.0.0")
					var result=MultiPlay.Base64_URL_decode(cast(e.target,URLLoader).data);
					if(debug)trace("Data: "+cast(e.target,URLLoader).data+" Decoded: "+result);
				#else
				  var result=MultiPlay.Base64_URL_decode(cast(e.target,URLLoader).data);
if(debug)trace("Data: "+e.target.data+" Decoded: "+result);
				#end

                var items=result.split(",");
if(debug)trace("CallID?: items[0]: "+items[0]);
                if(items.length > 0 && (""+items[0]).charAt(0)=="C"){
                        dataActions(items);
                } // if items and items-first-element contains a C for callID
        }// onData

 //
        private static function dataActions(items:Array<String>){

                // items[0] = callID
                var text_func=""+callers.get(items[0]);
if(debug)trace("Inside dataAction : callID: "+items[0]+" text_func: "+text_func);
if(debug)trace("Inside dataAction : callID: "+items[0]+" State returned "+items[2]);
                if(text_func=="init"){
if(debug)trace("Inside initFunc checker .. what is the result of the checkCode: items1 : "+items[1]);
 			var appID=appIDs.get(""+items[0]);
                        isConnect.set(""+appID, false);

                        if(items[1] == "OK") isConnect.set(""+appID, true);
                        callBack(items[0]);
                } // init

                if(text_func=="setscore"){
                        if(items[2] == "OK"){ callBack(items[0]); }

                } // setroomdata
		if(text_func=="requestscore"){
			if(items[2]=="OK") {
				 // Store the results in the ID location so that other blocks can retrieve it
				// # and . extraction
trace("requestscore result :"+items[3]);
				interpretData(items);
				callBack(items[0]); // callback function	
			}
		} // requestScore (List)
		if(text_func=="requestplayerscore"){
			if(items[2]=="OK") {
				 // Store the results in the ID location so that other blocks can retrieve it
				// # and . extraction
				//C2027807,requestscore,OK,!456!TWRvdEVkb3Q.#1300316#15*9#!
				interpretPlayerScore(items);
				//interpretData(items);
				callBack(items[0]); // callback function	
			}
		} // requestPlayerScore

        } // eof dataActions


 // Calls the wrapper functions after data was received (eiter onData or onError)
        private static function callBack(callID:String){
                var callback:Dynamic;
                if(callID!=null && callID.length > 0){
                        // get the function pointer
if(debug)trace("Calling the callback function that we stored("+callID+") ");
                        // This is the name of the function .. we might want to do some stuff before actually calling it?§§
                        var func=callers.get(callID);
			var callback=callFunctions.get(callID);
if(debug)trace("Calling the callback function that we stored("+callID+") : "+callback+" name of func: "+func);
                        if(callback != null) callback();
                } // if callID is valid
        } // eof callBack




 // Call : arguments that are send to the server : CallID to communicate the result with this extension
        // onData: Return data function
        // onError: What do we do with the errors?
        // callback: Based on the data received we are doing the call-back function store in the extension for the callID
        //
        private static function call(CallID:String, Args:Array<String>){
                var str:String="";


                // Store the timer
                exectimer=time();

                // Convert each argument into a Base64 encoded string
                for(arg in Args){
if(debug)trace("Sending Data : "+arg+" encode the arg: "+MultiPlay.Base64_URL_encode(arg));
                        str=str+MultiPlay.Base64_URL_encode(arg)+",";
                }
                var url_encode:String=MultiPlay.Base64_URL_encode(str);
if(debug)trace("encrypted send: "+url_encode);
	
		var AppID=appIDs.get(""+CallID);
if(debug)trace("What is appid :"+AppID);
		var URL:String=urls.get(""+AppID);
		if(URL != null){
                	var execUrl=""+URL+"?c="+CallID+"&a="+url_encode+"&t="+MultiPlay.Base64_URL_encode(""+Date.now());
if(debug)if(debug)trace("Calling :"+execUrl);
	            	    var r:URLRequest=new URLRequest(execUrl);
	                var ul:URLLoader=new URLLoader();
	                ul.addEventListener( IOErrorEvent.IO_ERROR, onError);
	                ul.addEventListener(Event.COMPLETE,onData);
	                ul.load(r);
		}else{
			trace("ScoreBoard : URL is null .. check your AppID on all the blocks!");
		}
        } // call -- 

//
// -- Specific Extension Code
//

  // Investigate the data
	public static function interpretData(idata:Array<Dynamic>){

                var r:Array<Dynamic>=new Array<Dynamic>();
var id=idata[3];
var data=idata[4];
trace("Id from request is: "+id);
trace("Received list data : "+data);
		var type=listTypes.get(""+id);
		if(type == null) type="Number";

                if(data.length > 0){

if(debug)trace("received List : ["+data+"]");

                        var spl:Array<String>=data.split("!");

                        for(adata in spl){

//if(debug)trace("Adata :" +adata);

                                var ddata=adata.split("#");

                                if(ddata[1] != null){

                                        // name value pushed

                                        var p1=StringTools.replace(""+ddata[0], ":", "+");

                                        var p2=StringTools.replace(p1, "_", "/");

                                        var p3=StringTools.replace(p2, ".", "=");

                                        var store:Array<Dynamic>=new Array<Dynamic>();

                                        store.push(Base64.decode(p3));



                                        // if we have text decode it once more

                               //         if(type=="Text" || type=="Time"){
                                        if( type=="Time"){

                                                var p_1=StringTools.replace(""+ddata[1], ":", "+");

                                                var p_2=StringTools.replace(p_1, "_", "/");

                                                var p_3=StringTools.replace(p_2, ".", "=");

                                                store.push(Base64.decode(p_3));

                                        }else{

                                                store.push(ddata[1]);

                                        }

                		        r.push(store);

                                        // Position and rows

                                        if(ddata[2] != null && ddata[2].indexOf("*") > -1){

                                                var rdata=ddata[2].split("*");

if(debug)trace("GetPlayerScore Number pos found: Rows:"+rdata[0]+" - Pos: "+rdata[1]+" The ID: "+id);
                                                rowList.set(""+id, Std.parseFloat(rdata[0]));

                                                posList.set(""+id, Std.parseFloat(rdata[1]));



                                        }

                                } // if column?

                        } // if line

                } // if data

                //

                //

                // Get the AppID from the resulting data ...

                //

                if(r == null) r = new Array<Dynamic>();

                if(type=="Text"){
                        textLists.set(""+id, r);
                }

                if(type=="Number"){
                        numberLists.set(""+id,r);
                }

               if(type=="Time"){
                        timeLists.set(""+id,r);
                }

	} // interpretData


	public static function interpretPlayerScore(idata:Array<Dynamic>){

                var r:Array<Dynamic>=new Array<Dynamic>();
		//C2027807,requestscore,OK,!456!TWRvdEVkb3Q.#1300316#15*9#!
		var playerscore:Array<Dynamic>=idata[3].split("!");
trace("The idata[3] : "+idata[3]);
		if(playerscore != null && playerscore.length > 1){
			var id=playerscore[1];
			var type=listTypes.get(""+id);
trace("Id from request is: "+id);
			var data:Array<Dynamic>=playerscore[2].split("#");
trace("Received list data : "+data);
                	if( data != null && data.length > 1){
if(debug)trace("received List : -"+data+"-");
				var PlayerName=MultiPlay.Base64_URL_decode(""+data[0]);
// type Number / Time / Text
				var PlayerScore; // no type since it can change !
				if(type == "Text" || type == "Time"){
					PlayerScore=MultiPlay.Base64_URL_decode(""+data[1]);
				}else{
					PlayerScore=data[1];
				}
				var rows=data[2].split("*")[0];
				var pos=data[2].split("*")[1];
trace("PlayerName: "+PlayerName);
trace("Score: "+PlayerScore);
trace("RowS: "+rows);
trace("Pos: "+pos);
				posList.set(""+id, Std.parseFloat(pos));
				rowList.set(""+id, Std.parseFloat(rows));
				var scores:Array<Dynamic>=new Array<Dynamic>();
				var score:Array<Dynamic>=new Array<Dynamic>();
				score.push(""+PlayerName);
				score.push(PlayerScore);
				// List IN a List (!!) 
				scores.push(score);
				if(type == "Number"){
trace("PlayerScore : storing number list ");
                       			 numberLists.set(""+id, scores);
				}
				if(type == "Text"){
trace("PlayerScore : storing Text list ");
                        		textLists.set(""+id, scores);
				}
				if(type == "Time"){
trace("PlayerScore : storing Time list ");
                        		timeLists.set(""+id, scores);
				}
			} // playerscore data available?
		} // playerscore ! = null 
	} // intreptPlayerScore





     	//
        // Store the function to the callers
        //
        // We create an ID which is random and unique to us and store that number with the function_pointer in a List.
        //
        // When we receive data with that ID we know that the data belongs to the call made with this ID
        //
        public static function getCallID(callFunction:String, appID:String, function_pointer:Dynamic):String{
                var retval="";
                var found=true;
                while(found){
                        retval="C"+Std.random(2300023);
                        var chk=callers.get(retval);
                        if(chk == null){
                                found=false;
                                callers.set(retval, callFunction);
				callFunctions.set(retval, function_pointer);
                                callAppIDs.set(retval,""+appID);
                        }
                }
                return retval;
        } // getCallID

	public static function Unique():Float{
           	return Std.random(8999999);
	}


	public static function Debug(text:String){
		if(debug){
			trace(""+text);
		}
	}
} // class
