package com.nfc.SayNFC;

import org.haxe.extension.Extension; // for extending extension
import android.content.Context; // for mainContext
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.app.Activity;

//Intent
import android.content.Intent;
import android.content.IntentFilter;
import android.app.PendingIntent;
import android.nfc.tech.NfcF;

//Toasting
import android.widget.Toast;
import android.os.Handler;
import android.os.Bundle;

//NFC
import android.nfc.NdefMessage;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.Ndef;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcAdapter.CreateNdefMessageCallback;
import android.nfc.NfcEvent;
import android.os.Parcelable;
import android.nfc.Tag;

public class NFC extends Extension{ 
 	public static NfcAdapter mNfcAdapter=null;
	public static Tag tag=null;
	public static String lastRead = "";
	public static IntentFilter mFilters[];
	public static String[][] mTechLists;

	public static PendingIntent mPendingIntent;
	public static String theText="";


	public static Intent intent;

 	@Override
        public void onCreate(Bundle bundle){
                super.onCreate(bundle);
		mNfcAdapter = NfcAdapter.getDefaultAdapter(mainActivity);
		if (mNfcAdapter == null) {
			Toast.makeText(mainActivity, "NFC is not available", Toast.LENGTH_LONG).show();
			return;
		}

		intent = new Intent(mainActivity,mainActivity.getClass());
		mPendingIntent = PendingIntent.getActivity(mainContext, 0, new Intent(mainContext,mainActivity.getClass()).addFlags(Intent.FLAG_RECEIVER_REPLACE_PENDING), 0);

		IntentFilter ndef = new IntentFilter(NfcAdapter.ACTION_NDEF_DISCOVERED);
		try{
			ndef.addDataType("*/*");
		}catch(Exception e){}
		IntentFilter nt = new IntentFilter(NfcAdapter.ACTION_TAG_DISCOVERED);

		mFilters = new IntentFilter[]{
			ndef,nt,
		};

		mTechLists = new String[][] { new String[] { NfcF.class.getName() } };
	
	} // onCreate

	@Override
	public void onNewIntent(Intent intent){
		NdefMessage[] messages = null;  
		// When we need to write tag later .. we store the tag now!
		if(NfcAdapter.ACTION_TAG_DISCOVERED.equals(intent.getAction())){
			tag = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
		}
		Parcelable[] rawMsgs = intent.getParcelableArrayExtra(NfcAdapter.EXTRA_NDEF_MESSAGES);  
		if (rawMsgs != null) {  
			messages = new NdefMessage[rawMsgs.length];  
			if(messages != null){
				for (int i = 0; i < rawMsgs.length; i++) {  
					messages[i] = (NdefMessage) rawMsgs[i];  
				}  
			}
		}  
		if( messages != null && messages[0] != null) {  
			String result="";  
			byte[] payload = messages[0].getRecords()[0].getPayload();  
			if(payload != null){
				for (int b = 1; b<payload.length; b++) { // skip SOH  
					result += (char) payload[b];  
				}  
				if(result != null){
					lastRead=""+result;
				}
			}
		} // if messages 
	} // onNewIntent

	@Override
	public void onResume() {
		super.onResume();
		mNfcAdapter.enableForegroundDispatch(mainActivity, mPendingIntent,  null, null);
	} // onResume


	public static void formatTag(Tag tag,NdefMessage ndefMessage){
		try{
			NdefFormatable ndefFormatable=NdefFormatable.get(tag);
			if(ndefFormatable == null){
				Toast.makeText(mainActivity, "This Tag is Not ndef Formatable!", Toast.LENGTH_SHORT).show();
				return;
			}
			ndefFormatable.connect();
			ndefFormatable.format(ndefMessage);
			ndefFormatable.close();
		}catch(Exception e){
			Toast.makeText(mainActivity, "formatTag: Error: "+e.toString(), Toast.LENGTH_SHORT).show();
		}
	}//formatTag


	public static void writeNdefMessage(Tag tag, NdefMessage ndefMessage){
		try{
			if(tag == null){
				return;
			}

			Ndef ndef = Ndef.get(tag);
			if(ndef == null){
				//formats tag with the ndef format and writes the message
				formatTag(tag, ndefMessage);
			}else{
				ndef.connect();
				if(!ndef.isWritable()){
					Toast.makeText(mainActivity, "Tag is not writable!", Toast.LENGTH_SHORT).show();
					ndef.close();
					return;
				}
	
				ndef.writeNdefMessage(ndefMessage);
				ndef.close();
//Toast.makeText(mainActivity, "Written: "+ndefMessage, Toast.LENGTH_SHORT).show();
			}
		}catch(Exception e){
			Toast.makeText(mainActivity, "writeNdefMessage: Error: "+e.toString(), Toast.LENGTH_SHORT).show();
		}
	}// writeNdefMessage

	public static NdefMessage createNdefMessage(String content){
		try{
			String lang = "en";
			byte[] textBytes = content.getBytes();
			byte[] langBytes = lang.getBytes("US-ASCII");
			int langLength = langBytes.length;
			int textLength = textBytes.length;
			byte[] payload = new byte[1 + langLength + textLength];
			payload[0] = (byte) langLength;
			// copy langbytes and textbytes into payload
			System.arraycopy(langBytes, 0, payload, 1, langLength);
			System.arraycopy(textBytes, 0, payload, 1 + langLength, textLength);
			NdefRecord recordNFC = new NdefRecord(NdefRecord.TNF_WELL_KNOWN, NdefRecord.RTD_TEXT, new byte[0], payload);
			NdefMessage ndefMessage=new NdefMessage(new NdefRecord[] {recordNFC});
			return ndefMessage;
		}catch(Exception ega){
			return null;
		}
	} // createNdefMessage

// ---------------- Interface to the outside world (HaXe) --------------------

	// Write the message to the Tag
	public static void write(String thetext){
		theText=""+thetext;
		try{
			NdefMessage ndefMessage = createNdefMessage(""+theText);
			if(ndefMessage != null){
				// tag is from onNewIntent(Intent intent)
				writeNdefMessage(tag, ndefMessage);
			}
		}catch(Exception ea){}
	} //write

	public static String read(){
		// last read is read in onNewIntent
		return ""+lastRead;
	} // read

} // class
