import openfl.display3D.*;
import com.stencyl.graphics.*;
import com.stencyl.Engine;
import com.stencyl.behavior.*;
import com.stencyl.behavior.Script.*;
import haxe.macro.Context;
import com.stencyl.graphics.shaders.*;

import openfl.geom.Point;
import openfl.geom.Rectangle;
import openfl.filters.*;
import com.stencyl.models.*;

#if flash
import flash.display.*;
#else
import openfl.display.*;
import lime.graphics.opengl.*; // GLProgram
import lime.utils.Float32Array;
#end


class ImageShaders{


	// Map to contain the shader name and its properties....
	public static var Images:Map<String, Dynamic>=new Map<String, Dynamic>();
	public static var UniformList:Map<String, Dynamic>=new Map<String, Dynamic>();
	public static var Shaders:Map<String, Shader>=new Map<String, Shader>();

	public static function ActorShader(name:String, actor:Actor, code:String){

#if !flash
		// Default VertexSource : you need this when you want to create a bitmapshader
		var _vert="attribute vec4 openfl_Position;	attribute vec2 openfl_TextureCoord;	varying vec2 openfl_TextureCoordv;	uniform mat4 openfl_Matrix;	uniform vec2 openfl_TextureSize;void main(void){openfl_TextureCoordv = openfl_TextureCoord;	gl_Position = openfl_Matrix * openfl_Position;}";

		var shader=new Shader();
		
		shader.glFragmentSource=code;
		shader.glVertexSource=_vert;
		
		var data=shader.data; // This makes the glfragmentSource and glVertexSource active
		
		for(item in Images.keys()){
			if(item.indexOf(name)==0){
				var uniformName:String=item.substr(name.length+1,item.length);
			
				var dynObject2:Dynamic=data;
				if(dynObject2 != null){
				
					var attribute:Dynamic=Reflect.getProperty(dynObject2, ""+uniformName); // set the uniform data
					if(attribute != null){
						Reflect.setProperty(attribute, "value", [Images.get(item)]); // to this value
					}else{
						trace("Attribute is null: " +uniformName+" !!" );
					}
				}
			} // does name match?

		} // Image Map with Uniform Names
		var data=shader.data; // This makes the glfragmentSource and glVertexSource active
//trace("Data is : "+data);
		actor.currAnimation.shader = shader;
trace("Add to shaders: "+name);		
		Shaders.set(name, shader);
		
#end		
		
	}
	
	public static function call(name:String, image:BitmapData, code:Dynamic, func:BitmapWrapper->Void){

#if !flash
		// Default VertexSource : you need this when you want to create a bitmapshader
		var _vert="attribute vec4 openfl_Position;	attribute vec2 openfl_TextureCoord;	varying vec2 openfl_TextureCoordv;	uniform mat4 openfl_Matrix;	uniform vec2 openfl_TextureSize;void main(void){openfl_TextureCoordv = openfl_TextureCoord;	gl_Position = openfl_Matrix * openfl_Position;}";

		var bitmap=new Bitmap(image); // Make a Bitmap from the BitmapData
		
		var shader=new Shader();
		
		shader.glFragmentSource=code;
		shader.glVertexSource=_vert;
		
		var data=shader.data; // This makes the glfragmentSource and glVertexSource active
		
		for(item in Images.keys()){
			if(item.indexOf(name)==0){
				var uniformName:String=item.substr(name.length+1,item.length);
			
				var dynObject2:Dynamic=data;
				if(dynObject2 != null){
				
					var attribute:Dynamic=Reflect.getProperty(dynObject2, ""+uniformName); // set the uniform data
					if(attribute != null){
						Reflect.setProperty(attribute, "value", [Images.get(item)]); // to this value
					}else{
						trace("Attribute is null: " +uniformName+" !!" );
					}
				}
			} // does name match?

		} // Image Map with Uniform Names
		var data=shader.data; // This makes the glfragmentSource and glVertexSource active
//trace("Data is : "+data);
		bitmap.shader=shader; // apply the shader to the bitmap

		// get the instance and return it to the wrapper block
		var returnInstance:BitmapWrapper=new BitmapWrapper(bitmap);
trace("Add to shaders: "+name);		
		Shaders.set(name, shader);
		
		func(returnInstance);
#end	
	} // call
	
	public static function setProperty(name:String, property:String, value:Dynamic){
	
		Images.set(""+name+"."+property, value);
		// When shader is active : change the uniform
		if(com.stencyl.utils.Utils.mapCount(Shaders) > 0 && Shaders.get(name)!=null){
		
			var shader:Shader=cast(Shaders.get(name),Shader);
			
			
			var dynObject2:Dynamic=shader.data;
			if(dynObject2 != null){
				
				var attribute:Dynamic=Reflect.getProperty(dynObject2, ""+property); // set the uniform data
				if(attribute != null){
					Reflect.setProperty(attribute, "value", [value]); // to this value
					
				}
			}
			
			
		} // count
	}
	
	
	
} // ImageShaders class

