/*
	TurnBased Extension
*/


// For Stencyl 3.3 change all the nme.* into openfl.*
import nme.net.URLLoader;
import nme.net.URLLoaderDataFormat;
import nme.net.URLRequest;
import nme.events.Event;
import nme.events.IOErrorEvent;
import nme.display.*;
//import nme.display.DisplayObject;


import com.stencyl.Engine;
import com.stencyl.behavior.Script;
import com.stencyl.behavior.ActorScript;
import com.stencyl.models.actor.ActorType;

// Use at your own risk!

class Turn{
        // All default settings go into initialization since we do a disconnect sometimes ...
        private static var script:Script;

	// Timer
        private static var heartTimer:haxe.Timer;
	private static var SecondCounter:Float;
	private static var HeartBeat:Float;
	private static var TurnTime:Float;

	private static var debug:Bool=false;


	// SadiQ told me no one would ever need more AppIDs in their games .. so stop making extension overcomplicated!
	// private static var urls:Map<String,String>=new Map<String,String>();
	// private static var appids:Map<String,String>=new Map<String,String>();
	// private static var secrets:Map<String,Float>=new Map<String,Float>();
	private static var URL:String;
	private static var SecretID:Float;
	private static var AppID:String;


	// Player Information
	private static var PlayerID:Float;
	private static var PlayerName:String;
	private static var CurrentElapsed:Float;
	private static var CurrentPlayerID:Float;
	private static var CurrentPlayerName:String;
	//private static var CurrentRoomPlayerNames:Array<Dynamic>;
	private static var CurrentRoomPlayerNames:Map<String, Dynamic>;
	private static var CurrentRoomPlayerIDs:Array<Dynamic>;

	// Room information
	//private static var RoomName:String;
	public static var RoomName:String;
	//private static var PlayerSeats:Array<Dynamic>;
	private static var PlayerSeats:Map<String, Float>; // The ID is used to get/set playerset with the server data
	private static var Seat:Float;
	private static var SharedData:Map<String,Dynamic>;
	private static var RestartCounter:Float; // keep track of resetrooms and ingame-restarts
	


	// CallBack functions
	private static var callers:Map<String,String>;
        private static var callFunctions:Map<String,Dynamic>;


	// Internal Extension 
	private static var isConnect:Bool;
	private static var State:String; // state of the connection/result/search

	private static var TurnState:Int; // 0 = no transitioning, 1 = transitioning, 2 = data sent
	private static var isChanged:Bool; // Did we change .. keep track of currentplayerid <-> oldcurrentplayerid
	private static var isAskChange:Bool; // Did we change .. keep track of currentplayerid <-> oldcurrentplayerid

	private static var exectimer:Float=0; // for elapsedTime Between call and onData
	public static var elapsedTime:Float=-1;



	private static function init(){
		URL="";
		SecretID=0;
		AppID="";
		SecondCounter=0;
		// Player Information
		PlayerID=0;
		PlayerName="";
		CurrentElapsed=0;
		CurrentPlayerID=-231310;
		CurrentPlayerName="";
		//CurrentRoomPlayerNames=new Array<Dynamic>();
		  CurrentRoomPlayerNames=new Map<String, Dynamic>();
		CurrentRoomPlayerIDs=new Array<Dynamic>();
		// Room
		RoomName="";
		//PlayerSeats=new Array<Dynamic>();
		PlayerSeats=new Map<String,Float>();
		HeartBeat=0;
		TurnTime=0;
		Seat=0;
		RestartCounter=0;	// tracking in-game restarts (resetroom);


		SharedData=new Map<String,Dynamic>();


		callers= new Map<String,String>();
        	callFunctions=new Map<String,Dynamic>();
		isConnect=false;
		State="";	// Error/Bad/OK states

		// Turn Heart
		TurnState=0; // 0 = no transitioning, 1 = transitioning, 2 = data sent
		isChanged=false; // Did we change .. keep track of currentplayerid <-> oldcurrentplayerid
		isAskChange=false;

	} // init


	// HeartBeat timer
	public static function hearts(){
      		SecondCounter++;
		if(SecondCounter % HeartBeat == 0 && isConnect){
			var param:String="";
			var func:Dynamic=null; // dummy function  -> we don't need a callback
			var callID=getCallID("getheart", func);
			// Make Code makes a calculation based on the secret and the
                	var scd=MultiPlay.makeCode(AppID,SecretID); // make secure code and return scd[0] + scd[1]
			var args:Array<String>=new Array<String>();

			args.push("turn");	
			args.push("getheart");	
			args.push(""+callID);	
			args.push(""+AppID);	
			args.push(""+PlayerID);
			args.push(""+scd[0]);	
			args.push(""+scd[1]);	

			call(callID,args);
                } // for all keys
        } //hearts (get online data)



	// ---------------------------
	// Network connection routines
	// ---------------------------
	// Call : arguments that are send to the server : CallID to communicate the result with this extension
	// onData: Return data function
	// onError: What do we do with the errors?
	// callback: Based on the data received we are doing the call-back function store in the extension for the callID
	//
	private static function call(CallID:String, Args:Array<String>){
		var str:String="";


 		// Store the timer
                exectimer=time();

		// Convert each argument into a Base64 encoded string 
		for(arg in Args){
if(debug)trace("Sending Data : "+arg+" encode the arg: "+MultiPlay.Base64_URL_encode(arg));
			str=str+MultiPlay.Base64_URL_encode(arg)+",";
		}
		var url_encode:String=MultiPlay.Base64_URL_encode(str);
if(debug)trace("encrypted send: "+url_encode);

		var execUrl=""+URL+"?c="+CallID+"&a="+url_encode+"&t="+MultiPlay.Base64_URL_encode(""+Date.now());
if(debug)if(debug)trace("Calling :"+execUrl);
                var r:URLRequest=new URLRequest(execUrl);
                var ul:URLLoader=new URLLoader();
                ul.addEventListener( IOErrorEvent.IO_ERROR, onError);
                ul.addEventListener(Event.COMPLETE,onData);
                ul.load(r);
	} // eof call

	private static function onError(e:Event){
		var e_str:String=""+e;
if(debug)trace(""+Date.now()+" : ERROR = "+e_str.substring(e_str.indexOf("text=")+5));
		// See if we have a callID in our onError situation
		if(e_str.indexOf("?=c") > -1){
			var callID:String=e_str.substring(e_str.indexOf("?c=")+3, e_str.indexOf("&"));
			callBack(callID); // call the function-wrapper
		}

	}// eof onError

	private static function onData(e:Event){
		// get the Call ID from the data
		var e_str:String=""+e;

		elapsedTime=time()-exectimer;


		// try to find the call-string (propably not!)
		var callID:String=e_str.substring(e_str.indexOf("?c=")+3, e_str.indexOf("&"));

if(debug)trace("In onData: "+cast(e.target, URLLoader).data);
		var result=MultiPlay.Base64_URL_decode(cast(e.target, URLLoader).data);
if(debug)trace("Data: "+cast(e.target, URLLoader).data+" Decoded: "+result);

		var items=result.split(",");
if(debug)trace("CallID?: items[0]: "+items[0]);
		if(items.length > 0 && (""+items[0]).charAt(0)=="C"){
			dataActions(items);
		} // if items and items-first-element contains a C for callID
	}// onData



	//
	// items does contain elements, otherwise this will not be called
	//
	private static function dataActions(items:Array<String>){

		// items[0] = callID
		var text_func=callers.get(items[0]);
if(debug)trace("Inside dataAction : callID: "+items[0]+" text_func: "+text_func);
		if(text_func=="init"){
if(debug)trace("Inside initFunc checker .. what is the result of the checkCode: items1 : "+items[1]);
			isConnect=false;
			State=items[1];
			if(items[1] == "OK") isConnect=true;
if(debug)trace("Is ConnecT: "+isConnect);
			callBack(items[0]);
		} // init

		if(text_func=="logout"){
			RoomName="";
			HeartBeat=0;
			TurnTime=0;
			Seat=0;
			PlayerID=0;
			callBack(items[0]);
		}

		if(text_func=="joinorcreate"){
			// We get information back on the room + player data
			joinorcreate_back(items);
		}
		if(text_func=="getheart"){
			getheart_back(items);
		}
		if(text_func=="nextturn"){
if(debug)trace("NextTurn callback .. what is items[2] : "+items[2]);
			if(items[2] == "OK"){	
				CurrentElapsed=-1;
                        	CurrentPlayerID=-2362661;
                        	CurrentPlayerName="";
				callBack(items[0]);
			 } // nextturn OK
		} // nextturn
		if(text_func=="setroomdata"){
			if(items[2] == "OK"){ callBack(items[0]); }
			
		}

	} // eof dataActions

	//
	// HeartBeat call-back function
	//   Shared Heartbeat Data like GameAttributes, PlayerInformation/Seat, RoomData ...
	private static function getheart_back(items:Array<Dynamic>){

		// Data from the server !!!!!
if(debug)trace("Inside getHeart.. callback routine");
for(i in  0 ... items.length){
if(debug)trace("Received: i="+i+" item: "+items[i]);
}
//  Received: i=2 item: :SHD::Og..:VlU1TFRrOVhUZz09OlZVNUxUazlYVGc9PQ..:MDA6MDA6MDA.:
		var SHD:String=items[2];	
		var shd:Array<String>=SHD.split(":");
		var cnt=0;
		for(d in shd){
			var part=MultiPlay.Base64_URL_decode(d);
if(debug)trace("GetHeart : HeartBeat data: cnt: "+cnt+" d before: "+d+" after: "+part);
			// cnt==3 -> SharedData
			if(cnt==3){
				// We only interpret the data when we are not in transition .. 
				// if we are about to send new data .. do not change global game attribute when we are about to send new global data
if(debug)trace("GetHeart : SHD : only get the shareddata once when you are on turn : "+CurrentPlayerID+" =? "+PlayerID+" AND Elapsed == 1? :"+CurrentElapsed+" And for all other players part: "+part+" ... ");
				if((CurrentPlayerID == PlayerID && CurrentElapsed == 1) || CurrentPlayerID != PlayerID){
					if(part != null && part.length > 0)getSharedData(part);
				}

			} // cnt == 3 is getSharedData

			// cnt==4 -> PlayerData
			if(cnt==4){
				getPlayerInformation(part);
			} // cnt ==4 -> PlayerData

			// cnt==2 -> Current
   			if(cnt==2){
				getCurrentPlayerInformation(part);
			} // cnt==2 -> Current / changed Player 

			// HeartBeat - Data - Part-Counter
			cnt++;
		}

	} // getHeart_Back callback function


	public static function passLobby(playerid:Float, playername:String, roomname:String, roomid:Float, seat:Float, heartbeat:Float, turntime:Float){
		var pass:Array<Dynamic>=new Array<Dynamic>();
		pass.push(null); // dummy call
		pass.push("join");
		pass.push("OK"); // state
		pass.push(""+heartbeat); 
		pass.push(""+seat);
		pass.push(""+playerid);
		pass.push(""+playername);
		pass.push(""+roomname);
		pass.push(""+turntime);
		pass.push(""+roomid);
		//RoomID=roomid;
		HeartBeat=heartbeat;
		joinorcreate_back(pass);
	}

	// Different call back functions
	private static function joinorcreate_back(items:Array<Dynamic>){
if(debug)trace("Inside JoinOrCreate_Back .. callback routine");
for(i in  0 ... items.length){
if(debug)trace("Received: i="+i+" item: "+items[i]);
}
/*
 $retval=$call_id.",".$requestID.",".$state.",".$heart.",".$seat.",".$playerid.",".$playername.",".$currentroom.",".$TurnTime.",";
*/
		// This HeartBeat will be already set!
		//HeartBeat=Std.parseFloat(""+items[3]);	
		Seat=Std.parseFloat(""+items[4]);
		PlayerID=Std.parseFloat(""+items[5]);
		PlayerName=""+items[6];
		RoomName=""+items[7];
		TurnTime=Std.parseFloat(""+items[8]);

		// Fireup HeartBeat Trigger

		if(heartTimer != null) heartTimer.stop();
		heartTimer=new haxe.Timer(1000);
		heartTimer.run=function():Void{hearts();}
		if(items[0]!=null){	
			callBack(items[0]); // call wrapper
		}
	} // eof join or create _ back



	// CallBack routine
	// Calls the wrapper functions after data was received (eiter onData or onError)
	private static function callBack(callID:String){
                var callback:Dynamic;
                if(callID.length > 0){
			// get the function pointer
                        callback=callFunctions.get(callID);
			// This is the name of the function .. we might want to do some stuff before actually calling it?§§
                        var func=callers.get(callID);
if(debug)trace("Calling the callback function that we stored("+callID+") : "+callback+" name of func: "+func);
			
			if(callback != null) callback();
		} // if callID is valid
	} // eof callBack


/*

	<block tag="Turn__Debug" spec="Turn: set debug %0 [i:camera]" code="Turn.setDebug(~);" type="action" color="charcoal" returns="void">
		<fields>
			<dropdown order="0">
				<choices>
					<c text="Off" code="false"/>
					<c text="On" code="true"/>
				</choices>
			</dropdown>
		</fields>
	</block>
*/
	public static function setDebug(OnOff:Bool){
		debug=OnOff;
	} // setDebug



/*

	<block tag="Turn__Connect" spec="Turn: Server URL: %0 AppID: %1 SecretID: %2" code="Turn.connect(~,~,~,function TurnConnectFunc(){~});" type="wrapper" color="charcoal" returns="void">
		<fields>
			<text order="0"/>
			<text order="1"/>
			<number order="2"/>
			<CODE_BLOCK order="3"/>
		</fields>
	</block>
*/

	public static function connect(url:String, appid:String, secretid:Float, func:Dynamic){

		// 3.2
		//script=new com.stencyl.behavior.Script(Engine.engine); // Stencyl initialize
		// 3.3:
		script=new com.stencyl.behavior.Script(); // Stencyl initialize

		// initialize variables - when connect is called several times it will clear out previous data!
		init();

		AppID=appid;
		SecretID=secretid;

		// The server 	
		URL=url;

		var callID=getCallID("init",func);  // We bind the "init" text to the function we receive .. Stored with CallID inside this extension
if(debug)trace("CallID before making call: "+callID);

                var scd=MultiPlay.makeCode(AppID,SecretID); // make secure code and return scd[0] + scd[1]

		var args:Array<String>=new Array<String>();

		args.push("turn");	
		args.push("init");	
		args.push(""+callID);	
		args.push(""+AppID);	
		args.push(""+scd[0]);	
		args.push(""+scd[1]);	
	
		//call(args);
		call(callID, args);

	}

/*	
	<block tag="Turn__Logout" spec="Turn: For Logout Player" code="Turn.Logout(function myLogout(){~});" type="wrapper" color="charcoal" returns="void">
                <fields>
			<text order="0"/>
                        <CODE_BLOCK order="1"/>
                </fields>
	</block>
*/
	public static function Logout(Player_ID:Float, func:Dynamic){
		// Logout = Kick player out of room
		
		//init();
		// Make sure that the internal variables are reset.
    		var callID=getCallID("logout",func);  // We bind the "joinorcreate" text to the function
       		var scd=MultiPlay.makeCode(AppID,SecretID); // make secure code and return scd[0] + scd[1]
	
		var args:Array<String>=new Array<String>();
		args.push("lobby");	
		args.push("logout");	
		args.push(""+callID);	
		args.push(""+AppID);	
		args.push(""+Player_ID);
		args.push(""+scd[0]);	
		args.push(""+scd[1]);	
		
if(debug)trace("logout: callID: "+callID+" args: "+args);
		call(callID, args);


		//if(func!=null)func();
	} // Logout (logged in player) -> Logout


	//
	// Re-order players in the room (re-number the seats) and clear the shareddata
	public static function resetRoom():Void{
		if(RoomName != null && RoomName.length > 0){
			RestartCounter++;

			// Make sure that the internal variables are reset.
			CurrentPlayerID=-13131;
			CurrentElapsed=-1;
			CurrentPlayerName="";
			TurnState=0; // 0 = no transitioning, 1 = transitioning, 2 = data sent
			isChanged=false; // Did we change .. keep track of currentplayerid <-> oldcurrentplayerid
			isAskChange=false;
			SharedData=new Map<String,Dynamic>();
			
			// 
			var n:Dynamic=function(){}; // Null Function!
    			var callID=getCallID("resetroom",n);  // We bind the "joinorcreate" text to the function
       		         var scd=MultiPlay.makeCode(AppID,SecretID); // make secure code and return scd[0] + scd[1]
	
			var args:Array<String>=new Array<String>();
	
			args.push("turn");	
			args.push("resetroom");	
			args.push(""+callID);	
			args.push(""+AppID);	
			args.push(""+RoomName);
			args.push(""+scd[0]);	
			args.push(""+scd[1]);	
		

			//call(args);
if(debug)trace("resetroom : callID: "+callID+" args: "+args);
			call(callID, args);

		}// if roomname
		

	}


/*

	<block tag="Turn_isConnected" spec="Turn: is Connected to ?" code="Turn.isConnected()" type="normal" color="green" returns="boolean">
		<fields>
		</fields>
	</block>
*/
	public static function isConnected():Bool{
		return isConnect;
	} // isConnected
/*

	<block tag="Turn_getState" spec="Turn: getState" code="Turn.getState()" type="normal" color="green" returns="text">
		<fields>
		</fields>
	</block>
*/
	public static function getState():String{
		return ""+State;
	}


/*


	Players: number of players
	Heartbeat: get data from server
	Force Turn after x beats: The server will disconnect a player when it didn't receive a turn within x heartbeats
	Function to be called	
*/
	public static function joinOrCreateRoom(Players:Float, heartbeat:Float, turntime:Float, extra:String, func:Dynamic){
		// Re-initialize Room Information
		//CurrentRoomPlayerNames=new Array<Dynamic>();
		CurrentRoomPlayerNames=new Map<String,Dynamic>();
		CurrentRoomPlayerIDs=new Array<Dynamic>();

		// Make variable on Current Player empty
		CurrentElapsed=-1;
		CurrentPlayerID=-2616216233;
		CurrentPlayerName="";
		// 
		HeartBeat=heartbeat;
		TurnTime=turntime; // ForceSeconds

		SharedData=new Map<String,Dynamic>(); // empty shareddata

    		var callID=getCallID("joinorcreate",func);  // We bind the "joinorcreate" text to the function
                var scd=MultiPlay.makeCode(AppID,SecretID); // make secure code and return scd[0] + scd[1]

		var args:Array<String>=new Array<String>();

if(debug)trace("Sending data rnd: "+scd[0]+" sendid: "+scd[1]);


		args.push("turn");	
		args.push("joinorcreate");	
		args.push(""+callID);	
		args.push(""+AppID);	
		args.push(""+PlayerID);
		args.push(""+Players); // number of players
		args.push(""+HeartBeat); // heartbeat
		args.push(""+TurnTime); // forcing turn after beat
		args.push(""+extra);
		args.push(""+scd[0]);	
		args.push(""+scd[1]);	
if(debug)trace("Sending joinorcreate : "+args);	
		//call(args);
		call(callID, args);


	} // joinOrCreateRoom





/*
 <block tag="Turn__getPlayerID" spec="Turn: Get %0 Player %1" code="Turn.getPlayer(~,~)" type="normal" color="red" returns="text">
                <fields>
                        <dropdown order="0">
                                <choices>
                                        <c text="Logged In" code="&quot;LOGGED&quot;"/>
                                        <c text="Current" code="&quot;CURRENT&quot;"/>
                                </choices>
                        </dropdown>
                        <dropdown order="1">
                                <choices>
                                        <c text="ID" code="&quot;ID&quot;"/>
                                        <c text="Name" code="&quot;Name&quot;"/>
                                </choices>
                        </dropdown>
                </fields>
        </block>


*/
	public static function getPlayer(PlayerType:String, IDorName:String):String{
		var retval:String="";
		if(PlayerType=="LOGGED" && IDorName=="ID" ) retval=""+PlayerID;
		if(PlayerType=="CURRENT" && IDorName=="ID" ) retval=""+CurrentPlayerID;
		if(PlayerType=="LOGGED" && IDorName=="Name") retval=""+PlayerName;
		if(PlayerType=="CURRENT" && IDorName=="Name") retval=""+CurrentPlayerName;
		return retval;
	} // getPlayer


	public static function setInfo(CType:String, IDorName:String, Value:String){
if(debug) trace("setInfo Room Or Player: "+CType+" IDorName: "+IDorName+" Value : "+Value);
		if(CType=="Room" && IDorName == "Name") RoomName=""+Value;
		if(CType=="Player" && IDorName == "Name") PlayerName=""+Value;
		if(CType=="Player" && IDorName == "ID") PlayerID=Std.parseFloat(""+Value);
		
	}


/*
	<block tag="Turn_PlayerInSeat" spec="Turn: get Player %0 in seat: %1" code="Turn.getPlayerInSeat(~,~,~)" type="normal" color="red" returns="anything">
		<fields>
			<dropdown order="1">
				<choices>
					<c text="ID" code="&quot;ID&quot;"/>
					<c text="Name" code="&quot;Name&quot;"/>
				</choices>
			</dropdown>
			<number order="2"/>
		</fields>
	</block>
*/
	public static function  getPlayerInSeat( IDorName:String, SeatNumber:Float):Dynamic{
		var retval:Dynamic=null;
  		var Counter=0;
		var Type=IDorName;
                if(Type=="ID")retval=0; else retval="";
		for(pid in CurrentRoomPlayerIDs){
			var snr=PlayerSeats.get(""+pid);
			if(snr == SeatNumber){
				if(Type=="ID")return pid;
				if(Type=="Name") return CurrentRoomPlayerNames.get(""+pid);
			}// if seatnumber?

		} // for all playerids
/*
		for(k in PlayerSeats){
if(debug)trace("getPlayerInSeat: SeatNumbeR: "+k);
			if(k == SeatNumber){
				if(Type=="ID"){
					return CurrentRoomPlayerIDs.get(""+k); 
				}
				if(Type=="Name"){
					return CurrentRoomPlayerNames.get(""+k);
				}
			}
		}
*/
/*
                for(i in PlayerSeats){
                        if(i == SeatNumber){
                                if(Type=="ID"){
                                        return CurrentRoomPlayerIDs[Counter];
                                }
                                if(Type=="Name"){
                                        if(CurrentRoomPlayerNames[Counter] != null && CurrentRoomPlayerNames[Counter] != "0"){
                                                return CurrentRoomPlayerNames[Counter];
                                        }else{ return ""; }
                                }
                        } // if Seat == SearchSeat

		   	Counter++;
                } // for all Players in Seats
*/

		return retval;
	} // getPlayerInSeat






/*

	<block tag="Turn_getSeat" spec="Turn: Get Seat for player" code="Turn.getSeat()" type="normal" color="red" returns="number">
		<fields>
		</fields>
	</block>

*/
	// When joining / creatingroom you have Restartcounter of zero so you get the join-state
	//      in-game restarts will change this creation-state so we need playerinformation to get to the seat
	public static function getSeat(Selection:String):Float{
		var retval:Float=0;
		if(Selection=="YOUR"){
			retval = PlayerSeats.get(""+PlayerID);
		}
		if(Selection=="CURRENT"){	
			for(i in PlayerSeats.keys()){
				if(""+i == ""+CurrentPlayerID){
					retval = Std.parseFloat(""+PlayerSeats.get(""+i));
				}
			}
		}
		if(Selection=="COUNT"){
			retval=0;
			for(i in PlayerSeats.keys()){
				if(Std.parseInt(""+i) > 0){
					retval++;
				}
			} // all seats
		} // count
		return retval;
	} // getSeat


/*

	<block tag="Turn__LeaveRoom" spec="Turn: Leave room " code="Turn.leaveRoom(~, function myLeaveRoom(){~});" type="wrapper" color="charcoal" returns="void">
                <fields>
                        <CODE_BLOCK order="0"/>
                </fields>
	</block>


*/
	public static function leaveRoom(func:Dynamic){
		CurrentPlayerID=-231310;
                CurrentPlayerName="";
                //CurrentRoomPlayerNames=new Array<Dynamic>();
		CurrentRoomPlayerNames=new Map<String, Dynamic>();
                CurrentRoomPlayerIDs=new Array<Dynamic>();
                // Room
                RoomName="";
                //PlayerSeats=new Array<Dynamic>();
		PlayerSeats=new Map<String, Float>();
                HeartBeat=0;
                TurnTime=0;
                Seat=0;

		SharedData=new Map<String,Dynamic>();

		callers= new Map<String,String>();
        	callFunctions=new Map<String,Dynamic>();
		State="";	// Error/Bad/OK states

		// Turn Heart
		TurnState=0; // 0 = no transitioning, 1 = transitioning, 2 = data sent
		isChanged=false; // Did we change .. keep track of currentplayerid <-> oldcurrentplayerid
		isAskChange=false;

		if(heartTimer!=null)heartTimer.stop();

		if(func!=null)func();
	}








/*

	<block tag="Turn_setRoomMapData" spec="Turn:  Send room data" code="Turn.setRoomMapData(function TurnSendData(){~});" type="wrapper" color="purple" returns="void">
                <fields>
			<text order="0"/>
                        <CODE_BLOCK order="0"/>
		</fields>
	</block>

*/
	public static function setRoomMapData(func:Dynamic){
                if(PlayerID > 0 && AppID.length > 0 && PlayerID==CurrentPlayerID){
                         if(RoomName.length > 0){
                                var data:String="";

                                for(e in SharedData.keys()){
   // We set our internal data to the mapdata that the user made .. so to match the internal set
                                        var dat=SharedData.get(e);
					
if(debug)trace("Sending Data: TheName: "+e+" the data: "+dat);
					if(e.indexOf("&M") > -1){
                                        	var sdat:Map<String,String>=SharedData.get(e);
						dat="";
if(debug)trace("Sending Data: TheName: "+e+" the data: "+sdat);
						for(el in sdat.keys()){
if(debug)trace("Sending Data : M : key :"+el+" Value: "+sdat.get(el));
							dat=dat+MultiPlay.Base64_URL_encode(el)+"%"+MultiPlay.Base64_URL_encode(sdat.get(el))+"@";
						}
					}
					if(e.indexOf("&L") > -1 || e.indexOf("&L") > -1 || e.indexOf("&I") > -1){
                                        	var sdat:Array<String>=SharedData.get(e);
						dat="";
if(debug)trace("Sending Data: TheName: "+e+" the data: "+sdat);
						for(el in sdat){
if(debug)trace("Sending Data : "+e+" : Value: "+el);
							if(el!=null){
								dat=dat+MultiPlay.Base64_URL_encode(""+el)+",";
							} // el ement != null
							else{
								var elem="0";
								if(e.indexOf("&L") > -1)elem=""; 
								dat=dat+MultiPlay.Base64_URL_encode(elem)+",";
							}
						} // el in shared-data
					} // Is List of Texts?
					data=data+MultiPlay.Base64_URL_encode(e)+"("+MultiPlay.Base64_URL_encode(dat)+")";
                                } // for all roomdata
if(debug)trace("Sending Data : send: "+data);
				var scd=MultiPlay.makeCode(AppID,SecretID); // make secure code and return scd[0] + scd[1]
				var callID=getCallID("setroomdata", func);
                        	var args:Array<String>=new Array<String>();
                        	args.push("turn");
                        	args.push("setroomdata");
				args.push(""+callID);
				args.push(""+AppID);
				args.push(""+RoomName);
				args.push(""+PlayerID);
				args.push(""+data);
if(debug)trace("Sending Data : Scd[0]"+scd[0]+" - "+scd[1]);
				args.push(""+scd[0]);
				args.push(""+scd[1]);
                        	call(callID,args);
			} // roomName . length > 0
		} // if player == current
	} // eof setRoomMapData


/*

	<block tag="_Turn_RequestChangeTurn" spec="Turn:  Request change turn " code="Turn.requestChangeTurn(,function TurnRequestChangeFunc(){~});" type="wrapper" color="cyan" returns="void">
		<fields>
			<CODE_BLOCK order="0"/>
		</fields>
	</block>


*/
/*
	public static function requestChangeTurn(changefunc:Dynamic){
    		if(isTurn()){
                        // The extension assumes that it is no longer on turn and waits for heartbeat to confirm turn
                        // The NextTurn call is made even though we don't know if the server is aware of it, but we tell the
                        // extension-user that it at least THINKS we are not on turn...
                        TurnState=1;
                        if(changefunc != null){
if(debug)trace("Calling changefunc");
                                changefunc();
                        }
                }
                // If we do not have the turn we do not execute the wrapper !!!

	}
*/



/*

	<block tag="Turn_NextTurn" spec="Turn: AppID: %0 Change Turn and then do " code="Turn.NextTurn(~,function TurnNextTurn(){~});" type="wrapper" color="cyan" returns="void">
		<fields>
			<CODE_BLOCK order="0"/>
		</fields>
	</block>
	
*/
	public static function NextTurn(afterNext:Dynamic){
if(debug)trace("In NextTurn with afterNext function: "+afterNext);

                //
                // ignore if we have a request, but it would be nicer/better to have a request
                //
                // TurnID

                // TurnBased system : give control to some other player
                //
                // ONLY do a next turn when we are the one that is active (do not use isTurn since it is checking TurnReset)
 		if(PlayerID > 0 && AppID.length > 0 && PlayerID==CurrentPlayerID){
                        // make CurrentPlayer invalid
/*
			CurrentElapsed=-1;
                        CurrentPlayerID=-2362661;
                        CurrentPlayerName="";
*/
if(debug)if(debug)trace("NextTurn: "+RoomName);
                        // Make Code makes a calculation based on the secret and the
                        var scd=MultiPlay.makeCode(AppID,SecretID); // make secure code and return scd[0] + scd[1]
    			var callID=getCallID("nextturn", afterNext);
                        var args:Array<String>=new Array<String>();

                        args.push("turn");
                        args.push("nextturn");
                        args.push(""+callID);
                        args.push(""+AppID);
			args.push(""+RoomName);
                        args.push(""+PlayerID);
                        args.push(""+scd[0]);
                        args.push(""+scd[1]);

                        call(callID,args);
if(debug)trace("NextTurn : Call afterTurn :"+callID);
                } // player logged in?
                else{  
if(debug)trace("In NextTurn but we are not the active player !!!");
                }
	} // nextTurn





/*

	<block tag="Turn_IsTurnChanged" spec="Turn: did turn change?" code="Turn.isTurnChanged(~)" type="normal" color="cyan" returns="boolean">
		<fields>
		</fields>
	</block>

*/

	public static function isTurnChanged():Bool{
		var retval:Bool=false;
                // isAskChange will be reset in currentplayer != oldcurrentplayer
                // isChanged will become true if currentplayer != oldcurrentplayer
                if(isChanged){
                        // So only give the TRUE when we did not ask for it yet (otherwise the client thinks that it is changing ALL the time
                        if(isAskChange){
                                retval=true;
                                isAskChange=false;
                        }
                }
                return retval;
	}





/*


	<block tag="Turn_IsTurn" spec="Turn: Is it your turn?" code="Turn.isTurn(~)" type="normal" color="cyan" returns="boolean">
		<fields>
			<text order="0"/>
		</fields>
	</block>

*/
	public static function isTurn():Bool{
  		if(TurnState == 0)
                        return PlayerID==CurrentPlayerID;
                else    return false;
	}







	//
        // Store the function to the callers
	//
	// The functions and their callbacks are Extension dependent, so not in MultiPlay class
        //
        public static function getCallID(callFunction:String, function_pointer:Dynamic):String{
                var retval="";
                var found=true;
                while(found){
                        retval="C"+Std.random(23000);
                        var chk=callers.get(retval);
                        if(chk == null){
                                found=false;
                                callers.set(retval, callFunction);
                                callFunctions.set(retval, function_pointer);
                        }
                } // while found - generate new ID
                return retval;
        } // eof getCallID

	// 
	// SharedData SHD = HeartBeat
	//
	public static function getSharedData(d:String){

		Engine.engine.setGameAttribute("GetSharedDataTime",""+Date.now()); // Debug Purposes

		if(d != null && d.length > 0){
if(debug)trace("getSharedData: "+d);
			for(e in d.split(")")){
				if(e.length > 0){
					var splitdata=e.split("(");
					if(splitdata.length < 2 || splitdata[0]==null || splitdata[1]==null){
if(debug)trace("getSharedData : getHeart : Data is not valid! "+d+" ");
						return;
					}
					var varname:String=MultiPlay.Base64_URL_decode(splitdata[0]);
if(debug)trace("Turn: getSharedData: Name: "+varname);
					var thetype:String="";
					if(varname.length > 2){ // At least &x
        					thetype=varname.substr(varname.length-2,varname.length);
					}
					var thename=varname.substr(0,varname.length-2);
if(debug)trace("getSharedData SHD The Type: "+thetype+" The Name: "+thename+" splitdata[1]: "+splitdata[1]);
					if(thetype=="&T"){ // Text
        					var data=MultiPlay.Base64_URL_decode(splitdata[1]);
if(debug)trace("getSharedData TEXT_conversion thetype = before "+data);
						SharedData.set(""+thename+""+thetype, ""+data);
					} // Text
					if(thetype=="&N"){ // numeric game attribute
        					var data=MultiPlay.Base64_URL_decode(""+splitdata[1]);
if(debug)trace("Numeric conversion on: "+thename+"  thetype = N: data = "+data+" orig: "+splitdata[1]+" another convert: "+MultiPlay.Base64_URL_decode(""+data));
        					//Engine.engine.setGameAttribute(""+thename,Std.parseFloat(""+MultiPlay.Base64_URL_decode(""+data)));
						//SharedData.set(""+thename+"&"+thetype, Std.parseFloat(""+MultiPlay.Base64_URL_decode(""+data)));
						SharedData.set(""+thename+""+thetype, Std.parseFloat(""+data));
					} // Numeric
					if(thetype=="&L"){ // list of texts
					        var thelist=MultiPlay.Base64_URL_decode(splitdata[1]).split(",");
//if(debug)trace("Array Conversion Type = list : name ="+thename+" theList: "+thelist+" splitted ");
						thelist.splice(thelist.length-1,1); // always remove last element (",") is added always
        					var data:Array<Dynamic>=new Array<Dynamic>();
        					for(tl in thelist){
                					var afterconv=MultiPlay.Base64_URL_decode(tl);
							if(afterconv != null){
								data.push(afterconv);
							}// if afterconv!=null
//if(debug)trace("After double Array Conversion: "+data);
        					}
						SharedData.set(""+thename+""+thetype, cast(data,Array<Dynamic>));
//if(debug)trace("Array Conversion After getting the data what is the game attribute thedata : "+thename+" = "+data);
					} // List of Text
					if(thetype=="&F"){ // list of Floats
					        var thelist=MultiPlay.Base64_URL_decode(splitdata[1]).split(",");
if(debug)trace("Floating List: "+thelist+" we are splicing with , ");
						thelist.splice(thelist.length-1,1); // always remove last element (",") is added always
        					var data:Array<Dynamic>=new Array<Dynamic>();
        					for(tl in thelist){
                					//var afterconv=MultiPlay.Base64_URL_decode(tl);
							//if(afterconv != null){
						//		data.push(Std.parseFloat(""+afterconv));
						//	}// if afterconv!=null
							data.push(Std.parseFloat(""+tl));
        					}
						SharedData.set(""+thename+""+thetype, cast(data,Array<Dynamic>));
					} // List Of Floats
					if(thetype=="&I"){ // list of Ints
					        var thelist=MultiPlay.Base64_URL_decode(splitdata[1]).split(",");
						thelist.splice(thelist.length-1,1); // always remove last element (",") is added always
        					var data:Array<Dynamic>=new Array<Dynamic>();
        					for(tl in thelist){
                					var afterconv=MultiPlay.Base64_URL_decode(tl);
							if(afterconv != null){
								data.push(Std.parseInt(""+afterconv));
							}// if afterconv!=null
        					}
						SharedData.set(""+thename+""+thetype, cast(data,Array<Dynamic>));
					} // List Of Ints
					if(thetype=="&M"){
if(debug)trace("SHD Type = The_MAP_data : name = "+thename+" thedata: "+splitdata[1]);
     						var theMapDataDecode=MultiPlay.Base64_URL_decode(splitdata[1]);
     						//var theMapDataDecode=Base64.decode(theMapDataDecode);
if(debug)trace("SHD The_Map_Data : decoded :  "+theMapDataDecode);
     						theMapDataDecode=theMapDataDecode.substr(0,theMapDataDecode.length-1);
        					var theMapData=theMapDataDecode.split("@");
if(debug)trace("SHD The decoded The_Map_Data : splitted value the_Map_Data : "+theMapData);
        					var data:Map<String, String>=new Map<String,String>();
        					for(theM in theMapData){
    							if(theM != null){
                        					var col=theM.split("%");
                        					if(col != null && col.length > 1){
									if(col[0] != null && col[1] != null){
if(debug)trace("SHD The_Map_Data adding the string to shareddata Map : "+col[0]+" value :"+Base64.decode(col[1]));
                                						data.set(""+MultiPlay.Base64_URL_decode(col[0]), ""+MultiPlay.Base64_URL_decode(col[1]));
									}
                        					} // if columns
                					} // if data in Map-string
        					} // The Array of Strings
        // thedata inspection
						SharedData.set(""+thename+""+thetype, data);
if(debug)trace("After getting the data what is the game attribute Name: "+thename+" = "+data);
					} // Map-dat
				// We don't set the shared data .. we did set all the game attributes we needed to!
                                //        SharedData.set(""+Base64.decode(splitdata[0]), ""+Base64.decode(splitdata[1]));
				} // Do we have > 0 gameAttributes 
			} // for all GameAttributes
		} // if getSharedData length > 0  AND TurnState == 0 <- we can receive data : we are not transitioning
	}// eof getSharedData (heartbeat)

	//
	// PlayerInformation from heartbeat
	//
	public static function getPlayerInformation(d:String){
if(debug)trace("cnt == 4 Get Players before decode: ["+d+"]");
		var playerData=d;
                if(playerData.indexOf(":")  > -1){
                	var pdata=playerData.split(":");
			CurrentRoomPlayerNames=new Map<String, Dynamic>();
                        CurrentRoomPlayerIDs=new Array<Dynamic>();
                        //PlayerSeats=new Array<Dynamic>();
			PlayerSeats=new Map<String, Float>();
                        for(p in pdata){
if(debug)trace(" cnt == 4 Players P: "+p);
                                var onerow=p.split("%");
                                if(onerow[0] != null && onerow[1] != null){
if(debug)trace("Player Seat : "+onerow[0]+" ID: "+onerow[1]);
                                	//PlayerSeats.push(""+onerow[0]);
					PlayerSeats.set(""+onerow[1], Std.parseFloat(""+onerow[0])); // PlayerID used to store Seat
                                        CurrentRoomPlayerIDs.push(""+onerow[1]);
					//CurrentRoomPlayerNames.push(MultiPlay.Base64_URL_decode(""+onerow[2]));
					// PlayerID used to store name
					CurrentRoomPlayerNames.set(""+onerow[1], ""+MultiPlay.Base64_URL_decode(""+onerow[2]));
                                } // if onerow
                         } // for p
if(debug)trace(" cnt == 4 Players Pdata: "+pdata);
		} // playerData.index 
	} // getPlayerInformation
	//
	//
	// getCurrentPlayerInformation : NextTurn - isTurn? - AskChange?
	//
	public static function getCurrentPlayerInformation(d:String){
      		var playerData=d;
if(debug)trace("getCurrentPlayerInformation d: "+playerData);
       		if(playerData.indexOf(":")  > -1 ){
        		var pdata=playerData.split(":");
for(x in pdata){
	if(debug)trace("PlayerData (cnt==2 currentplayer) : "+x);
}//debug
if(debug)if(debug)trace("cnt==2 = Current Player Information: decode: ["+d+"]");
if(debug)trace("Ts:"+TurnState+" Check on Player change (the shareddata should change BEFORE the turn has changed .. CurrentPlayerID: "+pdata[0]+" Pdata: "+pdata);
			// We did check TurnState but that is done in the requestChange etc..
       	         	// TurnState = 2 when you change turn in code
                	// You require a situation w
			if(CurrentPlayerID != Std.parseFloat(""+pdata[1])){
               	 		isChanged=true;
                        	isAskChange=true;       // We did change and we did not ask the new change
                        	TurnState=0;
                	}else { isChanged=false;}
			//pdata[0]=seat
			CurrentElapsed=Std.parseFloat(""+pdata[0]);
                	CurrentPlayerID=Std.parseFloat(""+pdata[1]);
if(debug)trace("cnt==2 CurrentPlayerID: "+pdata[0]+" Pdata: "+pdata+" CurrentPlayerID after convert: "+CurrentPlayerID);
//                	CurrentPlayerName=MultiPlay.Base64_URL_decode(pdata[2]);
			CurrentPlayerName=MultiPlay.Base64_URL_decode(pdata[2]);
        	} // if data has ':' data
	} // eof getCurrentPlayerInformation

	public static function getData(TheType:Float, aName:String):Dynamic{
		var retval:Dynamic;
		var Type:String="";
		var def:Dynamic=null;
 		if(TheType==0){ Type="T"; def="";}
                if(TheType==1){ Type="N"; def=0;}
                if(TheType==2){ Type="L"; def=new Array<String>();}
                if(TheType==3){ Type="F"; def=new Array<Float>();}
                if(TheType==4){ Type="I"; def=new Array<Int>();}
                if(TheType==5){ Type="M"; def=new Map<String,String>();}
		var temp=SharedData.get(""+aName+"&"+Type);
	
		var isNull=false;
		if(temp != null){
			retval=temp;
		 }else{
			isNull=true;
			 retval=def;
		}

if(debug)trace("getData : "+aName+" Type="+Type+" temp is null?: "+isNull+"  else return def:"+def+" what is the result: "+retval);
		return retval;
	} //getData
	
	public static function  setData(aType:Float, aName:String, aValue:Dynamic){
		var Type:String="";
 		if(aType==0) Type="T";
                if(aType==1) Type="N";
                if(aType==2) Type="L";
		if(aType==3) Type="F";
		if(aType==4) Type="I";
                if(aType==5) Type="M";
if(debug)trace("setData : "+aName+"&"+Type+" value stored: "+aValue);
		SharedData.set(""+aName+"&"+Type, aValue);
	} //setData


	// Time Function = Elapsed Time
	public static inline function time():Float {
        #if flash
            return Date.now().getTime();
        #else
            return haxe.Timer.stamp()*1000;
        #end
	} // elapsedTime time() function

	


} // Turn - class


