package;
import com.stencyl.Engine;

// Loader, BitmapData
import flash.display.*;
import flash.events.*;	
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;

#if cpp
        import cpp.Lib;
#elseif neko
        import neko.Lib;
#else
        #if android
                import openfl.Lib;
        #end
#end

#if android
        import openfl.utils.JNI;
#end

class Capture
{
    
	public static var bmp:BitmapData;
	public static var ldr:Loader;
	public static var stop:Bool;

	#if ios
		private static var StartCapture = Lib.load("StartCapture", "StartIt", 0); // 1 = one parameter = text
		private static var StopCapture = Lib.load("StopCapture", "StopIt", 0); // 1 = one parameter = text
		private static var GetCapture = Lib.load("GetCapture", "GetIt", 0); // 1 = one parameter = text

	#else
		#if android
			private static var StartCapture:Dynamic;
			private static var StopCapture:Dynamic;
			private static var GetCapture:Dynamic;
			private static var GetInfo:Dynamic;
		#end

	#end

	// Device Information : Manufacturer: ... Model: ....
	public static function getInfo():String{
		var retval:String="";
		#if android
			if(GetInfo == null){
				GetInfo=JNI.createStaticMethod("com/capture/Capture/Capture", "GetInfo", "()Ljava/lang/String;", true);
			}
			if(GetInfo != null){
				var ar:Array<Dynamic>=new Array<Dynamic>() ;
               		          retval=""+GetInfo(ar);
			}
		#end
		return retval;	
	} // getInfo

	// Get Base64 string from device
	public static function RequestBitmap(func:Dynamic){
	//	var AB:String="iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3wcFEyUsbgmJVQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABrUlEQVR42u3YgXEDMQwDQZPj/lt2qoit1+01kDEAAvq8XgAAAAAAAECET/nHD/Pbeizz2wzz25os89ssCQQA4YZY5moAhIMyTG3rowFMAMpTsIzUAMwXAFQDtMzTAAgHSQA0gKsVAGQDNcxqazbMb+tmAuKM629rt8z3FQAT4Pqr+q0gawANENbQGyD++FwGmADmh7U0Af4PgPIULcE1APMFANVgLpE1AMIBFYA447ra2mqAeFjfxPQIRDi4AqABXJEAIBvgJZ4GQDjIAhBnXE1bbw0QD/USygQwP6y7CfAZiHLLLWE0APMFANXALzE0AMLBXyJoAIQPYFz/MUytAZhvAiAA+GkjbunHQgNogQMC4Po1AE45EAGIMzenmzcawBQcFADXH54A5h/qkQnwGYjyW2Cf/gNwdgCYbwJw8iGt69cACLfAun4NgHALrOvXAAi3gADEQ7AnpxPPmgDmewPgaTOwrl8DINwCAqAB1L8AIDsD4/qvYb4dAOZfEAIT4A2A8nvg/Y0/Ag2ASx4Nrv8yXzWACUD5MSgAGgAC8H+PRgAAAAAAAAAA8Fv+ALCdV4ZrFbhZAAAAAElFTkSuQmCC";
		var temp:String="";
		var retval:String="";
		if(!stop){
			#if ios
				retval=""+GetCapture();
				if(retval == null){retval=temp;}
			#end
			#if android
				if(GetCapture == null){
				        // file:    dependencies/android/src/com/capture/Capture/Capture.java
					GetCapture = JNI.createStaticMethod("com/capture/Capture/Capture", "GetImage", "()Ljava/lang/String;", true);
				}
				if(GetCapture != null){
					var ar:Array<Dynamic>=new Array<Dynamic>() ;
      		                          retval=""+GetCapture(ar);
					if(retval == null || retval.length < 1){
						retval=temp;
					}
				}
			#end
			// Convert the text into an image
trace("Request Bitmap : Retval = "+retval);
			if(retval.length > 0){
				ConvertToImage(retval);
			}

			// Call wrapper-block
			if( func != null){
				func();
			}
		} // if ! stop
	} // Get (Image as Base64 encoded string)

	public static function Stop(){
		stop=true;
		#if ios
			StopCapture();
		#end
		#if android
			if(StopCapture == null){
				StopCapture = JNI.createStaticMethod("com/capture/Capture/Capture", "Stop", "()V", true);
			}
			if(StopCapture != null){
				var args = new Array<Dynamic>();
trace("StopCapture calling");
				StopCapture(args);
			}
		#end
	}// Stop	

	public static function Start(){
		#if ios
                        StartCapture();
		#else
			#if android
				if(StartCapture == null){
					// include:  <android extension="com.capture.Capture.Capture" />
					// file:    dependencies/android/src/com/capture/Capture/Capture.java
					StartCapture = JNI.createStaticMethod("com/capture/Capture/Capture", "Start", "()V", true);
				}
				if(StartCapture != null){
					var args = new Array<Dynamic>();
					StartCapture(args);
				}
			#end
                #end

	} // Start

  	public static function flipHorizontal(img:BitmapData){
		var retval:BitmapData=new BitmapData(img.width,img.height,true,0);
		var R:Rectangle=new Rectangle(1,1);
		var P:Point=new Point(1,1);
                var matrix:Matrix = new Matrix();
                matrix.scale(-1, 1);
                matrix.translate(img.width, 0);

                var final = new BitmapData(img.width, img.height, true, 0);
                final.draw(img, matrix);

                R.x = 0;
                R.y = 0;
                R.width = final.width;
                R.height = final.height;

                P.x = 0;
                P.y = 0;

                //img.copyPixels(final, R, P);
                retval.copyPixels(final, R, P);
		return retval;
        } // flipHorizontal

 	public static function flipVertical(img:BitmapData):BitmapData{
		var retval:BitmapData=new BitmapData(img.width,img.height,true,0);
		var R:Rectangle=new Rectangle(1,1);
		var P:Point=new Point(1,1);
                var matrix:Matrix = new Matrix();
                matrix.scale(1, -1);
                matrix.translate(0, img.height);

                var final = new BitmapData(img.width, img.height, true, 0);
                final.draw(img, matrix);

                R.x = 0;
                R.y = 0;
                R.width = final.width;
                R.height = final.height;

                P.x = 0;
                P.y = 0;

                retval.copyPixels(final, R, P);
		return retval;
        } // flipVertical


	// Get the latest captured bitmap
	public static function getBitmap():BitmapData{
		var bmp2:BitmapData = new BitmapData(1,1,true,0);
	
		if(!stop){
			if(bmp != null){ 
				bmp2=bmp.clone();
			}

			#if android
				// Nexus 6 is upside 
				if(getInfo().toUpperCase().indexOf("NEXUS") > 0){
					bmp2=flipVertical(bmp2); 
				}else{
					// For all others the image is flipped (and mirrored, but I don't care about mirror)
					bmp2=flipHorizontal(bmp2);
				}
			#end
			#if ios
				bmp2=flipHorizontal(bmp2);
			#end
		} // if stop
		return bmp2;
	} // getBitmap



	// The String will be converted into Image
	public static function ConvertToImage(source:String){
		ldr=new Loader();
		var bytes:haxe.io.Bytes=null;
		try{
			var convertString:String=""+source;
			bytes=Base64.decodeBytes(convertString);
			var data = new flash.utils.ByteArray();
			data.position=0;
			for(n in 0...bytes.length){
				data.writeByte(bytes.get(n));
			}
			data.position = 0;
			ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
			ldr.loadBytes(cast(data)); // bytearray contains raw image data
		}catch(e:String ){
			trace("Error :"+e);
		}
	}// convertToImage

	// On Complete load
	public static function onComplete(E:Event){
		var dp: DisplayObject = ldr.content; // actually ontent should be of Bitmap class
		bmp = new BitmapData(Std.int(dp.width), Std.int(dp.height), true, 0);
		bmp.draw(dp);
	} // onComplete : Bitmap is waiting to be picked up!
}// Class


