
#include <Capture.h>
#import <UIKit/UIKit.h>

// UIImage convert
#import <CoreVideo/CoreVideo.h>
#import <CoreMedia/CoreMedia.h>
#import <ImageIO/ImageIO.h>

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>


@interface TestControllerCamera : UIViewController  <AVCaptureVideoDataOutputSampleBufferDelegate> {
	AVCaptureSession *_captureSession;
	UIImageView *_imageView;
	UIImageView *_imageView2;
	UIImage *_image;
	CALayer *_customLayer;
	AVCaptureVideoPreviewLayer *_prevLayer;

}

@property (nonatomic, retain) AVCaptureSession *captureSession;
@property  int counter;
@property (nonatomic, retain) UIImage *image;
@property (nonatomic, retain) UIImageView *imageView;
@property (nonatomic, retain) UIImageView *imageView2;
@property (nonatomic, retain) CALayer *customLayer;
@property (nonatomic, retain) AVCaptureVideoPreviewLayer *prevLayer;

@end



@implementation TestControllerCamera

@synthesize captureSession = _captureSession;
@synthesize imageView = _imageView;
@synthesize imageView2 = _imageView2;
@synthesize image = _image;
@synthesize customLayer = _customLayer;
@synthesize prevLayer = _prevLayer;
int counter=20000; 

#pragma mark -
#pragma mark Initialization
- (id)init {
self.counter++;
	self = [super init];
	if (self) {
		self.image = nil;
		self.imageView = nil;
		self.imageView2=nil;
		self.prevLayer = nil;
		self.customLayer = nil;
	}
	return self;
} //init

- (void)viewDidLoad {
	[self initCapture];
} // didload

- (void)initCapture {
	AVCaptureDeviceInput *captureInput = [AVCaptureDeviceInput 
										  deviceInputWithDevice:[AVCaptureDevice defaultDeviceWithMediaType:AVMediaTypeVideo] 
										  error:nil];
	AVCaptureVideoDataOutput *captureOutput = [[AVCaptureVideoDataOutput alloc] init];
	captureOutput.alwaysDiscardsLateVideoFrames = YES; 
	
	dispatch_queue_t queue;
	queue = dispatch_queue_create("cameraQueue", NULL);
	[captureOutput setSampleBufferDelegate:self queue:queue];
	dispatch_release(queue);
	// Set the video output to store frame in BGRA (It is supposed to be faster)
	NSString* key = (NSString*)kCVPixelBufferPixelFormatTypeKey; 
	NSNumber* value = [NSNumber numberWithUnsignedInt:kCVPixelFormatType_32BGRA]; 
	NSDictionary* videoSettings = [NSDictionary dictionaryWithObject:value forKey:key]; 
  captureOutput.videoSettings = @{ (id)kCVPixelBufferPixelFormatTypeKey: [NSNumber numberWithInt:kCVPixelFormatType_420YpCbCr8BiPlanarVideoRange] };
        captureOutput.alwaysDiscardsLateVideoFrames = YES;


	self.captureSession = [[AVCaptureSession alloc] init];
	[self.captureSession addInput:captureInput];
	[self.captureSession addOutput:captureOutput];
	[self.captureSession setSessionPreset:AVCaptureSessionPresetMedium];
	self.customLayer = [CALayer layer];
	self.customLayer.frame = self.view.bounds;
	self.customLayer.transform = CATransform3DRotate(CATransform3DIdentity, M_PI/2.0f, 0, 0, 1);
	self.customLayer.contentsGravity = kCAGravityResizeAspectFill;
	[self.view.layer addSublayer:self.customLayer];
	self.imageView = [[UIImageView alloc] init];
	self.imageView2 = [[UIImageView alloc] init];
	self.imageView.frame = CGRectMake(0, 0, 200, 200);
	self.imageView2.frame = CGRectMake(0,210, 200, 200);
[self.view insertSubview:self.imageView atIndex:0];
[self.view insertSubview:self.imageView2 atIndex:1];
	self.prevLayer = [AVCaptureVideoPreviewLayer layerWithSession: self.captureSession];
	self.prevLayer.frame = CGRectMake(0,0, 100, 100);
	self.prevLayer.videoGravity = AVLayerVideoGravityResizeAspectFill;
	[self.view.layer addSublayer: self.prevLayer];
	[self.captureSession startRunning];
	
}

#pragma mark -
#pragma mark AVCaptureSession delegate


- (UIImage *) imageFromSampleBuffer:(CMSampleBufferRef) sampleBuffer
{
    // Get a CMSampleBuffer's Core Video image buffer for the media data
    CVImageBufferRef imageBuffer = CMSampleBufferGetImageBuffer(sampleBuffer);
    // Lock the base address of the pixel buffer
    CVPixelBufferLockBaseAddress(imageBuffer, 0);

    // Get the number of bytes per row for the pixel buffer
    void *baseAddress = CVPixelBufferGetBaseAddress(imageBuffer);

    // Get the number of bytes per row for the pixel buffer
    size_t bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer);
    // Get the pixel buffer width and height
    size_t width = CVPixelBufferGetWidth(imageBuffer);
    size_t height = CVPixelBufferGetHeight(imageBuffer);

    // Create a device-dependent RGB color space
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();

    // Create a bitmap graphics context with the sample buffer data
    CGContextRef context = CGBitmapContextCreate(baseAddress, width, height, 8,
                                                                bytesPerRow, colorSpace, kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst);
    // Create a Quartz image from the pixel data in the bitmap graphics context
    CGImageRef quartzImage = CGBitmapContextCreateImage(context);
    // Unlock the pixel buffer
    CVPixelBufferUnlockBaseAddress(imageBuffer,0);

    // Free up the context and color space
    CGContextRelease(context);
    CGColorSpaceRelease(colorSpace);

    // Create an image object from the Quartz image
    UIImage *image = [UIImage imageWithCGImage:quartzImage];

    // Release the Quartz image
    CGImageRelease(quartzImage);

    return (image);
}



- (void)captureOutput:(AVCaptureOutput *)captureOutput 
didOutputSampleBuffer:(CMSampleBufferRef)sampleBuffer 
	   fromConnection:(AVCaptureConnection *)connection 
{ 
UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(180, 230, 300, 150)];
label.textAlignment = NSTextAlignmentCenter;
label.text = [NSString stringWithFormat:@"Your data" ]; // Make use of the exposed data property
[self.view insertSubview:label atIndex:2];

 	UIImage *image = [self imageFromSampleBuffer:sampleBuffer];
NSString *str_image=[UIImagePNGRepresentation(image) base64EncodedStringWithOptions:NSDataBase64Encoding64CharacterLineLength];



/*

   // dispatch_async(dispatch_get_main_queue(), ^{
   dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_BACKGROUND, 0), ^{
            // do actual processing
UIGraphicsBeginImageContextWithOptions(CGSizeMake(100,100), NO, 0);
UIBezierPath* p =
    [UIBezierPath bezierPathWithRect:CGRectMake(0,0,100,100)];
[[UIColor redColor] setFill];
[p fill];
UIImage* im = UIGraphicsGetImageFromCurrentImageContext();
UIGraphicsEndImageContext();

		if(self.imageView2 != nil){
		if(im != nil){
       		 	[self.imageView2 setImage:im];
		}else{
    			self.imageView2.backgroundColor = [UIColor blueColor];
		}
       	 [self.imageView2 setNeedsDisplay];
		}
        });
    //});
*/
/*
UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, 100, 100)];
  imageView.image = image;
  //[self.view addSubview:imageView];
[self.imageView2 addSubview:imageView];
*/


/*
*/

/*
self.imageView2.backgroundColor = abc; //[UIColor redColor];
if(self.counter > 0 && self.counter < 8){
self.imageView2.backgroundColor = [UIColor whiteColor];
}
if(self.counter > 7 && self.counter < 9){
self.imageView2.backgroundColor = [UIColor redColor];
}
if(self.counter > 8 && self.counter < 19){
self.imageView2.backgroundColor = [UIColor greenColor];
}
*/

/*
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];

    CVImageBufferRef imageBuffer = CMSampleBufferGetImageBuffer(sampleBuffer); 
    CVPixelBufferLockBaseAddress(imageBuffer,0); 
    uint8_t *baseAddress = (uint8_t *)CVPixelBufferGetBaseAddress(imageBuffer); 
    size_t bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer); 
    size_t width = CVPixelBufferGetWidth(imageBuffer); 
    size_t height = CVPixelBufferGetHeight(imageBuffer);  
    
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB(); 
    CGContextRef newContext = CGBitmapContextCreate(baseAddress, width, height, 8, bytesPerRow, colorSpace, kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst);
    CGImageRef newImage = CGBitmapContextCreateImage(newContext); 
	
    CGContextRelease(newContext); 
    CGColorSpaceRelease(colorSpace);
    
	//[self.customLayer performSelectorOnMainThread:@selector(setContents:) withObject: (id) newImage waitUntilDone:YES];
	
*/
/*
UIGraphicsBeginImageContextWithOptions(CGSizeMake(100,100), NO, 0);
UIBezierPath* p =
    [UIBezierPath bezierPathWithRect:CGRectMake(0,0,100,100)];
[[UIColor redColor] setFill];
[p fill];
UIImage* im = UIGraphicsGetImageFromCurrentImageContext();
UIGraphicsEndImageContext();

	//[self.imageView2 performSelectorOnMainThread:@selector(setImage:) withObject:self.image waitUntilDone:YES];
   self.imageView2.image=im;
*/
//[self.imageView2 setHidden: NO];
//[self.imageView2 sizeToFit];
//	CGImageRelease(newImage);

} 

#pragma mark -
#pragma mark Memory management

- (void)viewDidUnload {
	self.imageView = nil;
	self.imageView2 = nil;
	self.customLayer = nil;
	self.prevLayer = nil;
}

- (void)dealloc {
	[self.captureSession release];
    [super dealloc];
}


@end


using namespace SayCapture;

namespace SayCapture
{

AVCaptureVideoPreviewLayer *PreviewLayer;
TestControllerCamera *wn;


	const char *Get(){
		NSString *combined=[NSString stringWithFormat:@"State:"];
		if(wn != nil){
			if(wn.image != nil){
				// Base64 Encode the wn.image
                		combined = [combined stringByAppendingString:@"IMAGE"];

			}else{
                		combined = [combined stringByAppendingString:@"IMAGE NULL"];
			}
		}else{
                		combined = [combined stringByAppendingString:@"VIEW NULL"];
		}
        	return [combined cStringUsingEncoding:NSASCIIStringEncoding];
        }

        void Stop(){
/*
                [CaptureSession stopRunning];
                CaptureSession = nil;
                [PreviewLayer removeFromSuperlayer];
*/

        } // stop

	void Say(const char *vidURL){
			  NSString *n=[NSString stringWithFormat:@"%s",vidURL];
                        wn = [[TestControllerCamera alloc] init];
                        UIViewController *a = [[[[UIApplication sharedApplication] delegate] window] rootViewController];
                        [a.view addSubview:wn.view];
                        [a addChildViewController:wn];


   	} // Say
}//namespace 
