
#include <Capture.h>
#import <UIKit/UIKit.h>

// UIImage convert
#import <CoreVideo/CoreVideo.h>
#import <CoreMedia/CoreMedia.h>
#import <ImageIO/ImageIO.h>

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>


@interface TestControllerCamera : UIViewController  <AVCaptureVideoDataOutputSampleBufferDelegate> {

//@interface TestControllerCamera : UIViewController <AVCaptureVideoDataOutputSampleBufferDelegate > {
	AVCaptureSession *_captureSession;
	UIImageView *_imageView;
	UIImageView *_imageView2;
	UIImage *_image;
	CALayer *_customLayer;
	AVCaptureVideoPreviewLayer *_prevLayer;
AVCaptureConnection *_videoConnection ;
	AVCaptureStillImageOutput *_stillImageOutput;

}

@property (nonatomic, retain) AVCaptureSession *captureSession;
@property (nonatomic, retain) AVCaptureConnection *videoConnection;
@property(nonatomic, retain) AVCaptureStillImageOutput *stillImageOutput;
@property(nonatomic, retain) IBOutlet UIView *vImagePreview;
@property  int counter;
@property (nonatomic, retain) NSString *str_image;
@property (nonatomic, retain) UIImage *image;
@property (nonatomic, retain) UIImageView *imageView;
@property (nonatomic, retain) UIImageView *imageView2;
@property (nonatomic, retain) CALayer *customLayer;
@property (nonatomic, retain) AVCaptureVideoPreviewLayer *prevLayer;

@end



@implementation TestControllerCamera

@synthesize captureSession = _captureSession;
@synthesize videoConnection = _videoConnection;
@synthesize imageView = _imageView;
@synthesize imageView2 = _imageView2;
@synthesize image = _image;
@synthesize customLayer = _customLayer;
@synthesize prevLayer = _prevLayer;
@synthesize stillImageOutput = _stillImageOutput;
int counter=20000; 

#pragma mark -
#pragma mark Initialization

-(void) viewDidAppear:(BOOL)animated
{
}



- (id)init {
self.counter++;
	self = [super init];
	if (self) {
		self.image = nil;
		self.imageView = nil;
		self.imageView2=nil;
		self.prevLayer = nil;
		self.customLayer = nil;
	}
	return self;
} //init

- (void)viewDidLoad {
	[self initCapture];
} // didload

/*
Use the below code to display front camera:-

NSArray *possibleDevices = [AVCaptureDevice devicesWithMediaType:AVMediaTypeVideo];

AVCaptureDevice* cameraDevice = [possibleDevices lastObject];
*/

- (void)initCapture {


	// Make ImageView for uiimage showing:
	self.imageView = [[UIImageView alloc] init];
        self.imageView.frame = CGRectMake(100, 100, 200, 200);
	[self.view insertSubview:self.imageView atIndex:0];

    NSError *error = nil;
 
    // Create the session
    AVCaptureSession *session = [[AVCaptureSession alloc] init];
 
    // Configure the session to produce lower resolution video frames, if your
    // processing algorithm can cope. We'll specify medium quality for the
    // chosen device.
    session.sessionPreset = AVCaptureSessionPresetMedium;
 
    // Find a suitable AVCaptureDevice
    AVCaptureDevice *device = [AVCaptureDevice
                             defaultDeviceWithMediaType:AVMediaTypeVideo];
 
    // Create a device input with the device and add it to the session.
    AVCaptureDeviceInput *input = [AVCaptureDeviceInput deviceInputWithDevice:device
                                                                    error:&error];
    if (!input) {
        // Handling the error appropriately.
    }
    [session addInput:input];
 
    // Create a VideoDataOutput and add it to the session
    AVCaptureVideoDataOutput *output = [[[AVCaptureVideoDataOutput alloc] init] autorelease];
    [session addOutput:output];
 
    // Configure your output.
    dispatch_queue_t queue = dispatch_queue_create("myQueue", NULL);
    [output setSampleBufferDelegate:self queue:queue];
    dispatch_release(queue);
 
    // Specify the pixel format
    output.videoSettings =
                [NSDictionary dictionaryWithObject:
                    [NSNumber numberWithInt:kCVPixelFormatType_32BGRA]
                    forKey:(id)kCVPixelBufferPixelFormatTypeKey];
 
 
    // If you wish to cap the frame rate to a known value, such as 15 fps, set
    // minFrameDuration.
    //output.minFrameDuration = CMTimeMake(1, 15);
 
    // Start the session running to start the flow of data
    [session startRunning];
 
} // initCapture

#pragma mark -
#pragma mark AVCaptureSession delegate


- (UIImage *) imageFromSampleBuffer:(CMSampleBufferRef) sampleBuffer
{
    // Get a CMSampleBuffer's Core Video image buffer for the media data
    CVImageBufferRef imageBuffer = CMSampleBufferGetImageBuffer(sampleBuffer);
    // Lock the base address of the pixel buffer
    CVPixelBufferLockBaseAddress(imageBuffer, 0);

    // Get the number of bytes per row for the pixel buffer
    void *baseAddress = CVPixelBufferGetBaseAddress(imageBuffer);

    // Get the number of bytes per row for the pixel buffer
    size_t bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer);
    // Get the pixel buffer width and height
    size_t width = CVPixelBufferGetWidth(imageBuffer);
    size_t height = CVPixelBufferGetHeight(imageBuffer);

    // Create a device-dependent RGB color space
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();

    // Create a bitmap graphics context with the sample buffer data
    CGContextRef context = CGBitmapContextCreate(baseAddress, width, height, 8,
                                                                bytesPerRow, colorSpace, kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst);
    // Create a Quartz image from the pixel data in the bitmap graphics context
    CGImageRef quartzImage = CGBitmapContextCreateImage(context);
    // Unlock the pixel buffer
    CVPixelBufferUnlockBaseAddress(imageBuffer,0);

    // Free up the context and color space
    CGContextRelease(context);
    CGColorSpaceRelease(colorSpace);

    // Create an image object from the Quartz image
    UIImage *image = [UIImage imageWithCGImage:quartzImage];

    // Release the Quartz image
    CGImageRelease(quartzImage);

    return (image);
}



- (void)captureOutput:(AVCaptureOutput *)captureOutput 
didOutputSampleBuffer:(CMSampleBufferRef)sampleBuffer 
	   fromConnection:(AVCaptureConnection *)connection 
{ 
// [self.image performSelectorOnMainThread:@selector(setImage:) withObject:img waitUntilDone:TRUE];

 	UIImage *image = [self imageFromSampleBuffer:sampleBuffer];
	dispatch_async(dispatch_get_main_queue(), ^{
       		 [self.imageView setImage:image];
      		[self.view setNeedsDisplay];
		self.str_image=[UIImagePNGRepresentation(image) base64EncodedStringWithOptions:NSDataBase64Encoding64CharacterLineLength];
    });
} 


#pragma mark -
#pragma mark Memory management

- (void)viewDidUnload {
	self.imageView = nil;
	self.imageView2 = nil;
	self.customLayer = nil;
	self.prevLayer = nil;
}

- (void)dealloc {
	[self.captureSession release];
    [super dealloc];
}


@end


using namespace SayCapture;

namespace SayCapture
{

AVCaptureVideoPreviewLayer *PreviewLayer;
TestControllerCamera *wn=nil;;

 NSString *combined;

	const char* GetImage(){
		combined = [NSString stringWithFormat:@""];
		if(wn.str_image != nil){
                		combined = [combined stringByAppendingString:wn.str_image];
		}
 		const char *retval=[combined UTF8String];
                return retval;

	} //Get

        void Stop(){

 		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Speak" message:@"Hi" delegate:NULL cancelButtonTitle:@"OK" otherButtonTitles: nil];
        	[alert show];

/*
                [CaptureSession stopRunning];
                CaptureSession = nil;
                [PreviewLayer removeFromSuperlayer];
*/

        } // stop

	void Say(const char *vidURL){
		NSString *n=[NSString stringWithFormat:@"%s",vidURL];
                wn = [[TestControllerCamera alloc] init];
                UIViewController *a = [[[[UIApplication sharedApplication] delegate] window] rootViewController];
                [a.view addSubview:wn.view];
                [a addChildViewController:wn];
   	} // Say
}//namespace 
