
#include <Capture.h>
#import <UIKit/UIKit.h>

// UIImage convert
#import <CoreVideo/CoreVideo.h>
#import <CoreMedia/CoreMedia.h>
#import <ImageIO/ImageIO.h>

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>


@interface TestControllerCamera : UIViewController  <AVCaptureVideoDataOutputSampleBufferDelegate> {
	AVCaptureSession *_captureSession;
	UIImageView *_imageView;
	UIImageView *_imageView2;
	UIImage *_image;
	CALayer *_customLayer;
	AVCaptureVideoPreviewLayer *_prevLayer;
	AVCaptureConnection *_videoConnection ;
	AVCaptureStillImageOutput *_stillImageOutput;

}

@property (nonatomic, retain) AVCaptureSession *captureSession;
@property (nonatomic, retain) AVCaptureConnection *videoConnection;
@property(nonatomic, retain) AVCaptureStillImageOutput *stillImageOutput;
@property(nonatomic, retain) IBOutlet UIView *vImagePreview;
@property  int counter;
@property (nonatomic, retain) NSString *str_image;
@property (nonatomic, retain) UIImage *image;
@property (nonatomic, retain) UIImageView *imageView;
@property (nonatomic, retain) UIImageView *imageView2;
@property (nonatomic, retain) CALayer *customLayer;
@property (nonatomic, retain) AVCaptureVideoPreviewLayer *prevLayer;

@end



@implementation TestControllerCamera

@synthesize captureSession = _captureSession;
@synthesize videoConnection = _videoConnection;
@synthesize imageView = _imageView;
@synthesize imageView2 = _imageView2;
@synthesize image = _image;
@synthesize customLayer = _customLayer;
@synthesize prevLayer = _prevLayer;
@synthesize stillImageOutput = _stillImageOutput;
int counter=20000; 

#pragma mark -
#pragma mark Initialization

-(void) viewDidAppear:(BOOL)animated
{
}



- (id)init {
self.counter++;
	self = [super init];
	if (self) {
		self.image = nil;
		self.imageView = nil;
		self.imageView2=nil;
		self.prevLayer = nil;
		self.customLayer = nil;
	}
	return self;
} //init

- (void)viewDidLoad {
	[self initCapture];
} // didload


- (void)initCapture {


	// Make ImageView for uiimage showing:
	self.imageView = [[UIImageView alloc] init];
        self.imageView.frame = CGRectMake(1, 1, 2, 2);
	[self.view insertSubview:self.imageView atIndex:0];

    NSError *error = nil;
 
    // Create the session
    AVCaptureSession *session = [[AVCaptureSession alloc] init];
 
    // Configure the session to produce lower resolution video frames, if your
    // processing algorithm can cope. We'll specify medium quality for the
    // chosen device.
    session.sessionPreset = AVCaptureSessionPresetMedium;
 
    // Find a suitable AVCaptureDevice
/*
    AVCaptureDevice *device = [AVCaptureDevice
                             defaultDeviceWithMediaType:AVMediaTypeVideo];
*/
 
NSArray *possibleDevices = [AVCaptureDevice devicesWithMediaType:AVMediaTypeVideo];
AVCaptureDevice* device= [possibleDevices lastObject];
    // Create a device input with the device and add it to the session.
    AVCaptureDeviceInput *input = [AVCaptureDeviceInput deviceInputWithDevice:device
                                                                    error:&error];
    if (!input) {
        // Handling the error appropriately.
    }
    [session addInput:input];
 
    // Create a VideoDataOutput and add it to the session
    AVCaptureVideoDataOutput *output = [[[AVCaptureVideoDataOutput alloc] init] autorelease];
 
    // Configure your output.
    dispatch_queue_t queue = dispatch_queue_create("myQueue", NULL);
    [output setSampleBufferDelegate:self queue:queue];
    dispatch_release(queue);
 
    // Specify the pixel format
 
output.videoSettings = [NSDictionary dictionaryWithObject: [NSNumber numberWithInt:kCVPixelFormatType_32BGRA] forKey: (id)kCVPixelBufferPixelFormatTypeKey];

    [session addOutput:output];
 
    // If you wish to cap the frame rate to a known value, such as 15 fps, set
    // minFrameDuration.
    //output.minFrameDuration = CMTimeMake(1, 15);
 
    // Start the session running to start the flow of data
    [session startRunning];
 
} // initCapture

#pragma mark -
#pragma mark AVCaptureSession delegate


- (UIImage *) imageFromSampleBuffer:(CMSampleBufferRef) sampleBuffer
{
    // Get a CMSampleBuffer's Core Video image buffer for the media data
    CVImageBufferRef imageBuffer = CMSampleBufferGetImageBuffer(sampleBuffer);
    // Lock the base address of the pixel buffer
    CVPixelBufferLockBaseAddress(imageBuffer, 0);

    // Get the number of bytes per row for the pixel buffer
    void *baseAddress = CVPixelBufferGetBaseAddress(imageBuffer);

    // Get the number of bytes per row for the pixel buffer
    size_t bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer);
    // Get the pixel buffer width and height
    size_t width = CVPixelBufferGetWidth(imageBuffer);
    size_t height = CVPixelBufferGetHeight(imageBuffer);

    // Create a device-dependent RGB color space
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();

    // Create a bitmap graphics context with the sample buffer data
    CGContextRef context = CGBitmapContextCreate(baseAddress, width, height, 8,
                                                                bytesPerRow, colorSpace, kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst);
    // Create a Quartz image from the pixel data in the bitmap graphics context
    CGImageRef quartzImage = CGBitmapContextCreateImage(context);
    // Unlock the pixel buffer
    CVPixelBufferUnlockBaseAddress(imageBuffer,0);

    // Free up the context and color space
    CGContextRelease(context);
    CGColorSpaceRelease(colorSpace);

    // Create an image object from the Quartz image
    UIImage *image = [UIImage imageWithCGImage:quartzImage];

    // Release the Quartz image
    CGImageRelease(quartzImage);

// Scale
  CGImageRef imgRef = [image CGImage];
    CGFloat Width = CGImageGetWidth(imgRef);
    CGFloat Height = CGImageGetHeight(imgRef);
    CGRect bounds = CGRectMake(0, 0, Width, Height);
//int resolution=256;
int resolution=128;

    //if already at the minimum resolution, return the orginal image, otherwise scale
        CGFloat ratio = Width/Height;

        if (ratio > 1) {
            bounds.size.width = resolution;
            bounds.size.height = bounds.size.width / ratio;
        } else {
            bounds.size.height = resolution;
            bounds.size.width = bounds.size.height * ratio;
        }

    UIGraphicsBeginImageContext(bounds.size);
    [image drawInRect:CGRectMake(0.0, 0.0, bounds.size.width, bounds.size.height)];
    UIImage *imageCopy = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();


    return (imageCopy);
}



- (void)captureOutput:(AVCaptureOutput *)captureOutput 
didOutputSampleBuffer:(CMSampleBufferRef)sampleBuffer 
	   fromConnection:(AVCaptureConnection *)connection {

 	UIImage *image = [self imageFromSampleBuffer:sampleBuffer];
	dispatch_async(dispatch_get_main_queue(), ^{
       		[self.imageView setImage:image];
      		[self.view setNeedsDisplay];
		if(image!=nil){
//NSLog(@"This is it: %@", @"image != nil");
			NSString *ii= [UIImagePNGRepresentation(image) base64EncodedStringWithOptions:NSDataBase64EncodingEndLineWithLineFeed];
	

			NSString *TrimBase64String=[ii stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];

	  	  	self.str_image=[NSString stringWithFormat:@"%@",TrimBase64String];
		}else{
//NSLog(@"This is it: %@", @"image == nill so default string");
			self.str_image=[NSString stringWithFormat:@"iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAIAAAAiOjnJAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3wIGAw86M8VzwgAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABc0lEQVR42u3SMREAAAjEMMC/58cEA0MioddOUnBtJMBYGAtjgbEwFsYCY2EsjAXGwlgYC4yFsTAWGAtjYSwwFsbCWGAsjIWxwFgYC2OBsTAWxgJjYSyMBcbCWBgLjIWxMBYYC2NhLDAWxsJYYCyMhbHAWBgLY4GxMBbGAmNhLIwFxsJYGAuMhbEwFhgLY2EsMBbGwlhgLIyFscBYGAtjgbEwFsYCY2EsjAXGwlgYC4yFsTAWxgJjYSyMBcbCWBgLjIWxMBYYC2NhLDAWxsJYYCyMhbHAWBgLY4GxMBbGAmNhLIwFxsJYGAuMhbEwFhgLY2EsMBbGwlhgLIyFscBYGAtjgbEwFsYCY2EsjAXGwlgYC4yFsTAWGAtjYSwwFsbCWGAsjIWxwFgYC2OBsTAWxgJjYSyMBcbCWBgLjIWxMBYYC2NhLIwFxsJYGAuMhbEwFhgLY2EsMBbGwlhgLIyFscBYGAtjgbEwFsYCY2EsjAXG4psFIQoEjU734eUAAAAASUVORK5CYII="];
		}
    });
}  // captureOutput


#pragma mark -
#pragma mark Memory management

- (void)viewDidUnload {
	self.imageView = nil;
	self.imageView2 = nil;
	self.customLayer = nil;
	self.prevLayer = nil;
}

- (void)dealloc {
	[self.captureSession release];
    [super dealloc];
}


@end


using namespace StartCapture;

namespace StartCapture
{

	AVCaptureVideoPreviewLayer *PreviewLayer;
	TestControllerCamera *wn=nil;;
	Boolean stopit=false;

 	NSString *combined;
        UIViewController *aView ;

	const char* GetImage(){
		NSString *TrimBase64String;
 		const char *retval;
		//if(!stopit){
			combined = [NSString stringWithFormat:@"iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3wcFEyUsbgmJVQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABrUlEQVR42u3YgXEDMQwDQZPj/lt2qoit1+01kDEAAvq8XgAAAAAAAECET/nHD/Pbeizz2wzz25os89ssCQQA4YZY5moAhIMyTG3rowFMAMpTsIzUAMwXAFQDtMzTAAgHSQA0gKsVAGQDNcxqazbMb+tmAuKM629rt8z3FQAT4Pqr+q0gawANENbQGyD++FwGmADmh7U0Af4PgPIULcE1APMFANVgLpE1AMIBFYA447ra2mqAeFjfxPQIRDi4AqABXJEAIBvgJZ4GQDjIAhBnXE1bbw0QD/USygQwP6y7CfAZiHLLLWE0APMFANXALzE0AMLBXyJoAIQPYFz/MUytAZhvAiAA+GkjbunHQgNogQMC4Po1AE45EAGIMzenmzcawBQcFADXH54A5h/qkQnwGYjyW2Cf/gNwdgCYbwJw8iGt69cACLfAun4NgHALrOvXAAi3gADEQ7AnpxPPmgDmewPgaTOwrl8DINwCAqAB1L8AIDsD4/qvYb4dAOZfEAIT4A2A8nvg/Y0/Ag2ASx4Nrv8yXzWACUD5MSgAGgAC8H+PRgAAAAAAAAAA8Fv+ALCdV4ZrFbhZAAAAAElFTkSuQmCC"];
			if(wn.str_image != nil){
				combined = [NSString stringWithFormat:@""];
                		combined = [combined stringByAppendingString:wn.str_image];
			}

			TrimBase64String=[combined stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
 			retval=[TrimBase64String UTF8String];
//NSLog(@"GetImage returning: %@",TrimBase64String);
//NSLog(@"before returning: %@",@"RETVAL");
		//}
                return retval;

	} //Get

        void Stop(){
		stopit=true;
		[wn.view removeFromSuperview];

        } // stop

	void Start(){
                wn = [[TestControllerCamera alloc] init];
                aView = [[[[UIApplication sharedApplication] delegate] window] rootViewController];
                [aView.view addSubview:wn.view];
                [aView addChildViewController:wn];
   	} //Start 
}//namespace 
