//
//

// See: http://www.ios-developer.net/iphone-ipad-programmer/development/camera/record-video-with-avcapturesession-2

// see: http://stackoverflow.com/questions/23882605/how-to-capture-frame-by-frame-images-from-iphone-video-recording-in-real-time

#include <Capture.h>
#import <UIKit/UIAlert.h>

#import "MediaPlayer/MPMoviePlayerViewController.h"
#import "MediaPlayer/MPMoviePlayerController.h"

#import <Foundation/Foundation.h>
#import <CoreMedia/CoreMedia.h>
#import <AVFoundation/AVFoundation.h>




using namespace SayCapture;

namespace SayCapture 
{

AVCaptureVideoPreviewLayer *PreviewLayer;





	AVCaptureSession *CaptureSession;
	AVCaptureMovieFileOutput *MovieFileOutput;
	AVCaptureDeviceInput *VideoInputDevice;

    void OldSay(const char *TheText)
    {
	NSString *TheMessage=[NSString stringWithFormat:@" The Message: %s", TheText];
	UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Speak" message:TheMessage  delegate:NULL cancelButtonTitle:@"OK" otherButtonTitles: nil];
	[alert show];

    } //  Say

	const char *Get(){
NSString *combined=[NSString stringWithFormat:@""];
                combined = [combined stringByAppendingString:@"BASE64"];
        return [combined cStringUsingEncoding:NSASCIIStringEncoding];

	}

	void Stop(){
		[CaptureSession stopRunning];
		CaptureSession = nil;	
		[PreviewLayer removeFromSuperlayer];
		
	} // stop

    void Say(const char *vidURL){

//---------------------------------
	//----- SETUP CAPTURE SESSION -----
	//---------------------------------
	NSLog(@"Setting up capture session");
	CaptureSession = [[AVCaptureSession alloc] init];
	
	//----- ADD INPUTS -----
	NSLog(@"Adding video input");
	
	//ADD VIDEO INPUT
	AVCaptureDevice *VideoDevice = [AVCaptureDevice defaultDeviceWithMediaType:AVMediaTypeVideo];
	if (VideoDevice)
	{
		NSError *error;
		VideoInputDevice = [AVCaptureDeviceInput deviceInputWithDevice:VideoDevice error:&error];
		if (!error)
		{
			if ([CaptureSession canAddInput:VideoInputDevice])
				[CaptureSession addInput:VideoInputDevice];
		}
	}
	
	//ADD AUDIO INPUT
/*
	AVCaptureDevice *audioCaptureDevice = [AVCaptureDevice defaultDeviceWithMediaType:AVMediaTypeAudio];
	NSError *error = nil;
	AVCaptureDeviceInput *audioInput = [AVCaptureDeviceInput deviceInputWithDevice:audioCaptureDevice error:&error];
	if (audioInput)
	{
		[CaptureSession addInput:audioInput];
	}
	
*/
	
	//----- ADD OUTPUTS -----
	
	//ADD VIDEO PREVIEW LAYER
    id rootVC = [[[[[UIApplication sharedApplication] keyWindow] subviews] objectAtIndex:0] nextResponder];
	//:wq
//[rootVC setPreviewLayer:[[[AVCaptureVideoPreviewLayer alloc] initWithSession:CaptureSession] autorelease]];
	PreviewLayer = [[AVCaptureVideoPreviewLayer alloc] initWithSession:CaptureSession];
	
//	PreviewLayer.orientation = AVCaptureVideoOrientationLandscapeRight;		
//<<SET ORIENTATION.  You can deliberatly set this wrong to flip the image and may actually need to set it wrong to get the right image
	
	[PreviewLayer setVideoGravity:AVLayerVideoGravityResizeAspectFill];
	
	
	//ADD MOVIE FILE OUTPUT
	MovieFileOutput = [[AVCaptureMovieFileOutput alloc] init];
	
	Float64 TotalSeconds = 60;			//Total seconds
	int32_t preferredTimeScale = 30;	//Frames per second
	
	MovieFileOutput.minFreeDiskSpaceLimit = 1024 * 1024;						//<<SET MIN FREE SPACE IN BYTES FOR RECORDING TO CONTINUE ON A VOLUME
	
	if ([CaptureSession canAddOutput:MovieFileOutput])
		[CaptureSession addOutput:MovieFileOutput];

	//SET THE CONNECTION PROPERTIES (output properties)
//	[rootVC CameraSetOutputProperties];			//(We call a method as it also has to be done after changing camera)

			
	
	//----- SET THE IMAGE QUALITY / RESOLUTION -----
	//Options:
	//	AVCaptureSessionPresetHigh - Highest recording quality (varies per device)
	//	AVCaptureSessionPresetMedium - Suitable for WiFi sharing (actual values may change)
	//	AVCaptureSessionPresetLow - Suitable for 3G sharing (actual values may change)
	//	AVCaptureSessionPreset640x480 - 640x480 VGA (check its supported before setting it)
	//	AVCaptureSessionPreset1280x720 - 1280x720 720p HD (check its supported before setting it)
	//	AVCaptureSessionPresetPhoto - Full photo resolution (not supported for video output)
/*
	[CaptureSession setSessionPreset:AVCaptureSessionPresetMedium];
	if ([CaptureSession canSetSessionPreset:AVCaptureSessionPreset640x480])		//Check size based configs are supported before setting them
		[CaptureSession setSessionPreset:AVCaptureSessionPreset640x480];

*/

	
	//----- DISPLAY THE PREVIEW LAYER -----
	//Display it full screen under out view controller existing controls
	CGRect layerRect = [[[rootVC view] layer] bounds];
	[PreviewLayer setBounds:layerRect];
	[PreviewLayer setPosition:CGPointMake(CGRectGetMidX(layerRect),
																  CGRectGetMidY(layerRect))];
	//We use this instead so it goes on a layer behind our UI controls (avoids us having to manually bring each control to the front):
	UIView *CameraView = [[[UIView alloc] init] autorelease];
	[[rootVC view] addSubview:CameraView];
	[[rootVC view] sendSubviewToBack:CameraView];
	
	[[CameraView layer] addSublayer:PreviewLayer];
	
	
	//----- START THE CAPTURE SESSION RUNNING -----
	[CaptureSession startRunning];


    } // Say

} // namespace SayCapture 

